/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.account;

import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tcvat.business.service.account.StatusService;
import kd.taxc.tcvat.business.service.draft.PeriodService;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.engine.impl.AddDeductionEngine;

public class AddDeductionService {
    public static void save(Map<String, Object> customParams, DynamicObjectCollection entryentity) {
        if (!entryentity.isEmpty()) {
            Object orgid = customParams.get("orgid");
            String taxperiod = ((String)customParams.get("skssqq")).substring(0, 7);
            DraftMetaDataDTO addDeductionMetaData = DraftMetaDataDTO.getMetaDataByCustomParam(customParams);
            DynamicObject[] load = BusinessDataServiceHelper.load((Object[])entryentity.stream().map(o -> o.getLong("id")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)addDeductionMetaData.getAddDeduction().getAccountMetaDataName()));
            Map<Long, DynamicObject> updateMap = entryentity.stream().collect(Collectors.toMap(o -> o.getLong("id"), o -> o, (o1, o2) -> o1));
            for (DynamicObject dObj : load) {
                DynamicObject dynamicObject = updateMap.get(dObj.getLong("id"));
                dObj.set("org", orgid);
                dObj.set("servicetype", dynamicObject.get("servicetype"));
                dObj.set("currentamount", dynamicObject.get("currentamount"));
                dObj.set("currentdecrease", dynamicObject.get("currentdecrease"));
                dObj.set("rowno", dynamicObject.get("rowno"));
                dObj.set("taxperiod", dynamicObject.get("taxperiod"));
            }
            try (TXHandle h = TX.required();){
                try {
                    SaveServiceHelper.save((DynamicObject[])load);
                    StatusService.updateStatus((String)orgid, taxperiod, "2", addDeductionMetaData.getPolicyConfirm().getAccountMetaDataName(), addDeductionMetaData.getDraftPurpose());
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
    }

    public DynamicObject[] loadPreAddDeduction(Map<String, Object> customParams, Date skssqq, Date skssqz, String deadLine) {
        DraftMetaDataDTO addDeductionMetaData = DraftMetaDataDTO.getMetaDataByCustomParam(customParams);
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(customParams.get("orgid").toString()));
        QFilter taxPeriodFilter = new QFilter("taxperiod", "in", PeriodService.getPeriodList(skssqq, skssqz));
        QFilter deadLineFilter = new QFilter("deadline", "=", (Object)deadLine);
        return BusinessDataServiceHelper.load((String)addDeductionMetaData.getAddDeduction().getAccountMetaDataName(), (String)"id,servicetype,taxperiod,currentamount,currentdecrease,rowno", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter, deadLineFilter}, (String)"taxperiod,servicetype");
    }

    public void executeAddDeductionEngine(Map<String, Object> customParams, DraftMetaDataDTO deductionMateData, String org) {
        String startdate = (String)customParams.get("skssqq");
        String enddate = (String)customParams.get("skssqz");
        TcvatEngineModel engineModel = new TcvatEngineModel(org, startdate, enddate);
        engineModel.setDraftMetaDataDTO(deductionMateData);
        engineModel.getCustom().put("deadLine", customParams.get("deadLine"));
        engineModel.getCustom().put("skssqq", startdate);
        engineModel.getCustom().put("skssqz", enddate);
        AddDeductionEngine engine = new AddDeductionEngine();
        engine.insertData(org, engineModel);
    }
}

