/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.declare;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.constant.TaxConstant;
import kd.taxc.bdtaxr.common.taxdeclare.constant.TaxTypeEnum;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class TaxDeclareEditService {
    public static String buildErrorMsg(String[] taxLimits) {
        String msgTmp = ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u4e0d\u5408\u6cd5\uff0c\u5fc5\u987b\u4e3a%s", (String)"TaxDeclareEditService_0", (String)"taxc-tcvat", (Object[])new Object[0]);
        ArrayList nameList = new ArrayList(4);
        for (String taxLimit : taxLimits) {
            nameList.add(TaxConstant.getTaxLimitNameMap().get(taxLimit));
        }
        return String.format(msgTmp, String.join((CharSequence)"\u3001", nameList));
    }

    public static DynamicObject queryNsrxx(String orgId, String startdate, String enddate, QFilter taxTypeQfilter) {
        Date start = null;
        Date end = null;
        if (null != startdate) {
            start = DateUtils.stringToDate((String)startdate);
        }
        if (null != enddate) {
            end = DateUtils.stringToDate((String)enddate);
        }
        QFilter q1 = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        QFilter q2 = new QFilter("skssqq", "=", (Object)start);
        QFilter q3 = new QFilter("skssqz", "<=", (Object)end);
        QFilter q5 = new QFilter("taxlimit", "=", (Object)DateUtils.getTaxLimit((Date)start, (Date)end));
        return BusinessDataServiceHelper.loadSingle((String)"tcvat_nsrxx", (String)"id,billstatus,declarestatus", (QFilter[])new QFilter[]{q1, q2, q3, q5, taxTypeQfilter});
    }

    public static DynamicObject queryZzsNsrxx(String orgId, Date start, Date end) {
        QFilter q1 = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        QFilter q2 = new QFilter("skssqq", "=", (Object)start);
        QFilter q3 = new QFilter("skssqz", "<=", (Object)end);
        QFilter q4 = new QFilter("type", "in", (Object)TaxTypeEnum.TCVAT.getTemplates());
        QFilter q5 = new QFilter("taxlimit", "=", (Object)DateUtils.getTaxLimit((Date)start, (Date)end));
        return BusinessDataServiceHelper.loadSingle((String)"tcvat_nsrxx", (String)"id,billstatus,declarestatus", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5});
    }
}

