/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.dispatchservice.handler;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.tcvat.business.service.dispatchservice.dto.PrepayDeclareDTO;
import kd.taxc.tcvat.business.service.dispatchservice.handler.AbstractProcessHandler;
import kd.taxc.tcvat.business.service.draft.TaxDeclarationService;
import kd.taxc.tcvat.business.service.prepay.declare.CheckParemsService;

public class DataCheckHandler
extends AbstractProcessHandler<ApiResult, PrepayDeclareDTO> {
    private static Log logger = LogFactory.getLog(DataCheckHandler.class);

    @Override
    public ApiResult handler(PrepayDeclareDTO prepayDeclareDTO) {
        logger.info("data check step");
        ApiResult checkResult = this.checkParams(prepayDeclareDTO);
        if (!checkResult.getSuccess()) {
            return checkResult;
        }
        checkResult = CheckParemsService.checkOrg(prepayDeclareDTO, null);
        if (!checkResult.getSuccess()) {
            return checkResult;
        }
        checkResult = CheckParemsService.checkProject(prepayDeclareDTO);
        if (!checkResult.getSuccess()) {
            return checkResult;
        }
        if (null != this.getNextProcessHandler()) {
            return (ApiResult)this.getNextProcessHandler().handler(prepayDeclareDTO);
        }
        return ApiResult.success((Object)prepayDeclareDTO);
    }

    private ApiResult checkParams(PrepayDeclareDTO prepayDeclareDTO) {
        if (ObjectUtils.isEmpty((Object)prepayDeclareDTO.getOrgId())) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (String)"DataCheckHandler_0", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
        if (ObjectUtils.isEmpty((Object)prepayDeclareDTO.getStartDate())) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u8d77\u4e0d\u80fd\u4e3a\u7a7a", (String)"DataCheckHandler_1", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
        if (ObjectUtils.isEmpty((Object)prepayDeclareDTO.getEndDate())) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u6b62\u4e0d\u80fd\u4e3a\u7a7a", (String)"DataCheckHandler_2", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
        if (!TaxDeclarationService.isNature(prepayDeclareDTO.getStartDate(), prepayDeclareDTO.getEndDate())) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u9700\u4e3a\u6574\u6708\u6216\u6574\u5b63\u5ea6", (String)"DataCheckHandler_3", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
        return ApiResult.success((Object)prepayDeclareDTO);
    }
}

