/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.draft;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.dao.declare.DeclareReportDao;
import kd.taxc.tcvat.business.dao.draft.DraftDao;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.draft.strategy.TcvatStrategy;
import kd.taxc.tcvat.common.dto.draft.DraftDto;
import kd.taxc.tcvat.common.enums.StrategyEnum;
import org.apache.commons.collections4.CollectionUtils;

public class TcvatDraftService {
    private static Log logger = LogFactory.getLog(TcvatDraftService.class);
    private DeclareReportDao declareReportDao = new DeclareReportDao();
    private DraftDao draftDao = new DraftDao();
    private static final Map<String, String> dgSbbCellMap = new HashMap<String, String>(){
        {
            this.put("tcvat_zlb_ybnsr#11#ybxm", "tcvat_ybnsr_zb#1#mdtytse");
            this.put("tcvat_zlb_ybnsr#12#ybxm", "tcvat_ybnsr_zb#1#sqldse");
            this.put("tcvat_zlb_ybnsr#12#jzjtxm", "tcvat_ybnsr_zb#3#sqldse");
            this.put("tcvat_zlb_ybnsr#16#ybxm", "tcvat_ybnsr_jjdj#1#qcye");
            this.put("tcvat_zlb_ybnsr#16#jzjtxm", "tcvat_ybnsr_jjdj#2#qcye");
        }
    };

    public String checkAlreadyExistsDraft(String draftpurpose, String orgId, Date startDate, Date endDate) {
        List<DraftDto> allDraft = "sjjt".equals(draftpurpose) ? this.getAllSjjtDraftByCondition(orgId, startDate, endDate) : this.getAllNssbDraftByCondition(orgId, startDate, endDate);
        if (CollectionUtils.isNotEmpty(allDraft)) {
            DraftDto dto = allDraft.get(0);
            String orgName = OrgUtils.getOrgNameById((String)orgId);
            String draftType = (String)TemplateTypeConstant.getMap().get(dto.getTemplateType());
            return String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u3010%1$s\u3011\u5df2\u5b58\u5728\u5c5e\u671f\u4e3a\u3010%2$s\u3011\u81f3\u3010%3$s\u3011\u7684\u3010%4$s\u3011\u5e95\u7a3f,\u65e0\u9700\u751f\u6210\u3002", (String)"TcvatDraftService_0", (String)"taxc-tcvat", (Object[])new Object[0]), orgName, DateUtils.format((Date)((Date)dto.getStartDate())), DateUtils.format((Date)((Date)dto.getEndDate())), draftType);
        }
        return null;
    }

    public List<DraftDto> getAllSjjtDraftByCondition(String orgId, Date startDate, Date endDate) {
        DraftDto draftDto = new DraftDto();
        draftDto.setOrgId(Long.valueOf(orgId));
        draftDto.setStartDate(startDate);
        draftDto.setEndDate(endDate);
        draftDto.setDraftPurpose("sjjt");
        DynamicObjectCollection collection = this.draftDao.querAllSjjtDraft(draftDto);
        ArrayList<DraftDto> draftDtos = new ArrayList<DraftDto>(collection.size());
        for (DynamicObject object : collection) {
            DraftDto dto = new DraftDto();
            dto.setTemplateType(object.getString("templatetype"));
            dto.setStartDate(object.getDate("skssqq"));
            dto.setEndDate(object.getDate("skssqz"));
            draftDtos.add(dto);
        }
        return draftDtos;
    }

    public List<DraftDto> getAllNssbDraftByCondition(String orgId, Date startDate, Date endDate) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        QFilter and = new QFilter("org", "=", (Object)Long.valueOf(orgId)).and(new QFilter("templatetype", "in", Arrays.asList("draft_zzsybnsr_yz_zjg", "draft_zzsybnsr_yz_fzjg", "draft_zzsybnsr", "draft_zzsxgmnsr", "draft_zzsybnsr_ybhz", "draft_zzsybnsr_hz_zjg")));
        filterList.add(and);
        String deadLine = TaxDeclareHelper.getDeadLine("nssb", orgId, startDate, endDate);
        this.buildDateFilter(startDate, endDate, filterList, deadLine);
        DynamicObjectCollection collection = this.draftDao.querAllDraft(filterList);
        ArrayList<DraftDto> draftDtos = new ArrayList<DraftDto>(collection.size());
        for (DynamicObject object : collection) {
            DraftDto draftDto = new DraftDto();
            draftDto.setTemplateType(object.getString("templatetype"));
            draftDto.setStartDate(object.getDate("startdate"));
            draftDto.setEndDate(object.getDate("enddate"));
            draftDtos.add(draftDto);
        }
        return draftDtos;
    }

    public void buildDateFilter(Date startDate, Date endDate, List<QFilter> filterList, String deadLine) {
        if ("aysb".equals(deadLine)) {
            filterList.add(new QFilter("startdate", "=", (Object)startDate).and(new QFilter("enddate", "=", (Object)DateUtils.trunc((Date)endDate))).or(new QFilter("startdate", "=", (Object)DateUtils.getFirstDateOfSeason((Date)startDate)).and(new QFilter("enddate", "=", (Object)DateUtils.trunc((Date)DateUtils.getLastDateOfSeason((Date)endDate))))));
        } else {
            filterList.add(new QFilter("startdate", ">=", (Object)startDate).and(new QFilter("enddate", "<=", (Object)endDate)));
        }
    }

    public static DynamicObject loadPolicyConfirm(String draftPurpose, String taxpayerType, String templateType, String orgId, String startdate, String enddate) {
        DraftMetaDataDTO metaDataDTO = DraftMetaDataDTO.getMetaData(draftPurpose, taxpayerType);
        if (metaDataDTO == null) {
            return null;
        }
        DynamicObject policyConfirm = TaxDeclareHelper.getPolicyConfirm(metaDataDTO.getDraftPurpose(), metaDataDTO.getPolicyConfirm().getAccountMetaDataName(), templateType, orgId, startdate, enddate);
        if (policyConfirm != null) {
            return BusinessDataServiceHelper.loadSingle((Object)policyConfirm.getLong("id"), (String)metaDataDTO.getPolicyConfirm().getAccountMetaDataName());
        }
        return null;
    }

    public static DynamicObject queryPolicyConfirmId(String draftPurpose, String taxpayerType, String templateType, String orgId, String startdate, String enddate, String planid) {
        DraftMetaDataDTO metaDataDTO = DraftMetaDataDTO.getMetaData(draftPurpose, taxpayerType);
        if (metaDataDTO == null) {
            return null;
        }
        DynamicObject policyConfirm = TaxDeclareHelper.getPolicyConfirm(metaDataDTO.getDraftPurpose(), metaDataDTO.getPolicyConfirm().getAccountMetaDataName(), templateType, orgId, startdate, enddate);
        if (!(policyConfirm != null || planid != null || "zzsybnsr".equals(taxpayerType) || "zzsxgmnsr".equals(taxpayerType) || "zzs".equals(taxpayerType))) {
            String orgName = OrgUtils.getOrgNameById((String)orgId);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u5728\u3010%2$s\u3011-\u3010%3$s\u3011\u671f\u95f4\u6240\u5c5e\u7684\u6c47\u603b\u65b9\u6848\u72b6\u6001\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u786e\u8ba4\u91cd\u65b0\u751f\u6210\u5e95\u7a3f\u8fd8\u662f\u4fee\u6539\u6c47\u603b\u65b9\u6848\u3002", (String)"TcvatDraftService_1", (String)"taxc-tcvat", (Object[])new Object[0]), orgName, startdate, enddate));
        }
        return policyConfirm;
    }

    public static DynamicObject queryDraftData(String draftPurpose, List<String> templateTypeList, Long orgid, Date startDate, Date endDate) {
        String entryName;
        QFilter filterList = new QFilter("org", "=", (Object)orgid).and(new QFilter("templatetype", "in", templateTypeList));
        if ("sjjt".equals(draftPurpose)) {
            entryName = "tcvat_sjjt_draft_query";
            filterList.and(new QFilter("skssqq", "<=", (Object)startDate)).and(new QFilter("skssqz", ">=", (Object)endDate));
        } else {
            entryName = "tcvat_query_ybnsr";
            filterList.and(new QFilter("startdate", "<=", (Object)startDate)).and(new QFilter("enddate", ">=", (Object)endDate));
        }
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)entryName, (String)"id", (QFilter[])new QFilter[]{filterList});
        if (dynamicObject != null) {
            return BusinessDataServiceHelper.loadSingle((Object)dynamicObject.get("id"), (String)entryName);
        }
        return null;
    }

    public static TcvatStrategy getStrategy(DraftDto draftDto) {
        logger.info("strategy draftDTO:{}", (Object)draftDto.toString());
        String taxPayerType = draftDto.getTaxPayerType();
        if ("zzsybnsr_yz_zjg".equals(taxPayerType) || "zzsybnsr_yz_fzjg".equals(taxPayerType)) {
            if ("3".equals(draftDto.getPrelevyrate())) {
                return StrategyEnum.ZZSYBNSR_YZ_ZJG3.getStrategy();
            }
            return StrategyEnum.ZZSYBNSR_YZ_ZJG.getStrategy();
        }
        return StrategyEnum.getByTaxPayerType(taxPayerType).getStrategy();
    }

    @Deprecated
    public static TcvatStrategy getStrategy(String taxPayerType, String prelevyrate) {
        if ("zzsybnsr_yz_zjg".equals(taxPayerType) || "zzsybnsr_yz_fzjg".equals(taxPayerType)) {
            if ("3".equals(prelevyrate)) {
                return StrategyEnum.ZZSYBNSR_YZ_ZJG3.getStrategy();
            }
            return StrategyEnum.ZZSYBNSR_YZ_ZJG.getStrategy();
        }
        return StrategyEnum.getByTaxPayerType(taxPayerType).getStrategy();
    }

    public static String getDraftTemplateType(String draftPurpose, String taxPayerType) {
        if (taxPayerType == null) {
            return null;
        }
        String templateType = "draft_" + taxPayerType;
        if ("sjjt".equals(draftPurpose)) {
            templateType = templateType + "_sjjt";
        }
        return templateType;
    }

    public void updateDeclareReport(DraftDto draftDto, Map<String, String> updateMap) {
        TemplateEnum template = TemplateEnum.getEnumByDraftType((String)draftDto.getTemplateType());
        String declareType = template.getDeclareType();
        if (StringUtils.isNotBlank((CharSequence)declareType) && updateMap != null && !updateMap.isEmpty()) {
            HashMap<String, String> sbbUpdMap = new HashMap<String, String>();
            HashMap<String, Long> sbbCellIdMap = new HashMap<String, Long>();
            ArrayList<QFilter> filterList = new ArrayList<QFilter>();
            filterList.add(new QFilter("org", "=", draftDto.getOrgId()));
            filterList.add(new QFilter("skssqq", ">=", draftDto.getStartDate()));
            filterList.add(new QFilter("skssqz", "<=", draftDto.getEndDate()));
            filterList.add(new QFilter("type", "=", (Object)declareType));
            DynamicObject sbb = this.declareReportDao.queryOneDeclareReport(filterList);
            if (sbb != null) {
                String sbbid = sbb.getString("id");
                QFilter sbbIdFilter = new QFilter("sbbid", "=", (Object)sbbid);
                for (Map.Entry<String, String> entry : dgSbbCellMap.entrySet()) {
                    String vk = entry.getKey().replaceAll("#", "_");
                    String v = updateMap.get(vk);
                    if (!StringUtils.isNotBlank((CharSequence)v)) continue;
                    String sbbCellKey = entry.getValue();
                    String[] split = sbbCellKey.split("#");
                    String sbbCellIdKey = split[0] + "#" + split[1] + "#id";
                    Long sbbCellId = (Long)sbbCellIdMap.get(sbbCellIdKey);
                    if (sbbCellId != null) {
                        sbbUpdMap.put(sbbCellIdKey, String.valueOf(sbbCellId));
                    } else {
                        DynamicObject sbbCellIdDyo = QueryServiceHelper.queryOne((String)split[0], (String)"id", (QFilter[])new QFilter[]{sbbIdFilter, new QFilter("ewblxh", "=", (Object)split[1])});
                        if (sbbCellIdDyo != null) {
                            sbbCellIdMap.put(sbbCellIdKey, sbbCellIdDyo.getLong("id"));
                            sbbUpdMap.put(sbbCellIdKey, sbbCellIdDyo.getString("id"));
                        }
                    }
                    sbbUpdMap.put(sbbCellKey, v);
                }
            }
        }
    }

    public void getInvalidNone(DynamicObjectCollection entryentity, List<Map<String, Object>> invalidOther, List<Map<String, Object>> invalidNone) {
        BigDecimal hundred = new BigDecimal("100");
        BigDecimal five = new BigDecimal("5");
        BigDecimal negateFive = five.negate();
        for (int row = 0; row < entryentity.size(); ++row) {
            Pattern compile;
            Matcher matcher;
            DynamicObject en = (DynamicObject)entryentity.get(row);
            BigDecimal otherinvoiceamount = en.getBigDecimal("otherinvoiceamount");
            BigDecimal othertaxamount = en.getBigDecimal("othertaxamount");
            BigDecimal noneinvoiceamount = en.getBigDecimal("noneinvoiceamount");
            BigDecimal nonetaxamount = en.getBigDecimal("nonetaxamount");
            String taxrate = en.getString("taxrate");
            BigDecimal rate = BigDecimal.ZERO;
            if (StringUtils.isNotBlank((CharSequence)taxrate) && (matcher = (compile = Pattern.compile("\\d+")).matcher(taxrate)).find()) {
                String rateStr = matcher.group();
                rate = new BigDecimal(rateStr).divide(hundred, 2, RoundingMode.HALF_UP);
            }
            BigDecimal otherTaxOffset = otherinvoiceamount.multiply(rate).subtract(othertaxamount);
            BigDecimal noneTaxOffset = noneinvoiceamount.multiply(rate).subtract(nonetaxamount);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("rowno", String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c", (String)"TcvatDraftService_2", (String)"taxc-tcvat", (Object[])new Object[0]), row + 1));
            map.put("description", en.get("description"));
            map.put("taxmethod", en.get("taxmethod"));
            map.put("taxrate", en.get("taxrate"));
            map.put("jzjt", en.get("jzjt"));
            if (otherTaxOffset.compareTo(five) > 0 || otherTaxOffset.compareTo(negateFive) < 0) {
                map.put("otherinvoiceamount", en.get("otherinvoiceamount"));
                map.put("othertaxamount", en.get("othertaxamount"));
                invalidOther.add(map);
            }
            if (noneTaxOffset.compareTo(five) <= 0 && noneTaxOffset.compareTo(negateFive) >= 0) continue;
            map.put("noneinvoiceamount", en.get("noneinvoiceamount"));
            map.put("nonetaxamount", en.get("nonetaxamount"));
            invalidNone.add(map);
        }
    }

    public JobFormInfo createJobFormInfo(String appId, String jobName, String jobId, String taskClassName, String clickClassName, Map<String, Object> customParam, CloseCallBack closeCallBack) {
        JobInfo jobInfo = this.createJobInfo(appId, jobName, jobId, taskClassName, customParam);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(jobInfo.getName());
        if (null != closeCallBack) {
            jobFormInfo.setCloseCallBack(closeCallBack);
        }
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setClickClassName(clickClassName);
        return jobFormInfo;
    }

    public JobInfo createJobInfo(String appId, String jobName, String jobId, String taskClassName, Map<String, Object> customParam) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(appId);
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(jobName);
        jobInfo.setId(jobId);
        jobInfo.setTaskClassname(taskClassName);
        jobInfo.setParams(customParam);
        return jobInfo;
    }
}

