/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.draft.metadata.handler.hz.nssb;

import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.taxc.tcvat.business.service.draft.TcvatDraftService;
import kd.taxc.tcvat.business.service.draft.metadata.AbstractDraftMetaDataHandler;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;
import kd.taxc.tcvat.business.service.draft.metadata.handler.hz.nssb.NssbHzDraftMetaDataEnum;

public class NssbHzDraftMetaDataHandler
extends AbstractDraftMetaDataHandler<NssbHzDraftMetaDataEnum> {
    public Map<String, DraftMetaDataDTO> cacheMap = new ConcurrentHashMap<String, DraftMetaDataDTO>();
    private static final Set<String> taxPayerTypeSet = Sets.newHashSet((Object[])new String[]{"zzsybnsr_ybhz", "zzsybnsr_hz_zjg", "zzsybnsr_yz_zjg"});

    @Override
    public DraftMetaDataDTO handler(String draftPurpose, String taxPayerType) {
        if (taxPayerTypeSet.contains(taxPayerType) && "nssb".equals(draftPurpose)) {
            if (null != this.cacheMap.get(draftPurpose)) {
                return this.cacheMap.get(draftPurpose);
            }
            this.cacheMap.put(draftPurpose, this.getDraftMetaDataDTO(draftPurpose, taxPayerType));
            return this.cacheMap.get(draftPurpose);
        }
        if (null != this.getNextHandler()) {
            return this.getNextHandler().handler(draftPurpose, taxPayerType);
        }
        return null;
    }

    @Override
    public DraftMetaDataDTO getDraftMetaDataDTO(String draftPurpose, String taxPayerType) {
        DraftMetaDataDTO draftMetaDataDTO = new DraftMetaDataDTO(draftPurpose, taxPayerType);
        draftMetaDataDTO.setTemplateType(TcvatDraftService.getDraftTemplateType(draftPurpose, taxPayerType));
        draftMetaDataDTO.setPolicyConfirm(this.createDraftMetaDataInfo(NssbHzDraftMetaDataEnum.POLICY_CONFIRM));
        draftMetaDataDTO.setIncome(this.createDraftMetaDataInfo(NssbHzDraftMetaDataEnum.INCOME));
        draftMetaDataDTO.setDiff(this.createDraftMetaDataInfo(NssbHzDraftMetaDataEnum.DIFF));
        draftMetaDataDTO.setWaitDeduction(this.createDraftMetaDataInfo(NssbHzDraftMetaDataEnum.WAITDEDUCTION));
        draftMetaDataDTO.setTaxReduction(this.createDraftMetaDataInfo(NssbHzDraftMetaDataEnum.TAXREDUCTION));
        draftMetaDataDTO.setRollOut(this.createDraftMetaDataInfo(NssbHzDraftMetaDataEnum.ROLLOUT));
        draftMetaDataDTO.setDeduction(this.createDraftMetaDataInfo(NssbHzDraftMetaDataEnum.DEDUCTION));
        draftMetaDataDTO.setAddDeduction(this.createDraftMetaDataInfo(NssbHzDraftMetaDataEnum.ADDDEDUCTION));
        draftMetaDataDTO.setPerpre(this.createDraftMetaDataInfo(NssbHzDraftMetaDataEnum.PERPRE));
        draftMetaDataDTO.setJzjtjxse(this.createDraftMetaDataInfo(NssbHzDraftMetaDataEnum.JZJTJXSE));
        return draftMetaDataDTO;
    }

    @Override
    public DraftMetaDataInfo createDraftMetaDataInfo(NssbHzDraftMetaDataEnum draftMetaDataEnum) {
        return new DraftMetaDataInfo(draftMetaDataEnum.getAccountMetaDataName(), draftMetaDataEnum.getDetailMetaDataNameMap());
    }
}

