/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.draft.metadata.handler.ybnsr.nssb;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.taxc.tcvat.business.service.draft.metadata.AbstractDraftMetaDataHandler;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;
import kd.taxc.tcvat.business.service.draft.metadata.handler.ybnsr.nssb.NssbYbnsrDraftMetaDataEnum;

public class NssbYbnsrDraftMetaDataHandler
extends AbstractDraftMetaDataHandler<NssbYbnsrDraftMetaDataEnum> {
    private Map<String, DraftMetaDataDTO> cacheMap = new ConcurrentHashMap<String, DraftMetaDataDTO>();

    @Override
    public DraftMetaDataDTO handler(String draftPurpose, String taxPayerType) {
        if (("zzsybnsr".equals(taxPayerType) || "zzsybnsr_yz_fzjg".equals(taxPayerType)) && "nssb".equals(draftPurpose)) {
            if (null != this.cacheMap.get(draftPurpose)) {
                return this.cacheMap.get(draftPurpose);
            }
            this.cacheMap.put(draftPurpose, this.getDraftMetaDataDTO(draftPurpose, taxPayerType));
            return this.cacheMap.get(draftPurpose);
        }
        if (null != this.getNextHandler()) {
            return this.getNextHandler().handler(draftPurpose, taxPayerType);
        }
        return null;
    }

    @Override
    public DraftMetaDataDTO getDraftMetaDataDTO(String draftPurpose, String taxPayerType) {
        DraftMetaDataDTO draftMetaDataDTO = new DraftMetaDataDTO(draftPurpose, taxPayerType);
        draftMetaDataDTO.setTemplateType("draft_zzsybnsr");
        draftMetaDataDTO.setPolicyConfirm(this.createDraftMetaDataInfo(NssbYbnsrDraftMetaDataEnum.POLICY_CONFIRM));
        draftMetaDataDTO.setIncome(this.createDraftMetaDataInfo(NssbYbnsrDraftMetaDataEnum.INCOME));
        draftMetaDataDTO.setDiff(this.createDraftMetaDataInfo(NssbYbnsrDraftMetaDataEnum.DIFF));
        draftMetaDataDTO.setDiffDeduct(this.createDraftMetaDataInfo(NssbYbnsrDraftMetaDataEnum.DIFFDEDUCT));
        draftMetaDataDTO.setWaitDeduction(this.createDraftMetaDataInfo(NssbYbnsrDraftMetaDataEnum.WAITDEDUCTION));
        draftMetaDataDTO.setTaxReduction(this.createDraftMetaDataInfo(NssbYbnsrDraftMetaDataEnum.TAXREDUCTION));
        draftMetaDataDTO.setRollOut(this.createDraftMetaDataInfo(NssbYbnsrDraftMetaDataEnum.ROLLOUT));
        draftMetaDataDTO.setDeduction(this.createDraftMetaDataInfo(NssbYbnsrDraftMetaDataEnum.DEDUCTION));
        draftMetaDataDTO.setAddDeduction(this.createDraftMetaDataInfo(NssbYbnsrDraftMetaDataEnum.ADDDEDUCTION));
        draftMetaDataDTO.setPerpre(this.createDraftMetaDataInfo(NssbYbnsrDraftMetaDataEnum.PERPRE));
        draftMetaDataDTO.setJzjtjxse(this.createDraftMetaDataInfo(NssbYbnsrDraftMetaDataEnum.JZJTJXSE));
        return draftMetaDataDTO;
    }

    @Override
    public DraftMetaDataInfo createDraftMetaDataInfo(NssbYbnsrDraftMetaDataEnum draftMetaDataEnum) {
        return new DraftMetaDataInfo(draftMetaDataEnum.getAccountMetaDataName(), draftMetaDataEnum.getDetailMetaDataNameMap());
    }
}

