/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.draft.metadata.handler.ybnsr.sjjt;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.taxc.tcvat.business.service.draft.metadata.AbstractDraftMetaDataHandler;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;
import kd.taxc.tcvat.business.service.draft.metadata.handler.ybnsr.sjjt.SjjtYbnsrDraftMetaDataEnum;

public class SjjtYbnsrDraftMetaDataHandler
extends AbstractDraftMetaDataHandler<SjjtYbnsrDraftMetaDataEnum> {
    private Map<String, DraftMetaDataDTO> cacheMap = new ConcurrentHashMap<String, DraftMetaDataDTO>();

    @Override
    public DraftMetaDataDTO handler(String draftPurpose, String taxPayerType) {
        if (("zzsybnsr".equals(taxPayerType) || "zzsybnsr_yz_fzjg".equals(taxPayerType)) && "sjjt".equals(draftPurpose)) {
            if (null != this.cacheMap.get(draftPurpose)) {
                return this.cacheMap.get(draftPurpose);
            }
            this.cacheMap.put(draftPurpose, this.getDraftMetaDataDTO(draftPurpose, taxPayerType));
            return this.cacheMap.get(draftPurpose);
        }
        if (null != this.getNextHandler()) {
            return this.getNextHandler().handler(draftPurpose, taxPayerType);
        }
        return null;
    }

    @Override
    public DraftMetaDataDTO getDraftMetaDataDTO(String draftPurpose, String taxPayerType) {
        DraftMetaDataDTO draftMetaDataDTO = new DraftMetaDataDTO(draftPurpose, taxPayerType);
        draftMetaDataDTO.setTemplateType("draft_zzsybnsr_sjjt");
        draftMetaDataDTO.setPolicyConfirm(this.createDraftMetaDataInfo(SjjtYbnsrDraftMetaDataEnum.POLICY_CONFIRM));
        draftMetaDataDTO.setIncome(this.createDraftMetaDataInfo(SjjtYbnsrDraftMetaDataEnum.INCOME));
        draftMetaDataDTO.setDiff(this.createDraftMetaDataInfo(SjjtYbnsrDraftMetaDataEnum.DIFF));
        draftMetaDataDTO.setDiffDeduct(this.createDraftMetaDataInfo(SjjtYbnsrDraftMetaDataEnum.DIFFDEDUCT));
        draftMetaDataDTO.setWaitDeduction(this.createDraftMetaDataInfo(SjjtYbnsrDraftMetaDataEnum.WAITDEDUCTION));
        draftMetaDataDTO.setTaxReduction(this.createDraftMetaDataInfo(SjjtYbnsrDraftMetaDataEnum.TAXREDUCTION));
        draftMetaDataDTO.setRollOut(this.createDraftMetaDataInfo(SjjtYbnsrDraftMetaDataEnum.ROLLOUT));
        draftMetaDataDTO.setDeduction(this.createDraftMetaDataInfo(SjjtYbnsrDraftMetaDataEnum.DEDUCTION));
        draftMetaDataDTO.setAddDeduction(this.createDraftMetaDataInfo(SjjtYbnsrDraftMetaDataEnum.ADDDEDUCTION));
        draftMetaDataDTO.setPerpre(this.createDraftMetaDataInfo(SjjtYbnsrDraftMetaDataEnum.PERPRE));
        draftMetaDataDTO.setJzjtjxse(this.createDraftMetaDataInfo(SjjtYbnsrDraftMetaDataEnum.JZJTJXSE));
        return draftMetaDataDTO;
    }

    @Override
    public DraftMetaDataInfo createDraftMetaDataInfo(SjjtYbnsrDraftMetaDataEnum draftMetaDataEnum) {
        return new DraftMetaDataInfo(draftMetaDataEnum.getAccountMetaDataName(), draftMetaDataEnum.getDetailMetaDataNameMap());
    }
}

