/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.draft.strategy.impl;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.DeclarePageType;
import kd.taxc.bdtaxr.common.taxdeclare.TaxStepsConstant;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.tctb.helper.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.draft.PeriodService;
import kd.taxc.tcvat.business.service.draft.strategy.TcvatStrategy;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.engine.task.PartitionSaveTask;
import kd.taxc.tcvat.business.service.engine.util.SmallScaleEngineUtils;
import org.apache.commons.collections.CollectionUtils;

public class XgmnsrStrategyImpl
extends TcvatStrategy {
    @Override
    public Map<String, DeclarePageType> getDeclareMapAndStatusMap() {
        return TaxStepsConstant.getTcvatXgmnsr();
    }

    @Override
    public EngineModel buildEngineModel(String orgId, String skssqq, String skssqz, String taxPayerType, IPageCache pageCache, String draftPurpose) {
        TcvatEngineModel engineModel = (TcvatEngineModel)super.buildEngineModel(orgId, skssqq, skssqz, taxPayerType, pageCache, draftPurpose);
        List<Long> curOrgList = Collections.singletonList(Long.parseLong(orgId));
        pageCache = engineModel.getPageCache();
        DynamicObject dynamicObject = PeriodService.loadTaxMain(orgId);
        pageCache.put("registertype", dynamicObject != null ? dynamicObject.getString("registertype.id") : null);
        Map orgRelationMap = TaxOrgTakeRelationServiceHelper.getOrgRelationMapByTaxOrgs(curOrgList, (Date)DateUtils.stringToDate((String)skssqq), (Date)DateUtils.stringToDate((String)skssqz));
        engineModel.addCustom("OrgRelationMap", orgRelationMap);
        return engineModel;
    }

    @Override
    public TcvatEngineModel engineExecute(TcvatEngineModel engineModel) throws InterruptedException, ExecutionException, TimeoutException {
        SmallScaleEngineUtils.execute(RequestContext.getOrCreate(), engineModel);
        return engineModel;
    }

    @Override
    public void insertCheckData(TcvatEngineModel engineModel, String orgId, String startdate, String enddate, String planid) {
        super.insertCheckData(engineModel, orgId, startdate, enddate, planid);
        Map<String, String> invoiceTypeMap = this.getInvoiceTypeMap();
        String draftPurpose = engineModel.getDraftMetaDataDTO().getDraftPurpose();
        QFilter filter = this.getDeleteCheckDataFilter(orgId, startdate, enddate, draftPurpose);
        DeleteServiceHelper.delete((String)"tcvat_ybnsr_repeat_invoic", (QFilter[])new QFilter[]{filter});
        DeleteServiceHelper.delete((String)"tcvat_ybnsr_rule_invoice", (QFilter[])new QFilter[]{filter});
        XgmnsrStrategyImpl.saveYbnsrRepInvoiceData(engineModel, orgId, engineModel.getErrorMap(), DateUtils.stringToDate((String)startdate), DateUtils.stringToDate((String)enddate), invoiceTypeMap);
        XgmnsrStrategyImpl.saveYbnsrInvoiceNotConfigData(engineModel, orgId, engineModel.getEntryIds(), DateUtils.stringToDate((String)startdate), DateUtils.stringToDate((String)enddate), invoiceTypeMap);
    }

    private static void saveYbnsrRepInvoiceData(TcvatEngineModel engineModel, String orgId, Map<String, Map<String, Object>> repeatInvoice, Date skssqq, Date skssqz, Map<String, String> invoiceTypeMap) {
        ArrayList<DynamicObject> ruleList = new ArrayList<DynamicObject>(repeatInvoice.size());
        String draftPurpose = engineModel.getDraftMetaDataDTO().getDraftPurpose();
        for (Map<String, Object> objectMap : repeatInvoice.values()) {
            String field = (String)objectMap.get("field");
            Set rulelist = (Set)objectMap.get("rulelist");
            String rulename = String.join((CharSequence)",", rulelist);
            if (!field.equals("invoice")) continue;
            DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"tcvat_ybnsr_repeat_invoic");
            object.set("org", (Object)Long.parseLong(orgId));
            object.set("skssqq", (Object)skssqq);
            object.set("skssqz", (Object)skssqz);
            object.set("ruletype", objectMap.get("type"));
            object.set("field", (Object)field);
            object.set("name", (Object)rulename);
            object.set("baseinvoicetype", objectMap.get("baseinvoicetype"));
            object.set("invoicedate", objectMap.get("invoicedate"));
            object.set("goodsname", objectMap.get("goodsname"));
            object.set("goodscode", objectMap.get("goodscode"));
            object.set("invoicecode", objectMap.get("invoicecode"));
            object.set("invoiceno", objectMap.get("invoiceno"));
            object.set("taxrate", objectMap.get("taxrate"));
            object.set("amount", objectMap.get("amount"));
            object.set("taxamount", objectMap.get("taxamount"));
            object.set("total", objectMap.get("total"));
            object.set("draftpurpose", (Object)draftPurpose);
            ruleList.add(object);
        }
        ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(ruleList));
    }

    private static void saveYbnsrInvoiceNotConfigData(TcvatEngineModel engineModel, String orgId, Set<String> entryIds, Date skssqq, Date skssqz, Map<String, String> invoiceTypeMap) {
        QFilter orgFilter = new QFilter("taxorg", "=", (Object)Long.parseLong(orgId)).and(new QFilter("issuetime", ">=", (Object)skssqq).and("issuetime", "<=", (Object)skssqz).and("invoicestatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"0", "3"})));
        String selectFields = "id, orgid as org, issuetime as invoicedate,invoicecode,invoiceno,baseinvoicetype,items.id as entryentity.id ,items.taxrate as entryentity.taxrate,items.amount as entryentity.amount,items.tax as entryentity.taxamount1,items.goodsname as goodsname,items.goodscode as goodscode";
        QFilter and = QFilter.isNotNull((String)"items.goodscode").and("items.goodscode", "!=", (Object)" ").and("items.goodscode", "!=", (Object)"");
        DynamicObjectCollection invoiceList = QueryServiceHelper.query((String)"sim_vatinvoice", (String)selectFields, (QFilter[])new QFilter[]{orgFilter, and}, (String)"invoicetype,items.taxrate");
        ArrayList<QFilter> notDetailFilters = new ArrayList<QFilter>();
        notDetailFilters.add(orgFilter);
        notDetailFilters.add(new QFilter("issuetype", "=", (Object)"1"));
        notDetailFilters.add(QFilter.isNull((String)"items.goodscode").or("items.goodscode", "=", (Object)" ").or("items.goodscode", "=", (Object)""));
        if (CollectionUtils.isNotEmpty((Collection)invoiceList)) {
            List ids = invoiceList.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
            notDetailFilters.add(new QFilter("id", "not in", ids));
        }
        DynamicObjectCollection notDetailList = QueryServiceHelper.query((String)"sim_vatinvoice", (String)selectFields, (QFilter[])notDetailFilters.toArray(new QFilter[0]));
        invoiceList.addAll((Collection)notDetailList);
        selectFields = "id, orgid as org, issuetime as invoicedate,invoicecode,invoiceno, '961641829533496320' as baseinvoicetype, id as entryentity.id ,taxrate as entryentity.taxrate, invoiceamount as entryentity.amount,totaltax as entryentity.taxamount1,'' as goodsname, goodscode";
        DynamicObjectCollection invoiceVehiclesList = QueryServiceHelper.query((String)"sim_vatinvoice_vehicles", (String)selectFields, (QFilter[])new QFilter[]{orgFilter}, (String)"invoicetype");
        invoiceList.addAll((Collection)invoiceVehiclesList);
        if (CollectionUtils.isEmpty((Collection)invoiceList)) {
            return;
        }
        HashMap invoiceEntityMap = new HashMap();
        for (DynamicObject invoice : invoiceList) {
            String entryentityId = invoice.getString("entryentity.id");
            if (entryIds.contains(entryentityId)) continue;
            HashMap<String, Object> invoicemap = new HashMap<String, Object>();
            invoicemap.put("baseinvoicetype", invoice.getString("baseinvoicetype"));
            invoicemap.put("taxrate", invoice.getString("entryentity.taxrate"));
            invoicemap.put("count", invoicemap.getOrDefault("count", 0) + 1);
            invoicemap.put("amount", invoice.getBigDecimal("entryentity.amount"));
            invoicemap.put("taxamount", invoice.getBigDecimal("entryentity.taxamount1"));
            invoicemap.put("total", invoicemap.getOrDefault("amount", BigDecimal.ZERO).add((BigDecimal)invoicemap.get("taxamount")));
            invoicemap.put("invoicedate", invoice.getDate("invoicedate"));
            invoicemap.put("invoicecode", invoice.get("invoicecode"));
            invoicemap.put("invoiceno", invoice.get("invoiceno"));
            invoicemap.put("org", invoice.get("org"));
            invoicemap.put("goodsname", invoice.get("goodsname"));
            invoicemap.put("goodscode", invoice.get("goodscode"));
            invoiceEntityMap.put(entryentityId, invoicemap);
        }
        String draftPurpose = engineModel.getDraftMetaDataDTO().getDraftPurpose();
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(invoiceEntityMap.size());
        for (Map value : invoiceEntityMap.values()) {
            DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"tcvat_ybnsr_rule_invoice");
            object.set("org", (Object)Long.parseLong(orgId));
            object.set("skssqq", (Object)skssqq);
            object.set("skssqz", (Object)skssqz);
            object.set("baseinvoicetype", value.get("baseinvoicetype"));
            object.set("count", value.get("count"));
            object.set("taxrate", value.get("taxrate"));
            object.set("amount", value.get("amount"));
            object.set("taxamount", value.get("taxamount"));
            object.set("total", value.get("total"));
            object.set("invoicedate", value.get("invoicedate"));
            object.set("invoicecode", value.get("invoicecode"));
            object.set("invoiceno", value.get("invoiceno"));
            object.set("goodsname", value.get("goodsname"));
            object.set("goodscode", value.get("goodscode"));
            object.set("draftpurpose", (Object)draftPurpose);
            list.add(object);
        }
        ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(list));
    }
}

