/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.draft.strategy.impl;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import kd.bos.context.RequestContext;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.DeclarePageType;
import kd.taxc.bdtaxr.common.taxdeclare.TaxStepsConstant;
import kd.taxc.bdtaxr.common.tctb.helper.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.draft.strategy.TcvatStrategy;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.engine.util.EngineUtils;
import kd.taxc.tcvat.common.dto.draft.DraftDto;

public class YbnsrStrategyImpl
extends TcvatStrategy {
    @Override
    public Map<String, DeclarePageType> getDeclareMapAndStatusMap() {
        return TaxStepsConstant.getTcvatDraftYbnsr();
    }

    @Override
    public TcvatEngineModel buildEngineModel(String orgId, String skssqq, String skssqz, String taxPayerType, IPageCache pageCache, String draftPurpose) {
        TcvatEngineModel engineModel = (TcvatEngineModel)super.buildEngineModel(orgId, skssqq, skssqz, taxPayerType, pageCache, draftPurpose);
        List<Long> curOrgList = Collections.singletonList(Long.parseLong(orgId));
        engineModel.addCustom("policyconfirmentry", "tcvat_policy_confirm");
        Map orgRelationMap = TaxOrgTakeRelationServiceHelper.getOrgRelationMapByTaxOrgs(curOrgList, (Date)DateUtils.stringToDate((String)skssqq), (Date)DateUtils.stringToDate((String)skssqz));
        engineModel.addCustom("OrgRelationMap", orgRelationMap);
        return engineModel;
    }

    @Override
    public TcvatEngineModel engineExecute(TcvatEngineModel engineModel) throws InterruptedException, ExecutionException, TimeoutException {
        EngineUtils.execute(RequestContext.getOrCreate(), engineModel);
        return engineModel;
    }

    @Override
    public void insertCheckData(TcvatEngineModel engineModel, String orgId, String startdate, String enddate, String planid) {
        super.insertCheckData(engineModel, orgId, startdate, enddate, planid);
        Map<String, String> invoiceTypeMap = this.getInvoiceTypeMap();
        String draftPurpose = engineModel.getDraftMetaDataDTO().getDraftPurpose();
        QFilter filter = this.getDeleteCheckDataFilter(orgId, startdate, enddate, draftPurpose);
        DeleteServiceHelper.delete((String)"tcvat_ybnsr_repeat_invoic", (QFilter[])new QFilter[]{filter});
        DeleteServiceHelper.delete((String)"tcvat_ybnsr_rule_invoice", (QFilter[])new QFilter[]{filter});
        this.saveRepInvoiceData(orgId, engineModel, DateUtils.stringToDate((String)startdate), DateUtils.stringToDate((String)enddate), invoiceTypeMap, "tcvat_ybnsr_repeat_invoic", null);
        this.saveInvoiceNotConfigData(engineModel, orgId, engineModel.getEntryIds(), DateUtils.stringToDate((String)startdate), DateUtils.stringToDate((String)enddate), invoiceTypeMap, "tcvat_ybnsr_rule_invoice", null);
    }

    @Override
    public Boolean validDeductionDraft(DraftDto draftDto) {
        return Boolean.FALSE;
    }
}

