/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.engine.impl;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.IAccountEngine;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tcvat.business.service.draft.TaxDeclarationService;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.engine.task.PartitionSaveTask;
import kd.taxc.tcvat.common.constant.DraftConstant;
import kd.taxc.tcvat.common.enums.DraftEngineEnum;
import org.apache.commons.lang.StringUtils;

public class AddDeductionEngine
implements IAccountEngine<TcvatEngineModel> {
    private static Log logger = LogFactory.getLog(AddDeductionEngine.class);
    private static final String ORGID_KEY = "orgid";
    private static final String REPORT_PERIOD = "reportperiod";
    private static final String ROLLOUTTYPE_10 = "10";
    private static final String ROLLOUTTYPE_11 = "11";
    private Set<String> INCOMETAXMETHOD = Sets.newHashSet((Object[])new String[]{"19", "20"});

    public void execute(TcvatEngineModel model) {
        logger.info("\u5f00\u59cb\u6267\u884c\u8fdb\u9879\u7a0e\u989d\u52a0\u8ba1\u62b5\u51cf\u53f0\u8d26\u5f15\u64ce");
        long start = System.currentTimeMillis();
        this.insertData(model.getOrgId(), model);
        logger.info("\u7ed3\u675f\u6267\u884c\u8fdb\u9879\u7a0e\u989d\u52a0\u8ba1\u62b5\u51cf\u53f0\u8d26\u5f15\u64ce\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
    }

    public void insertData(String orgId, TcvatEngineModel model) {
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        Object deadLine = model.getCustom().get("deadLine");
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(16);
        List<String> dateList = TaxDeclarationService.getRealQuarter(model.getDraftMetaDataDTO().getDraftPurpose(), model.getOrgId(), (String)model.getCustom().get("skssqq"), (String)model.getCustom().get("skssqz"));
        QFilter taxPeriodFilter = new QFilter("taxperiod", "in", dateList);
        DynamicObjectCollection deductionSummarys = QueryServiceHelper.query((String)model.getDraftMetaDataDTO().getAddDeduction().getDetailMetaDataNameMap().get(DraftConstant.YBNSR_DEDUCTION_SUMMARY), (String)"deductiontype,taxamount,inputtaxamount,taxperiod", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter});
        DynamicObjectCollection jzjtjxseSummarys = QueryServiceHelper.query((String)model.getDraftMetaDataDTO().getAddDeduction().getDetailMetaDataNameMap().get(DraftConstant.YBNSR_JZJT_JXSE_SUMMARY), (String)"jzjtamount,amountsum,splitrate,inputtax,jzjtjxtax,taxperiod,jzjtlx", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter});
        DynamicObjectCollection rollOutSummarys = QueryServiceHelper.query((String)model.getDraftMetaDataDTO().getAddDeduction().getDetailMetaDataNameMap().get(DraftConstant.YBNSR_ROLLOUT_SUMMARY), (String)"jzjt,rollouttype,accountingamount,jzjtrolloutamount,taxperiod", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter});
        DynamicObjectCollection incomeSummarys = QueryServiceHelper.query((String)model.getDraftMetaDataDTO().getIncome().getAccountMetaDataName(), (String)"taxperiod,taxmethodtype,taxamount", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter});
        String deductionRate = this.getDeductionRate(orgId, model).replace("%", "");
        for (String date : dateList) {
            if ("N".equals(deductionRate)) {
                return;
            }
            List<DynamicObject> deductionSummary = deductionSummarys.stream().filter(one -> date.equals(one.getString("taxperiod"))).collect(Collectors.toList());
            List<DynamicObject> rollOutSummary = rollOutSummarys.stream().filter(one -> date.equals(one.getString("taxperiod"))).collect(Collectors.toList());
            List<DynamicObject> incomeSummary = incomeSummarys.stream().filter(one -> date.equals(one.getString("taxperiod"))).collect(Collectors.toList());
            List<DynamicObject> jzjtjxseSum = jzjtjxseSummarys.stream().filter(one -> date.equals(one.getString("taxperiod"))).collect(Collectors.toList());
            Set<Map.Entry<String, String>> entries = this.getAddDeductRow().entrySet();
            for (Map.Entry<String, String> map : entries) {
                DynamicObject entity = BusinessDataServiceHelper.newDynamicObject((String)model.getDraftMetaDataDTO().getAddDeduction().getAccountMetaDataName());
                entity.set("org", (Object)orgId);
                entity.set("servicetype", (Object)map.getValue());
                BigDecimal divideAmou = this.getIncomeSaleAmou(incomeSummary);
                entity.set("currentamount", (Object)this.getCurrentAmount(deductionRate, deductionSummary, jzjtjxseSum, divideAmou, map.getKey()));
                entity.set("currentdecrease", (Object)this.getCurrentDecreaseAmount(deductionRate, rollOutSummary, divideAmou, map.getKey()));
                entity.set("rowno", (Object)map.getKey());
                entity.set("taxperiod", (Object)date);
                if ("sjjt".equals(model.getDraftMetaDataDTO().getDraftPurpose())) {
                    entity.set("taxperioddate", (Object)DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate2((String)date, (String)"yyyy-MM")));
                }
                entity.set("deadline", deadLine);
                result.add(entity);
            }
        }
        DraftEngineEnum.YBNSR.deleteAddDeduction(model);
        ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(result));
    }

    private String getDeductionRate(String orgId, TcvatEngineModel model) {
        Date startDate = DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)model.getStartDate(), (String)"yyyy-MM"));
        Date endDate = DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)model.getEndDate(), (String)"yyyy-MM"));
        QFilter orgFilter = new QFilter(ORGID_KEY, "=", (Object)Long.parseLong(orgId));
        QFilter taxperiodFilter = new QFilter(REPORT_PERIOD, ">=", (Object)DateUtils.getDayFirst((Date)startDate)).and(new QFilter(REPORT_PERIOD, "<=", (Object)DateUtils.getDayLast((Date)endDate)));
        QFilter draftPurposeFilter = new QFilter("draftpurpose", "=", (Object)model.getDraftMetaDataDTO().getDraftPurpose());
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)model.getDraftMetaDataDTO().getPolicyConfirm().getAccountMetaDataName(), (String)"deductionrate", (QFilter[])new QFilter[]{orgFilter, taxperiodFilter, draftPurposeFilter});
        return "N".equals(dynamicObject.getString("deductionrate")) ? "0" : BigDecimalUtil.divideObject((Object)BigDecimalUtil.toBigDecimal((Object)dynamicObject.getString("deductionrate").replace("%", "")), (Object)100, (int)2).toPlainString();
    }

    private BigDecimal getCurrentAmount(String deductionRate, List<DynamicObject> deductionSummary, List<DynamicObject> jzjtjxseSummarys, BigDecimal divideAmou, String key) {
        BigDecimal totalTaxAmoumt = BigDecimal.ZERO;
        BigDecimal totalInputTaxAmount = BigDecimal.ZERO;
        if (StringUtils.isEmpty((String)deductionRate)) {
            return BigDecimal.ZERO;
        }
        for (DynamicObject object : deductionSummary) {
            totalTaxAmoumt = totalTaxAmoumt.add(object.getBigDecimal("taxamount"));
        }
        for (DynamicObject object : jzjtjxseSummarys) {
            totalInputTaxAmount = totalInputTaxAmount.add(object.getBigDecimal("jzjtjxtax"));
        }
        if ("1".equals(key)) {
            BigDecimal oldResult = BigDecimalUtil.multiplyObject((Object)BigDecimalUtil.subtractObject((Object)totalTaxAmoumt, (Object)totalInputTaxAmount), (Object)new BigDecimal(deductionRate.replace("%", "")), (int)8, (int)4);
            return BigDecimalUtil.multiplyObject((Object)oldResult, (Object)divideAmou, (int)8, (int)4);
        }
        return BigDecimalUtil.multiplyObject((Object)totalInputTaxAmount, (Object)new BigDecimal(deductionRate.replace("%", "")), (int)2, (int)4);
    }

    private BigDecimal getIncomeSaleAmou(List<DynamicObject> incomeSummary) {
        BigDecimal total = BigDecimal.ZERO;
        BigDecimal mstotal = BigDecimal.ZERO;
        for (DynamicObject dyn : incomeSummary) {
            String taxmethodtype = dyn.getString("taxmethodtype");
            BigDecimal taxamount = dyn.getBigDecimal("taxamount");
            if (this.INCOMETAXMETHOD.contains(taxmethodtype)) {
                mstotal = mstotal.add(taxamount);
            }
            total = total.add(taxamount);
        }
        if (total.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ONE;
        }
        return BigDecimal.ONE.subtract(mstotal.divide(total, 8, 4));
    }

    private BigDecimal getCurrentDecreaseAmount(String deductionRate, List<DynamicObject> list, BigDecimal divideAmou, String key) {
        BigDecimal totalTaxAmoumt = BigDecimal.ZERO;
        BigDecimal jzjtTotalRolloutAmount = BigDecimal.ZERO;
        if (StringUtils.isEmpty((String)deductionRate)) {
            return BigDecimal.ZERO;
        }
        for (DynamicObject object : list) {
            String jzjt = object.getString("jzjt");
            String rollouttype = object.getString("rollouttype");
            if (!ROLLOUTTYPE_10.equals(rollouttype) && !ROLLOUTTYPE_11.equals(rollouttype)) {
                totalTaxAmoumt = totalTaxAmoumt.add(object.getBigDecimal("accountingamount"));
            }
            if (!"1".equals(jzjt) && !"2".equals(jzjt)) continue;
            jzjtTotalRolloutAmount = jzjtTotalRolloutAmount.add(object.getBigDecimal("jzjtrolloutamount"));
        }
        if ("1".equals(key)) {
            BigDecimal oldResult = BigDecimalUtil.multiplyObject((Object)BigDecimalUtil.subtractObject((Object)totalTaxAmoumt, (Object)jzjtTotalRolloutAmount), (Object)new BigDecimal(deductionRate), (int)8, (int)4);
            return BigDecimalUtil.multiplyObject((Object)oldResult, (Object)divideAmou, (int)8, (int)4);
        }
        return BigDecimalUtil.multiplyObject((Object)jzjtTotalRolloutAmount, (Object)new BigDecimal(deductionRate), (int)2, (int)4);
    }

    public Map<String, String> getAddDeductRow() {
        return new LinkedHashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("1", ResManager.loadKDString((String)"\u4e00\u822c\u8ba1\u7a0e\u9879\u76ee", (String)"AddDeductionEngine_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                this.put("2", ResManager.loadKDString((String)"\u5373\u5f81\u5373\u9000\u9879\u76ee", (String)"AddDeductionEngine_1", (String)"taxc-tcvat", (Object[])new Object[0]));
            }
        };
    }
}

