/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.engine.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.helper.YbnsrServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineTask;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.draft.TaxDeclarationService;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.engine.impl.service.DiffDeductionEngineService;
import kd.taxc.tcvat.business.service.engine.impl.service.DraftEditService;
import kd.taxc.tcvat.business.service.engine.impl.utils.IncomeUtils;
import kd.taxc.tcvat.business.service.engine.task.NewRuleSettingTask;
import kd.taxc.tcvat.business.service.engine.task.PartitionSaveTask;
import kd.taxc.tcvat.common.constant.DraftConstant;
import kd.taxc.tcvat.common.enums.DiffRuleTypeEnum;
import kd.taxc.tcvat.common.enums.DraftEngineEnum;
import kd.taxc.tcvat.common.util.UUID;
import org.apache.commons.collections.CollectionUtils;

public class DiffDeductionEngine
extends EngineTask<TcvatEngineModel, DynamicObject> {
    private static Log logger = LogFactory.getLog(DiffDeductionEngine.class);

    protected DynamicObject execute() throws Exception {
        logger.info("\u5f00\u59cb\u6267\u884c\u5dee\u989d\u6263\u9664\u5f15\u64ce");
        long start = System.currentTimeMillis();
        TcvatEngineModel model = (TcvatEngineModel)this.getEngineModel();
        DraftMetaDataInfo diffDraftMetaData = model.getDraftMetaDataDTO().getDiff();
        String rulePurpose = (String)model.getCustom().get("rulePurpose");
        String taxpayertype = ((String)model.getCustom().get("taxPayerType")).replace("zzs", "");
        String deadLine = (String)model.getCustom().get("deadLine");
        List rules = (List)RuleUtils.getSharingAndOrgRules((Long)Long.parseLong(model.getOrgId()), (RuleTypeEnum)RuleTypeEnum.DIFF, (String)taxpayertype, (String)rulePurpose).get(RuleTypeEnum.DIFF);
        List sortedRules = RuleUtils.sortDiffRules((List)rules);
        if (CollectionUtils.isNotEmpty((Collection)sortedRules)) {
            ArrayList<DynamicObject> summaryList = new ArrayList<DynamicObject>(sortedRules.size());
            ArrayList<DynamicObject> summaryAccountingList = new ArrayList<DynamicObject>();
            List<String> dateList = TaxDeclarationService.getRealQuarter(model.getDraftMetaDataDTO().getDraftPurpose(), model.getOrgId(), (String)model.getCustom().get("skssqq"), (String)model.getCustom().get("skssqz"));
            DynamicObjectCollection oldDraftList = DraftEditService.getDraftList(model, model.getDraftMetaDataDTO().getDiff());
            DynamicObject[] draftEditArr = DraftEditService.getDraftEditList(oldDraftList);
            for (String date : dateList) {
                for (DynamicObject rule : sortedRules) {
                    NewRuleSettingTask ruleSettingTask;
                    String serialno = UUID.randomUUID();
                    MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)diffDraftMetaData.getAccountMetaDataName());
                    DynamicObject summary = new DynamicObject((DynamicObjectType)entityType);
                    summary.set("serialno", (Object)serialno);
                    summary.set("rowno", rule.getDynamicObject("difftype").get("number"));
                    summary.set("org", (Object)model.getOrgId());
                    summary.set("project", rule.get("name"));
                    if (summary.containsProperty("ruleid")) {
                        summary.set("ruleid", (Object)rule.getLong("id"));
                    }
                    summary.set("difftype", rule.get("difftype"));
                    summary.set("deductproject", rule.get("deductproject"));
                    summary.set("deductiontype", rule.get("deductiontype"));
                    summary.set("taxperiod", (Object)date);
                    summary.set("deadline", (Object)deadLine);
                    summary.set("jzjt", rule.get("jzjt"));
                    String diffType = rule.getDynamicObject("difftype").getString("number");
                    if ("bqfse".equals(rule.getString("deductproject"))) {
                        ruleSettingTask = new NewRuleSettingTask(new ConcurrentHashMap<String, String>(), new ConcurrentHashMap<String, Map<String, Object>>(), rule, model, rule.getDynamicObjectCollection("entryentity"), serialno, diffDraftMetaData.getDetailMetaDataNameMap().get(DraftConstant.YBNSR_DIFF_DETAIL), IncomeUtils.getDiffRates().get(diffType), "", "currentamount", date);
                        this.doCalRuleAmount(summaryAccountingList, summary, ruleSettingTask, "currentamount");
                    } else if ("bqsjkce".equals(rule.getString("deductproject"))) {
                        NewRuleSettingTask deductRuleSettingTask1;
                        if (!rule.getBoolean("minswitch")) {
                            NewRuleSettingTask deductRuleSettingTask = new NewRuleSettingTask(new ConcurrentHashMap<String, String>(), new ConcurrentHashMap<String, Map<String, Object>>(), rule, model, rule.getDynamicObjectCollection("entryentity1"), serialno, diffDraftMetaData.getDetailMetaDataNameMap().get(DraftConstant.YBNSR_DIFF_DETAIL), IncomeUtils.getDiffRates().get(diffType), "1", "deductamount", date);
                            this.doCalRuleAmount(summaryAccountingList, summary, deductRuleSettingTask, "deductamount");
                        }
                        if (!rule.getBoolean("equalsjkce")) {
                            deductRuleSettingTask1 = new NewRuleSettingTask(new ConcurrentHashMap<String, String>(), new ConcurrentHashMap<String, Map<String, Object>>(), rule, model, rule.getDynamicObjectCollection("entryentity11"), serialno, diffDraftMetaData.getDetailMetaDataNameMap().get(DraftConstant.YBNSR_DIFF_DETAIL), IncomeUtils.getDiffRates().get(diffType), "11", "jzjtdeductamount", date);
                            this.doCalRuleAmount(summaryAccountingList, summary, deductRuleSettingTask1, "jzjtdeductamount");
                        } else if (!rule.getBoolean("minswitch")) {
                            deductRuleSettingTask1 = new NewRuleSettingTask(new ConcurrentHashMap<String, String>(), new ConcurrentHashMap<String, Map<String, Object>>(), rule, model, rule.getDynamicObjectCollection("entryentity1"), serialno, diffDraftMetaData.getDetailMetaDataNameMap().get(DraftConstant.YBNSR_DIFF_DETAIL), IncomeUtils.getDiffRates().get(diffType), "1", "jzjtdeductamount", date);
                            this.doCalRuleAmount(summaryAccountingList, summary, deductRuleSettingTask1, "jzjtdeductamount");
                        }
                    } else if ("fseandkce".equals(rule.getString("deductproject"))) {
                        NewRuleSettingTask deductRuleSettingTask;
                        ruleSettingTask = new NewRuleSettingTask(new ConcurrentHashMap<String, String>(), new ConcurrentHashMap<String, Map<String, Object>>(), rule, model, rule.getDynamicObjectCollection("entryentity"), serialno, diffDraftMetaData.getDetailMetaDataNameMap().get(DraftConstant.YBNSR_DIFF_DETAIL), IncomeUtils.getDiffRates().get(diffType), "", "currentamount", date);
                        this.doCalRuleAmount(summaryAccountingList, summary, ruleSettingTask, "currentamount");
                        if (!rule.getBoolean("qzkce")) {
                            deductRuleSettingTask = new NewRuleSettingTask(new ConcurrentHashMap<String, String>(), new ConcurrentHashMap<String, Map<String, Object>>(), rule, model, rule.getDynamicObjectCollection("entryentity1"), serialno, diffDraftMetaData.getDetailMetaDataNameMap().get(DraftConstant.YBNSR_DIFF_DETAIL), IncomeUtils.getDiffRates().get(diffType), "1", "deductamount", date);
                            this.doCalRuleAmount(summaryAccountingList, summary, deductRuleSettingTask, "deductamount");
                        } else {
                            deductRuleSettingTask = new NewRuleSettingTask(new ConcurrentHashMap<String, String>(), new ConcurrentHashMap<String, Map<String, Object>>(), rule, model, rule.getDynamicObjectCollection("entryentity"), serialno, diffDraftMetaData.getDetailMetaDataNameMap().get(DraftConstant.YBNSR_DIFF_DETAIL), IncomeUtils.getDiffRates().get(diffType), "", "deductamount", date);
                            this.doCalRuleAmount(summaryAccountingList, summary, deductRuleSettingTask, "deductamount");
                        }
                    }
                    List<DynamicObject> editList = DraftEditService.matchDraftEditList(oldDraftList, draftEditArr, summary, "ruleid");
                    Map<String, BigDecimal> rowEditAmountMap = DraftEditService.getEditAmountBeforeReFetch(editList);
                    DraftEditService.updateDraftEditOriginAmount(summary, rowEditAmountMap, editList);
                    DraftEditService.addEditAmount(summary, rowEditAmountMap);
                    summaryList.add(summary);
                }
            }
            ArrayList<DynamicObject> deductSummaryList = new ArrayList<DynamicObject>(16);
            long sjkceRuleCount = sortedRules.stream().filter(s -> "bqsjkce".equals(s.getString("deductproject"))).count();
            DynamicObjectCollection oldDeductDraftList = DraftEditService.getDraftList(model, model.getDraftMetaDataDTO().getDiffDeduct());
            DynamicObject[] deductDraftEditArr = DraftEditService.getDraftEditList(oldDeductDraftList);
            if (sjkceRuleCount > 0L) {
                DynamicObject[] incomeAccountCollection = BusinessDataServiceHelper.load((String)model.getDraftMetaDataDTO().getIncome().getAccountMetaDataName(), (String)"businesstype,taxrate,taxmethodtype,pricetaxamount,jzjt,totaltaxamount", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)Long.parseLong(model.getOrgId())), new QFilter("taxperiod", "in", dateList)});
                String preSbbid = YbnsrServiceHelper.queryYbnsrPre((String)model.getOrgId(), (String)((String)model.getCustom().get("taxPayerType")), (String)model.getStartDate(), (String)model.getEndDate(), (int)this.getMonthOffset(model));
                DynamicObjectCollection fb3List = QueryServiceHelper.query((String)"tcvat_ybnsr_fb3", (String)"ewblxh,qmye", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)preSbbid)});
                List<DiffRuleTypeEnum> ybnsrDiffTypeList = DiffRuleTypeEnum.getYbnsrDiffTypeList();
                for (int i = 0; i < ybnsrDiffTypeList.size(); ++i) {
                    DiffRuleTypeEnum diffType = ybnsrDiffTypeList.get(i);
                    MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)model.getDraftMetaDataDTO().getDiffDeduct().getAccountMetaDataName());
                    DynamicObject deductSummary = new DynamicObject((DynamicObjectType)entityType);
                    deductSummary.set("ruleid", (Object)diffType.getId());
                    deductSummary.set("org", (Object)model.getOrgId());
                    deductSummary.set("taxperiod", (Object)model.getStartDate().substring(0, 7));
                    deductSummary.set("difftype", (Object)diffType.getId());
                    deductSummary.set("deadline", (Object)deadLine);
                    List<DynamicObject> incomeList = DiffDeductionEngineService.doGetIncomeList(incomeAccountCollection, diffType, false);
                    if (CollectionUtils.isNotEmpty(incomeList)) {
                        deductSummary.set("notaxamount", (Object)incomeList.stream().map(e -> e.getBigDecimal("pricetaxamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                    }
                    deductSummary.set("beginamount", (Object)this.doGetQcyeFromFb3(fb3List, i));
                    deductSummary.set("currentamount", (Object)this.sumCurrentAmount(summaryList, diffType));
                    deductSummary.set("predeductamount", (Object)deductSummary.getBigDecimal("beginamount").add(deductSummary.getBigDecimal("currentamount")));
                    deductSummary.set("endamount", (Object)deductSummary.getBigDecimal("predeductamount"));
                    Optional<DynamicObject> ruleOp = sortedRules.stream().filter(s -> s.getDynamicObject("difftype").get("number").equals(diffType.getNumber()) && Arrays.asList("fseandkce", "bqsjkce").contains(s.getString("deductproject"))).findFirst();
                    if (ruleOp.isPresent()) {
                        DynamicObject rule = ruleOp.get();
                        deductSummary.set("deductamount", (Object)this.doGetDeductAmount(rule, summaryList, deductSummary, diffType));
                        deductSummary.set("ruleid", (Object)rule.getLong("id"));
                        deductSummary.set("endamount", (Object)deductSummary.getBigDecimal("predeductamount").subtract(deductSummary.getBigDecimal("deductamount")));
                        deductSummary.set("jzjtdeductamount", (Object)this.doGetJzjtDeductAmount(rule, summaryList, deductSummary, diffType));
                    }
                    deductSummary.set("ynse", (Object)DiffDeductionEngineService.calYnse(incomeList.stream().map(e -> e.getBigDecimal("totaltaxamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO), deductSummary, diffType));
                    List<DynamicObject> jzjtIncomeList = DiffDeductionEngineService.doGetIncomeList(incomeAccountCollection, diffType, true);
                    if (CollectionUtils.isNotEmpty(jzjtIncomeList)) {
                        deductSummary.set("jzjtsumamount", (Object)jzjtIncomeList.stream().map(e -> e.getBigDecimal("pricetaxamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                    }
                    deductSummary.set("jzjtynse", (Object)DiffDeductionEngineService.calJzjtYnse(jzjtIncomeList.stream().map(e -> e.getBigDecimal("totaltaxamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO), deductSummary, diffType));
                    List<DynamicObject> editList = DraftEditService.matchDraftEditList(oldDeductDraftList, deductDraftEditArr, deductSummary, "ruleid");
                    Map<String, BigDecimal> rowEditAmountMap = DraftEditService.getEditAmountBeforeReFetch(editList);
                    DraftEditService.updateDraftEditOriginAmount(deductSummary, rowEditAmountMap, editList);
                    DraftEditService.addEditAmount(deductSummary, rowEditAmountMap);
                    deductSummaryList.add(deductSummary);
                }
            }
            DraftEngineEnum.YBNSR.deleteDiff(model);
            ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(summaryAccountingList));
            ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(summaryList));
            ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(deductSummaryList));
            DraftEditService.updateNewDraftId(summaryList, oldDraftList, draftEditArr, "ruleid");
            DraftEditService.updateNewDraftId(deductSummaryList, oldDeductDraftList, deductDraftEditArr, "ruleid");
        } else {
            DraftEngineEnum.YBNSR.deleteDiff(model);
        }
        logger.info("\u7ed3\u675f\u6267\u884c\u5dee\u989d\u6263\u9664\u5f15\u64ce\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        return null;
    }

    private BigDecimal doGetJzjtDeductAmount(DynamicObject rule, List<DynamicObject> summaryList, DynamicObject deductSummary, DiffRuleTypeEnum diffType) {
        if (diffType == DiffRuleTypeEnum.TYPE_MDTS || diffType == DiffRuleTypeEnum.TYPE_MS) {
            return BigDecimal.ZERO;
        }
        List kceList = summaryList.stream().filter(s -> s.getString("rowno").equals(diffType.getNumber()) && s.getString("deductproject").equals("bqsjkce")).collect(Collectors.toList());
        if (rule.getBoolean("equalsjkce")) {
            return deductSummary.getBigDecimal("deductamount");
        }
        if (CollectionUtils.isNotEmpty(kceList)) {
            return kceList.stream().map(kce -> kce.getBigDecimal("jzjtdeductamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal doGetDeductAmount(DynamicObject rule, List<DynamicObject> summaryList, DynamicObject deductSummary, DiffRuleTypeEnum diffType) {
        if (rule.getBoolean("minswitch")) {
            BigDecimal notaxamount = deductSummary.getBigDecimal("notaxamount");
            BigDecimal predeductamount = deductSummary.getBigDecimal("predeductamount");
            return notaxamount.min(predeductamount);
        }
        List kceList = summaryList.stream().filter(s -> s.getString("rowno").equals(diffType.getNumber()) && s.getString("deductproject").equals("bqsjkce")).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(kceList)) {
            return kceList.stream().map(kce -> kce.getBigDecimal("deductamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        }
        List msKceList = summaryList.stream().filter(s -> s.getString("rowno").equals(diffType.getNumber()) && s.getString("deductproject").equals("fseandkce")).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(msKceList)) {
            return msKceList.stream().map(kce -> kce.getBigDecimal("deductamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal sumCurrentAmount(List<DynamicObject> summaryList, DiffRuleTypeEnum diffType) {
        return summaryList.stream().filter(s -> s.getString("rowno").equals(diffType.getNumber())).map(s -> s.getBigDecimal("currentamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
    }

    private BigDecimal doGetQcyeFromFb3(DynamicObjectCollection fb3List, int index) {
        for (DynamicObject fb3 : fb3List) {
            if (fb3.getInt("ewblxh") != index + 1) continue;
            return fb3.getBigDecimal("qmye");
        }
        return BigDecimal.ZERO;
    }

    private int getMonthOffset(TcvatEngineModel model) {
        return DateUtils.monthOfD1MinusD2((Date)DateUtils.stringToDate2((String)model.getStartDate()), (Date)DateUtils.stringToDate2((String)model.getEndDate()));
    }

    private void doCalRuleAmount(List<DynamicObject> summaryAccountingList, DynamicObject summary, NewRuleSettingTask ruleSettingTask, String amountField) throws Exception {
        List futures = ThreadPoolsService.getInstance().submitReturnFuture((Task)ruleSettingTask);
        List accountingList = DiffDeductionEngine.getFutureList((List)futures);
        summaryAccountingList.addAll(accountingList);
        BigDecimal accountingamount = IncomeUtils.getAccountingAmount(accountingList);
        summary.set(amountField, (Object)accountingamount);
        if ("currentamount".equals(amountField)) {
            summary.set(amountField, (Object)accountingamount.setScale(2, 4));
        }
    }
}

