/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.engine.impl;

import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.db.DataSaveService;
import kd.taxc.bdtaxr.common.formula.biz.FormulaService;
import kd.taxc.bdtaxr.common.formula.cache.CacheUtils;
import kd.taxc.bdtaxr.common.formula.service.CacheFormulaService;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineTask;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.common.enums.DraftEngineEnum;

public class SmallScaleCurrentPaymentEngine
extends EngineTask<TcvatEngineModel, DynamicObject> {
    private static Log logger = LogFactory.getLog(SmallScaleCurrentPaymentEngine.class);

    protected DynamicObject execute() {
        logger.info("\u5f00\u59cb\u6267\u884c\u5c0f\u89c4\u6a21\u6267\u884c\u672c\u671f\u7f34\u7a0e\u60c5\u51b5\u8ba1\u7b97\u5f15\u64ce");
        long start = System.currentTimeMillis();
        TcvatEngineModel model = (TcvatEngineModel)this.getEngineModel();
        String orgId = model.getOrgId();
        String startDate = (String)model.getCustom().get("skssqq");
        String endDate = (String)model.getCustom().get("skssqz");
        String deadLine = (String)model.getCustom().get("deadLine");
        String draftpurpose = (String)model.getCustom().get("draftpurpose");
        IPageCache customCache = (IPageCache)model.getCustom().get("customCache");
        this.createDraft(orgId, startDate, endDate, deadLine, draftpurpose, customCache);
        logger.info("\u7ed3\u675f\u6267\u884c\u672c\u671f\u7f34\u7a0e\u60c5\u51b5\u8ba1\u7b97\u5f15\u64ce\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        return null;
    }

    public void createDraft(String orgId, String startDate, String endDate, String deadLine, String draftpurpose, IPageCache customCache) {
        String templateType = TaxDeclareHelper.getXgmTemplateType(deadLine, draftpurpose);
        CacheFormulaService.deleteCache((IPageCache)customCache);
        CacheUtils.getInstance().deleteCache(customCache);
        CacheUtils.getInstance().setDataResult(customCache, null);
        Map valueMap = FormulaService.query((IPageCache)customCache, (String)templateType, (String)orgId, (String)startDate, (String)endDate, (boolean)true);
        CacheFormulaService.deleteCache((IPageCache)customCache);
        CacheUtils.getInstance().deleteCache(customCache);
        CacheUtils.getInstance().setDataResult(customCache, null);
        this.handleSpecialValuePreSave(orgId, startDate, draftpurpose, valueMap);
        TcvatEngineModel model = new TcvatEngineModel(orgId, startDate, endDate);
        model.addCustom("skssqq", startDate);
        model.addCustom("skssqz", endDate);
        model.addCustom("deadLine", deadLine);
        model.addCustom("draftpurpose", draftpurpose);
        DraftEngineEnum.XGMNSR.deleteCurrentPay(model);
        DataSaveService.mapToTable((String)"tcvat_nsrxx", (Map)valueMap);
    }

    private void handleSpecialValuePreSave(String orgID, String startDate, String draftpurpose, Map<String, String> valueMap) {
        Date date = DateUtils.stringToDate((String)startDate, (String)"yyyy-MM");
        String table = "nssb".equals(draftpurpose) ? "tcvat_xgm_current_payment" : "tcvat_xgm_current_pay_jt";
        for (Map.Entry<String, String> entry : valueMap.entrySet()) {
            String entryKey;
            switch (entryKey = entry.getKey().replace(table, "")) {
                case "#1#taxperiod": 
                case "#2#taxperiod": 
                case "#3#taxperiod": 
                case "#4#taxperiod": 
                case "#5#taxperiod": 
                case "#6#taxperiod": 
                case "#7#taxperiod": 
                case "#8#taxperiod": {
                    entry.setValue(DateUtils.format((Date)date, (String)"yyyy-MM"));
                    break;
                }
                case "#9#taxperiod": 
                case "#10#taxperiod": 
                case "#11#taxperiod": 
                case "#12#taxperiod": 
                case "#13#taxperiod": 
                case "#14#taxperiod": 
                case "#15#taxperiod": 
                case "#16#taxperiod": {
                    entry.setValue(DateUtils.format((Date)DateUtils.addMonth((Date)date, (int)1), (String)"yyyy-MM"));
                    break;
                }
                case "#17#taxperiod": 
                case "#18#taxperiod": 
                case "#19#taxperiod": 
                case "#20#taxperiod": 
                case "#21#taxperiod": 
                case "#22#taxperiod": 
                case "#23#taxperiod": 
                case "#24#taxperiod": 
                case "#25#taxperiod": {
                    entry.setValue(DateUtils.format((Date)DateUtils.addMonth((Date)date, (int)2), (String)"yyyy-MM"));
                    break;
                }
                case "#1#org_id": 
                case "#2#org_id": 
                case "#3#org_id": 
                case "#4#org_id": 
                case "#5#org_id": 
                case "#6#org_id": 
                case "#7#org_id": 
                case "#8#org_id": 
                case "#9#org_id": 
                case "#10#org_id": 
                case "#11#org_id": 
                case "#12#org_id": 
                case "#13#org_id": 
                case "#14#org_id": 
                case "#15#org_id": 
                case "#16#org_id": 
                case "#17#org_id": 
                case "#18#org_id": 
                case "#19#org_id": 
                case "#20#org_id": 
                case "#21#org_id": 
                case "#22#org_id": 
                case "#23#org_id": 
                case "#24#org_id": 
                case "#25#org_id": {
                    entry.setValue(orgID);
                    break;
                }
                case "#1#description": 
                case "#9#description": 
                case "#17#description": {
                    entry.setValue(ResManager.loadKDString((String)"3%\u8d27\u7269\u548c\u52b3\u52a1\u7c7b", (String)"SmallScaleCurrentPaymentEngine_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                    break;
                }
                case "#2#description": 
                case "#10#description": 
                case "#18#description": {
                    entry.setValue(ResManager.loadKDString((String)"3%\u670d\u52a1\u548c\u65e0\u5f62\u8d44\u4ea7\u7c7b", (String)"SmallScaleCurrentPaymentEngine_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                    break;
                }
                case "#3#description": 
                case "#11#description": 
                case "#19#description": {
                    entry.setValue(ResManager.loadKDString((String)"5%\u670d\u52a1\u7c7b\u548c\u4e0d\u52a8\u4ea7\u7c7b", (String)"SmallScaleCurrentPaymentEngine_2", (String)"taxc-tcvat", (Object[])new Object[0]));
                    break;
                }
                case "#4#description": 
                case "#12#description": 
                case "#20#description": {
                    entry.setValue(ResManager.loadKDString((String)"  \u5176\u4e2d\uff1a\u4e0d\u52a8\u4ea7\u7c7b", (String)"SmallScaleCurrentPaymentEngine_9", (String)"taxc-tcvat", (Object[])new Object[0]));
                    break;
                }
                case "#5#description": 
                case "#13#description": 
                case "#21#description": {
                    entry.setValue(ResManager.loadKDString((String)"\u9500\u552e\u5df2\u4f7f\u7528\u56fa\u5b9a\u8d44\u4ea7\u7c7b", (String)"SmallScaleCurrentPaymentEngine_5", (String)"taxc-tcvat", (Object[])new Object[0]));
                    break;
                }
                case "#6#description": 
                case "#14#description": 
                case "#22#description": {
                    entry.setValue(ResManager.loadKDString((String)"\u5176\u4ed6\u514d\u7a0e\u9500\u552e\u989d", (String)"SmallScaleCurrentPaymentEngine_10", (String)"taxc-tcvat", (Object[])new Object[0]));
                    break;
                }
                case "#7#description": 
                case "#15#description": 
                case "#23#description": {
                    entry.setValue(ResManager.loadKDString((String)"\u51fa\u53e3\u514d\u7a0e\u9500\u552e\u989d", (String)"SmallScaleCurrentPaymentEngine_11", (String)"taxc-tcvat", (Object[])new Object[0]));
                    break;
                }
                case "#8#description": 
                case "#16#description": 
                case "#24#description": {
                    entry.setValue(ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"SmallScaleCurrentPaymentEngine_7", (String)"taxc-tcvat", (Object[])new Object[0]));
                    break;
                }
                case "#25#description": {
                    entry.setValue(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"SmallScaleCurrentPaymentEngine_8", (String)"taxc-tcvat", (Object[])new Object[0]));
                    break;
                }
            }
        }
    }
}

