/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.engine.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.constant.TaxRateConstant;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineTask;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tcvat.business.service.draft.TaxDeclarationService;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.engine.impl.service.DraftEditService;
import kd.taxc.tcvat.business.service.engine.impl.utils.IncomeUtils;
import kd.taxc.tcvat.business.service.engine.task.NewRuleSettingTask;
import kd.taxc.tcvat.business.service.engine.task.PartitionSaveTask;
import kd.taxc.tcvat.business.service.engine.task.util.NewRuleSettingUtils;
import kd.taxc.tcvat.common.constant.DraftConstant;
import kd.taxc.tcvat.common.constant.RuleSettingConstant;
import kd.taxc.tcvat.common.enums.DraftEngineEnum;
import kd.taxc.tcvat.common.util.UUID;

public class SmallScaleIncomeEngine
extends EngineTask<TcvatEngineModel, DynamicObject> {
    private static Log logger = LogFactory.getLog(SmallScaleIncomeEngine.class);

    protected DynamicObject execute() throws Exception {
        logger.info("\u5f00\u59cb\u5c0f\u89c4\u6a21\u6267\u884c\u6536\u5165\u5f15\u64ce");
        long start = System.currentTimeMillis();
        TcvatEngineModel model = (TcvatEngineModel)this.getEngineModel();
        DraftMetaDataDTO draftMetaDataDTO = model.getDraftMetaDataDTO();
        String policyConfirm = draftMetaDataDTO.getPolicyConfirm().getAccountMetaDataName();
        String incomeSummary = draftMetaDataDTO.getIncome().getAccountMetaDataName();
        String ruleAndDraftPurpose = draftMetaDataDTO.getDraftPurpose();
        String orgId = model.getOrgId();
        Object deadLine = model.getCustom().get("deadLine");
        Date lastMonthFirstDay = DateUtils.stringToDate((String)model.getStartDate());
        Date lastMonthLastDay = DateUtils.stringToDate((String)model.getEndDate());
        QFilter orgidFilter = new QFilter("orgid", "=", (Object)Long.parseLong(orgId));
        QFilter reportPeriodFilter = new QFilter("reportperiod", ">=", (Object)lastMonthFirstDay).and(new QFilter("reportperiod", "<=", (Object)lastMonthLastDay));
        QFilter taxPayerTypeFilter = new QFilter("taxplayeraptitude", "=", model.getCustom().get("taxPayerType"));
        QFilter draftPurposeFilter = new QFilter("draftpurpose", "=", model.getCustom().get("draftpurpose"));
        DynamicObject confirm = QueryServiceHelper.queryOne((String)policyConfirm, (String)"ruledata_tag", (QFilter[])new QFilter[]{orgidFilter, reportPeriodFilter, taxPayerTypeFilter, draftPurposeFilter});
        if (null == confirm) {
            return null;
        }
        String ruledata_tag = confirm.getString("ruledata_tag");
        JSONObject rulesObject = JSONObject.parseObject((String)ruledata_tag);
        JSONArray incomerules = null;
        if (rulesObject != null) {
            incomerules = rulesObject.getJSONArray(RuleTypeEnum.INCOME.name());
        }
        List incomeRuleList = (List)RuleUtils.getSharingAndOrgRules((Long)Long.parseLong(model.getOrgId()), (RuleTypeEnum)RuleTypeEnum.INCOME, (String)((String)model.getCustom().get("taxPayerType")).replace("zzs", ""), (String)ruleAndDraftPurpose).get(RuleTypeEnum.INCOME);
        if (incomerules != null && incomerules.size() > 0) {
            ArrayList<DynamicObject> summaryList = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> summaryAccountingList = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> summaryInvoiceList = new ArrayList<DynamicObject>();
            ConcurrentHashMap<String, String> allInvoiceItemIdBeUsedByIncomeRuleXseMap = new ConcurrentHashMap<String, String>();
            ConcurrentHashMap<String, String> allInvoiceItemIdBeUsedByIncomeRuleSeMap = new ConcurrentHashMap<String, String>();
            ConcurrentHashMap<String, Map<String, Object>> repeatInvoiceDataMap = new ConcurrentHashMap<String, Map<String, Object>>();
            List<String> dateList = TaxDeclarationService.getRealQuarter(model.getDraftMetaDataDTO().getDraftPurpose(), model.getOrgId(), (String)model.getCustom().get("skssqq"), (String)model.getCustom().get("skssqz"));
            DynamicObjectCollection oldDraftList = DraftEditService.getDraftList(model, model.getDraftMetaDataDTO().getIncome());
            DynamicObject[] draftEditArr = DraftEditService.getDraftEditList(oldDraftList);
            for (String date : dateList) {
                for (int i = 0; i < incomerules.size(); ++i) {
                    BigDecimal wkpTax;
                    List<DynamicObject> wkpTaxList;
                    BigDecimal otherTax;
                    List<DynamicObject> otherTaxList;
                    BigDecimal invoiceTax;
                    List<DynamicObject> invoiceTaxList;
                    DynamicObject deductionRule;
                    JSONObject incomerule = incomerules.getJSONObject(i);
                    DynamicObject rule = IncomeUtils.getIncomeRule(incomerule.getLong("id"), incomeRuleList);
                    if (rule == null) continue;
                    String serialno = UUID.randomUUID();
                    MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)incomeSummary);
                    DynamicObject summary = new DynamicObject((DynamicObjectType)entityType);
                    summary.set("serialno", (Object)serialno);
                    summary.set("jzjt", rule.get("jzjt"));
                    summary.set("org", (Object)orgId);
                    summary.set("taxperiod", (Object)date);
                    summary.set("ruleid", (Object)incomerule.getLong("id"));
                    DynamicObjectCollection businesstypeList = rule.getDynamicObjectCollection("businesstype");
                    if (businesstypeList.size() > 0) {
                        DynamicObject businesstype = (DynamicObject)businesstypeList.get(0);
                        summary.set("businesstype", (Object)businesstype.getDynamicObject("fbasedataid"));
                    }
                    summary.set("description", (Object)incomerule.getJSONObject("name").getString("zh_CN"));
                    JSONObject taxmethodValue = incomerule.getJSONObject("taxation");
                    summary.set("taxmethod", (Object)taxmethodValue.getJSONObject("name").getString("zh_CN"));
                    summary.set("taxmethodtype", taxmethodValue.get((Object)"id"));
                    String taxrate = incomerule.getJSONObject("taxrate").getJSONObject("name").getString("zh_CN");
                    summary.set("taxrate", (Object)taxrate);
                    if (StringUtils.equals((CharSequence)((CharSequence)TaxRateConstant.getTaxmethodMap().get(TaxRateConstant.getExcludeTaxCN())), (CharSequence)taxmethodValue.get((Object)"number").toString()) && null != (deductionRule = rule.getDynamicObject("deductiontype"))) {
                        summary.set("taxreductionid", deductionRule.get("id"));
                        summary.set("taxreductioncode", deductionRule.get("number"));
                        summary.set("taxreductionname", (Object)deductionRule.getString("name"));
                        summary.set("taxreductiontype", (Object)deductionRule.getString("deductiontype"));
                    }
                    taxrate = NewRuleSettingUtils.trimTaxRate(taxrate);
                    BigDecimal taxrateBig = new BigDecimal(taxrate.replaceAll("%", "")).divide(NewRuleSettingUtils.ONE_HUNDRED);
                    boolean invoiceseqs = rule.getBoolean("invoiceseqs");
                    boolean qtfpseqs = rule.getBoolean("qtfpseqs");
                    boolean wkpseqs = rule.getBoolean("wkpseqs");
                    NewRuleSettingTask invoiceTask = new NewRuleSettingTask(allInvoiceItemIdBeUsedByIncomeRuleXseMap, repeatInvoiceDataMap, rule, model, rule.getDynamicObjectCollection("invoiceentity"), serialno, DraftConstant.XGMNSR_INVOICE_DETAIL, taxrate, "12", RuleSettingConstant.GET_DATE_TYPE_ZYSR, date);
                    List invoiceFutures = ThreadPoolsService.getInstance().submitReturnFuture((Task)invoiceTask);
                    NewRuleSettingTask otherInvoiceTask = new NewRuleSettingTask(allInvoiceItemIdBeUsedByIncomeRuleXseMap, repeatInvoiceDataMap, rule, model, rule.getDynamicObjectCollection("entryentity1"), serialno, DraftConstant.XGMNSR_ACCOUNTING_DETAIL, taxrate, "1", RuleSettingConstant.GET_DATE_TYPE_QTSR, date);
                    List otherFutures = ThreadPoolsService.getInstance().submitReturnFuture((Task)otherInvoiceTask);
                    NewRuleSettingTask ruleSettingTask = new NewRuleSettingTask(allInvoiceItemIdBeUsedByIncomeRuleXseMap, repeatInvoiceDataMap, rule, model, rule.getDynamicObjectCollection("entryentity"), serialno, DraftConstant.XGMNSR_ACCOUNTING_DETAIL, taxrate, "", RuleSettingConstant.GET_DATE_TYPE_WKPSR, date);
                    List futures = ThreadPoolsService.getInstance().submitReturnFuture((Task)ruleSettingTask);
                    List invoiceTaxFutures = null;
                    if (invoiceseqs) {
                        NewRuleSettingTask invoiceTaxTask = new NewRuleSettingTask(allInvoiceItemIdBeUsedByIncomeRuleSeMap, repeatInvoiceDataMap, rule, model, rule.getDynamicObjectCollection("entryentity2"), serialno, DraftConstant.XGMNSR_INVOICE_DETAIL, taxrate, "2", RuleSettingConstant.GET_DATE_TYPE_ZYSE, date);
                        invoiceTaxFutures = ThreadPoolsService.getInstance().submitReturnFuture((Task)invoiceTaxTask);
                    }
                    List otherTaxFutures = null;
                    if (qtfpseqs) {
                        NewRuleSettingTask otherInvoiceTaxTask = new NewRuleSettingTask(allInvoiceItemIdBeUsedByIncomeRuleSeMap, repeatInvoiceDataMap, rule, model, rule.getDynamicObjectCollection("entryentity11"), serialno, DraftConstant.XGMNSR_ACCOUNTING_DETAIL, taxrate, "11", RuleSettingConstant.GET_DATE_TYPE_QTSE, date);
                        otherTaxFutures = ThreadPoolsService.getInstance().submitReturnFuture((Task)otherInvoiceTaxTask);
                    }
                    List wkpseFutures = null;
                    if (wkpseqs) {
                        NewRuleSettingTask wkpseTask = new NewRuleSettingTask(allInvoiceItemIdBeUsedByIncomeRuleSeMap, repeatInvoiceDataMap, rule, model, rule.getDynamicObjectCollection("entryentity3"), serialno, DraftConstant.XGMNSR_ACCOUNTING_DETAIL, taxrate, "3", RuleSettingConstant.GET_DATE_TYPE_WKPSE, date);
                        wkpseFutures = ThreadPoolsService.getInstance().submitReturnFuture((Task)wkpseTask);
                    }
                    List invoiceList = SmallScaleIncomeEngine.getFutureList((List)invoiceFutures);
                    summaryInvoiceList.addAll(invoiceList);
                    BigDecimal invoiceamount = IncomeUtils.getInvoiceTotalAmount(invoiceList, "invoiceamount");
                    List otherAccountingList = SmallScaleIncomeEngine.getFutureList((List)otherFutures);
                    summaryAccountingList.addAll(otherAccountingList);
                    BigDecimal otherAccount = IncomeUtils.getAccountingAmount(otherAccountingList);
                    List accountingList = SmallScaleIncomeEngine.getFutureList((List)futures);
                    summaryAccountingList.addAll(accountingList);
                    BigDecimal accountingamount = IncomeUtils.getAccountingAmount(accountingList);
                    if (invoiceseqs && invoiceTaxFutures != null) {
                        invoiceTaxList = SmallScaleIncomeEngine.getFutureList((List)invoiceTaxFutures);
                        summaryInvoiceList.addAll(invoiceTaxList);
                        if (EmptyCheckUtils.isNotEmpty(invoiceTaxList)) {
                            invoiceTaxList.forEach(a -> a.set("taxamount", a.get("invoiceamount")));
                        }
                        invoiceTax = IncomeUtils.getInvoiceTotalAmount(invoiceTaxList, "invoiceamount");
                    } else {
                        invoiceTaxList = NewRuleSettingUtils.buildTaxDetail(invoiceList, taxrateBig, DraftConstant.YBNSR_INCOME_INVOICE_DETAIL, RuleSettingConstant.GET_DATE_TYPE_ZYSE);
                        summaryInvoiceList.addAll(invoiceTaxList);
                        invoiceTax = IncomeUtils.getAccountingTaxAmount(invoiceTaxList);
                    }
                    if (qtfpseqs && otherTaxFutures != null) {
                        otherTaxList = SmallScaleIncomeEngine.getFutureList((List)otherTaxFutures);
                        summaryAccountingList.addAll(otherTaxList);
                        if (EmptyCheckUtils.isNotEmpty(otherTaxList)) {
                            otherTaxList.forEach(a -> a.set("taxamount", a.get("amount")));
                        }
                        otherTax = IncomeUtils.getAccountingAmount(otherTaxList);
                    } else {
                        otherTaxList = NewRuleSettingUtils.buildTaxDetail(otherAccountingList, taxrateBig, DraftConstant.XGMNSR_ACCOUNTING_DETAIL, RuleSettingConstant.GET_DATE_TYPE_QTSE);
                        summaryAccountingList.addAll(otherTaxList);
                        otherTax = IncomeUtils.getAccountingTaxAmount(otherTaxList);
                    }
                    if (wkpseqs && wkpseFutures != null) {
                        wkpTaxList = SmallScaleIncomeEngine.getFutureList((List)wkpseFutures);
                        summaryAccountingList.addAll(wkpTaxList);
                        wkpTax = IncomeUtils.getAccountingAmount(wkpTaxList);
                        if (EmptyCheckUtils.isNotEmpty(wkpTaxList)) {
                            wkpTaxList.forEach(a -> a.set("taxamount", a.get("amount")));
                        }
                    } else {
                        wkpTaxList = NewRuleSettingUtils.buildTaxDetail(accountingList, taxrateBig, DraftConstant.XGMNSR_ACCOUNTING_DETAIL, RuleSettingConstant.GET_DATE_TYPE_WKPSE);
                        summaryAccountingList.addAll(wkpTaxList);
                        wkpTax = IncomeUtils.getAccountingTaxAmount(wkpTaxList);
                    }
                    summary.set("specialinvoiceamount", (Object)invoiceamount);
                    summary.set("specialtaxamount", (Object)invoiceTax);
                    summary.set("otherinvoiceamount", (Object)otherAccount);
                    summary.set("othertaxamount", (Object)otherTax);
                    summary.set("noneinvoiceamount", (Object)accountingamount);
                    summary.set("nonetaxamount", (Object)wkpTax);
                    summary.set("deadline", deadLine);
                    summaryList.add(summary);
                    List<DynamicObject> editList = DraftEditService.matchDraftEditList(oldDraftList, draftEditArr, summary, "ruleid");
                    Map<String, BigDecimal> rowEditAmountMap = DraftEditService.getEditAmountBeforeReFetch(editList);
                    DraftEditService.updateDraftEditOriginAmount(summary, rowEditAmountMap, editList);
                    if (rowEditAmountMap.get("specialinvoiceamount") != null) {
                        invoiceamount = invoiceamount.add(rowEditAmountMap.get("specialinvoiceamount"));
                        summary.set("specialinvoiceamount", (Object)invoiceamount);
                    }
                    if (rowEditAmountMap.get("specialtaxamount") != null) {
                        invoiceTax = invoiceTax.add(rowEditAmountMap.get("specialtaxamount"));
                        summary.set("specialtaxamount", (Object)invoiceTax);
                    }
                    if (rowEditAmountMap.get("otherinvoiceamount") != null) {
                        otherAccount = otherAccount.add(rowEditAmountMap.get("otherinvoiceamount"));
                        summary.set("otherinvoiceamount", (Object)otherAccount);
                    }
                    if (rowEditAmountMap.get("othertaxamount") != null) {
                        otherTax = otherTax.add(rowEditAmountMap.get("othertaxamount"));
                        summary.set("othertaxamount", (Object)otherTax);
                    }
                    if (rowEditAmountMap.get("noneinvoiceamount") != null) {
                        accountingamount = accountingamount.add(rowEditAmountMap.get("noneinvoiceamount"));
                        summary.set("noneinvoiceamount", (Object)accountingamount);
                    }
                    if (rowEditAmountMap.get("nonetaxamount") != null) {
                        wkpTax = wkpTax.add(rowEditAmountMap.get("nonetaxamount"));
                        summary.set("nonetaxamount", (Object)wkpTax);
                    }
                    BigDecimal totalAmount = BigDecimalUtil.addWithHalfUp((BigDecimal[])new BigDecimal[]{invoiceamount, otherAccount, accountingamount});
                    summary.set("totalinvoiceamount", (Object)totalAmount);
                    BigDecimal totaltaxamount = BigDecimalUtil.addWithHalfUp((BigDecimal[])new BigDecimal[]{invoiceTax, otherTax, wkpTax});
                    summary.set("totaltaxamount", (Object)totaltaxamount);
                    summary.set("pricetaxamount", (Object)BigDecimalUtil.addObject((Object)totalAmount, (Object)totaltaxamount));
                }
            }
            model.addErrorMap(repeatInvoiceDataMap);
            allInvoiceItemIdBeUsedByIncomeRuleXseMap.putAll(allInvoiceItemIdBeUsedByIncomeRuleSeMap);
            model.setEntryIds(allInvoiceItemIdBeUsedByIncomeRuleXseMap.keySet());
            List<DynamicObject> groupSummaryDataList = IncomeUtils.groupSummaryData("SmallScaleIncomeEngine", model, summaryList);
            DraftEngineEnum.XGMNSR.deleteIncome(model);
            ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(summaryAccountingList));
            ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(summaryInvoiceList));
            ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(summaryList));
            ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(groupSummaryDataList));
            DraftEditService.updateNewDraftId(summaryList, oldDraftList, draftEditArr, "ruleid");
        } else {
            DraftEngineEnum.XGMNSR.deleteIncome(model);
        }
        logger.info("\u7ed3\u675f\u6267\u884c\u6536\u5165\u5f15\u64ce\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        return null;
    }
}

