/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.engine.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineTask;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.tcvat.business.service.draft.TaxDeclarationService;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.engine.impl.service.DraftEditService;
import kd.taxc.tcvat.business.service.engine.impl.utils.ReductionUtils;
import kd.taxc.tcvat.business.service.engine.task.PartitionSaveTask;
import kd.taxc.tcvat.business.service.engine.task.SmallScaleRuleSettingTask;
import kd.taxc.tcvat.common.enums.DraftEngineEnum;
import kd.taxc.tcvat.common.util.UUID;

public class SmallScaleTaxReductionEngine
extends EngineTask<TcvatEngineModel, DynamicObject> {
    private static Log logger = LogFactory.getLog(SmallScaleTaxReductionEngine.class);

    protected DynamicObject execute() throws Exception {
        logger.info("\u5f00\u59cb\u6267\u884c\u51cf\u514d\u7a0e\u53f0\u8d26\u5f15\u64ce");
        long start = System.currentTimeMillis();
        TcvatEngineModel model = (TcvatEngineModel)this.getEngineModel();
        DraftMetaDataInfo taxReductionMetaData = model.getDraftMetaDataDTO().getTaxReduction();
        String rulePurpose = (String)model.getCustom().get("rulePurpose");
        List<Object> dateList = new ArrayList<String>();
        if ("zzsxgmnsr".equals(model.getCustom().get("taxPayerType"))) {
            dateList = TaxDeclarationService.getRealQuarter(model.getDraftMetaDataDTO().getDraftPurpose(), model.getOrgId(), (String)model.getCustom().get("skssqq"), (String)model.getCustom().get("skssqz"));
        } else {
            dateList.add(model.getCustom().get("taxperiod").toString());
        }
        List rules = (List)RuleUtils.getSharingAndOrgRules((Long)Long.parseLong(model.getOrgId()), (RuleTypeEnum)RuleTypeEnum.REDUCE, (String)((String)model.getCustom().get("taxPayerType")).replace("zzs", ""), (String)rulePurpose).get(RuleTypeEnum.REDUCE);
        ArrayList<DynamicObject> summaryAccountingList = new ArrayList<DynamicObject>();
        if (rules != null && rules.size() > 0) {
            ArrayList<DynamicObject> summaryList = new ArrayList<DynamicObject>(rules.size());
            ArrayList<DynamicObject> groupSummaryDataList = new ArrayList<DynamicObject>(rules.size());
            DynamicObjectCollection oldDraftList = DraftEditService.getDraftList(model, model.getDraftMetaDataDTO().getTaxReduction());
            DynamicObject[] draftEditArr = DraftEditService.getDraftEditList(oldDraftList);
            for (String string : dateList) {
                for (DynamicObject rule : rules) {
                    if (rule.getLong("deductiontype.id") == 790468283538082818L) continue;
                    String serialno = UUID.randomUUID();
                    MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)taxReductionMetaData.getAccountMetaDataName());
                    DynamicObject summary = new DynamicObject((DynamicObjectType)entityType);
                    summary.set("taxperiod", (Object)string);
                    SmallScaleRuleSettingTask ruleSettingTask = new SmallScaleRuleSettingTask(rule, model, rule.getDynamicObjectCollection("entryentity"), serialno, taxReductionMetaData.getDetailMetaDataNameMap().get("tcvat_taxreduce_detail"), null, string);
                    List futures = ThreadPoolsService.getInstance().submitReturnFuture((Task)ruleSettingTask);
                    List accountingList = SmallScaleTaxReductionEngine.getFutureList((List)futures);
                    summaryAccountingList.addAll(accountingList);
                    ReductionUtils.setCommon(model, accountingList, rule, serialno, summary);
                    List<DynamicObject> editList = DraftEditService.matchDraftEditList(oldDraftList, draftEditArr, summary, "ruleid");
                    Map<String, BigDecimal> rowEditAmountMap = DraftEditService.getEditAmountBeforeReFetch(editList);
                    DraftEditService.updateDraftEditOriginAmount(summary, rowEditAmountMap, editList);
                    DraftEditService.addEditAmount(summary, rowEditAmountMap);
                    summaryList.add(summary);
                }
            }
            groupSummaryDataList.addAll(ReductionUtils.groupSummaryData("zzsxgmnsr", model, summaryList));
            DraftEngineEnum.XGMNSR.deleteTaxReduce(model);
            ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(summaryAccountingList));
            ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(summaryList));
            ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(groupSummaryDataList));
            DraftEditService.updateNewDraftId(summaryList, oldDraftList, draftEditArr, "ruleid");
        } else {
            DraftEngineEnum.XGMNSR.deleteTaxReduce(model);
        }
        logger.info("\u7ed3\u675f\u6267\u884c\u51cf\u514d\u7a0e\u53f0\u8d26\u5f15\u64ce\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        return null;
    }
}

