/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.engine.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineTask;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.draft.TaxDeclarationService;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.engine.impl.service.DraftEditService;
import kd.taxc.tcvat.business.service.engine.impl.utils.ReductionUtils;
import kd.taxc.tcvat.business.service.engine.task.PartitionSaveTask;
import kd.taxc.tcvat.business.service.engine.task.RuleSettingTask;
import kd.taxc.tcvat.common.enums.DraftEngineEnum;
import kd.taxc.tcvat.common.util.UUID;

public class TaxReductionEngine
extends EngineTask<TcvatEngineModel, DynamicObject> {
    private static Log logger = LogFactory.getLog(TaxReductionEngine.class);

    protected DynamicObject execute() throws Exception {
        logger.info("\u5f00\u59cb\u6267\u884c\u51cf\u514d\u7a0e\u53f0\u8d26\u5f15\u64ce");
        long start = System.currentTimeMillis();
        TcvatEngineModel model = (TcvatEngineModel)this.getEngineModel();
        DraftMetaDataInfo taxReductionMetaData = model.getDraftMetaDataDTO().getTaxReduction();
        String rulePurpose = (String)model.getCustom().get("rulePurpose");
        String taxpayertype = ((String)model.getCustom().get("taxPayerType")).replace("zzs", "");
        List rules = (List)RuleUtils.getSharingAndOrgRules((Long)Long.parseLong(model.getOrgId()), (RuleTypeEnum)RuleTypeEnum.REDUCE, (String)taxpayertype, (String)rulePurpose).get(RuleTypeEnum.REDUCE);
        if (rules != null && rules.size() > 0) {
            ArrayList<DynamicObject> summaryList = new ArrayList<DynamicObject>(rules.size());
            ArrayList<DynamicObject> summaryAccountingList = new ArrayList<DynamicObject>();
            List<String> dateList = TaxDeclarationService.getRealQuarter(model.getDraftMetaDataDTO().getDraftPurpose(), model.getOrgId(), (String)model.getCustom().get("skssqq"), (String)model.getCustom().get("skssqz"));
            DynamicObjectCollection oldDraftList = DraftEditService.getDraftList(model, model.getDraftMetaDataDTO().getTaxReduction());
            DynamicObject[] draftEditArr = DraftEditService.getDraftEditList(oldDraftList);
            for (String date : dateList) {
                for (DynamicObject rule : rules) {
                    if (!rule.getString("taxpayertype").equals(taxpayertype)) continue;
                    String serialno = UUID.randomUUID();
                    MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)taxReductionMetaData.getAccountMetaDataName());
                    DynamicObject summary = new DynamicObject((DynamicObjectType)entityType);
                    RuleSettingTask ruleSettingTask = new RuleSettingTask(rule, model, rule.getDynamicObjectCollection("entryentity"), serialno, taxReductionMetaData.getDetailMetaDataNameMap().get("tcvat_taxreduce_detail"), null, date);
                    List futures = ThreadPoolsService.getInstance().submitReturnFuture((Task)ruleSettingTask);
                    List accountingList = TaxReductionEngine.getFutureList((List)futures);
                    summaryAccountingList.addAll(accountingList);
                    ReductionUtils.setCommon(model, accountingList, rule, serialno, summary);
                    summary.set("taxperiod", (Object)date);
                    if ("sjjt".equals(model.getDraftMetaDataDTO().getDraftPurpose())) {
                        summary.set("taxperioddate", (Object)DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate2((String)date, (String)"yyyy-MM")));
                    }
                    List<DynamicObject> editList = DraftEditService.matchDraftEditList(oldDraftList, draftEditArr, summary, "ruleid");
                    Map<String, BigDecimal> rowEditAmountMap = DraftEditService.getEditAmountBeforeReFetch(editList);
                    DraftEditService.updateDraftEditOriginAmount(summary, rowEditAmountMap, editList);
                    DraftEditService.addEditAmount(summary, rowEditAmountMap);
                    summaryList.add(summary);
                }
            }
            List<DynamicObject> groupSummaryDataList = ReductionUtils.groupSummaryData("zzsybnsr", model, summaryList);
            DraftEngineEnum.YBNSR.deleteTaxReduce(model);
            ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(summaryAccountingList));
            ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(summaryList));
            ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(groupSummaryDataList));
            DraftEditService.updateNewDraftId(summaryList, oldDraftList, draftEditArr, "ruleid");
        } else {
            DraftEngineEnum.YBNSR.deleteTaxReduce(model);
        }
        logger.info("\u7ed3\u675f\u6267\u884c\u51cf\u514d\u7a0e\u53f0\u8d26\u5f15\u64ce\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        return null;
    }
}

