/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.engine.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineTask;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tcvat.business.service.account.DeductionService;
import kd.taxc.tcvat.business.service.draft.TaxDeclarationService;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.engine.impl.service.DraftEditService;
import kd.taxc.tcvat.business.service.engine.impl.utils.IncomeUtils;
import kd.taxc.tcvat.business.service.engine.impl.utils.WaitDeductionUtils;
import kd.taxc.tcvat.business.service.engine.task.PartitionSaveTask;
import kd.taxc.tcvat.common.enums.DraftEngineEnum;
import kd.taxc.tcvat.common.util.UUID;

public class WaitDeductionEngine
extends EngineTask<TcvatEngineModel, DynamicObject> {
    private static Log logger = LogFactory.getLog(WaitDeductionEngine.class);

    protected DynamicObject execute() throws Exception {
        logger.info("\u5f00\u59cb\u6267\u884c\u5f85\u8fdb\u9879\u62b5\u6263\u5f15\u64ce");
        long start = System.currentTimeMillis();
        TcvatEngineModel model = (TcvatEngineModel)this.getEngineModel();
        DraftMetaDataDTO draftMetaDataDTO = model.getDraftMetaDataDTO();
        String rulePurpose = (String)model.getCustom().get("rulePurpose");
        Date startDate = DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)model.getStartDate()));
        Date endDate = DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)model.getEndDate()));
        QFilter orgidFilter = new QFilter("orgid", "=", (Object)Long.parseLong(model.getOrgId()));
        QFilter reportPeriodFilter = new QFilter("reportperiod", ">=", (Object)startDate).and(new QFilter("reportperiod", "<=", (Object)endDate));
        QFilter taxPayerTypeFilter = new QFilter("taxplayeraptitude", "=", (Object)"zzsybnsr");
        QFilter draftPurposeFilter = new QFilter("draftpurpose", "=", (Object)model.getDraftMetaDataDTO().getDraftPurpose());
        DynamicObject confirm = QueryServiceHelper.queryOne((String)draftMetaDataDTO.getPolicyConfirm().getAccountMetaDataName(), (String)"id", (QFilter[])new QFilter[]{orgidFilter, reportPeriodFilter, taxPayerTypeFilter, draftPurposeFilter});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)confirm.getLong("id"), (String)"tcvat_policy_confirm");
        String ruledata_tag = dynamicObject.getString("ruledata_tag");
        JSONObject object = JSONObject.parseObject((String)ruledata_tag);
        JSONArray deductionRules = new JSONArray();
        if (object != null) {
            deductionRules = object.getJSONArray(RuleTypeEnum.DEDUCT.name());
        }
        String taxPayerType = (String)model.getCustom().get("taxPayerType");
        List deductRuleList = (List)RuleUtils.getSharingAndOrgRules((Long)Long.parseLong(model.getOrgId()), (RuleTypeEnum)RuleTypeEnum.DEDUCT, (String)taxPayerType.replace("zzs", ""), (String)rulePurpose).get(RuleTypeEnum.DEDUCT);
        if (!deductionRules.isEmpty()) {
            ArrayList<DynamicObject> summaryList = new ArrayList<DynamicObject>(10);
            ArrayList<DynamicObject> summaryAccountingList = new ArrayList<DynamicObject>();
            List<String> dateList = TaxDeclarationService.getRealQuarter(model.getDraftMetaDataDTO().getDraftPurpose(), model.getOrgId(), (String)model.getCustom().get("skssqq"), (String)model.getCustom().get("skssqz"));
            List<String> initList = Arrays.asList("VAT_JXDK_BQDK_11", "VAT_JXDK_DDK_1", "VAT_JXDK_DDK_2", "VAT_JXDK_DDK_3", "VAT_JXDK_DDK_4", "VAT_JXDK_DDK_5", "VAT_JXDK_DDK_6", "VAT_JXDK_DDK_7", "VAT_JXDK_DDK_8", "VAT_JXDK_DDK_9", "VAT_JXDK_DDK_00", "VAT_JXDK_BQDK_15", "VAT_JXDK_BQDK_16", "VAT_JXDK_BQDK_17", "VAT_JXDK_BQDK_18");
            DynamicObjectCollection query = QueryServiceHelper.query((String)"tpo_tcvat_bizdef", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "in", initList)});
            DynamicObjectCollection oldDraftList = DraftEditService.getDraftList(model, model.getDraftMetaDataDTO().getWaitDeduction());
            DynamicObject[] draftEditArr = DraftEditService.getDraftEditList(oldDraftList);
            for (String date : dateList) {
                HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>();
                this.initMap(model, map, date, query);
                for (int i = 0; i < deductionRules.size(); ++i) {
                    Long deducttype;
                    DynamicObject summary;
                    JSONObject waitDeductionRule = deductionRules.getJSONObject(i);
                    DynamicObject rule = WaitDeductionUtils.getWaitDeductionRule(waitDeductionRule.getLong("id"), deductRuleList);
                    if (null == rule || null == (summary = map.get(deducttype = Long.valueOf(rule.getLong("deducttype.id"))))) continue;
                    Map<String, List<Future<Object>>> calMap = WaitDeductionUtils.calResult(rule, model, summary.getString("serialno"), date);
                    List<Future<Object>> countFutures = calMap.get("count");
                    List<Future<Object>> amountFutures = calMap.get("amount");
                    List<Future<Object>> taxFutures = calMap.get("taxamount");
                    List amountList = WaitDeductionEngine.getFutureList(amountFutures);
                    BigDecimal amount = IncomeUtils.getInvoiceTotalAmount(amountList, "fetchamount");
                    summary.set("amount", (Object)BigDecimalUtil.addObject((Object)summary.get("amount"), (Object)amount));
                    summaryAccountingList.addAll(amountList);
                    if (BigDecimal.ZERO.compareTo(BigDecimalUtil.toBigDecimal((Object)summary.get("count"))) > 0) {
                        summary.set("count", (Object)BigDecimal.ZERO);
                    }
                    List countList = WaitDeductionEngine.getFutureList(countFutures);
                    BigDecimal count = IncomeUtils.getInvoiceTotalAmount(countList, "amount");
                    summary.set("count", (Object)BigDecimalUtil.addObject((Object)summary.get("count"), (Object)count));
                    summaryAccountingList.addAll(countList);
                    List taxList = WaitDeductionEngine.getFutureList(taxFutures);
                    BigDecimal taxAmount = IncomeUtils.getInvoiceTotalAmount(taxList, "fetchamount");
                    summary.set("taxamount", (Object)BigDecimalUtil.addObject((Object)summary.get("taxamount"), (Object)taxAmount));
                    summaryAccountingList.addAll(taxList);
                }
                for (Map.Entry<Long, DynamicObject> entry : map.entrySet()) {
                    DynamicObject summary = entry.getValue();
                    if (BigDecimal.ZERO.compareTo(BigDecimalUtil.toBigDecimal((Object)summary.get("count"))) > 0) continue;
                    String serialno = summary.getString("serialno");
                    List accountList = summaryAccountingList.stream().filter(s -> serialno.equals(s.getString("taxaccountserialno"))).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(accountList)) continue;
                    List<DynamicObject> editList = DraftEditService.matchDraftEditList(oldDraftList, draftEditArr, summary, "deductiontype");
                    Map<String, BigDecimal> rowEditAmountMap = DraftEditService.getEditAmountBeforeReFetch(editList);
                    DraftEditService.updateDraftEditOriginAmount(summary, rowEditAmountMap, editList);
                    DraftEditService.addEditAmount(summary, rowEditAmountMap);
                    summaryList.add(summary);
                }
            }
            DraftEngineEnum.YBNSR.deleteWait(model);
            ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(summaryAccountingList));
            ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(summaryList));
            DraftEditService.updateNewDraftId(summaryList, oldDraftList, draftEditArr, "deductiontype");
        } else {
            DraftEngineEnum.YBNSR.deleteWait(model);
        }
        logger.info("\u7ed3\u675f\u6267\u884c\u8fdb\u9879\u5f85\u6263\u9664\u5f15\u64ce\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        return null;
    }

    private void initMap(TcvatEngineModel model, HashMap<Long, DynamicObject> map, String taxperiod, DynamicObjectCollection query) {
        Object deadLine = model.getCustom().get("deadLine");
        for (DynamicObject dynamicObject : query) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)model.getDraftMetaDataDTO().getWaitDeduction().getAccountMetaDataName());
            DynamicObject summary = new DynamicObject((DynamicObjectType)entityType);
            String serialno = UUID.randomUUID();
            summary.set("org", (Object)model.getOrgId());
            summary.set("serialno", (Object)serialno);
            summary.set("taxperiod", (Object)taxperiod);
            summary.set("count", (Object)BigDecimal.ZERO);
            summary.set("amount", (Object)BigDecimal.ZERO);
            summary.set("taxamount", (Object)BigDecimal.ZERO);
            summary.set("deductiontype", (Object)dynamicObject.getLong("id"));
            if (DeductionService.DOWN_DEDUCTION.contains(dynamicObject.getString("number"))) {
                summary.set("count", (Object)BigDecimal.valueOf(-1L));
            }
            summary.set("deadline", deadLine);
            map.put(dynamicObject.getLong("id"), summary);
        }
    }
}

