/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.engine.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineTask;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.tcvat.business.service.draft.TaxDeclarationService;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.engine.impl.service.DraftEditService;
import kd.taxc.tcvat.business.service.engine.impl.service.JzjtJxseEngineService;
import kd.taxc.tcvat.business.service.engine.task.NewRuleSettingTask;
import kd.taxc.tcvat.business.service.engine.task.PartitionSaveTask;
import kd.taxc.tcvat.common.constant.DraftConstant;
import kd.taxc.tcvat.common.enums.DraftEngineEnum;
import kd.taxc.tcvat.common.util.UUID;

public class YbnsrJzjtJxseEngine
extends EngineTask<TcvatEngineModel, DynamicObject> {
    private static Log logger = LogFactory.getLog(YbnsrJzjtJxseEngine.class);
    private JzjtJxseEngineService engineService = new JzjtJxseEngineService();

    protected DynamicObject execute() throws Exception {
        logger.info("\u5f00\u59cb\u6267\u884c\u5373\u5f81\u5373\u9000\u8fdb\u9879\u7a0e\u989d\u5f15\u64ce");
        TcvatEngineModel model = (TcvatEngineModel)this.getEngineModel();
        this.calcData(model);
        return null;
    }

    public void calcData(TcvatEngineModel model) throws Exception {
        DraftMetaDataDTO draftMetaDataDTO = model.getDraftMetaDataDTO();
        ArrayList<DynamicObject> summaryList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> detailList = new ArrayList<DynamicObject>();
        DynamicObjectCollection oldDraftList = DraftEditService.getDraftList(model, draftMetaDataDTO.getJzjtjxse());
        DynamicObject[] draftEditArr = DraftEditService.getDraftEditList(oldDraftList);
        DraftEngineEnum.YBNSR.deleteJzjtJxse(model);
        DraftMetaDataInfo deductionMetaData = draftMetaDataDTO.getJzjtjxse();
        String rulePurpose = draftMetaDataDTO.getDraftPurpose();
        String taxPayerType = (String)model.getCustom().get("taxPayerType");
        Long orgid = Long.parseLong(model.getOrgId());
        List ruleList = (List)RuleUtils.getSharingAndOrgRules((Long)Long.parseLong(model.getOrgId()), (RuleTypeEnum)RuleTypeEnum.JZJTSE, (String)taxPayerType.replace("zzs", ""), (String)rulePurpose).get(RuleTypeEnum.JZJTSE);
        List<String> dateList = TaxDeclarationService.getRealQuarter(rulePurpose, model.getOrgId(), (String)model.getCustom().get("skssqq"), (String)model.getCustom().get("skssqz"));
        DynamicObjectCollection incomeAccountCollection = QueryServiceHelper.query((String)draftMetaDataDTO.getIncome().getAccountMetaDataName(), (String)"taxperiod,taxamount,jzjt,nrjzjtjs", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgid), new QFilter("taxperiod", "in", dateList)});
        Object jzjttscl = SystemParamUtil.getAppParameter((String)"tcvat", (String)"jzjttscl", (long)orgid);
        boolean jzjttsclB = jzjttscl != null && (Boolean)jzjttscl != false;
        int splitRateScale = TaxDeclarationService.getJzjtJxseSplitRateScale(orgid);
        Object deadLine = model.getCustom().get("deadLine");
        Map<String, BigDecimal> resultMap = this.engineService.getIncomePeriodAmount(incomeAccountCollection, jzjttsclB, splitRateScale, dateList);
        BigDecimal jzjtSellAmount = resultMap.get("jzjtSellAmount");
        BigDecimal totalSellAmount = resultMap.get("totalSellAmount");
        BigDecimal splitRate = resultMap.get("splitRate");
        for (String date : dateList) {
            for (DynamicObject rule : ruleList) {
                String uuid = UUID.randomUUID();
                DynamicObject summary = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)deductionMetaData.getAccountMetaDataName()));
                String jzjtlx = rule.getString("jzjtlx");
                BigDecimal inputTax = this.getExecuteCalculateTask(model, detailList, uuid, rule, jzjtlx, date);
                summary.set("taxperiod", (Object)date);
                summary.set("org", (Object)orgid);
                summary.set("serialno", (Object)uuid);
                summary.set("ruleid", rule.get("id"));
                summary.set("bizname", (Object)rule.getString("name"));
                summary.set("deadline", deadLine);
                summary.set("jzjtlx", (Object)jzjtlx);
                summary.set("inputtax", (Object)inputTax);
                if ("wfhf".equals(jzjtlx)) {
                    summary.set("jzjtamount", (Object)jzjtSellAmount);
                    summary.set("amountsum", (Object)totalSellAmount);
                    summary.set("splitrate", (Object)splitRate);
                }
                List<DynamicObject> editList = DraftEditService.matchDraftEditList(oldDraftList, draftEditArr, summary, "ruleid");
                Map<String, BigDecimal> rowEditAmountMap = DraftEditService.getEditAmountBeforeReFetch(editList);
                DraftEditService.updateDraftEditOriginAmount(summary, rowEditAmountMap, editList);
                DraftEditService.addEditAmount(summary, rowEditAmountMap);
                inputTax = summary.getBigDecimal("inputtax");
                this.engineService.calcJzjtjxTax(summary, inputTax);
                summaryList.add(summary);
            }
        }
        ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(summaryList));
        ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(detailList));
        DraftEditService.updateNewDraftId(summaryList, oldDraftList, draftEditArr, "ruleid");
    }

    private BigDecimal getExecuteCalculateTask(TcvatEngineModel model, List<DynamicObject> detailList, String uuid, DynamicObject rule, String jzjtlx, String date) throws Exception {
        String entryentity = "entryentity";
        String suffix = "";
        if ("wfhf".equals(jzjtlx)) {
            entryentity = "entryentity1";
            suffix = "1";
        }
        NewRuleSettingTask settingTask = new NewRuleSettingTask(new ConcurrentHashMap<String, String>(), new ConcurrentHashMap<String, Map<String, Object>>(), rule, model, rule.getDynamicObjectCollection(entryentity), uuid, model.getDraftMetaDataDTO().getJzjtjxse().getDetailMetaDataNameMap().get(DraftConstant.YBNSR_JZJT_JXSE_ACCDETAIL), null, suffix, null, date.substring(0, 7));
        List futureList = ThreadPoolsService.getInstance().submitReturnFuture((Task)settingTask);
        List draftDetailList = YbnsrJzjtJxseEngine.getFutureList((List)futureList);
        detailList.addAll(draftDetailList);
        BigDecimal resultSum = draftDetailList.stream().map(s -> s.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return resultSum;
    }
}

