/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.engine.impl.hzsb.ybhz;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineTask;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.account.DeductionService;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.engine.impl.service.DraftEditService;
import kd.taxc.tcvat.business.service.engine.impl.utils.DeductEngineService;
import kd.taxc.tcvat.business.service.engine.task.PartitionSaveTask;
import kd.taxc.tcvat.business.service.engine.task.hzsb.NewHzRuleSettingTask;
import kd.taxc.tcvat.common.constant.DraftConstant;
import kd.taxc.tcvat.common.enums.DraftEngineEnum;
import kd.taxc.tcvat.common.util.UUID;
import org.apache.commons.collections4.CollectionUtils;

public class YbhzDeductionEngine
extends EngineTask<TcvatEngineModel, DynamicObject> {
    private static Log logger = LogFactory.getLog(YbhzDeductionEngine.class);
    private DeductEngineService deductEngineService = new DeductEngineService();

    protected DynamicObject execute() throws Exception {
        logger.info("\u5f00\u59cb\u6267\u884c\u8fdb\u9879\u62b5\u6263\u5f15\u64ce");
        long start = System.currentTimeMillis();
        TcvatEngineModel model = (TcvatEngineModel)this.getEngineModel();
        if ("sjjt".equals(model.getDraftMetaDataDTO().getDraftPurpose())) {
            return null;
        }
        DraftMetaDataDTO draftMetaDataDTO = model.getDraftMetaDataDTO();
        DraftMetaDataInfo deduction = draftMetaDataDTO.getDeduction();
        ArrayList<DynamicObject> deductionSummaryList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> inputPTServicesList = new ArrayList<DynamicObject>();
        List<Object> orglist = new ArrayList<Long>();
        HashMap<String, String> declareTypeMap = new HashMap();
        if ("zzsybnsr_ybhz".equals(model.getCustom().get("taxPayerType")) || "zzsybnsr_hz_zjg".equals(model.getCustom().get("taxPayerType")) || "zzsybnsr_yz_zjg".equals(model.getCustom().get("taxPayerType"))) {
            Object hzsbOrgList = model.getCustom().get("hzsbOrgList");
            String orglistStr = !CollectionUtils.isEmpty((Collection)((Collection)hzsbOrgList)) ? hzsbOrgList.toString() : model.getCustom().get("orglist").toString();
            orglist = JSON.parseArray((String)orglistStr, Long.class).stream().distinct().collect(Collectors.toList());
            declareTypeMap = (Map)model.getCustom().get("declaremap");
        } else {
            orglist.add(Long.parseLong(model.getOrgId()));
        }
        if (orglist.isEmpty()) {
            return null;
        }
        ArrayList<DynamicObject> detailList = new ArrayList<DynamicObject>();
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(model.getOrgId()));
        Date startDate = DateUtils.stringToDate((String)model.getStartDate());
        Date endDate = DateUtils.stringToDate((String)model.getEndDate());
        QFilter dateFilter = new QFilter("startdate", "=", (Object)startDate).and(new QFilter("enddate", "=", (Object)endDate));
        QFilter taxpayertypeFilter = new QFilter("taxpayertype", "=", model.getCustom().get("taxpayertype"));
        DynamicObjectCollection incomeAccountCollection = QueryServiceHelper.query((String)model.getDraftMetaDataDTO().getIncome().getAccountMetaDataName(), (String)"startdate,taxamount, jzjt", (QFilter[])new QFilter[]{orgFilter.and(dateFilter), taxpayertypeFilter});
        Map<String, BigDecimal> resultMap = this.deductEngineService.incomeJzjtAmount(incomeAccountCollection);
        BigDecimal invoiceJzjtSum = resultMap.get("invoiceJzjtSum");
        BigDecimal taxAmountSum = resultMap.get("taxAmountSum");
        logger.info("resultMap===={}==={}", (Object)resultMap.get("invoiceJzjtSum").toString(), (Object)resultMap.get("taxAmountSum").toString());
        String rulePurpose = (String)model.getCustom().get("rulePurpose");
        Map suborgDeclarationMap = (Map)model.getCustom().get("declaremap");
        LinkedHashMap<String, String> deductTypeMap = this.deductEngineService.getDeductTypeMap();
        DynamicObjectCollection oldDraftList = DraftEditService.getDraftList(model, model.getDraftMetaDataDTO().getDeduction());
        DynamicObject[] draftEditArr = DraftEditService.getDraftEditList(oldDraftList);
        for (Map.Entry<String, String> entry : deductTypeMap.entrySet()) {
            String key = entry.getKey();
            String val = entry.getValue();
            DynamicObject deductionSummary = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)deduction.getAccountMetaDataName()));
            BigDecimal countSum = BigDecimal.ZERO;
            BigDecimal amountSum = BigDecimal.ZERO;
            BigDecimal taxSum = BigDecimal.ZERO;
            BigDecimal inputtaxamount = BigDecimal.ZERO;
            String ruleName = "";
            String uuid = UUID.randomUUID();
            for (Long l : orglist) {
                List allRuleList = (List)RuleUtils.getSharingAndOrgRules((Long)l, (RuleTypeEnum)RuleTypeEnum.DEDUCT, (String)"ybnsr", (String)rulePurpose).get(RuleTypeEnum.DEDUCT);
                List deductRuleList = allRuleList.stream().filter(d -> d.getDynamicObject("deducttype").getString("number").startsWith("VAT_JXDK_BQDK") && !DeductionService.DOWN_DEDUCTION.contains(d.getDynamicObject("deducttype").getString("number"))).collect(Collectors.toList());
                Map<String, List<DynamicObject>> deductRuleMap = deductRuleList.stream().collect(Collectors.groupingBy(d -> d.getDynamicObject("deducttype").getString("number")));
                List<DynamicObject> ruleList = deductRuleMap.get(key);
                if (!CollectionUtils.isNotEmpty(ruleList)) continue;
                ruleName = ruleList.get(0).getString("name");
                for (DynamicObject deductRule : ruleList) {
                    countSum = countSum.add(this.getExecuteCalculateTask(model, detailList, uuid, deductRule, "entryentity11", "11", "count", l, suborgDeclarationMap, val));
                    amountSum = amountSum.add(this.getExecuteCalculateTask(model, detailList, uuid, deductRule, "entryentity", "", "amount", l, suborgDeclarationMap, val));
                    taxSum = taxSum.add(this.getExecuteCalculateTask(model, detailList, uuid, deductRule, "entryentity1", "1", "taxamount", l, suborgDeclarationMap, val));
                }
                inputtaxamount = inputtaxamount.add(this.deductEngineService.getBuildHZJzjtAmount(model, declareTypeMap, inputPTServicesList, invoiceJzjtSum, taxAmountSum, ruleList.get(0), uuid, l));
            }
            this.setCommon(model, ruleName, val, uuid, deductionSummary, countSum.longValue(), amountSum, taxSum, inputtaxamount);
            List<DynamicObject> editList = DraftEditService.matchDraftEditList(oldDraftList, draftEditArr, deductionSummary, "deductiontype");
            Map<String, BigDecimal> map = DraftEditService.getEditAmountBeforeReFetch(editList);
            DraftEditService.updateDraftEditOriginAmount(deductionSummary, map, editList);
            DraftEditService.addEditAmount(deductionSummary, map);
            deductionSummaryList.add(deductionSummary);
        }
        try (TXHandle h = TX.required();){
            try {
                DraftEngineEnum.YBHZ.deleteDeduction(model);
                ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(deductionSummaryList));
                ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(inputPTServicesList));
                ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(detailList));
                DraftEditService.updateNewDraftId(deductionSummaryList, oldDraftList, draftEditArr, "deductiontype");
            }
            catch (Throwable t) {
                h.markRollback();
                throw t;
            }
        }
        logger.info("\u7ed3\u675f\u6267\u884c\u8fdb\u9879\u62b5\u6263\u5f15\u64ce\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        return null;
    }

    private BigDecimal getExecuteCalculateTask(TcvatEngineModel model, List<DynamicObject> detailList, String uuid, DynamicObject deductRule, String entryentity, String suffix, String type, Long suborg, Map<String, String> suborgDeclarationMap, String deductiontype) throws Exception {
        NewHzRuleSettingTask amountSettingTask = new NewHzRuleSettingTask(new ConcurrentHashMap<String, String>(), suborg, new ConcurrentHashMap<String, Map<String, Object>>(), deductRule, model, deductRule.getDynamicObjectCollection(entryentity), uuid, model.getDraftMetaDataDTO().getDeduction().getDetailMetaDataNameMap().get(DraftConstant.YBHZ_DEDUCT_DETAIL), null, suffix, type, suborgDeclarationMap);
        List futureList = ThreadPoolsService.getInstance().submitReturnFuture((Task)amountSettingTask);
        List draftDetailList = YbhzDeductionEngine.getFutureList((List)futureList);
        draftDetailList.forEach(d -> d.set("deductiontype", (Object)deductiontype));
        detailList.addAll(draftDetailList);
        BigDecimal resultSum = draftDetailList.stream().map(s -> s.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return resultSum;
    }

    private void setCommon(EngineModel engineModel, String ruleName, String deductionType, String uuid, DynamicObject dynamicObject, Long summaryCount, BigDecimal totalAmount, BigDecimal totalTaxAmount, BigDecimal inputtaxamount) {
        dynamicObject.set("serialno", (Object)uuid);
        dynamicObject.set("description", (Object)ruleName);
        dynamicObject.set("org", (Object)engineModel.getOrgId());
        dynamicObject.set("startdate", (Object)DateUtils.stringToDate((String)engineModel.getStartDate()));
        dynamicObject.set("enddate", (Object)DateUtils.stringToDate((String)engineModel.getEndDate()));
        dynamicObject.set("count", (Object)summaryCount);
        dynamicObject.set("amount", (Object)totalAmount);
        dynamicObject.set("taxAmount", (Object)totalTaxAmount);
        dynamicObject.set("inputtaxamount", (Object)inputtaxamount);
        dynamicObject.set("deductiontype", (Object)deductionType);
        dynamicObject.set("taxpayertype", engineModel.getCustom().get("taxPayerType"));
    }
}

