/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.engine.impl.hzsb.ybhz;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.constant.TaxRateConstant;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineTask;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tcvat.business.service.draft.TcvatDraftService;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.engine.impl.service.DraftEditService;
import kd.taxc.tcvat.business.service.engine.impl.utils.IncomeUtils;
import kd.taxc.tcvat.business.service.engine.task.PartitionSaveTask;
import kd.taxc.tcvat.business.service.engine.task.hzsb.NewHzRuleSettingTask;
import kd.taxc.tcvat.business.service.engine.task.util.NewRuleSettingUtils;
import kd.taxc.tcvat.business.service.rule.RuleService;
import kd.taxc.tcvat.common.constant.DraftConstant;
import kd.taxc.tcvat.common.constant.RuleSettingConstant;
import kd.taxc.tcvat.common.enums.DraftEngineEnum;
import kd.taxc.tcvat.common.util.UUID;

public class YbhzIncomeEngine
extends EngineTask<TcvatEngineModel, DynamicObject> {
    private static Log logger = LogFactory.getLog(YbhzIncomeEngine.class);
    private RuleService ruleService = new RuleService();

    protected DynamicObject execute() throws Exception {
        logger.info("\u5f00\u59cb\u6267\u884c\u6c47\u603b\u6536\u5165\u5f15\u64ce");
        long start = System.currentTimeMillis();
        TcvatEngineModel model = (TcvatEngineModel)this.getEngineModel();
        DraftMetaDataDTO draftMetaDataDTO = model.getDraftMetaDataDTO();
        DraftMetaDataInfo income = draftMetaDataDTO.getIncome();
        String incomeSummary = income.getAccountMetaDataName();
        Map<String, String> incomeSummaryDetailMap = income.getDetailMetaDataNameMap();
        String rulePurpose = draftMetaDataDTO.getDraftPurpose();
        String orgId = model.getOrgId();
        Date startDate = DateUtils.stringToDate((String)model.getStartDate());
        Date endDate = DateUtils.stringToDate((String)model.getEndDate());
        DynamicObject dynamicObject = TcvatDraftService.loadPolicyConfirm(draftMetaDataDTO.getDraftPurpose(), draftMetaDataDTO.getTaxPayerType(), draftMetaDataDTO.getTemplateType(), orgId, model.getStartDate(), model.getEndDate());
        if (dynamicObject == null) {
            return null;
        }
        DynamicObjectCollection list = dynamicObject.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection hzPlanCollection = dynamicObject.getDynamicObjectCollection("hzentryentity");
        Map<String, String> orgToLeveMap = hzPlanCollection.stream().collect(Collectors.toMap(k -> k.getDynamicObject("assignorg").getString("id"), v -> v.getString("levelname"), (k1, k2) -> k1));
        List orglist = JSON.parseArray((String)model.getCustom().get("orglist").toString(), Long.class);
        orglist = orglist.stream().distinct().collect(Collectors.toList());
        ArrayList<DynamicObject> summaryList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> summaryAccountingList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> summaryInvoiceList = new ArrayList<DynamicObject>();
        ConcurrentHashMap<String, String> allInvoiceItemIdBeUsedByIncomeRuleXseMap = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, String> allInvoiceItemIdBeUsedByIncomeRuleSeMap = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, Map<String, Object>> repeatInvoiceDataMap = new ConcurrentHashMap<String, Map<String, Object>>();
        DynamicObjectCollection oldDraftList = DraftEditService.getDraftList(model, model.getDraftMetaDataDTO().getIncome());
        Map<String, Long> oldDetailSerialnoMap = DraftEditService.getDetailSerialnoMap((List<DynamicObject>)oldDraftList);
        DynamicObject[] draftEditArr = DraftEditService.getDraftEditList(oldDraftList);
        for (Long suborgid : orglist) {
            List incomeRuleList = (List)RuleUtils.getSharingAndOrgRules((Long)suborgid, (RuleTypeEnum)RuleTypeEnum.INCOME, (String)"ybnsr", (String)rulePurpose).get(RuleTypeEnum.INCOME);
            if (list == null || list.size() <= 0) continue;
            for (DynamicObject confirmRule : list) {
                BigDecimal wkpTax;
                List<DynamicObject> wkpTaxList;
                BigDecimal otherTax;
                List<DynamicObject> otherTaxList;
                BigDecimal invoiceTax;
                List<DynamicObject> invoiceTaxList;
                BigDecimal accountingamount;
                DynamicObject deductionRule;
                DynamicObject rule;
                if (!suborgid.equals(confirmRule.getDynamicObject("suborg").getLong("id")) || !confirmRule.getBoolean("nrhzsb") || (rule = IncomeUtils.getIncomeRule(confirmRule.getLong("ruleid"), incomeRuleList)) == null) continue;
                String serialno = UUID.randomUUID();
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)incomeSummary);
                DynamicObject summary = new DynamicObject((DynamicObjectType)entityType);
                String belongsorg = confirmRule.getDynamicObject("belongsorg").getString("id");
                summary.set("serialno", (Object)serialno);
                summary.set("jzjt", rule.get("jzjt"));
                summary.set("nrjzjtjs", rule.get("nrjzjtjs"));
                summary.set("org", (Object)orgId);
                summary.set("suborg", (Object)belongsorg);
                summary.set("levelname", (Object)orgToLeveMap.get(belongsorg));
                summary.set("declaretype", (Object)("1".equals(orgToLeveMap.get(belongsorg)) ? "2" : "1"));
                summary.set("startdate", (Object)startDate);
                summary.set("enddate", (Object)endDate);
                summary.set("ruleid", confirmRule.get("ruleid"));
                summary.set("taxpayertype", model.getCustom().get("taxPayerType"));
                DynamicObjectCollection businesstypeList = rule.getDynamicObjectCollection("businesstype");
                if (businesstypeList.size() > 0) {
                    DynamicObject businesstype = (DynamicObject)businesstypeList.get(0);
                    summary.set("businesstype", (Object)businesstype.getDynamicObject("fbasedataid"));
                }
                summary.set("description", confirmRule.get("servicedesc"));
                DynamicObject taxmethodValue = confirmRule.getDynamicObject("taxation");
                summary.set("taxmethod", taxmethodValue.get("name"));
                summary.set("taxmethodtype", taxmethodValue.get("id"));
                String taxrate = confirmRule.getDynamicObject("rate").getString("name");
                summary.set("taxrate", (Object)taxrate);
                if (StringUtils.equals((CharSequence)((CharSequence)TaxRateConstant.getTaxmethodMap().get(TaxRateConstant.getExcludeTaxCN())), (CharSequence)taxmethodValue.get("number").toString()) && null != (deductionRule = rule.getDynamicObject("deductiontype"))) {
                    summary.set("taxreductionid", deductionRule.get("id"));
                    summary.set("taxreductioncode", deductionRule.get("number"));
                    summary.set("taxreductionname", (Object)deductionRule.getString("name"));
                    summary.set("taxreductiontype", (Object)deductionRule.getString("deductiontype"));
                }
                taxrate = NewRuleSettingUtils.trimTaxRate(taxrate);
                BigDecimal taxrateBig = new BigDecimal(taxrate.replaceAll("%", "")).divide(NewRuleSettingUtils.ONE_HUNDRED);
                boolean invoiceseqs = rule.getBoolean("invoiceseqs");
                boolean qtfpseqs = rule.getBoolean("qtfpseqs");
                boolean wkpseqs = rule.getBoolean("wkpseqs");
                NewHzRuleSettingTask invoiceTask = new NewHzRuleSettingTask(allInvoiceItemIdBeUsedByIncomeRuleXseMap, suborgid, repeatInvoiceDataMap, rule, model, rule.getDynamicObjectCollection("invoiceentity"), serialno, incomeSummaryDetailMap.get(DraftConstant.YBHZ_HZ_INVOICE_DETAIL), taxrate, "12", RuleSettingConstant.GET_DATE_TYPE_ZYSR);
                List invoiceFutures = ThreadPoolsService.getInstance().submitReturnFuture((Task)invoiceTask);
                NewHzRuleSettingTask otherInvoiceTask = new NewHzRuleSettingTask(allInvoiceItemIdBeUsedByIncomeRuleXseMap, suborgid, repeatInvoiceDataMap, rule, model, rule.getDynamicObjectCollection("entryentity1"), serialno, incomeSummaryDetailMap.get(DraftConstant.YBHZ_HZ_ACCOUNTING_DETAIL), taxrate, "1", RuleSettingConstant.GET_DATE_TYPE_QTSR);
                List otherFutures = ThreadPoolsService.getInstance().submitReturnFuture((Task)otherInvoiceTask);
                NewHzRuleSettingTask ruleSettingTask = new NewHzRuleSettingTask(allInvoiceItemIdBeUsedByIncomeRuleXseMap, suborgid, repeatInvoiceDataMap, rule, model, rule.getDynamicObjectCollection("entryentity"), serialno, incomeSummaryDetailMap.get(DraftConstant.YBHZ_HZ_ACCOUNTING_DETAIL), taxrate, "", RuleSettingConstant.GET_DATE_TYPE_WKPSR);
                List futures = ThreadPoolsService.getInstance().submitReturnFuture((Task)ruleSettingTask);
                List invoiceTaxFutures = null;
                if (invoiceseqs) {
                    NewHzRuleSettingTask invoiceTaxTask = new NewHzRuleSettingTask(allInvoiceItemIdBeUsedByIncomeRuleSeMap, suborgid, repeatInvoiceDataMap, rule, model, rule.getDynamicObjectCollection("entryentity2"), serialno, incomeSummaryDetailMap.get(DraftConstant.YBHZ_HZ_INVOICE_DETAIL), taxrate, "2", RuleSettingConstant.GET_DATE_TYPE_ZYSE);
                    invoiceTaxFutures = ThreadPoolsService.getInstance().submitReturnFuture((Task)invoiceTaxTask);
                }
                List otherTaxFutures = null;
                if (qtfpseqs) {
                    NewHzRuleSettingTask otherInvoiceTaxTask = new NewHzRuleSettingTask(allInvoiceItemIdBeUsedByIncomeRuleSeMap, suborgid, repeatInvoiceDataMap, rule, model, rule.getDynamicObjectCollection("entryentity11"), serialno, incomeSummaryDetailMap.get(DraftConstant.YBHZ_HZ_ACCOUNTING_DETAIL), taxrate, "11", RuleSettingConstant.GET_DATE_TYPE_QTSE);
                    otherTaxFutures = ThreadPoolsService.getInstance().submitReturnFuture((Task)otherInvoiceTaxTask);
                }
                List wkpseFutures = null;
                if (wkpseqs) {
                    NewHzRuleSettingTask wkpseTask = new NewHzRuleSettingTask(allInvoiceItemIdBeUsedByIncomeRuleSeMap, suborgid, repeatInvoiceDataMap, rule, model, rule.getDynamicObjectCollection("entryentity3"), serialno, incomeSummaryDetailMap.get(DraftConstant.YBHZ_HZ_ACCOUNTING_DETAIL), taxrate, "3", RuleSettingConstant.GET_DATE_TYPE_WKPSE);
                    wkpseFutures = ThreadPoolsService.getInstance().submitReturnFuture((Task)wkpseTask);
                }
                List invoiceList = YbhzIncomeEngine.getFutureList((List)invoiceFutures);
                summaryInvoiceList.addAll(invoiceList);
                BigDecimal invoiceamount = IncomeUtils.getInvoiceTotalAmount(invoiceList, "invoiceamount");
                List otherAccountingList = YbhzIncomeEngine.getFutureList((List)otherFutures);
                summaryAccountingList.addAll(otherAccountingList);
                BigDecimal otherAccount = IncomeUtils.getAccountingAmount(otherAccountingList);
                List accountingList = YbhzIncomeEngine.getFutureList((List)futures);
                summaryAccountingList.addAll(accountingList);
                BigDecimal initaccountingamount = accountingamount = IncomeUtils.getAccountingAmount(accountingList);
                if (invoiceseqs && invoiceTaxFutures != null) {
                    invoiceTaxList = YbhzIncomeEngine.getFutureList((List)invoiceTaxFutures);
                    summaryInvoiceList.addAll((Collection<DynamicObject>)invoiceTaxList);
                    invoiceTax = IncomeUtils.getInvoiceTotalAmount(invoiceTaxList, "invoiceamount");
                    if (EmptyCheckUtils.isNotEmpty(invoiceTaxList)) {
                        invoiceTaxList.forEach(a -> a.set("taxamount", a.get("invoiceamount")));
                    }
                } else {
                    invoiceTaxList = NewRuleSettingUtils.buildTaxDetail(invoiceList, taxrateBig, incomeSummaryDetailMap.get(DraftConstant.YBHZ_HZ_INVOICE_DETAIL), RuleSettingConstant.GET_DATE_TYPE_ZYSE);
                    summaryInvoiceList.addAll(invoiceTaxList);
                    invoiceTax = IncomeUtils.getAccountingTaxAmount(invoiceTaxList);
                }
                if (qtfpseqs && otherTaxFutures != null) {
                    otherTaxList = YbhzIncomeEngine.getFutureList((List)otherTaxFutures);
                    summaryAccountingList.addAll((Collection<DynamicObject>)otherTaxList);
                    otherTax = IncomeUtils.getAccountingAmount(otherTaxList);
                    if (EmptyCheckUtils.isNotEmpty(otherTaxList)) {
                        otherTaxList.forEach(a -> a.set("taxamount", a.get("amount")));
                    }
                } else {
                    otherTaxList = NewRuleSettingUtils.buildTaxDetail(otherAccountingList, taxrateBig, incomeSummaryDetailMap.get(DraftConstant.YBHZ_HZ_ACCOUNTING_DETAIL), RuleSettingConstant.GET_DATE_TYPE_QTSE);
                    summaryAccountingList.addAll(otherTaxList);
                    otherTax = IncomeUtils.getAccountingTaxAmount(otherTaxList);
                }
                if (wkpseqs && wkpseFutures != null) {
                    wkpTaxList = YbhzIncomeEngine.getFutureList((List)wkpseFutures);
                    summaryAccountingList.addAll((Collection<DynamicObject>)wkpTaxList);
                    wkpTax = IncomeUtils.getAccountingAmount(wkpTaxList);
                    if (EmptyCheckUtils.isNotEmpty(wkpTaxList)) {
                        wkpTaxList.forEach(a -> a.set("taxamount", a.get("amount")));
                    }
                } else {
                    wkpTaxList = NewRuleSettingUtils.buildTaxDetail(accountingList, taxrateBig, incomeSummaryDetailMap.get(DraftConstant.YBHZ_HZ_ACCOUNTING_DETAIL), RuleSettingConstant.GET_DATE_TYPE_WKPSE);
                    summaryAccountingList.addAll(wkpTaxList);
                    wkpTax = IncomeUtils.getAccountingTaxAmount(wkpTaxList);
                }
                if (BigDecimal.ZERO.compareTo(wkpTax) == 0 && rule.getBoolean("iswkpwscl")) {
                    accountingamount = BigDecimal.ZERO;
                }
                summary.set("invoiceamount", (Object)invoiceamount);
                summary.set("invoicetaxamount", (Object)BigDecimalUtil.addObject((Object)invoiceamount, (Object)invoiceTax));
                summary.set("specialinvoiceamount", (Object)invoiceamount);
                summary.set("specialtaxamount", (Object)invoiceTax);
                summary.set("otherinvoiceamount", (Object)otherAccount);
                summary.set("othertaxamount", (Object)otherTax);
                summary.set("initaccountingamount", (Object)initaccountingamount);
                summary.set("accountingamount", (Object)accountingamount);
                summary.set("nonetaxamount", (Object)wkpTax);
                summaryList.add(summary);
                List<DynamicObject> editList = DraftEditService.matchYbhzIncomeDraftEditList(oldDraftList, oldDetailSerialnoMap, draftEditArr, summary, suborgid, "ruleid");
                Map<String, BigDecimal> rowEditAmountMap = DraftEditService.getEditAmountBeforeReFetch(editList);
                DraftEditService.updateDraftEditOriginAmount(summary, rowEditAmountMap, editList);
                if (rowEditAmountMap.get("specialinvoiceamount") != null) {
                    invoiceamount = invoiceamount.add(rowEditAmountMap.get("specialinvoiceamount"));
                    summary.set("invoiceamount", (Object)invoiceamount);
                    summary.set("specialinvoiceamount", (Object)invoiceamount);
                }
                if (rowEditAmountMap.get("specialtaxamount") != null) {
                    invoiceTax = invoiceTax.add(rowEditAmountMap.get("specialtaxamount"));
                    summary.set("invoicetaxamount", (Object)BigDecimalUtil.addObject((Object)invoiceamount, (Object)invoiceTax));
                    summary.set("specialtaxamount", (Object)invoiceTax);
                }
                if (rowEditAmountMap.get("otherinvoiceamount") != null) {
                    otherAccount = otherAccount.add(rowEditAmountMap.get("otherinvoiceamount"));
                    summary.set("otherinvoiceamount", (Object)otherAccount);
                }
                if (rowEditAmountMap.get("othertaxamount") != null) {
                    otherTax = otherTax.add(rowEditAmountMap.get("othertaxamount"));
                    summary.set("othertaxamount", (Object)otherTax);
                }
                if (rowEditAmountMap.get("noneinvoiceamount") != null) {
                    initaccountingamount = initaccountingamount.add(rowEditAmountMap.get("noneinvoiceamount"));
                    summary.set("initaccountingamount", (Object)initaccountingamount);
                }
                if (rowEditAmountMap.get("noneinvoiceamount") != null) {
                    accountingamount = accountingamount.add(rowEditAmountMap.get("noneinvoiceamount"));
                    summary.set("accountingamount", (Object)accountingamount);
                }
                if (rowEditAmountMap.get("nonetaxamount") != null) {
                    wkpTax = wkpTax.add(rowEditAmountMap.get("nonetaxamount"));
                    summary.set("nonetaxamount", (Object)wkpTax);
                }
                BigDecimal totalAmount = BigDecimalUtil.addWithHalfUp((BigDecimal[])new BigDecimal[]{invoiceamount, otherAccount, accountingamount});
                summary.set("taxamount", (Object)totalAmount);
                BigDecimal totaltaxamount = BigDecimalUtil.addWithHalfUp((BigDecimal[])new BigDecimal[]{invoiceTax, otherTax, wkpTax});
                summary.set("totaltaxamount", (Object)totaltaxamount);
                summary.set("pricetaxamount", (Object)BigDecimalUtil.addObject((Object)totalAmount, (Object)totaltaxamount));
            }
        }
        model.addErrorMap(repeatInvoiceDataMap);
        allInvoiceItemIdBeUsedByIncomeRuleXseMap.putAll(allInvoiceItemIdBeUsedByIncomeRuleSeMap);
        model.setEntryIds(allInvoiceItemIdBeUsedByIncomeRuleXseMap.keySet());
        DraftEngineEnum.YBHZ.deleteIncome(model);
        List<DynamicObject> groupSummaryDataList = IncomeUtils.groupSummaryData(Long.valueOf(model.getOrgId()), model, summaryList);
        ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(summaryAccountingList));
        ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(summaryInvoiceList));
        ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(summaryList));
        ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(groupSummaryDataList));
        DraftEditService.updateNewYbhzIncomeDraftId(summaryList, oldDraftList, oldDetailSerialnoMap, draftEditArr, "ruleid");
        logger.info("\u7ed3\u675f\u6267\u884c\u6536\u5165\u5f15\u64ce\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        return null;
    }
}

