/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.engine.impl.hzsb.ybhz;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineTask;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.bdtaxr.common.util.UUID;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tcvat.business.service.account.DeductionService;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.engine.impl.service.DraftEditService;
import kd.taxc.tcvat.business.service.engine.impl.utils.IncomeUtils;
import kd.taxc.tcvat.business.service.engine.task.PartitionSaveTask;
import kd.taxc.tcvat.business.service.engine.task.hzsb.NewHzRuleSettingTask;
import kd.taxc.tcvat.common.constant.DraftConstant;
import kd.taxc.tcvat.common.enums.DraftEngineEnum;
import org.apache.commons.collections.CollectionUtils;

public class YbhzWaitDeductionEngine
extends EngineTask<TcvatEngineModel, DynamicObject> {
    private static Log logger = LogFactory.getLog(YbhzWaitDeductionEngine.class);

    protected DynamicObject execute() throws Exception {
        logger.info("\u5f00\u59cb\u6267\u884c\u8fdb\u9879\u8f6c\u51fa\u5f15\u64ce");
        long start = System.currentTimeMillis();
        TcvatEngineModel model = (TcvatEngineModel)this.getEngineModel();
        DraftMetaDataDTO draftMetaDataDTO = model.getDraftMetaDataDTO();
        DraftMetaDataInfo waitDeduction = draftMetaDataDTO.getWaitDeduction();
        String summaryEntity = waitDeduction.getAccountMetaDataName();
        Map<String, String> detailMap = waitDeduction.getDetailMetaDataNameMap();
        String rulePurpose = draftMetaDataDTO.getDraftPurpose();
        Object hzsbOrgList = model.getCustom().get("hzsbOrgList");
        String orglistStr = !CollectionUtils.isEmpty((Collection)((Collection)hzsbOrgList)) ? hzsbOrgList.toString() : model.getCustom().get("orglist").toString();
        List orglist = SerializationUtils.fromJsonStringToList((String)orglistStr, Long.class);
        Map suborgDeclarationMap = (Map)model.getCustom().get("declaremap");
        orglist = orglist.stream().sorted(Comparator.comparing(o -> (String)suborgDeclarationMap.get(String.valueOf(o)))).distinct().collect(Collectors.toList());
        QFilter qFilter = new QFilter("group.number", "=", (Object)"VAT_JXDK_DDK").or(new QFilter("number", "in", DeductionService.DOWN_DEDUCTION));
        DynamicObjectCollection bizDef = QueryServiceHelper.query((String)"tpo_tcvat_bizdef", (String)"id", (QFilter[])new QFilter[]{qFilter});
        Set waitDeductSet = bizDef.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(16);
        this.initMap(model, map, summaryEntity);
        ArrayList<DynamicObject> summaryList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> summaryAccountingList = new ArrayList<DynamicObject>(16);
        DynamicObjectCollection oldDraftList = DraftEditService.getDraftList(model, model.getDraftMetaDataDTO().getWaitDeduction());
        DynamicObject[] draftEditArr = DraftEditService.getDraftEditList(oldDraftList);
        for (Long l : orglist) {
            List rules = (List)RuleUtils.getSharingAndOrgRules((Long)l, (RuleTypeEnum)RuleTypeEnum.DEDUCT, (String)"ybnsr", (String)rulePurpose).get(RuleTypeEnum.DEDUCT);
            if (rules == null || rules.isEmpty()) continue;
            rules = rules.stream().filter(rule -> waitDeductSet.contains(rule.getLong("deducttype.id"))).collect(Collectors.toList());
            rules.sort((r1, r2) -> {
                String number1 = r1.getDynamicObject("deducttype").getString("number");
                String number2 = r2.getDynamicObject("deducttype").getString("number");
                return number1.compareTo(number2);
            });
            for (DynamicObject rule2 : rules) {
                Long deducttype = rule2.getLong("deducttype.id");
                DynamicObject summary = map.get(deducttype);
                if (null == summary) continue;
                summary.set("suborg", (Object)l);
                summary.set("declaretype", suborgDeclarationMap.get(String.valueOf(l)));
                String serialno = summary.getString("serialno");
                NewHzRuleSettingTask amountTask = new NewHzRuleSettingTask(new ConcurrentHashMap<String, String>(), l, new ConcurrentHashMap<String, Map<String, Object>>(), rule2, model, rule2.getDynamicObjectCollection("entryentity"), serialno, detailMap.get(DraftConstant.YBHZ_HZ_WAIT_DEDUCT_DET), null, "", "amount", suborgDeclarationMap);
                List amountFutures = ThreadPoolsService.getInstance().submitReturnFuture((Task)amountTask);
                List amountList = YbhzWaitDeductionEngine.getFutureList((List)amountFutures);
                BigDecimal amount = IncomeUtils.getInvoiceTotalAmount(amountList, "fetchamount");
                summary.set("amount", (Object)BigDecimalUtil.addObject((Object)summary.get("amount"), (Object)amount));
                summaryAccountingList.addAll(amountList);
                if (BigDecimal.ZERO.compareTo(BigDecimalUtil.toBigDecimal((Object)summary.get("count"))) > 0) {
                    summary.set("count", (Object)BigDecimal.ZERO);
                }
                NewHzRuleSettingTask countTask = new NewHzRuleSettingTask(new ConcurrentHashMap<String, String>(), l, new ConcurrentHashMap<String, Map<String, Object>>(), rule2, model, rule2.getDynamicObjectCollection("entryentity11"), serialno, detailMap.get(DraftConstant.YBHZ_HZ_WAIT_DEDUCT_DET), null, "11", "count", suborgDeclarationMap);
                List countFutures = ThreadPoolsService.getInstance().submitReturnFuture((Task)countTask);
                List countList = YbhzWaitDeductionEngine.getFutureList((List)countFutures);
                BigDecimal count = IncomeUtils.getInvoiceTotalAmount(countList, "amount");
                summary.set("count", (Object)BigDecimalUtil.addObject((Object)summary.get("count"), (Object)count));
                summaryAccountingList.addAll(countList);
                NewHzRuleSettingTask taxAmountTask = new NewHzRuleSettingTask(new ConcurrentHashMap<String, String>(), l, new ConcurrentHashMap<String, Map<String, Object>>(), rule2, model, rule2.getDynamicObjectCollection("entryentity1"), serialno, detailMap.get(DraftConstant.YBHZ_HZ_WAIT_DEDUCT_DET), null, "1", "taxamount", suborgDeclarationMap);
                List taxAmountFutures = ThreadPoolsService.getInstance().submitReturnFuture((Task)taxAmountTask);
                List taxList = YbhzWaitDeductionEngine.getFutureList((List)taxAmountFutures);
                BigDecimal taxAmount = IncomeUtils.getInvoiceTotalAmount(taxList, "fetchamount");
                summary.set("taxamount", (Object)BigDecimalUtil.addObject((Object)summary.get("taxamount"), (Object)taxAmount));
                summaryAccountingList.addAll(taxList);
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            DynamicObject summary = (DynamicObject)entry.getValue();
            if (BigDecimal.ZERO.compareTo(BigDecimalUtil.toBigDecimal((Object)summary.get("count"))) > 0) continue;
            String serialno = summary.getString("serialno");
            List accountList = summaryAccountingList.stream().filter(s -> serialno.equals(s.getString("taxaccountserialno"))).collect(Collectors.toList());
            if (kd.bos.orm.util.CollectionUtils.isEmpty(accountList)) continue;
            List<DynamicObject> editList = DraftEditService.matchDraftEditList(oldDraftList, draftEditArr, summary, "deductiontype");
            Map<String, BigDecimal> rowEditAmountMap = DraftEditService.getEditAmountBeforeReFetch(editList);
            DraftEditService.updateDraftEditOriginAmount(summary, rowEditAmountMap, editList);
            DraftEditService.addEditAmount(summary, rowEditAmountMap);
            summaryList.add(summary);
        }
        DraftEngineEnum.YBHZ.deleteWait(model);
        ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(summaryAccountingList));
        ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(summaryList));
        DraftEditService.updateNewDraftId(summaryList, oldDraftList, draftEditArr, "deductiontype");
        logger.info("\u7ed3\u675f\u6267\u884c\u8fdb\u9879\u8f6c\u51fa\u5f15\u64ce\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        return null;
    }

    private void initMap(TcvatEngineModel model, HashMap<Long, DynamicObject> map, String summaryEntity) {
        QFilter qFilter = new QFilter("group.number", "=", (Object)"VAT_JXDK_DDK").or(new QFilter("number", "in", DeductionService.DOWN_DEDUCTION));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tpo_tcvat_bizdef", (String)"id,number", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject dynamicObject : query) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)summaryEntity);
            DynamicObject summary = new DynamicObject((DynamicObjectType)entityType);
            String serialno = UUID.randomUUID();
            summary.set("org", (Object)model.getOrgId());
            summary.set("serialno", (Object)serialno);
            summary.set("startdate", (Object)DateUtils.stringToDate((String)model.getStartDate()));
            summary.set("enddate", (Object)DateUtils.stringToDate((String)model.getEndDate()));
            summary.set("count", (Object)BigDecimal.ZERO);
            summary.set("amount", (Object)BigDecimal.ZERO);
            summary.set("taxamount", (Object)BigDecimal.ZERO);
            summary.set("deductiontype", (Object)dynamicObject.getLong("id"));
            summary.set("taxpayertype", model.getCustom().get("taxPayerType"));
            if (DeductionService.DOWN_DEDUCTION.contains(dynamicObject.getString("number"))) {
                summary.set("count", (Object)BigDecimal.valueOf(-1L));
            }
            map.put(dynamicObject.getLong("id"), summary);
        }
    }
}

