/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.engine.impl.service;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.taxc.tcvat.common.enums.DiffRuleTypeEnum;

public class DiffDeductionEngineService {
    public static BigDecimal calYnse(BigDecimal incomeAmount, DynamicObject deductSummary, DiffRuleTypeEnum diffType) {
        if (deductSummary.getBigDecimal("deductamount").compareTo(BigDecimal.ZERO) == 0) {
            return incomeAmount;
        }
        switch (diffType) {
            case TYPE13: {
                return deductSummary.getBigDecimal("notaxamount").subtract(deductSummary.getBigDecimal("deductamount")).multiply(BigDecimal.valueOf(0.13)).divide(BigDecimal.valueOf(1.13), 10, 4);
            }
            case TYPE9: {
                return deductSummary.getBigDecimal("notaxamount").subtract(deductSummary.getBigDecimal("deductamount")).multiply(BigDecimal.valueOf(0.09)).divide(BigDecimal.valueOf(1.09), 10, 4);
            }
            case TYPE6_NOTCONTAINS: {
                return deductSummary.getBigDecimal("notaxamount").subtract(deductSummary.getBigDecimal("deductamount")).multiply(BigDecimal.valueOf(0.06)).divide(BigDecimal.valueOf(1.06), 10, 4);
            }
            case TYPE6: {
                return deductSummary.getBigDecimal("notaxamount").subtract(deductSummary.getBigDecimal("deductamount")).multiply(BigDecimal.valueOf(0.06)).divide(BigDecimal.valueOf(1.06), 10, 4);
            }
            case TYPE5: {
                return deductSummary.getBigDecimal("notaxamount").subtract(deductSummary.getBigDecimal("deductamount")).multiply(BigDecimal.valueOf(0.05)).divide(BigDecimal.valueOf(1.05), 10, 4);
            }
            case TYPE3: {
                return deductSummary.getBigDecimal("notaxamount").subtract(deductSummary.getBigDecimal("deductamount")).multiply(BigDecimal.valueOf(0.03)).divide(BigDecimal.valueOf(1.03), 10, 4);
            }
            case TYPE_MDTS: {
                return BigDecimal.ZERO;
            }
            case TYPE_MS: {
                return BigDecimal.ZERO;
            }
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal calJzjtYnse(BigDecimal jzjtIncomeAmount, DynamicObject deductSummary, DiffRuleTypeEnum diffType) {
        if (deductSummary.getBigDecimal("jzjtdeductamount").compareTo(BigDecimal.ZERO) == 0) {
            return jzjtIncomeAmount;
        }
        switch (diffType) {
            case TYPE13: {
                return deductSummary.getBigDecimal("jzjtsumamount").subtract(deductSummary.getBigDecimal("jzjtdeductamount")).multiply(BigDecimal.valueOf(0.13)).divide(BigDecimal.valueOf(1.13), 10, 4);
            }
            case TYPE9: {
                return deductSummary.getBigDecimal("jzjtsumamount").subtract(deductSummary.getBigDecimal("jzjtdeductamount")).multiply(BigDecimal.valueOf(0.09)).divide(BigDecimal.valueOf(1.09), 10, 4);
            }
            case TYPE6_NOTCONTAINS: {
                return deductSummary.getBigDecimal("jzjtsumamount").subtract(deductSummary.getBigDecimal("jzjtdeductamount")).multiply(BigDecimal.valueOf(0.06)).divide(BigDecimal.valueOf(1.06), 10, 4);
            }
            case TYPE6: {
                return deductSummary.getBigDecimal("jzjtsumamount").subtract(deductSummary.getBigDecimal("jzjtdeductamount")).multiply(BigDecimal.valueOf(0.06)).divide(BigDecimal.valueOf(1.06), 10, 4);
            }
            case TYPE5: {
                return deductSummary.getBigDecimal("jzjtsumamount").subtract(deductSummary.getBigDecimal("jzjtdeductamount")).multiply(BigDecimal.valueOf(0.05)).divide(BigDecimal.valueOf(1.05), 10, 4);
            }
            case TYPE3: {
                return deductSummary.getBigDecimal("jzjtsumamount").subtract(deductSummary.getBigDecimal("jzjtdeductamount")).multiply(BigDecimal.valueOf(0.03)).divide(BigDecimal.valueOf(1.03), 10, 4);
            }
            case TYPE_MDTS: {
                return BigDecimal.ZERO;
            }
            case TYPE_MS: {
                return BigDecimal.ZERO;
            }
        }
        return BigDecimal.ZERO;
    }

    public static List<DynamicObject> doGetIncomeList(DynamicObject[] incomeAccountCollection, DiffRuleTypeEnum diffType, boolean needJzjt) {
        Predicate<DynamicObject> predicate = null;
        switch (diffType) {
            case TYPE13: {
                predicate = i -> !(!i.getString("businesstype.mergecode").startsWith("3") && !i.getString("businesstype.mergecode").startsWith("4") && !i.getString("businesstype.mergecode").startsWith("5") || !i.getString("taxrate").equals("13%") && !i.getString("taxrate").equals("16%") && !i.getString("taxrate").equals("17%"));
                break;
            }
            case TYPE9: {
                predicate = i -> !(!i.getString("businesstype.mergecode").startsWith("3") && !i.getString("businesstype.mergecode").startsWith("4") && !i.getString("businesstype.mergecode").startsWith("5") || !i.getString("taxrate").equals("9%") && !i.getString("taxrate").equals("10%") && !i.getString("taxrate").equals("11%"));
                break;
            }
            case TYPE6_NOTCONTAINS: {
                predicate = i -> !i.getString("businesstype.mergecode").startsWith("30604") && i.getString("taxrate").equals("6%");
                break;
            }
            case TYPE6: {
                predicate = i -> i.getString("businesstype.mergecode").startsWith("30604") && i.getString("taxrate").equals("6%");
                break;
            }
            case TYPE5: {
                predicate = i -> (i.getString("businesstype.mergecode").startsWith("3") || i.getString("businesstype.mergecode").startsWith("4") || i.getString("businesstype.mergecode").startsWith("5")) && i.getString("taxrate").equals("5%");
                break;
            }
            case TYPE3: {
                predicate = i -> (i.getString("businesstype.mergecode").startsWith("3") || i.getString("businesstype.mergecode").startsWith("4") || i.getString("businesstype.mergecode").startsWith("5")) && i.getString("taxrate").equals("3%");
                break;
            }
            case TYPE_MDTS: {
                predicate = i -> (i.getString("businesstype.mergecode").startsWith("3") || i.getString("businesstype.mergecode").startsWith("4") || i.getString("businesstype.mergecode").startsWith("5")) && i.getString("taxmethodtype").equals("20");
                break;
            }
            case TYPE_MS: {
                predicate = i -> !(!i.getString("businesstype.mergecode").startsWith("3") && !i.getString("businesstype.mergecode").startsWith("4") && !i.getString("businesstype.mergecode").startsWith("5") || !i.getString("taxmethodtype").equals("3") && !i.getString("taxmethodtype").equals("19"));
            }
        }
        if (predicate != null && needJzjt) {
            predicate = predicate.and(i -> i.getBoolean("jzjt"));
        }
        return Arrays.stream(incomeAccountCollection).filter(Objects.requireNonNull(predicate)).collect(Collectors.toList());
    }
}

