/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.engine.impl.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.common.constant.DraftConstant;
import kd.taxc.tcvat.common.enums.DraftEngineEnum;

public class DraftEditService {
    public static void updateNewDraftId(List<DynamicObject> newDraftList, DynamicObjectCollection oldDraftList, DynamicObject[] draftEditArr, String rulePropertyName) {
        if (CollectionUtils.isEmpty(newDraftList) || CollectionUtils.isEmpty((Collection)oldDraftList) || draftEditArr.length == 0) {
            return;
        }
        for (DynamicObject d : draftEditArr) {
            Optional<DynamicObject> oldDraftOp = oldDraftList.stream().filter(o -> d.getLong("draftid") == o.getLong("id")).findFirst();
            if (!oldDraftOp.isPresent()) continue;
            DynamicObject oldDraft = oldDraftOp.get();
            newDraftList.stream().filter(n -> DraftEditService.isOldMatchNewDraft(oldDraft, n, rulePropertyName)).findFirst().ifPresent(newDraft -> d.set("draftid", (Object)newDraft.getLong("id")));
        }
        SaveServiceHelper.save((DynamicObject[])draftEditArr);
    }

    public static void updateNewYbhzIncomeDraftId(List<DynamicObject> newDraftList, DynamicObjectCollection oldDraftList, Map<String, Long> oldDetailSerialnoMap, DynamicObject[] draftEditArr, String rulePropertyName) {
        if (CollectionUtils.isEmpty(newDraftList) || CollectionUtils.isEmpty((Collection)oldDraftList) || draftEditArr.length == 0) {
            return;
        }
        Map<String, Long> newDetailSerialnoMap = DraftEditService.getDetailSerialnoMap(newDraftList);
        for (DynamicObject d : draftEditArr) {
            Optional<DynamicObject> oldDraftOp = oldDraftList.stream().filter(o -> d.getLong("draftid") == o.getLong("id")).findFirst();
            if (!oldDraftOp.isPresent()) continue;
            DynamicObject oldDraft = oldDraftOp.get();
            newDraftList.stream().filter(n -> DraftEditService.isOldMatchNewYbhzIncomeDraft(oldDraft, (Long)oldDetailSerialnoMap.get(oldDraft.getString("serialno")), n, (Long)newDetailSerialnoMap.get(n.getString("serialno")), rulePropertyName)).findFirst().ifPresent(newDraft -> d.set("draftid", (Object)newDraft.getLong("id")));
        }
        SaveServiceHelper.save((DynamicObject[])draftEditArr);
    }

    public static void addEditAmount(DynamicObject summary, Map<String, BigDecimal> rowEditAmountMap) {
        if (summary == null || CollectionUtils.isEmpty(rowEditAmountMap)) {
            return;
        }
        rowEditAmountMap.forEach((k, v) -> {
            if (rowEditAmountMap.get(k) != null) {
                summary.set(k, (Object)summary.getBigDecimal(k).add((BigDecimal)v));
            }
        });
    }

    public static void updateDraftEditOriginAmount(DynamicObject summary, Map<String, BigDecimal> rowEditAmountMap, List<DynamicObject> editList) {
        if (summary == null || CollectionUtils.isEmpty(rowEditAmountMap) || CollectionUtils.isEmpty(editList)) {
            return;
        }
        rowEditAmountMap.forEach((k, v) -> editList.forEach(e -> {
            if (k.equals(e.getString("rowcode"))) {
                e.set("originamount", (Object)DraftEditService.getSummaryAmountOfKey(summary, k));
            }
        }));
    }

    private static BigDecimal getSummaryAmountOfKey(DynamicObject summary, String k) {
        if (Arrays.asList("tcvat_account_summary", "tcvat_xgm_account_summary", "tcvat_hz_account_summary", "tcvat_account_sum_sjjt", "tcvat_hz_account_sum_sjjt").contains(summary.getDataEntityType().getName()) && "noneinvoiceamount".equals(k)) {
            return summary.getBigDecimal("accountingamount");
        }
        return summary.getBigDecimal(k);
    }

    public static Map<String, BigDecimal> getEditAmountBeforeReFetch(List<DynamicObject> summaryEditList) {
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        if (CollectionUtils.isEmpty(summaryEditList)) {
            return result;
        }
        Map<String, List<DynamicObject>> rowcodeMap = summaryEditList.stream().collect(Collectors.groupingBy(s -> s.getString("rowcode")));
        rowcodeMap.forEach((key, value) -> {
            Map<String, List<DynamicObject>> adjusttypeMap = value.stream().collect(Collectors.groupingBy(v -> v.getString("adjusttype")));
            adjusttypeMap.forEach((k, v) -> {
                Optional<DynamicObject> op = v.stream().max(Comparator.comparing(a -> a.getDate("createtime")));
                if (op.isPresent()) {
                    DynamicObject obj = op.get();
                    if (result.containsKey(key)) {
                        result.put((String)key, ((BigDecimal)result.get(key)).add(obj.getBigDecimal("tzszh")));
                    } else {
                        result.put((String)key, obj.getBigDecimal("tzszh"));
                    }
                }
            });
        });
        return result;
    }

    public static List<DynamicObject> matchDraftEditList(DynamicObjectCollection oldDraftList, DynamicObject[] draftEditArr, DynamicObject newDraft, String rulePropertyName) {
        if (draftEditArr.length == 0 || CollectionUtils.isEmpty((Collection)oldDraftList)) {
            return new ArrayList<DynamicObject>();
        }
        Optional<DynamicObject> oldDraft = oldDraftList.stream().filter(d -> DraftEditService.isOldMatchNewDraft(d, newDraft, rulePropertyName)).findFirst();
        if (oldDraft.isPresent()) {
            return Arrays.stream(draftEditArr).filter(d -> ((DynamicObject)oldDraft.get()).getLong("id") == d.getLong("draftid")).collect(Collectors.toList());
        }
        return new ArrayList<DynamicObject>();
    }

    public static List<DynamicObject> matchYbhzIncomeDraftEditList(DynamicObjectCollection oldDraftList, Map<String, Long> oldDetailSerialnoMap, DynamicObject[] draftEditArr, DynamicObject newDraft, Long newDetailOrg, String rulePropertyName) {
        if (draftEditArr.length == 0 || CollectionUtils.isEmpty((Collection)oldDraftList)) {
            return new ArrayList<DynamicObject>();
        }
        Optional<DynamicObject> oldDraft = oldDraftList.stream().filter(d -> DraftEditService.isOldMatchNewYbhzIncomeDraft(d, (Long)oldDetailSerialnoMap.get(d.getString("serialno")), newDraft, newDetailOrg, rulePropertyName)).findFirst();
        if (oldDraft.isPresent()) {
            return Arrays.stream(draftEditArr).filter(d -> ((DynamicObject)oldDraft.get()).getLong("id") == d.getLong("draftid")).collect(Collectors.toList());
        }
        return new ArrayList<DynamicObject>();
    }

    private static boolean isOldMatchNewYbhzIncomeDraft(DynamicObject oldDraft, Long oldDetailOrg, DynamicObject newDraft, Long newDetailOrg, String rulePropertyName) {
        return oldDetailOrg.equals(newDetailOrg) && newDraft.getString("suborg").equals(oldDraft.getString("suborg")) && newDraft.get(rulePropertyName).equals(oldDraft.get(rulePropertyName));
    }

    private static boolean isOldMatchNewDraft(DynamicObject oldDraft, DynamicObject newDraft, String rulePropertyName) {
        if (newDraft.containsProperty("taxperiod") && oldDraft.containsProperty("taxperiod")) {
            return newDraft.getString("org").equals(oldDraft.getString("org")) && newDraft.get(rulePropertyName).equals(oldDraft.get(rulePropertyName)) && newDraft.getString("taxperiod").equals(oldDraft.getString("taxperiod"));
        }
        if (newDraft.containsProperty("suborg") && oldDraft.containsProperty("suborg")) {
            return newDraft.getString("suborg").equals(oldDraft.getString("suborg")) && newDraft.get(rulePropertyName).equals(oldDraft.get(rulePropertyName));
        }
        return newDraft.getString("org").equals(oldDraft.getString("org")) && newDraft.get(rulePropertyName).equals(oldDraft.get(rulePropertyName));
    }

    public static Map<String, Long> getDetailSerialnoMap(List<DynamicObject> summary) {
        DynamicObjectCollection query2;
        HashMap<String, Long> result = new HashMap<String, Long>();
        Set serialnoSet = summary.stream().map(e -> e.getString("serialno")).collect(Collectors.toSet());
        DynamicObjectCollection query1 = QueryServiceHelper.query((String)DraftConstant.YBHZ_HZ_ACCOUNTING_DETAIL, (String)"taxaccountserialno,suborg", (QFilter[])new QFilter[]{new QFilter("taxaccountserialno", "in", serialnoSet)});
        if (query1 != null && query1.size() > 0) {
            result.putAll(query1.stream().collect(Collectors.toMap(k -> k.getString("taxaccountserialno"), v -> v.getLong("suborg"), (m, n) -> m)));
        }
        if ((query2 = QueryServiceHelper.query((String)DraftConstant.YBHZ_HZ_INVOICE_DETAIL, (String)"taxaccountserialno,suborg", (QFilter[])new QFilter[]{new QFilter("taxaccountserialno", "in", serialnoSet)})) != null && query2.size() > 0) {
            result.putAll(query2.stream().collect(Collectors.toMap(k -> k.getString("taxaccountserialno"), v -> v.getLong("suborg"), (m, n) -> m)));
        }
        return result;
    }

    public static DynamicObject[] getDraftEditList(DynamicObjectCollection draftList) {
        if (CollectionUtils.isEmpty((Collection)draftList)) {
            return new DynamicObject[0];
        }
        List idList = draftList.stream().map(i -> i.getLong("id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("draftid", "in", idList);
        return BusinessDataServiceHelper.load((String)DraftConstant.TCVAT_DRAFT_EDIT, (String)"id,adjusttype,itemname,taxorg,tzszq,tzszh,tzsm,draftid,rowcode,originamount,draftnumber,drafttype,creator,createtime,taxorg_id,creator_id", (QFilter[])new QFilter[]{qFilter});
    }

    public static DynamicObjectCollection getDraftList(TcvatEngineModel model, DraftMetaDataInfo meta) {
        if (!model.getCustom().containsKey("calcType") || model.getCustom().get("calcType") == null || model.getCustom().get("calcType") != null && !"refetch".equals(model.getCustom().get("calcType"))) {
            return new DynamicObjectCollection();
        }
        if (Arrays.asList("zzsybnsr_ybhz", "zzsybnsr_hz_zjg", "zzsybnsr_yz_zjg").contains(model.getCustom().get("taxpayertype"))) {
            return DraftEditService.doQueryHzDraftData(model, meta);
        }
        return DraftEditService.doQueryDraftData(model, meta);
    }

    private static DynamicObjectCollection doQueryHzDraftData(TcvatEngineModel model, DraftMetaDataInfo meta) {
        String taxPayerType = (String)model.getCustom().get("taxPayerType");
        String orgId = model.getOrgId();
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        Date startDate = DateUtils.stringToDate((String)model.getStartDate());
        Date endDate = DateUtils.stringToDate((String)model.getEndDate());
        QFilter skssqqzFilter = new QFilter("startdate", "=", (Object)startDate).and(new QFilter("enddate", "=", (Object)endDate));
        QFilter payerTypeFilter = new QFilter("taxpayertype", "in", Arrays.asList(taxPayerType, taxPayerType.replace("zzs", "")));
        if (Arrays.asList("tcvat_hz_deduction_sum", "tcvat_hz_wait_deduct_sum", "tcvat_hzwaitdeduct_sum_jt").contains(meta.getAccountMetaDataName())) {
            return QueryServiceHelper.query((String)meta.getAccountMetaDataName(), (String)"id,deductiontype,startdate,enddate,org", (QFilter[])new QFilter[]{orgFilter, payerTypeFilter, skssqqzFilter});
        }
        if (Collections.singletonList("tcvat_hz_deduction_sum_jt").contains(meta.getAccountMetaDataName())) {
            return QueryServiceHelper.query((String)meta.getAccountMetaDataName(), (String)"id,deductiontype,startdate,enddate,org,suborg", (QFilter[])new QFilter[]{orgFilter, payerTypeFilter, skssqqzFilter});
        }
        return QueryServiceHelper.query((String)meta.getAccountMetaDataName(), (String)"id,ruleid,startdate,enddate,org,suborg,serialno", (QFilter[])new QFilter[]{orgFilter, payerTypeFilter, skssqqzFilter});
    }

    private static DynamicObjectCollection doQueryDraftData(TcvatEngineModel model, DraftMetaDataInfo meta) {
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(model.getOrgId()));
        QFilter periodFilter = new QFilter("taxperiod", ">=", (Object)model.getStartDate().substring(0, 7)).and(new QFilter("taxperiod", "<=", (Object)model.getEndDate().substring(0, 7)));
        QFilter deadLineFilter = new QFilter("deadline", "=", DraftEngineEnum.getDeadLine(model));
        String metaName = meta.getAccountMetaDataName();
        if (Arrays.asList("tcvat_deduction_summary", "tcvat_wait_deduct_summary", "tcvat_deduction_sum_sjjt", "tcvat_waitdeduct_sum_sjjt").contains(metaName)) {
            return QueryServiceHelper.query((String)metaName, (String)"id,deductiontype,taxperiod,org", (QFilter[])new QFilter[]{orgFilter, periodFilter, deadLineFilter});
        }
        return QueryServiceHelper.query((String)metaName, (String)"id,ruleid,taxperiod,org,serialno", (QFilter[])new QFilter[]{orgFilter, periodFilter, deadLineFilter});
    }
}

