/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.engine.impl.utils;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcvat.business.dao.inputdeduction.InputIdentifyDao;
import kd.taxc.tcvat.business.service.draft.DeductionRolloutService;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.common.constant.DraftConstant;

public class DeductEngineService {
    private static Log logger = LogFactory.getLog(DeductEngineService.class);
    private static final LinkedHashMap<String, String> deductTypeMap = new LinkedHashMap<String, String>(){
        {
            this.put("VAT_JXDK_BQDK_1", "1");
            this.put("VAT_JXDK_BQDK_3", "2");
            this.put("VAT_JXDK_BQDK_5", "9");
            this.put("VAT_JXDK_BQDK_7", "21");
            this.put("VAT_JXDK_BQDK_8", "4");
            this.put("VAT_JXDK_BQDK_9", "5");
            this.put("VAT_JXDK_BQDK_10", "6");
            this.put("VAT_JXDK_BQDK_12", "7");
            this.put("VAT_JXDK_BQDK_2", "10");
            this.put("VAT_JXDK_BQDK_4", "11");
            this.put("VAT_JXDK_BQDK_6", "12");
            this.put("VAT_JXDK_BQDK_14", "8");
        }
    };
    private static Set<String> deductTypeSet = new HashSet<String>(){
        {
            this.add("VAT_JXDK_BQDK_1");
            this.add("VAT_JXDK_BQDK_3");
            this.add("VAT_JXDK_BQDK_5");
            this.add("VAT_JXDK_BQDK_7");
            this.add("VAT_JXDK_BQDK_12");
        }
    };
    private static final String PAGE_TCVAT_DEDUCT_INPUT_AUTH_DETAIL = "tcvat_hz_deduct_inpu_au";
    private DeductionRolloutService deductionRolloutService = new DeductionRolloutService();
    private static final Set<String> specialInvoiceType = new HashSet<String>(){
        {
            this.add("961639304377984000");
            this.add("961640097369875456");
            this.add("1376129725579325440");
        }
    };
    private static final Set<String> transportInvoiceType = new HashSet<String>(){
        {
            this.add("961640926684439552");
            this.add("961641064953820160");
            this.add("961642651029877760");
            this.add("961642939052733440");
            this.add("961634333825754112");
            this.add("1376129501813207040");
        }
    };

    public Map<String, String> getInvoiceTypeMap() {
        DynamicObject[] invoiceTypeDynamicObjects = BusinessDataServiceHelper.load((String)"bd_invoicetype", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("issystem", "=", (Object)"1")});
        return Arrays.stream(invoiceTypeDynamicObjects).collect(Collectors.toMap(o -> o.getString("number"), o -> o.getString("id")));
    }

    public LinkedHashMap<String, String> getDeductTypeMap() {
        return deductTypeMap;
    }

    public Map<String, BigDecimal> incomeJzjtAmount(DynamicObjectCollection incomeAccountCollection) {
        BigDecimal taxAmountSum = BigDecimal.ZERO;
        BigDecimal invoiceJzjtSum = BigDecimal.ZERO;
        for (DynamicObject income : incomeAccountCollection) {
            taxAmountSum = taxAmountSum.add(income.getBigDecimal("taxamount"));
            if (!"1".equals(income.getString("jzjt"))) continue;
            invoiceJzjtSum = invoiceJzjtSum.add(income.getBigDecimal("taxamount"));
        }
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        resultMap.put("taxAmountSum", taxAmountSum);
        resultMap.put("invoiceJzjtSum", invoiceJzjtSum);
        return resultMap;
    }

    public void buildSummaryObject(EngineModel engineModel, String ruleName, String deductionType, String uuid, DynamicObject dynamicObject, Long summaryCount, BigDecimal totalAmount, BigDecimal totalTaxAmount, String taxperiod) {
        dynamicObject.set("serialno", (Object)uuid);
        dynamicObject.set("description", (Object)ruleName);
        dynamicObject.set("org", (Object)engineModel.getOrgId());
        dynamicObject.set("taxperiod", (Object)taxperiod);
        dynamicObject.set("count", (Object)summaryCount);
        dynamicObject.set("amount", (Object)totalAmount.setScale(2, 4));
        dynamicObject.set("taxAmount", (Object)totalTaxAmount.setScale(2, 4));
        dynamicObject.set("deductiontype", (Object)deductionType);
        Object deadLine = engineModel.getCustom().get("deadLine");
        dynamicObject.set("deadline", deadLine);
        if (engineModel.getCustom().get("rulePurpose").equals("sjjt")) {
            dynamicObject.set("deductiontypebase", (Object)(StringUtil.isBlank((CharSequence)deductionType) && StringUtil.isNumeric((String)deductionType) ? 0L : Long.parseLong(deductionType)));
            dynamicObject.set("taxperioddate", (Object)DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate2((String)taxperiod, (String)"yyyy-MM")));
        }
    }

    public BigDecimal getBuildHZJzjtAmount(TcvatEngineModel model, Map<String, String> declareTypeMap, List<DynamicObject> inputPTServicesList, BigDecimal invoiceJzjtSum, BigDecimal taxAmountSum, DynamicObject deductRule, String uuid, Long suborg) {
        BigDecimal inputtaxamount = BigDecimal.ZERO;
        String deductTypeNumber = deductRule.getDynamicObject("deducttype").getString("number");
        if (!deductTypeSet.contains(deductTypeNumber)) {
            return inputtaxamount;
        }
        Map orgRelationMap = (Map)model.getCustom().get("OrgRelationMap");
        Map<String, String> invoiceTypeMap = this.getInvoiceTypeMap();
        DynamicObjectCollection invoiceSignCollection = InputIdentifyDao.getInstance().queryInvoiceSign(orgRelationMap, Collections.singletonList((String)model.getCustom().get("taxperiod")), Collections.singletonList(suborg), invoiceTypeMap);
        DynamicObjectCollection transitSignCollection = new DynamicObjectCollection();
        DynamicObjectCollection customsPaymentCollection = new DynamicObjectCollection();
        DynamicObjectCollection vehicleCollection = new DynamicObjectCollection();
        DynamicObjectCollection specialSignCollection = new DynamicObjectCollection();
        DynamicObjectCollection transportCollection = new DynamicObjectCollection();
        this.getInvoiceSignCollectionByInvoiceType(invoiceTypeMap, invoiceSignCollection, (String)model.getCustom().get("taxperiod"), transitSignCollection, customsPaymentCollection, vehicleCollection, specialSignCollection, transportCollection);
        DynamicObjectCollection signCollection = new DynamicObjectCollection();
        String deductionType = null;
        if ("VAT_JXDK_BQDK_1".equals(deductTypeNumber)) {
            deductionType = "1";
            signCollection = specialSignCollection;
        }
        if ("VAT_JXDK_BQDK_3".equals(deductTypeNumber)) {
            deductionType = "2";
            signCollection = transitSignCollection;
        }
        if ("VAT_JXDK_BQDK_5".equals(deductTypeNumber)) {
            deductionType = "9";
            signCollection = vehicleCollection;
        }
        if ("VAT_JXDK_BQDK_7".equals(deductTypeNumber)) {
            deductionType = "21";
            signCollection = customsPaymentCollection;
        }
        if ("VAT_JXDK_BQDK_12".equals(deductTypeNumber)) {
            deductionType = "7";
            signCollection = transportCollection;
        }
        inputtaxamount = this.getHzInputTaxAmount(declareTypeMap, uuid, suborg, inputPTServicesList, model, signCollection, deductionType, invoiceJzjtSum, taxAmountSum);
        return inputtaxamount;
    }

    public void getInvoiceSignCollectionByInvoiceType(Map<String, String> invoiceTypeMap, DynamicObjectCollection invoiceSignCollection, String date, DynamicObjectCollection transitSignCollection, DynamicObjectCollection customsPaymentCollection, DynamicObjectCollection vehicleCollection, DynamicObjectCollection specialSignCollection, DynamicObjectCollection transportCollection) {
        for (DynamicObject invoice : invoiceSignCollection) {
            if (!date.equals(invoice.getString("taxperiod"))) continue;
            if (invoiceTypeMap.get("15").equals(invoice.getString("invoicetype"))) {
                transitSignCollection.add((Object)invoice);
                continue;
            }
            if (invoiceTypeMap.get("21").equals(invoice.getString("invoicetype"))) {
                customsPaymentCollection.add((Object)invoice);
                continue;
            }
            if (invoiceTypeMap.get("12").equals(invoice.getString("invoicetype"))) {
                vehicleCollection.add((Object)invoice);
                continue;
            }
            if (specialInvoiceType.contains(invoice.getString("invoicetype"))) {
                specialSignCollection.add((Object)invoice);
                continue;
            }
            if (!transportInvoiceType.contains(invoice.getString("invoicetype"))) continue;
            transportCollection.add((Object)invoice);
        }
    }

    public BigDecimal getYbnsrInputTaxAmount(DynamicObjectCollection signCollection, String orgid, String taxperiod, String deductionType, BigDecimal invoiceJzjtSum, BigDecimal taxAmountSum, DraftMetaDataInfo deductionMetaData, List<DynamicObject> inputPTServicesList, String uuid) {
        BigDecimal inputtaxamount = BigDecimal.ZERO;
        if (null != signCollection) {
            for (DynamicObject d : signCollection) {
                DynamicObject t = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)deductionMetaData.getDetailMetaDataNameMap().get(DraftConstant.YBNSR_DEDUCT_INPUT_AUTH_DETAIL)));
                t.set("taxaccountserialno", (Object)uuid);
                t.set("org", (Object)orgid);
                t.set("taxperiod", (Object)taxperiod);
                t.set("voucherno", d.get("voucherno"));
                t.set("baseinvoicetype", d.get("invoicetype"));
                t.set("invoicecode", d.get("invoicecode"));
                t.set("effectivetaxamount", d.get("effectivetaxamount"));
                t.set("deductiontype", (Object)deductionType);
                t.set("taxamount", d.get("taxamount"));
                t.set("inputauthid", d.get("id"));
                t.set("consumertype", d.get("consumertype"));
                t.set("currentsigntaxamount", d.get("currentsigntaxamount"));
                if (t.getString("consumertype").equals("5")) {
                    this.deductionRolloutService.updateDeductDynam(t, invoiceJzjtSum, taxAmountSum, "currentsigntaxamount", "jzjsjxse");
                } else {
                    t.set("jzjtxse", (Object)0);
                    t.set("xsehe", (Object)0);
                    t.set("hfbl", (Object)0);
                    t.set("jzjsjxse", d.get("currentsigntaxamount"));
                }
                inputtaxamount = inputtaxamount.add(t.getBigDecimal("jzjsjxse"));
                inputPTServicesList.add(t);
            }
        }
        return inputtaxamount;
    }

    public BigDecimal getHzInputTaxAmount(Map<String, String> declareTypeMap, String uuid, Long suborg, List<DynamicObject> inputPTServicesList, EngineModel engineModel, DynamicObjectCollection signCollection, String deductionType, BigDecimal invoiceJzjtSum, BigDecimal taxAmountSum) {
        BigDecimal inputtaxamount = BigDecimal.ZERO;
        if (signCollection != null && signCollection.size() > 0) {
            for (DynamicObject d : signCollection) {
                if (!String.valueOf(suborg).equals(d.getString("org"))) continue;
                DynamicObject t = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)PAGE_TCVAT_DEDUCT_INPUT_AUTH_DETAIL));
                t.set("taxaccountserialno", (Object)uuid);
                t.set("org", (Object)engineModel.getOrgId());
                t.set("subOrg", (Object)d.getLong("org"));
                t.set("startdate", (Object)DateUtils.stringToDate((String)engineModel.getStartDate()));
                t.set("enddate", (Object)DateUtils.stringToDate((String)engineModel.getEndDate()));
                t.set("voucherno", d.get("voucherno"));
                t.set("baseinvoicetype", d.get("invoicetype"));
                t.set("type", (Object)("1".equals(declareTypeMap.get(d.getString("org"))) ? "2" : "3"));
                t.set("invoicecode", d.get("invoicecode"));
                t.set("effectivetaxamount", d.get("effectivetaxamount"));
                t.set("deductiontype", (Object)deductionType);
                t.set("taxamount", d.get("taxamount"));
                t.set("inputauthid", d.get("id"));
                t.set("consumertype", d.get("consumertype"));
                t.set("currentsigntaxamount", d.get("currentsigntaxamount"));
                if (t.getString("consumertype").equals("5")) {
                    t.set("jzjtxse", (Object)invoiceJzjtSum);
                    t.set("xsehe", (Object)taxAmountSum);
                    if (taxAmountSum.intValue() == 0) {
                        t.set("hfbl", (Object)0);
                        t.set("jzjsjxse", (Object)0);
                    } else {
                        t.set("hfbl", (Object)invoiceJzjtSum.divide(taxAmountSum, 4, 4));
                        t.set("jzjsjxse", (Object)t.getBigDecimal("currentsigntaxamount").multiply(t.getBigDecimal("hfbl")));
                    }
                } else {
                    t.set("jzjtxse", (Object)0);
                    t.set("xsehe", (Object)0);
                    t.set("hfbl", (Object)0);
                    t.set("jzjsjxse", d.get("currentsigntaxamount"));
                }
                inputtaxamount = inputtaxamount.add(t.getBigDecimal("jzjsjxse"));
                inputPTServicesList.add(t);
            }
        }
        return inputtaxamount;
    }
}

