/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.engine.task;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.util.FilterBuilderUtils;
import kd.taxc.bdtaxr.common.util.RuleConfigUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.utils.date.DateUtils;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;
import kd.taxc.tcvat.business.service.engine.task.util.RuleSettingUtils;
import kd.taxc.tcvat.common.enums.InputInvoiceFilterEnum;
import org.apache.commons.lang.StringUtils;

public class InvoiceAutoSignTask
extends Task<List<DynamicObject>> {
    private static Log logger = LogFactory.getLog(InvoiceAutoSignTask.class);
    private BigDecimal ONE_HUNDRED = new BigDecimal(100);
    private static final int batchSize = 5;
    private Map<String, String> invoiceTypeMap;
    private Map<String, String> result;
    private Map<String, String[]> errorMap;
    private Set<String> correctSet;
    private Set<String> errorSet;
    private DynamicObject rule;
    private String taxaccountserialno;
    private DynamicObjectCollection collection;
    private String entityType;
    private Date taxperiod;
    private Long orgId;

    public InvoiceAutoSignTask(Map<String, String> invoiceTypeMap, Map<String, String> result, Map<String, String[]> errorMap, Set<String> correctSet, Set<String> errorSet, DynamicObject rule, String taxaccountserialno, DynamicObjectCollection collection, String entityType, Date taxperiod, Long orgId) {
        this.invoiceTypeMap = invoiceTypeMap;
        this.result = result;
        this.errorMap = errorMap;
        this.correctSet = correctSet;
        this.errorSet = errorSet;
        this.rule = rule;
        this.taxaccountserialno = taxaccountserialno;
        this.collection = collection;
        this.entityType = entityType;
        this.taxperiod = taxperiod;
        this.orgId = orgId;
    }

    public List<List<DynamicObject>> getValue() {
        return Lists.partition((List)this.collection, (int)5);
    }

    public List<DynamicObject> executor(List<DynamicObject> settings) {
        logger.info("\u8fdb\u9879\u9879\u76ee\u914d\u7f6e\u53d6\u6570\u8ba1\u7b97\u5f00\u59cb\u6267\u884c");
        long start = System.currentTimeMillis();
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        ArrayList<String> logs1 = new ArrayList<String>(16);
        ArrayList<String> logs2 = new ArrayList<String>(16);
        for (DynamicObject setting : settings) {
            ArrayList<QFilter> filterList = new ArrayList<QFilter>();
            String name = this.rule.getString("name");
            DynamicObject table = setting.getDynamicObject("table");
            String entryName = table.getString("name");
            InputInvoiceFilterEnum invoiceTypeEnum2 = InputInvoiceFilterEnum.getInvoiceTypeEnum(entryName);
            if (invoiceTypeEnum2 == null) continue;
            filterList.add(invoiceTypeEnum2.getFilter());
            Map fieldMap = RuleConfigUtils.get((Long)table.getLong("id"));
            RuleSettingUtils.setFilter(fieldMap, filterList, String.valueOf(this.orgId), this.taxperiod);
            String conditionjson = setting.getString("conditionjson");
            if (StringUtils.isNotBlank((String)conditionjson)) {
                QFilter invoiceSettingFilter = FilterBuilderUtils.buildFilter((String)conditionjson, (String)entryName);
                filterList.add(invoiceSettingFilter);
            }
            DynamicObjectCollection query = QueryServiceHelper.query((String)entryName, (String)InputInvoiceFilterEnum.getInvoiceTypeEnum(entryName).getInvoicepkid().concat(",invoice_type,tax_org"), (QFilter[])filterList.toArray(new QFilter[0]));
            logs1.add("InvoiceAutoSignTask query:" + SerializationUtils.toJsonString((Object)query) + ",type:" + entryName + ",name:" + name);
            query.forEach(one -> {
                String[] invoicepkids = InputInvoiceFilterEnum.getInvoiceTypeEnum(entryName).getInvoicepkids();
                String pkid = invoicepkids.length == 2 ? one.getString(invoicepkids[0]).concat(one.getString(invoicepkids[1])) : one.getString(invoicepkids[0]);
                String serialNo = one.getString(invoicepkids[invoicepkids.length - 1]);
                if (this.errorSet.contains(pkid) || this.correctSet.contains(pkid)) {
                    this.errorSet.add(pkid);
                    String s = this.result.get(serialNo);
                    this.errorMap.put(serialNo, new String[]{s, name});
                } else {
                    this.correctSet.add(pkid);
                    this.result.put(serialNo, name);
                    list.add(this.getSignDynamic((DynamicObject)one, entryName, pkid, this.rule.getString("sign")));
                }
            });
            logs2.add("InvoiceAutoSignTask query after result:" + this.result + ",list:" + list + ",errorSet:" + this.errorSet + ",errorMap:" + this.errorMap);
        }
        logger.info(((Object)logs1).toString());
        logger.info(((Object)logs2).toString());
        logger.info("\u8fdb\u9879\u9879\u76ee\u914d\u7f6e\u53d6\u6570\u8ba1\u7b97\u6267\u884c\u7ed3\u675f\uff0c\u8017\u65f6\u4e3a:{},\u6267\u884c\u7684\u7ed3\u679c\u96c6\u4e3a:{}", (Object)(System.currentTimeMillis() - start), list);
        return list;
    }

    private DynamicObject getSignDynamic(DynamicObject query, String entryName, String invoicepkid, String sign) {
        String invoice_no;
        DynamicObject object = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.entityType));
        String[] invoicepkids = InputInvoiceFilterEnum.getInvoiceTypeEnum(entryName).getInvoicepkids();
        String invoice_code = "";
        if (invoicepkids.length == 2) {
            invoice_code = query.getString(invoicepkids[0]);
            invoice_no = query.getString(invoicepkids[1]);
        } else {
            invoice_no = query.getString(invoicepkids[0]);
        }
        object.set("invoicecode", (Object)invoice_code);
        object.set("invoiceno", (Object)invoice_no);
        if (StringUtil.isNotBlank((CharSequence)query.getString("invoice_type"))) {
            object.set("invoicetype", (Object)this.invoiceTypeMap.get(query.getString("invoice_type")));
        }
        object.set("invoicepkid", (Object)invoicepkid);
        object.set("taxperiod", (Object)DateUtils.format((Date)this.taxperiod, (String)"yyyy-MM"));
        object.set("deductperiod", (Object)this.taxperiod);
        if (sign.equals("1")) {
            object.set("consumertype", (Object)"4");
        } else {
            object.set("consumertype", (Object)"5");
        }
        object.set("signtype", (Object)"1");
        object.set("signrule", (Object)"1");
        object.set("signrate", (Object)BigDecimal.ZERO);
        object.set("baseinvoicetype", (Object)query.getString("invoice_type"));
        object.set("org", query.get("tax_org"));
        RequestContext context = RequestContext.get();
        object.set("signstatus", (Object)"1");
        object.set("createtime", (Object)new Date());
        object.set("creator", (Object)context.getUserId());
        object.set("modifier", (Object)context.getUserId());
        object.set("modifytime", (Object)new Date());
        return object;
    }

    private void dealAmount(DynamicObject object) {
        QFilter filter = new QFilter("invoice_no", "=", object.get("invoiceno")).and("invoice_code", "=", object.get("invoicecode"));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"total_tax_amount,effective_tax_amount", (QFilter[])new QFilter[]{filter});
        if (dynamicObject != null) {
            object.set("taxamount", (Object)BigDecimalUtil.setScale((Object)dynamicObject.getString("total_tax_amount")));
            object.set("effectivetaxamount", (Object)BigDecimalUtil.setScale((Object)dynamicObject.getString("effective_tax_amount")));
            object.set("avaliabletaxamount", (Object)BigDecimal.ZERO);
        }
    }
}

