/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.engine.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineCalcFilterService;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.util.RuleConfigUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.engine.task.util.RuleSettingUtils;

public class SmallScaleRuleSettingTask
extends Task<List<DynamicObject>> {
    private static Log logger = LogFactory.getLog(SmallScaleRuleSettingTask.class);
    private int batchSize = 5;
    private DynamicObject rule;
    private EngineModel model;
    private DynamicObjectCollection collection;
    private String taxaccountserialno;
    private String entityType;
    private String taxRate;
    private String taxperiod;

    public SmallScaleRuleSettingTask(DynamicObject rule, EngineModel model, DynamicObjectCollection collection, String taxaccountserialno, String entityType, String taxRate, String taxPeriod) {
        this.rule = rule;
        this.model = model;
        this.collection = collection;
        this.taxaccountserialno = taxaccountserialno;
        this.entityType = entityType;
        this.taxRate = taxRate;
        this.taxperiod = taxPeriod;
    }

    public List<List<DynamicObject>> getValue() {
        return Lists.partition((List)this.collection, (int)this.batchSize);
    }

    public List<DynamicObject> executor(List<DynamicObject> settings) {
        logger.info("\u53d6\u6570\u914d\u7f6e\u8ba1\u7b97\u5f00\u59cb\u6267\u884c");
        long start = System.currentTimeMillis();
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(settings.size());
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        Date firstDayOfMonth = DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)this.taxperiod, (String)"yyyy-MM"));
        Date lastDayOfMonth = DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)this.taxperiod, (String)"yyyy-MM"));
        for (DynamicObject setting : settings) {
            DynamicObject object = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.entityType));
            RuleSettingUtils.setDynamicObject(object, this.taxaccountserialno, this.model, setting, filterList);
            object.set("skssqq", (Object)DateUtils.stringToDate((String)this.taxperiod, (String)"yyyy-MM"));
            object.set("skssqz", (Object)DateUtils.stringToDate((String)DateUtils.format((Date)lastDayOfMonth, (String)"yyyy-MM-dd")));
            DynamicObject table = setting.getDynamicObject("table");
            String entryName = table.getString("name");
            Map fieldMap = RuleConfigUtils.get((Long)table.getLong("id"));
            String dataField = (String)fieldMap.get("datastate");
            if (null != dataField) {
                QFilter startFilter = new QFilter(dataField, ">=", (Object)firstDayOfMonth);
                QFilter endFilter = new QFilter(dataField, "<=", (Object)lastDayOfMonth);
                filterList.add(startFilter);
                filterList.add(endFilter);
            }
            RuleSettingUtils.setFilter(this.rule, fieldMap, this.model, filterList, this.taxperiod, entryName);
            QFilter mappingQfilter = EngineCalcFilterService.getMappingQfilter((Long)DeclareTaxType.ZZS.getBaseTaxId(), (Long)table.getLong("id"), Collections.singletonList(Long.valueOf(this.model.getOrgId())), (Date)firstDayOfMonth, (Date)lastDayOfMonth);
            if (mappingQfilter != null) {
                filterList.add(mappingQfilter);
            }
            RuleSettingUtils.calAmount(Long.parseLong(this.model.getOrgId()), setting, entryName, filterList, this.entityType, this.rule, this.model, object, this.taxRate, list, "tcvat_hz_accdetail_rout", this.taxperiod);
        }
        logger.info("\u53d6\u6570\u914d\u7f6e\u8ba1\u7b97\u6570\u7ed3\u675f\u6267\u884c\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start) + ":" + list.size());
        return list;
    }
}

