/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.engine.task.util;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.enums.DataType;
import kd.taxc.bdtaxr.common.helper.ExrateConvertHelper;
import kd.taxc.bdtaxr.common.taxdeclare.draft.fi.GetGLBalanceCommonUtil;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineCalcFilterService;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.FilterBuilderUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcvat.business.service.draft.PeriodService;
import kd.taxc.tcvat.business.service.identification.InputInvoiceSignRptQueryService;
import kd.taxc.tcvat.business.service.sql.SqlBuilder;
import org.apache.commons.lang.StringUtils;

public class RuleSettingUtils {
    private static BigDecimal reverse = new BigDecimal(-1);
    public static BigDecimal ONE_HUNDRED = new BigDecimal(100);
    private static String[] FIELDS = new String[]{"id", "org", "splitsign", "invoicecode", "invoiceno", "authenticateflag", "taxperiod", "salername", "salertaxno", "totalamount", "invoiceamount", "taxamount", "remark", "devidestate", "projectid"};
    private static Map<String, List<String>> prepayTypeMap = new HashMap<String, List<String>>(){
        {
            this.put("VAT_PREPAY_01", Arrays.asList("VAT_YJXMLX_001", "VAT_YJXMLX_002"));
            this.put("VAT_PREPAY_02", Arrays.asList("VAT_YJXMLX_003", "VAT_YJXMLX_004"));
            this.put("VAT_PREPAY_03", Collections.singletonList("VAT_YJXMLX_005"));
        }
    };

    public static void setDynamicObject(DynamicObject object, String taxaccountserialno, EngineModel model, DynamicObject setting, List<QFilter> filterList) {
        object.set("taxaccountserialno", (Object)taxaccountserialno);
        object.set("org", (Object)Long.parseLong(model.getOrgId()));
        DynamicObject table = setting.getDynamicObject("table");
        object.set("table", (Object)table.getLong("id"));
        object.set("amountfield", (Object)setting.getDynamicObject("amountfield").getLong("id"));
        object.set("datatype", setting.get("datatype"));
        object.set("datadirection", setting.get("datadirection"));
        object.set("filtercondition", setting.get("filtercondition"));
        DynamicObject rule = (DynamicObject)setting.getParent();
        if (!"tcvat_rule_prepay".equals(rule.getDataEntityType().getName())) {
            object.set("conditionjson", setting.get("conditionjson"));
        }
        object.set("absolute", (Object)setting.getBoolean("absolute"));
    }

    public static void setFilter(Map<String, String> fieldMap, String entryName, EngineModel model, List<QFilter> filterList, String taxperiod, Long orgid) {
        String org = fieldMap.get("orgstate");
        if (null != org) {
            Map orgRelationMap = (Map)model.getCustom().get("OrgRelationMap");
            String entityKey = entryName;
            if (org.contains(".")) {
                String[] split = org.split("\\.");
                entityKey = split[0];
            }
            QFilter qfilter = EngineCalcFilterService.getOrgQfilterByRelation((Map)orgRelationMap, (Long)orgid, (String)entryName, (String)entityKey, (String)org);
            filterList.add(qfilter);
        }
        RuleSettingUtils.setTimeFilter(fieldMap, model, filterList, taxperiod);
    }

    public static void setFilter(Map<String, String> fieldMap, List<QFilter> filterList, String orgId, Date taxperiod) {
        String org = fieldMap.get("orgstate");
        if (null != org) {
            QFilter orgFilter = new QFilter(org, "=", (Object)Long.parseLong(orgId));
            filterList.add(orgFilter);
        }
        RuleSettingUtils.setTaxperiodFilter(fieldMap, filterList, taxperiod);
    }

    public static void setFilter(DynamicObject rule, Map<String, String> fieldMap, EngineModel model, List<QFilter> filterList, String taxperiod, String entryName) {
        String org = fieldMap.get("orgstate");
        if (null != org) {
            Boolean isAccountingOrg = model.getCustom().getOrDefault("isAccountingOrg", Boolean.FALSE);
            Long orgid = Long.valueOf(model.getOrgId());
            if ("sim_vatinvoice_output_sig".equals(entryName) || "tcvat_invoice_sign_bill".equals(entryName)) {
                QFilter orgFilter = new QFilter(org, "=", (Object)Long.parseLong((String)model.getCustom().get("taxorg")));
                filterList.add(orgFilter);
            } else if (Objects.equals(isAccountingOrg, Boolean.TRUE)) {
                filterList.add(new QFilter(org, "=", (Object)orgid));
            } else {
                Map orgRelationMap = (Map)model.getCustom().get("OrgRelationMap");
                String entityKey = entryName;
                if (org.contains(".")) {
                    String[] split = org.split("\\.");
                    entityKey = split[0];
                }
                QFilter qfilter = EngineCalcFilterService.getOrgQfilterByRelation((Map)orgRelationMap, (Long)orgid, (String)entryName, (String)entityKey, (String)org);
                filterList.add(qfilter);
            }
        }
        RuleSettingUtils.setDefaultFilter(rule, entryName, model, filterList);
        RuleSettingUtils.setTimeFilter(fieldMap, model, filterList, taxperiod);
    }

    public static void setDefaultFilter(DynamicObject rule, String entryName, EngineModel model, List<QFilter> filterList) {
        if ("tcvat_output_sign".equals(entryName)) {
            filterList.add(new QFilter("projectname", "=", (Object)Long.valueOf((String)model.getCustom().get("projectid"))));
        } else if ("sim_vatinvoice_output_sig".equals(entryName)) {
            filterList.add(new QFilter("project", "=", (Object)Long.valueOf((String)model.getCustom().get("projectid"))));
        } else if ("tcvat_input_invoice_sign".equals(entryName) && RuleSettingUtils.needSetInputInvoiceSignFilter(rule, model)) {
            RuleSettingUtils.setInputInvoiceSignFilter(filterList, model);
        }
        RuleSettingUtils.setPartialPrepayDefaultFilter(rule, entryName, filterList);
    }

    private static boolean needSetInputInvoiceSignFilter(DynamicObject rule, EngineModel model) {
        if (rule != null) {
            return Arrays.asList("tcvat_rule_deduct", "tcvat_rule_rollout", "tcvat_rule_apportion").contains(rule.getDynamicObjectType().getName());
        }
        if (model.getCustomValue("draftEntry") != null) {
            return Arrays.asList("tcvat_roll_out_summary", "tcvat_deduction_summary", "tcvat_hz_roll_out_sum", "tcvat_hz_deduction_sum", "tcvat_hz_rollout_sum_sjjt", "tcvat_hz_deduction_sum_jt", "tcvat_roll_out_sum_sjjt", "tcvat_deduction_sum_sjjt").contains((String)model.getCustomValue("draftEntry"));
        }
        return false;
    }

    public static void setPartialPrepayDefaultFilter(DynamicObject rule, String entryName, List<QFilter> filterList) {
        if ("tcvat_prepay_declare_bill".equals(entryName) && null != rule) {
            String prepaytype = null;
            if (rule.containsProperty("perpreproduct")) {
                prepaytype = rule.getDynamicObject("perpreproduct").getString("number");
            }
            RuleSettingUtils.addPartialPerpayDefaultFilter(filterList, prepaytype);
        }
    }

    public static void setInputInvoiceSignFilter(List<QFilter> filterList, EngineModel model) {
        QFilter orgFilter = null;
        for (QFilter filter : filterList) {
            if (!"org".equals(filter.getProperty())) continue;
            orgFilter = new QFilter("tax_org", filter.getCP(), filter.getValue());
        }
        if (orgFilter == null) {
            orgFilter = new QFilter("tax_org", "=", (Object)Long.parseLong(model.getOrgId()));
        }
        QFilter taxPeriodFilter = new QFilter("tax_period", ">=", (Object)DateUtils.stringToDate2((String)model.getStartDate())).and(new QFilter("tax_period", "<=", (Object)DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate2((String)model.getEndDate()))));
        QFilter invoicetype = new QFilter("invoice_type.number", "in", (Object)new String[]{"4", "2", "27", "12", "15"});
        QFilter authenticateFilter = new QFilter("authenticate_flag", "in", (Object)new String[]{"2", "3"});
        QFilter invoiceStatusFilter = new QFilter("invoice_status", "=", (Object)"0");
        QFilter deductionPurposeFilter = new QFilter("deduction_purpose", "=", (Object)"1");
        QFilter deleteFilter = new QFilter("delete", "=", (Object)"1");
        DynamicObjectCollection rimInvoice1 = QueryServiceHelper.query((String)"rim_invoice", (String)"id,invoice_code,invoice_no,tax_org,tax_period,invoice_type", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter, invoicetype, deleteFilter, authenticateFilter, invoiceStatusFilter, deductionPurposeFilter});
        ArrayList invoiceList = new ArrayList(rimInvoice1);
        invoicetype = new QFilter("invoice_type.number", "in", (Object)new String[]{"1", "26"});
        QFilter transportDeduction = new QFilter("transport_deduction", "=", (Object)"1");
        DynamicObjectCollection rimInvoice2 = QueryServiceHelper.query((String)"rim_invoice", (String)"id,invoice_code,invoice_no,tax_org,tax_period,invoice_type", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter, invoicetype, deleteFilter, invoiceStatusFilter, transportDeduction});
        invoiceList.addAll(rimInvoice2);
        invoicetype = new QFilter("invoice_type.number", "in", (Object)new String[]{"10", "16", "20", "9"});
        DynamicObjectCollection rimInvoice3 = QueryServiceHelper.query((String)"rim_invoice", (String)"id,invoice_code,invoice_no,tax_org,tax_period,invoice_type", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter, invoicetype, deleteFilter, transportDeduction});
        invoiceList.addAll(rimInvoice3);
        invoicetype = new QFilter("invoice_type.number", "=", (Object)"21");
        QFilter manageStatus = QFilter.isNull((String)"manage_status").or(new QFilter("manage_status", "=", (Object)" ")).or(new QFilter("manage_status", "=", (Object)"")).or(new QFilter("manage_status", "=", (Object)"0"));
        DynamicObjectCollection rimInvoice4 = QueryServiceHelper.query((String)"rim_invoice", (String)"id,invoice_code,invoice_no,tax_org,tax_period,invoice_type", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter, invoicetype, authenticateFilter, deductionPurposeFilter, manageStatus, deleteFilter});
        invoiceList.addAll(rimInvoice4);
        HashSet<String> invoicepkidSet = new HashSet<String>(invoiceList.size());
        for (DynamicObject i : invoiceList) {
            String key = i.getString("invoice_code") + i.getString("invoice_no");
            invoicepkidSet.add(key);
        }
        filterList.add(new QFilter("invoicepkid", "in", invoicepkidSet));
    }

    public static void addPartialPerpayDefaultFilter(List<QFilter> filterList, String prepaytype) {
        filterList.add(new QFilter("prepayproject.prepaytype", "in", prepayTypeMap.get(prepaytype)));
    }

    public static void setTaxperiodFilter(Map<String, String> fieldMap, List<QFilter> filterList, Date taxperiod) {
        String dateField = fieldMap.get("datastate");
        if (null != dateField && taxperiod != null) {
            filterList.add(new QFilter(dateField, "=", (Object)taxperiod));
        }
    }

    public static void setTimeFilter(Map<String, String> fieldMap, EngineModel model, List<QFilter> filterList, String taxperiod) {
        String monthField;
        String yearField = fieldMap.get("yearstate");
        if (null != yearField) {
            String year = taxperiod.substring(0, 4);
            filterList.add(new QFilter(yearField, "=", (Object)year));
        }
        if (null != (monthField = fieldMap.get("monthstate"))) {
            String month = taxperiod.substring(5, 7);
            QFilter q1 = new QFilter(monthField, "=", (Object)month);
            int value = Integer.parseInt(month);
            QFilter q2 = new QFilter(monthField, "=", (Object)String.valueOf(value));
            if (value < 10) {
                filterList.add(q1.or(q2));
            } else {
                filterList.add(q1);
            }
        }
    }

    public static String trimTaxRate(String taxrate) {
        if (StringUtil.isEmpty((CharSequence)taxrate)) {
            return taxrate;
        }
        int i = taxrate.indexOf(37);
        return i > 0 ? taxrate.substring(0, i + 1) : taxrate;
    }

    public static void calAmount(Long orgid, DynamicObject setting, String entryName, List<QFilter> filterList, String entityType, DynamicObject rule, EngineModel model, DynamicObject object, String taxRate, List<DynamicObject> list, String rollout, String taxperiod) {
        RuleSettingUtils.calAmount(orgid, setting, entryName, filterList, entityType, rule, model, object, taxRate, list, rollout, model.getStartDate(), model.getEndDate(), taxperiod, Arrays.asList(PeriodService.getTaxPeriod(model.getStartDate()), PeriodService.getTaxPeriod(model.getEndDate())));
    }

    public static void calAmount(Long orgid, DynamicObject setting, String entryName, List<QFilter> filterList, String entityType, DynamicObject rule, EngineModel model, DynamicObject object, String taxRate, List<DynamicObject> list, String rollout, String startDate, String endDate, String taxperiod, List<String> dateList) {
        String selectFieldwithid;
        String amountField = setting.getDynamicObject("amountfield").getString("fieldname");
        String fieldsubname = setting.getDynamicObject("amountfield").getString("fieldsubname");
        String conditionjson = setting.getString("conditionjson");
        taxRate = RuleSettingUtils.trimTaxRate(taxRate);
        QFilter conditionFilters = null;
        if (StringUtils.isNotBlank((String)conditionjson)) {
            if ((entryName.equals("gl_voucher") || entryName.equals("gl_balance")) && conditionjson.contains("assgrp")) {
                conditionjson = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"RuleFilterService", (String)"setAssgrpConditionJson", (Object[])new Object[]{conditionjson});
            }
            if ((conditionFilters = FilterBuilderUtils.buildFilter((String)conditionjson, (String)entryName)) != null) {
                if ((entryName.equals("sim_vatinvoice") || entryName.equals("sim_vatinvoice_vehicles")) && conditionjson.contains("taxrate")) {
                    conditionFilters = RuleSettingUtils.dealRate(conditionFilters);
                } else if (entryName.equals("gl_balance")) {
                    conditionFilters = GetGLBalanceCommonUtil.reBuildAccountFilter((QFilter)conditionFilters);
                }
                filterList.add(conditionFilters);
            }
        }
        if (entryName.equals("sim_vatinvoice")) {
            filterList.add(QFilter.isNotNull((String)"items.goodscode").and("items.goodscode", "!=", (Object)" ").and("items.goodscode", "!=", (Object)""));
        }
        if (entryName.equals("tdm_invoice_output")) {
            filterList.add(new QFilter("invoicestatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"0", "3"})));
        }
        String selectField = amountField;
        if (!entryName.equals(fieldsubname)) {
            selectField = fieldsubname + "." + amountField;
            selectFieldwithid = fieldsubname + ".id as id," + fieldsubname + "." + amountField;
        } else {
            selectFieldwithid = "id," + amountField;
        }
        if (StringUtils.equals((String)rollout, (String)entityType) && StringUtils.equals((String)"tcvat_input_invoice_sign", (String)entryName)) {
            QFilter signStatusFilter = new QFilter("signstatus", "=", (Object)"1");
            filterList.add(signStatusFilter);
        }
        BigDecimal detailTotalAmount = BigDecimal.ZERO;
        boolean isBeginOrEnd = GetGLBalanceCommonUtil.conditionCheck((String)fieldsubname, (String)amountField);
        if (StringUtils.equals((String)rollout, (String)entityType) && StringUtils.equals((String)"tcvat_input_invoice_sign", (String)entryName) && selectFieldwithid.contains("avaliabletaxamount")) {
            BigDecimal sumRolloutTaxAmount = SqlBuilder.querySumTaxAmount(orgid, "rollouttaxamount", "tcvat_rollout_register", model, conditionFilters);
            BigDecimal sumSignedTaxAmount = SqlBuilder.querySumTaxAmount(orgid, "currentsigntaxamount", entryName, model, conditionFilters);
            detailTotalAmount = BigDecimalUtil.subtractObject((Object)sumRolloutTaxAmount, (Object)sumSignedTaxAmount, (int)2);
        } else {
            DynamicObjectCollection accountingList;
            if ("tcvat_invoice_sign_bill".equals(entryName)) {
                accountingList = RuleSettingUtils.getReportData(Long.parseLong((String)model.getCustom().get("taxorg")), model, conditionFilters);
            } else if (isBeginOrEnd) {
                accountingList = taxperiod.equals(dateList.get(0)) && StringUtil.startsWith((CharSequence)amountField, (CharSequence)"begin") ? GetGLBalanceCommonUtil.queryAccountingList((String)entryName, (String)selectFieldwithid, (String)amountField, (String)startDate, (String)endDate, filterList) : (taxperiod.equals(dateList.get(dateList.size() - 1)) && StringUtil.startsWith((CharSequence)amountField, (CharSequence)"end") ? GetGLBalanceCommonUtil.queryAccountingList((String)entryName, (String)selectFieldwithid, (String)amountField, (String)startDate, (String)endDate, filterList) : new DynamicObjectCollection());
            } else {
                accountingList = QueryServiceHelper.query((String)entryName, (String)selectFieldwithid, (QFilter[])filterList.toArray(new QFilter[0]));
                isBeginOrEnd = GetGLBalanceCommonUtil.tdmBalanceNew((String)fieldsubname, (String)amountField);
            }
            for (DynamicObject dynamicObject : accountingList) {
                detailTotalAmount = detailTotalAmount.add(isBeginOrEnd ? dynamicObject.getBigDecimal(selectField) : RuleSettingUtils.getAbsAmount(setting, entryName, selectField, dynamicObject));
            }
        }
        detailTotalAmount = isBeginOrEnd ? (setting.getBoolean("absolute") ? detailTotalAmount.abs() : detailTotalAmount) : detailTotalAmount;
        object.set("fetchamount", (Object)detailTotalAmount);
        String datadirection = setting.getString("datadirection");
        taxRate = RuleSettingUtils.getCalculateTaxRate(setting, rule, object, taxRate, "");
        BigDecimal amount = RuleSettingUtils.getAmount(taxRate, setting.getString("datatype"), detailTotalAmount, datadirection);
        object.set("amount", (Object)amount);
        list.add(object);
        filterList.clear();
    }

    public static QFilter dealRate(QFilter conditionFilters) {
        String property = conditionFilters.getProperty();
        Object value = conditionFilters.getValue();
        String cp = conditionFilters.getCP();
        if ("items.taxrate".equals(property) || "taxrate".equals(property)) {
            String[] newValue;
            if (value instanceof String) {
                if (((String)value).matches("^-?\\d+(\\.\\d+)?$")) {
                    List<String> rateScaleList = RuleSettingUtils.getRateScaleList(Collections.singletonList((String)value));
                    conditionFilters.__setValue(rateScaleList);
                    if (Objects.equals(cp, "=")) {
                        conditionFilters.__setCP("in");
                    } else if (Objects.equals(cp, "!=") || Objects.equals(cp, "<>")) {
                        conditionFilters.__setCP("not in");
                    }
                }
            } else if (value instanceof List) {
                List list = (List)value;
                conditionFilters.__setValue(RuleSettingUtils.getRateScaleList(list));
            } else if (value instanceof String[] && (newValue = (String[])value) != null && newValue.length > 0) {
                ArrayList<String> list = new ArrayList<String>(8);
                for (int i = 0; i < newValue.length; ++i) {
                    list.add(newValue[i]);
                }
                conditionFilters.__setValue(RuleSettingUtils.getRateScaleList(list));
            }
        }
        List nests = conditionFilters.getNests(false);
        for (QFilter.QFilterNest nest : nests) {
            RuleSettingUtils.dealRate(nest.getFilter());
        }
        return conditionFilters;
    }

    public static List<String> getRateScaleList(List<String> rates) {
        ArrayList<String> result = new ArrayList<String>(10);
        for (String rateStr : rates) {
            if (null == rateStr || !rateStr.matches("^-?\\d+(\\.\\d+)?$")) continue;
            BigDecimal rate = BigDecimalUtil.toBigDecimal((Object)rateStr);
            rate = rate.stripTrailingZeros();
            for (int i = rate.scale(); i <= 3; ++i) {
                result.add(rate.setScale(i).toString());
            }
        }
        return result;
    }

    public static DynamicObjectCollection getReportData(Long orgid, EngineModel model, QFilter conditionFilters) {
        DataSet ds = InputInvoiceSignRptQueryService.query(orgid, Long.parseLong((String)model.getCustom().get("projectid")), DateUtils.stringToDate((String)model.getStartDate()), DateUtils.stringToDate((String)model.getEndDate()));
        DynamicObjectCollection collectionList = new DynamicObjectCollection();
        if (null != ds) {
            DataSet iterator = ds.copy();
            if (Objects.nonNull(conditionFilters)) {
                DataSet where = ds.where(conditionFilters.toString());
                iterator = where.copy();
            }
            while (iterator.hasNext()) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tcvat_invoice_sign_bill");
                Row row = iterator.next();
                for (int key = 0; key < FIELDS.length; ++key) {
                    dynamicObject.set(FIELDS[key], (Object)row.getString(FIELDS[key]));
                }
                collectionList.add((Object)dynamicObject);
            }
        }
        return collectionList;
    }

    public static BigDecimal getAmount(String taxRate, String dataType, BigDecimal detailTotalamount, String datadirection) {
        BigDecimal amount = "positive".equals(datadirection) ? detailTotalamount : detailTotalamount.multiply(reverse);
        if (StringUtils.isNotBlank((String)taxRate)) {
            BigDecimal rate = new BigDecimal(taxRate.replaceAll("%", "")).divide(ONE_HUNDRED);
            if ("jsflqs".equals(dataType)) {
                amount = amount.divide(BigDecimal.ONE.add(rate), 10, RoundingMode.HALF_UP);
            } else if ("cysldsqs".equals(dataType)) {
                amount = rate.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : amount.divide(rate, 10, RoundingMode.HALF_UP);
            }
            if ("sehshsj".equals(dataType)) {
                amount = rate.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : amount.divide(rate, 10, RoundingMode.HALF_UP).multiply(BigDecimal.ONE.add(rate));
            }
            if ("bhsjhshsj".equals(dataType)) {
                amount = amount.multiply(BigDecimal.ONE.add(rate)).setScale(10, 4);
            }
            if ("prejsflqs".equals(dataType)) {
                amount = amount.multiply(BigDecimal.ONE.add(rate));
            } else if ("precysldsqs".equals(dataType)) {
                amount = rate.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : amount.add(amount.divide(rate, 2, RoundingMode.HALF_UP));
            }
            if (DataType.HSJHSSE.getCode().equals(dataType)) {
                BigDecimal numerator = amount.multiply(rate);
                BigDecimal denominator = rate.add(new BigDecimal(1));
                amount = numerator.divide(denominator, 2, RoundingMode.HALF_UP);
            }
            if (DataType.BHSJHSSE.getCode().equals(dataType)) {
                amount = amount.multiply(rate).setScale(2, RoundingMode.HALF_UP);
            }
        }
        return amount;
    }

    public static BigDecimal getAbsAmount(DynamicObject setting, String entryName, String selectField, DynamicObject dynamicObject) {
        BigDecimal amount = Boolean.TRUE.equals(setting.getBoolean("absolute")) ? dynamicObject.getBigDecimal(selectField).abs() : dynamicObject.getBigDecimal(selectField);
        return amount;
    }

    public static BigDecimal getAbsAmount(Boolean absolute, String selectField, DynamicObject dynamicObject) {
        BigDecimal amount = Boolean.TRUE.equals(absolute) ? dynamicObject.getBigDecimal(selectField).abs() : dynamicObject.getBigDecimal(selectField);
        return amount;
    }

    public static String getCalculateTaxRate(DynamicObject setting, DynamicObject rule, DynamicObject object, String calculateTaxRate, String settingSuffix) {
        String advanceConfigKey = "entryentity" + settingSuffix + "confjson";
        if (null != setting.getDataEntityType().getProperties().get((Object)advanceConfigKey)) {
            String ruleTaxRate = setting.getString(advanceConfigKey);
            if (rule.getDataEntityType().getName().startsWith("tcvat_rule_income") && "entryentity".equals(setting.getDataEntityType().getName())) {
                object.set("taxrate", (Object)ruleTaxRate);
            } else if (rule.getDataEntityType().getName().startsWith("tcvat_rule_refund") && "zjqs".equals(setting.get("datatype"))) {
                return "0";
            }
            calculateTaxRate = StringUtils.isNotBlank((String)ruleTaxRate) ? new BigDecimal(ruleTaxRate).multiply(new BigDecimal("100")).setScale(2).toString() : ruleTaxRate;
        }
        String vatrate = "vatrate" + settingSuffix;
        if (null != setting.getDataEntityType().getProperties().get((Object)vatrate)) {
            String ruleTaxRate;
            String obj;
            String string = obj = setting.get(vatrate) == null ? "0" : setting.get(vatrate);
            String string2 = obj instanceof String ? obj : (ruleTaxRate = obj instanceof BigDecimal ? ((BigDecimal)((Object)obj)).toPlainString() : obj.toString());
            if ((rule.getDataEntityType().getName().startsWith("tcvat_rule_income") || rule.getDataEntityType().getName().startsWith("tcvat_rule_deduction")) && ("entryentity".equals(setting.getDataEntityType().getName()) || "entryentity3".equals(setting.getDataEntityType().getName()) || "entryentity11".equals(setting.getDataEntityType().getName()))) {
                object.set("taxrate", (Object)ruleTaxRate);
            }
            String string3 = calculateTaxRate = StringUtils.isNotBlank((String)ruleTaxRate) ? new BigDecimal(ruleTaxRate).multiply(new BigDecimal("100")).setScale(2).toString() : ruleTaxRate;
        }
        if (rule.getDataEntityType().getName().startsWith("tcvat_rule_refund")) {
            calculateTaxRate = "zjqs".equals(setting.get("datatype" + settingSuffix)) ? "0" : BigDecimalUtil.toBigDecimal((Object)setting.getString("entryentityconfjson" + settingSuffix)).multiply(new BigDecimal(100)).setScale(2).toString();
        }
        return calculateTaxRate;
    }

    public static Map<String, BigDecimal> getExrateMap(String suffix, List<DynamicObject> settings, Date firstDayOfMonth, Date lastDayOfMonth) {
        Map<String, BigDecimal> exrateMap = settings.stream().filter(a -> a.containsProperty("exratejson" + suffix)).map(a -> a.getString("exratejson" + suffix)).collect(Collectors.toMap(k -> k, v -> BigDecimal.ZERO, (m, n) -> m));
        for (Map.Entry<String, BigDecimal> entry : exrateMap.entrySet()) {
            BigDecimal exrate = ExrateConvertHelper.calcExrate((String)entry.getKey(), (Date)firstDayOfMonth, (Date)lastDayOfMonth);
            entry.setValue(exrate);
        }
        return exrateMap;
    }
}

