/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.engine.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineTask;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.engine.impl.AddDeductionEngine;
import kd.taxc.tcvat.business.service.engine.task.TcvatDraftEngineCalcTask;

public class EngineUtils {
    private static Log logger = LogFactory.getLog(EngineUtils.class);

    public static void execute(RequestContext context, TcvatEngineModel engineModel) throws InterruptedException, ExecutionException, TimeoutException {
        List<EngineTask<TcvatEngineModel, DynamicObject>[]> engineTaskList = TcvatEngineModel.getEngineList("zzsybnsr");
        EngineUtils.execute(context, engineModel, engineTaskList);
        AddDeductionEngine engine = new AddDeductionEngine();
        engine.execute(engineModel);
    }

    public static void execute(RequestContext context, TcvatEngineModel engineModel, List<EngineTask<TcvatEngineModel, DynamicObject>[]> engineTaskList) throws InterruptedException, ExecutionException, TimeoutException {
        ArrayList<Future> futures = new ArrayList<Future>();
        ArrayList<String> engineName = new ArrayList<String>();
        int everySegmentProcess = 80 / engineTaskList.size();
        int currentTotalProcess = 10;
        int currentTaskProcess = 0;
        ArrayList<String> logs = new ArrayList<String>(16);
        for (int i = 0; i < engineTaskList.size(); ++i) {
            int taskCount = engineTaskList.get(i).length;
            for (EngineTask<TcvatEngineModel, DynamicObject> task : engineTaskList.get(i)) {
                task.setCtx(context);
                task.setEngineModel((EngineModel)engineModel);
                futures.add(ThreadPoolsService.getInstance().submitFutrue(task));
                engineName.add(task.getClass().getName());
            }
            for (int j = 0; j < futures.size(); ++j) {
                long start = System.currentTimeMillis();
                ((Future)futures.get(j)).get(300L, TimeUnit.SECONDS);
                if (null != engineModel.getDraftEngineCalcTask()) {
                    currentTaskProcess = (j + 1) * everySegmentProcess / taskCount;
                    ((TcvatDraftEngineCalcTask)engineModel.getDraftEngineCalcTask()).customFeedbackProgress(currentTaskProcess + currentTotalProcess, null, null);
                }
                logs.add((String)engineName.get(i) + "engine uesed time is:" + (System.currentTimeMillis() - start));
            }
            currentTotalProcess = currentTaskProcess;
        }
        logger.info(((Object)logs).toString());
    }
}

