/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.identification;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class InputInvoiceSignRptQueryService {
    private static final Log logger = LogFactory.getLog(InputInvoiceSignRptQueryService.class);
    public static final String DEVIDESTATE_UNDEVIDE = "0";
    public static final String DEVIDESTATE_DEVIDED = "1";
    public static final String SPLIT_DO = "true";
    public static final String SPLIT_UNDO = "false";
    public static final String COMMA = ",";
    public static final String COMPATIBLE_FIELDS = "Cast(id as String) id,org,baseinvoicetype,invoicecode,invoiceno,authenticateflag,taxperiod,salername,salertaxno,invoiceamount,totalamount,taxamount, selectstatus,selectresult, certstatus,remark,invoicedate";
    public static final String ENTITY_DEVIDE_DETAIL = "tcvat_devide_detail";
    public static final String ENTITY_INVOICE_PROJECT = "tcvat_in_invoice_project";
    private static String[] FIELDS = new String[]{"id", "org", "baseinvoicetype.number", "baseinvoicetype.name", "projectname", "splitsign", "invoicecode", "invoiceno", "authenticateflag", "taxperiod", "salername", "salertaxno", "totalamount", "invoiceamount", "taxamount", "selectstatus", "selectresult", "certstatus", "remark", "devidestate", "projectid", "fids", "devideid", "invoicedate"};
    private static DataType[] DATATYPES = new DataType[]{DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.LongType, DataType.StringType};
    private static final String TYPEARRAY = "1,2,3,4,5,15";
    private static final Map<String, String> INVOICE_TYPE_MAP = new LinkedHashMap<String, String>();
    private static final Map<String, String> FILTER_MAP = new HashMap<String, String>();

    public static DataSet query(Object orgid, Long projectid, Date startDate, Date endDate) {
        QFilter qFilterType = new QFilter("number", "in", (Object)TYPEARRAY.split(COMMA));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bd_invoicetype", (String)"id,name,number", (QFilter[])new QFilter[]{qFilterType});
        List ids = Arrays.stream(dynamicObjects).map(o -> o.getString("id")).collect(Collectors.toList());
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("tax_org", "=", orgid));
        qFilters.add(new QFilter("tax_period", ">=", (Object)startDate).and("tax_period", "<=", (Object)DateUtils.getLastDateOfMonth((Date)endDate)));
        qFilters.add(new QFilter("invoicetype", "in", ids));
        qFilters.add(new QFilter("project", "=", (Object)projectid));
        DataSet dataSet = InputInvoiceSignRptQueryService.collectDateSet(qFilters);
        if (dataSet == null) {
            RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])FIELDS, (DataType[])DATATYPES);
            Algo algo = Algo.create((String)(InputInvoiceSignRptQueryService.class.getName() + ".query"));
            DataSetBuilder builder = algo.createDataSetBuilder(rowMeta);
            return builder.build();
        }
        return dataSet;
    }

    public static DataSet collectDateSet(List<QFilter> qFilterList) {
        DataSet dataSet = null;
        ArrayList<QFilter> fieldQFilter = new ArrayList<QFilter>(16);
        QFilter typeQfilter = null;
        QFilter projectQfilter = null;
        for (QFilter qFilter : qFilterList) {
            if (StringUtil.equals((CharSequence)qFilter.getProperty(), (CharSequence)"invoicetype")) {
                typeQfilter = qFilter;
                continue;
            }
            if (StringUtil.equals((CharSequence)qFilter.getProperty(), (CharSequence)"project")) {
                projectQfilter = qFilter;
                continue;
            }
            fieldQFilter.add(qFilter);
        }
        DynamicObjectCollection invoice_project = QueryServiceHelper.query((String)"til_in_invoice_project", (String)"id,invoiceid", (QFilter[])new QFilter[]{projectQfilter});
        if (invoice_project.size() == 0) {
            return null;
        }
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bd_invoicetype", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("issystem", "=", (Object)DEVIDESTATE_DEVIDED)});
        Map<String, String> invoiceTypeMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(o -> o.getString("id"), o -> o.getString("number")));
        if (typeQfilter != null) {
            if (typeQfilter.getCP().equals("in")) {
                Object qfilterValue = typeQfilter.getValue();
                String[] types = qfilterValue instanceof List ? ((List)typeQfilter.getValue()).toArray(new String[0]) : (String[])typeQfilter.getValue();
                for (int i = 0; i < types.length; ++i) {
                    String entity = INVOICE_TYPE_MAP.get(invoiceTypeMap.get(types[i]));
                    DataSet newDateSet = InputInvoiceSignRptQueryService.queryDataSet(fieldQFilter, entity, types[i], FILTER_MAP.get(entity), invoice_project);
                    newDateSet = newDateSet.select(COMPATIBLE_FIELDS);
                    dataSet = null == dataSet ? newDateSet : dataSet.union(newDateSet);
                }
            } else if (typeQfilter.getCP().equals("=")) {
                String value = INVOICE_TYPE_MAP.get(invoiceTypeMap.get(typeQfilter.getValue()));
                DataSet newDateSet = InputInvoiceSignRptQueryService.queryDataSet(fieldQFilter, value, String.valueOf(typeQfilter.getValue()), FILTER_MAP.get(value), invoice_project);
                dataSet = newDateSet.select(COMPATIBLE_FIELDS);
            }
        }
        return null == dataSet ? null : InputInvoiceSignRptQueryService.dealOtherColumn(dataSet);
    }

    public static DataSet dealOtherColumn(DataSet dataSet) {
        DataSet copy = dataSet.copy();
        ArrayList<String> idsList = new ArrayList<String>(16);
        while (copy.hasNext()) {
            idsList.add(copy.next().get("id").toString());
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)ENTITY_INVOICE_PROJECT, (String)"id,project.id,project.name,split,invoiceid,baseinvoicetype", (QFilter[])new QFilter[]{new QFilter("invoiceid", "in", idsList), QFilter.isNotNull((String)"project.name")});
        Map<String, List<DynamicObject>> invoiceProjectMap = query.stream().collect(Collectors.groupingBy(v -> v.getString("invoiceid") + v.getString("baseinvoicetype")));
        DynamicObjectCollection devideQuery = QueryServiceHelper.query((String)ENTITY_DEVIDE_DETAIL, (String)"id,baseinvoicetype,devidetype,sumtaxamount,invoiceid", (QFilter[])new QFilter[]{new QFilter("invoiceid", "in", idsList)});
        Map<String, DynamicObject> devideDetailMap = devideQuery.stream().collect(Collectors.toMap(v -> v.getString("invoiceid") + v.getString("baseinvoicetype"), a -> a, (k1, k2) -> k1));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bd_invoicetype", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("issystem", "=", (Object)DEVIDESTATE_DEVIDED)});
        Map<String, String> invoiceTypeNumberMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(o -> o.getString("id"), o -> o.getString("number")));
        Map<String, String> invoiceTypeNameMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(o -> o.getString("id"), o -> o.getString("name")));
        ArrayList<Object[]> coll = new ArrayList<Object[]>(16);
        copy = dataSet.copy();
        while (copy.hasNext()) {
            DynamicObject devideDetail;
            Row row = copy.next();
            String id = String.valueOf(row.get("id"));
            String idtype = id + row.getString("baseinvoicetype");
            String orgName = row.getString("org");
            String baseinvoicetypeName = invoiceTypeNameMap.get(String.valueOf(row.get("baseinvoicetype")));
            String baseinvoicetypeNumber = invoiceTypeNumberMap.get(String.valueOf(row.get("baseinvoicetype")));
            String invoiceCode = row.getString("invoicecode");
            String invoiceNo = row.getString("invoiceno");
            String authenticateflag = row.getString("authenticateflag");
            String selectstatus = row.getString("selectstatus");
            String selectresult = row.getString("selectresult");
            String certstatus = row.getString("certstatus");
            String taxPeriod = null != row.getString("taxperiod") ? row.getString("taxperiod").substring(0, 7) : row.getString("taxperiod");
            String salerName = row.getString("salername");
            String salertaxno = row.getString("salertaxno");
            String remark = row.getString("remark");
            BigDecimal invoiceamount = BigDecimalUtil.setScale((Object)row.getString("invoiceamount"));
            BigDecimal taxamount = BigDecimalUtil.setScale((Object)row.getString("taxamount"));
            BigDecimal totalamount = BigDecimalUtil.setScale((Object)row.getString("totalamount"));
            String projectName = "";
            List<DynamicObject> projects = invoiceProjectMap.get(idtype);
            String splitsign = SPLIT_UNDO;
            String projectids = "";
            String fids = "";
            if (projects != null && projects.size() > 0) {
                DynamicObject project;
                String split;
                projectName = projects.stream().map(a -> a.getString("project.name")).reduce((acc, item) -> acc + COMMA + item).get();
                projectids = projects.stream().map(a -> a.getString("project.id")).reduce((acc, item) -> acc + COMMA + item).get();
                fids = projects.stream().map(a -> a.getString("id")).reduce((acc, item) -> acc + COMMA + item).get();
                if (projects.size() == 1 && SPLIT_DO.equals(split = (project = projects.get(0)).getString("split"))) {
                    splitsign = split;
                }
            }
            String devidestate = (devideDetail = devideDetailMap.get(idtype)) != null ? DEVIDESTATE_DEVIDED : (projects != null && projects.size() > 1 ? DEVIDESTATE_UNDEVIDE : "");
            Long devideid = devideDetail != null ? devideDetail.getLong("id") : 0L;
            coll.add(new Object[]{id, orgName, baseinvoicetypeNumber, baseinvoicetypeName, projectName, splitsign, invoiceCode, invoiceNo, authenticateflag, taxPeriod, salerName, salertaxno, totalamount, invoiceamount, taxamount, selectstatus, selectresult, certstatus, remark, devidestate, projectids, fids, devideid});
        }
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])FIELDS, (DataType[])DATATYPES);
        CollectionInput inputs = new CollectionInput(rowMeta, coll);
        return Algo.create((String)"utils").createDataSet(new Input[]{inputs});
    }

    public static DataSet queryDataSet(List<QFilter> qFilterList, String entity, String type, String selectFields, DynamicObjectCollection invoice_project) {
        ArrayList<QFilter> newlist = new ArrayList<QFilter>();
        newlist.addAll(qFilterList);
        newlist.add(new QFilter("invoice_type", "=", (Object)Long.parseLong(type)));
        if (invoice_project.size() > 0) {
            if ("rim_inv_toll".equals(entity)) {
                List invoiceid = invoice_project.stream().filter(a -> {
                    try {
                        Long.valueOf(a.getString("invoiceid"));
                    }
                    catch (Exception e) {
                        logger.error((Throwable)e);
                        return false;
                    }
                    return true;
                }).map(v -> Long.valueOf(v.getString("invoiceid"))).collect(Collectors.toList());
                newlist.add(new QFilter("id", "in", invoiceid));
            } else {
                List invoiceid = invoice_project.stream().map(a -> Long.valueOf(a.getString("invoiceid"))).collect(Collectors.toList());
                newlist.add(new QFilter("id", "in", invoiceid));
            }
        }
        return QueryServiceHelper.queryDataSet((String)"InputInvoiceSignRptQueryService", (String)entity, (String)selectFields, (QFilter[])newlist.toArray(new QFilter[newlist.size()]), null);
    }

    static {
        INVOICE_TYPE_MAP.put("4", "rim_inv_special");
        INVOICE_TYPE_MAP.put("2", "rim_inv_special");
        INVOICE_TYPE_MAP.put("15", "rim_inv_toll");
        INVOICE_TYPE_MAP.put(DEVIDESTATE_DEVIDED, "rim_inv_ordinary");
        INVOICE_TYPE_MAP.put("3", "rim_inv_ordinary");
        INVOICE_TYPE_MAP.put("5", "rim_inv_ordinary");
        FILTER_MAP.put("rim_inv_special", "id,org,invoice_type as baseinvoicetype,invoice_code as invoicecode,invoice_no as invoiceno,authenticate_flag as authenticateflag,tax_period as taxperiod,saler_name as salername,saler_tax_no as salertaxno,total_amount as totalamount,invoice_amount as invoiceamount,total_tax_amount as taxamount,authenticate_flag as selectstatus,deduction_purpose as selectresult,authenticate_flag as certstatus,remark,invoice_date as invoicedate");
        FILTER_MAP.put("rim_inv_toll", "id,org,invoice_type as baseinvoicetype,invoice_code as invoicecode,invoice_no as invoiceno,authenticate_flag as authenticateflag,tax_period as taxperiod,saler_name as salername,saler_tax_no as salertaxno,total_amount as totalamount,invoice_amount as invoiceamount,total_tax_amount as taxamount,authenticate_flag as selectstatus,deduction_purpose as selectresult,authenticate_flag as certstatus,remark,invoice_date as invoicedate");
        FILTER_MAP.put("rim_inv_ordinary", "id,org,invoice_type as baseinvoicetype,invoice_code as invoicecode,invoice_no as invoiceno,transport_deduction  as authenticateflag,tax_period as taxperiod,saler_name as salername,saler_tax_no as salertaxno,total_amount as totalamount,invoice_amount as invoiceamount,total_tax_amount as taxamount, '0' as selectstatus, '0' as selectresult, '0' as certstatus,remark,invoice_date as invoicedate");
    }
}

