/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.identification;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.form.IFormView;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;

public class InputRolloutService {
    private static Log logger = LogFactory.getLog(InputRolloutService.class);
    private static String INVOICE_QUERY_FIELDS = "invoicecode,invoiceno,authenticateflag,taxperiod,salername,totalamount,invoiceamount, taxamount, effectivetaxamount";
    private static final String INPUT_INVOICE_ROLLOUT_TABLE_NAME = "tcvat_rollout_register";
    private static String[] FIELDS = new String[]{"id", "org", "type", "invoicecode", "invoiceno", "authenticateflag", "taxperiod", "salername", "goodsname", "totalamount", "invoiceamount", "taxamount", "effectivetaxamount", "avaliabletaxamount", "signedtaxamount"};
    private static DataType[] DATATYPES = new DataType[]{DataType.LongType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType};
    private static String[] SUM_FIELDS = new String[]{"id", "totalamount", "invoiceamount", "taxamount", "effectivetaxamount", "avaliabletaxamount", "signedtaxamount"};
    private static final Map<String, String> INVOICE_TYPE_MAP = new LinkedHashMap<String, String>();
    private static final Map<String, String> FILTER_MAP = new HashMap<String, String>();
    private static final String TAXPERIOD = "taxperiod";
    private static final String ROLLOUT_TAXPERIOD = "rollouttaxperiod";
    private static final String EFFECTIVE_AMOUNT = "effectivetaxamount";
    private static final String AVALIABLE_AMOUNT = "avaliabletaxamount";
    private static final String ENTITY_NAME = "tcvat_rollout_register";
    private static final String INVOICE_NO = "invoiceno";
    private static final String INVOICE_ID = "invoicepkid";
    private static final String INVOICE_CODE = "invoicecode";
    private static final String ORG_ID = "org";
    private static final String INVOICE_TYPE = "invoicetype";
    private static final String BASE_INVOICETYPE = "baseinvoicetype";
    private static final String BILL_NO = "billno";
    private static final String BILL_STATUS = "billstatus";
    private static final String IS_VOUCHER = "isvoucher";

    public static void initialize(String invoicePkid, String cp, String signtype, IFormView getView, BillList billlist) {
        List invoicepkid = (List)getView.getFormShowParameter().getCustomParam("invoicePkIdList");
        String source = (String)getView.getFormShowParameter().getCustomParam("source");
        if (StringUtils.isBlank((CharSequence)source) || "signdetail".equals(source)) {
            QFilter qFilter = new QFilter(invoicePkid, "in", (Object)invoicepkid);
            QFilter dataTypeFilter = new QFilter("type", cp, (Object)"1");
            billlist.setFilter(qFilter.and(dataTypeFilter));
            getView.setVisible(Boolean.FALSE, new String[]{"btnok"});
        } else {
            QFilter qFilter = new QFilter(invoicePkid, "in", (Object)invoicepkid);
            QFilter signtype1 = new QFilter("signtype", "=", (Object)signtype);
            QFilter signstatus1 = new QFilter("signstatus", "=", (Object)"1");
            QFilter dataTypeFilter = new QFilter("type", cp, (Object)"1");
            billlist.setFilter(qFilter.and(signtype1).and(signstatus1).and(dataTypeFilter));
        }
        billlist.setOrderBy("createtime desc");
        billlist.addPackageDataListener(event -> InputRolloutService.packageData(event, getView));
    }

    public static void packageData(PackageDataEvent e, IFormView getView) {
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        DynamicObject d = e.getRowData();
        if (columnDesc.getKey().equals("signrule")) {
            String signrate = d.getBigDecimal("signrate").setScale(2, 4).toString();
            getView.setVisible(Boolean.FALSE, new String[]{"signrate"});
            if ("2".equals(d.getString("signrule"))) {
                e.setFormatValue((Object)String.format(ResManager.loadKDString((String)"\u6309%s%%\u6bd4\u4f8b\u6807\u8bc6", (String)"InputRolloutService_0", (String)"taxc-tcvat", (Object[])new Object[0]), signrate));
            }
        }
    }

    public static void submitUodoSignClick(IFormView getView, BillList billlist, String entityName) {
        logger.info("start InputRolloutService.submitUodoSignClick");
        long start = System.currentTimeMillis();
        ListSelectedRowCollection list = billlist.getSelectedRows();
        if (list == null || list.isEmpty()) {
            getView.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u53d6\u6d88\u6807\u8bb0\u7684\u8bb0\u5f55", (String)"InputRolloutService_1", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        MainEntityType detailEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        ArrayList<Long> idList = new ArrayList<Long>();
        for (ListSelectedRow selectedRow : list) {
            String pkId = selectedRow.getPrimaryKeyValue().toString();
            idList.add(Long.parseLong(pkId));
        }
        QFilter idFilter = new QFilter("id", "in", idList);
        String allFields = MetadataUtil.getAllFieldToQuery((String)entityName);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)entityName, (String)allFields, (QFilter[])new QFilter[]{idFilter});
        DynamicObject[] invoiceTypeDynamicObjects = BusinessDataServiceHelper.load((String)"bd_invoicetype", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("issystem", "=", (Object)"1")});
        Map<String, String> invoiceTypeMap = Arrays.stream(invoiceTypeDynamicObjects).collect(Collectors.toMap(o -> o.getString("id"), o -> o.getString("number")));
        OperationResult operationResult = null;
        if (dynamicObjects.length > 0) {
            ArrayList<DynamicObject> insertDynamicObjects = new ArrayList<DynamicObject>(dynamicObjects.length);
            for (DynamicObject obj : dynamicObjects) {
                obj.set("signstatus", (Object)"2");
                obj.set("modifytime", (Object)new Date());
                obj.set("modifier", (Object)RequestContext.get().getUserId());
                DynamicObject dObj = new DynamicObject((DynamicObjectType)detailEntityType);
                dObj.set(ORG_ID, obj.get(ORG_ID));
                dObj.set(TAXPERIOD, obj.get(TAXPERIOD));
                dObj.set("deductperiod", (Object)DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)(obj.get(TAXPERIOD) + "-01"))));
                dObj.set(AVALIABLE_AMOUNT, obj.get(AVALIABLE_AMOUNT));
                dObj.set("signedtaxamount", obj.get("signedtaxamount"));
                dObj.set(INVOICE_TYPE, (Object)invoiceTypeMap.get(obj.getDynamicObject(BASE_INVOICETYPE).getString("id")));
                dObj.set(BASE_INVOICETYPE, obj.get(BASE_INVOICETYPE));
                dObj.set("consumertype", obj.get("consumertype"));
                dObj.set("remark", obj.get("remark"));
                dObj.set(INVOICE_ID, obj.get(INVOICE_ID));
                dObj.set("signrate", obj.get("signrate"));
                dObj.set(INVOICE_CODE, obj.get(INVOICE_CODE));
                dObj.set(INVOICE_NO, obj.get(INVOICE_NO));
                dObj.set("taxamount", obj.get("taxamount"));
                dObj.set(EFFECTIVE_AMOUNT, obj.get(EFFECTIVE_AMOUNT));
                dObj.set("signrule", obj.get("signrule"));
                dObj.set("createtime", (Object)new Date());
                dObj.set("creator", (Object)RequestContext.get().getUserId());
                dObj.set("modifytime", (Object)new Date());
                dObj.set("modifier", (Object)RequestContext.get().getUserId());
                dObj.set("signcoid", obj.get("id"));
                dObj.set("currentsigntaxamount", (Object)obj.getBigDecimal("currentsigntaxamount").multiply(new BigDecimal(-1)));
                dObj.set("signtype", (Object)"2");
                dObj.set("signstatus", (Object)"2");
                dObj.set("rolloutid", obj.get("rolloutid"));
                dObj.set("type", obj.get("type"));
                dObj.set("rollouttype", (Object)obj.getString("rollouttype"));
                insertDynamicObjects.add(dObj);
            }
            operationResult = OperationServiceHelper.executeOperate((String)"save", (String)entityName, (DynamicObject[])dynamicObjects, (OperateOption)OperateOption.create());
            operationResult = OperationServiceHelper.executeOperate((String)"save", (String)entityName, (DynamicObject[])insertDynamicObjects.toArray(new DynamicObject[insertDynamicObjects.size()]), (OperateOption)OperateOption.create());
        }
        logger.info("InputRolloutService.submitUodoSignClick,\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - start));
        if (null != operationResult && operationResult.isSuccess()) {
            getView.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"InputRolloutService_2", (String)"taxc-tcvat", (Object[])new Object[0]));
            getView.close();
        } else {
            getView.showOperationResult(operationResult);
        }
        logger.info("end InputRolloutService.submitUodoSignClick,\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - start));
    }

    public static DynamicObject getDynamicObject(MainEntityType detailEntityType, String radiogroupfield, BigDecimal percent, String consumerType, Date rolloutTaxPeriodDate, String rolloutTaxPeriod, RequestContext context, Map<String, String> registerIdMap, DynamicObject detail, String rolltype, Map<String, String> invoiceTypeMap, Object remark) {
        DynamicObject another = new DynamicObject((DynamicObjectType)detailEntityType);
        Long id = DBUtils.getLongId((String)"tcvat_rollout_register");
        another.set("id", (Object)id);
        another.set(BILL_NO, (Object)id);
        another.set(BILL_STATUS, (Object)"C");
        another.set(IS_VOUCHER, (Object)Boolean.FALSE);
        another.set(ORG_ID, (Object)detail.getString(ORG_ID));
        another.set(TAXPERIOD, (Object)detail.getString(TAXPERIOD));
        another.set(INVOICE_ID, (Object)detail.getString(INVOICE_ID));
        another.set(INVOICE_TYPE, (Object)detail.getString(INVOICE_TYPE));
        another.set(BASE_INVOICETYPE, (Object)invoiceTypeMap.get(detail.getString(INVOICE_TYPE)));
        another.set(INVOICE_CODE, (Object)detail.getString(INVOICE_CODE));
        another.set(INVOICE_NO, (Object)detail.getString(INVOICE_NO));
        another.set(EFFECTIVE_AMOUNT, detail.get(EFFECTIVE_AMOUNT));
        another.set(AVALIABLE_AMOUNT, detail.get(AVALIABLE_AMOUNT));
        another.set("currentregistertaxamount", detail.get("currentregistertaxamount"));
        another.set("registeredtaxamount", detail.get("registeredtaxamount"));
        another.set("consumertype", (Object)consumerType);
        another.set("rollouttype", (Object)rolltype);
        another.set("remark", remark);
        another.set("registerrule", (Object)radiogroupfield);
        another.set("rolloutrate", (Object)percent);
        another.set("invoiceregistertype", (Object)detail.getString("invoiceregistertype"));
        another.set("registerstatus", (Object)"1");
        another.set("registertype", (Object)"1");
        another.set(ROLLOUT_TAXPERIOD, (Object)rolloutTaxPeriod);
        another.set("rolloutperiod", (Object)rolloutTaxPeriodDate);
        another.set("createtime", (Object)new Date());
        another.set("creator", (Object)context.getUserId());
        another.set("modifier", (Object)context.getUserId());
        another.set("modifytime", (Object)new Date());
        another.set("summaryflag", (Object)"0");
        another.set("rollouttaxamount", detail.get("rollouttaxamount"));
        another.set("apportionstatus", (Object)"2");
        another.set("apportiontype", (Object)"1");
        another.set("apportioncreatetime", (Object)new Date());
        another.set("registercoshareid", (Object)registerIdMap.get(detail.getString(INVOICE_ID)));
        return another;
    }

    public static String convertConsumerTypeToRolloutType(String consumerType, Object consumerRadioGroupValue) {
        String rolloutType = null;
        if (StringUtils.isNotBlank((CharSequence)consumerType)) {
            if ("7".equals(consumerType)) {
                if (StringUtils.isNotBlank((Object)consumerRadioGroupValue)) {
                    if ("4".equals(consumerRadioGroupValue)) {
                        rolloutType = "1";
                    }
                    if ("5".equals(consumerRadioGroupValue)) {
                        rolloutType = "4";
                    }
                    if ("6".equals(consumerRadioGroupValue)) {
                        rolloutType = "7";
                    }
                }
            } else {
                return consumerType;
            }
        }
        return rolloutType;
    }

    public void buildFilterList(List<FilterItemInfo> list, List<QFilter> qFilterList, List<QFilter> subQFilterList) {
        for (int i = 0; i < list.size(); ++i) {
            FilterItemInfo item = list.get(i);
            String name = item.getPropName();
            Object value = item.getValue();
            String compareType = item.getCompareType();
            if (StringUtils.equals((CharSequence)"invoicetype.id", (CharSequence)name)) {
                name = BASE_INVOICETYPE;
                qFilterList.add(new QFilter(name, compareType, value));
                continue;
            }
            if (StringUtils.equals((CharSequence)"period", (CharSequence)name)) {
                name = TAXPERIOD;
                if (!(value instanceof Date)) continue;
                value = DateUtils.format((Date)((Date)value), (String)"yyyy-MM");
                if (!StringUtils.equals((CharSequence)">=", (CharSequence)compareType)) continue;
                qFilterList.add(new QFilter(name, "=", value));
                continue;
            }
            if (StringUtils.equals((CharSequence)"orgs.id", (CharSequence)name) || StringUtils.equals((CharSequence)"orgs.name", (CharSequence)name)) {
                DynamicObjectCollection dynamicObject;
                if (StringUtils.equals((CharSequence)"orgs.name", (CharSequence)name) && null != (dynamicObject = TreeUtils.queryOrgListByCondition((Map)TreeUtils.convertParam((String)"name", (Object)value))) && dynamicObject.size() > 0) {
                    value = ((DynamicObject)dynamicObject.get(0)).get("id");
                }
                name = ORG_ID;
                qFilterList.add(new QFilter(name, compareType, value instanceof String ? Long.valueOf(String.valueOf(value)) : value));
                continue;
            }
            if (StringUtils.equals((CharSequence)"registertype", (CharSequence)name)) {
                name = "invoiceregistertype";
                subQFilterList.add(new QFilter(name, compareType, value));
                continue;
            }
            if (INVOICE_QUERY_FIELDS.contains(name)) {
                qFilterList.add(new QFilter(name, compareType, value));
                continue;
            }
            subQFilterList.add(new QFilter(name, compareType, value));
        }
    }

    public DataSet collectDateSet(Map<String, List<QFilter>> qFilterMap) {
        DataSet dataSet = null;
        for (Map.Entry<String, String> entry : INVOICE_TYPE_MAP.entrySet()) {
            DataSet newDateSet = this.queryDataSet(qFilterMap, entry.getValue(), FILTER_MAP.get(entry.getValue()), null, "taxperiod desc");
            if (null == dataSet) {
                dataSet = newDateSet;
                continue;
            }
            dataSet = dataSet.union(newDateSet);
        }
        return null == dataSet ? null : this.getSumDataSetByAlgo(dataSet, SUM_FIELDS);
    }

    private DataSet queryDataSet(Map<String, List<QFilter>> map, String entity, String selectFields, String[] sumFields, String orderBys) {
        List<QFilter> mainQFilterList = map.get("mainQueryFilter");
        List<QFilter> subQFilterList = map.get("subQueryFilter");
        List<String> typeList = new ArrayList();
        if (subQFilterList.size() > 0) {
            Object object = subQFilterList.get(0).getValue();
            if (object instanceof List) {
                typeList = (List)object;
            } else if (object instanceof String) {
                typeList.add((String)object);
            }
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entity, (String)selectFields, (QFilter[])mainQFilterList.toArray(new QFilter[mainQFilterList.size()]), (String)orderBys);
        return this.getSubDataSet(typeList, dataSet);
    }

    public DataSet getSubDataSet(List<String> typeList, DataSet dataSet) {
        LinkedHashMap value;
        ArrayList<Object[]> coll = new ArrayList<Object[]>();
        long defaultPrimaryId = 0L;
        String orgName = "";
        String invoiceType = "";
        String invoiceCode = "";
        String invoiceNo = "";
        String authenticateflag = "";
        String taxPeriod = "";
        String salerName = "";
        String goodsName = "";
        DynamicObjectCollection invoiceTypes = QueryServiceHelper.query((String)"bd_invoicetype", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("issystem", "=", (Object)"1")});
        Map<String, String> invoiceTypeMap = invoiceTypes.stream().collect(Collectors.toMap(o -> o.getString("id"), o -> o.getString("number")));
        HashMap map = new HashMap(16);
        for (Row row : dataSet.copy()) {
            BigDecimal signedtaxamount = BigDecimalUtil.setScale((Object)BigDecimal.ZERO);
            String invoicePrimaryId = row.getString("id");
            if (StringUtils.isBlank((CharSequence)invoicePrimaryId)) continue;
            orgName = row.getString(ORG_ID);
            String baseInvoiceTypeId = row.getString(BASE_INVOICETYPE);
            invoiceType = invoiceTypeMap.get(baseInvoiceTypeId);
            invoiceCode = row.getString(INVOICE_CODE);
            invoiceNo = row.getString(INVOICE_NO);
            authenticateflag = row.getString("authenticateflag");
            taxPeriod = row.getString(TAXPERIOD);
            salerName = row.getString("salername");
            BigDecimal invoiceamount = BigDecimalUtil.setScale((Object)row.getString("invoiceamount"));
            BigDecimal taxamount = BigDecimalUtil.setScale((Object)row.getString("taxamount"));
            BigDecimal totalamount = BigDecimalUtil.setScale((Object)row.getString("totalamount"));
            BigDecimal effectivetaxamount = BigDecimalUtil.setScale((Object)row.getString(EFFECTIVE_AMOUNT));
            QFilter idFilter = new QFilter(INVOICE_ID, "=", (Object)(invoiceCode + invoiceNo));
            idFilter.and(new QFilter("summaryflag", "=", (Object)"1"));
            DynamicObject[] subObject = BusinessDataServiceHelper.load((String)"tcvat_rollout_register", (String)"id,currentregistertaxamount", (QFilter[])new QFilter[]{idFilter}, (String)"modifytime desc");
            if (null != subObject && subObject.length > 0) {
                for (int i = 0; i < subObject.length; ++i) {
                    DynamicObject sub = subObject[i];
                    signedtaxamount = signedtaxamount.add(BigDecimalUtil.setScale((Object)sub.getString("currentregistertaxamount")));
                }
            }
            BigDecimal avaliabletaxamount = BigDecimalUtil.setScale((Object)effectivetaxamount.subtract(signedtaxamount));
            LinkedHashMap<String, Object> linkedMap = new LinkedHashMap<String, Object>(16);
            linkedMap.put("defaultPrimaryId", defaultPrimaryId);
            linkedMap.put("orgName", orgName);
            linkedMap.put("invoiceType", invoiceType);
            linkedMap.put("invoiceCode", invoiceCode);
            linkedMap.put("invoiceNo", invoiceNo);
            linkedMap.put("authenticateflag", authenticateflag);
            linkedMap.put("taxPeriod", taxPeriod);
            linkedMap.put("salerName", salerName);
            linkedMap.put("goodsName", goodsName);
            linkedMap.put("totalamount", totalamount);
            linkedMap.put("invoiceamount", invoiceamount);
            linkedMap.put("taxamount", taxamount);
            linkedMap.put(EFFECTIVE_AMOUNT, effectivetaxamount);
            linkedMap.put(AVALIABLE_AMOUNT, avaliabletaxamount);
            linkedMap.put("signedtaxamount", signedtaxamount);
            map.put(invoicePrimaryId, linkedMap);
        }
        if (typeList.size() == 0) {
            for (Map.Entry entry : map.entrySet()) {
                value = (LinkedHashMap)entry.getValue();
                if (new BigDecimal(value.get(EFFECTIVE_AMOUNT).toString()).compareTo(BigDecimal.ZERO) <= 0) continue;
                coll.add(new Object[]{value.get("defaultPrimaryId"), value.get("orgName"), value.get("invoiceType"), value.get("invoiceCode"), value.get("invoiceNo"), value.get("authenticateflag"), value.get("taxPeriod"), value.get("salerName"), value.get("goodsName"), value.get("totalamount"), value.get("invoiceamount"), value.get("taxamount"), value.get(EFFECTIVE_AMOUNT), value.get(AVALIABLE_AMOUNT), value.get("signedtaxamount")});
            }
        } else {
            for (Map.Entry entry : map.entrySet()) {
                value = (LinkedHashMap)entry.getValue();
                BigDecimal effectiveTaxamount = BigDecimalUtil.setScale(value.get(EFFECTIVE_AMOUNT));
                BigDecimal signedTaxamount = BigDecimalUtil.setScale(value.get("signedtaxamount"));
                for (String type : typeList) {
                    if (effectiveTaxamount.compareTo(BigDecimal.ZERO) <= 0) continue;
                    if ("1".equals(type) && signedTaxamount.compareTo(effectiveTaxamount) == 0) {
                        coll.add(new Object[]{value.get("defaultPrimaryId"), value.get("orgName"), value.get("invoiceType"), value.get("invoiceCode"), value.get("invoiceNo"), value.get("authenticateflag"), value.get("taxPeriod"), value.get("salerName"), value.get("goodsName"), value.get("totalamount"), value.get("invoiceamount"), value.get("taxamount"), value.get(EFFECTIVE_AMOUNT), value.get(AVALIABLE_AMOUNT), value.get("signedtaxamount")});
                        continue;
                    }
                    if ("2".equals(type) && signedTaxamount.compareTo(effectiveTaxamount) < 0 && signedTaxamount.compareTo(BigDecimal.ZERO) > 0) {
                        coll.add(new Object[]{value.get("defaultPrimaryId"), value.get("orgName"), value.get("invoiceType"), value.get("invoiceCode"), value.get("invoiceNo"), value.get("authenticateflag"), value.get("taxPeriod"), value.get("salerName"), value.get("goodsName"), value.get("totalamount"), value.get("invoiceamount"), value.get("taxamount"), value.get(EFFECTIVE_AMOUNT), value.get(AVALIABLE_AMOUNT), value.get("signedtaxamount")});
                        continue;
                    }
                    if (!"3".equals(type) || signedTaxamount.compareTo(BigDecimal.ZERO) != 0) continue;
                    coll.add(new Object[]{value.get("defaultPrimaryId"), value.get("orgName"), value.get("invoiceType"), value.get("invoiceCode"), value.get("invoiceNo"), value.get("authenticateflag"), value.get("taxPeriod"), value.get("salerName"), value.get("goodsName"), value.get("totalamount"), value.get("invoiceamount"), value.get("taxamount"), value.get(EFFECTIVE_AMOUNT), value.get(AVALIABLE_AMOUNT), value.get("signedtaxamount")});
                }
            }
        }
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])FIELDS, (DataType[])DATATYPES);
        CollectionInput inputs = new CollectionInput(rowMeta, coll);
        return Algo.create((String)this.getClass().getName()).createDataSet(new Input[]{inputs});
    }

    private DataSet getSumDataSetByAlgo(DataSet dataSet, String[] sumFields) {
        if (dataSet.copy().count("id", true) > 0) {
            GroupbyDataSet groupbyDataSet = dataSet.copy().groupBy();
            for (String sumField : sumFields) {
                groupbyDataSet.sum(sumField);
            }
            DataSet dataSetSum = groupbyDataSet.finish();
            ArrayList<Object[]> coll = new ArrayList<Object[]>();
            Long primaryId = 0L;
            BigDecimal totalamount = BigDecimalUtil.setScale((Object)BigDecimal.ZERO);
            BigDecimal taxamount = BigDecimalUtil.setScale((Object)BigDecimal.ZERO);
            BigDecimal invoiceamount = BigDecimalUtil.setScale((Object)BigDecimal.ZERO);
            BigDecimal effectivetaxamount = BigDecimalUtil.setScale((Object)BigDecimal.ZERO);
            BigDecimal avaliabletaxamount = BigDecimalUtil.setScale((Object)BigDecimal.ZERO);
            BigDecimal signedtaxamount = BigDecimalUtil.setScale((Object)BigDecimal.ZERO);
            if (dataSetSum.copy().count("id", true) > 0) {
                for (Row row : dataSetSum.copy()) {
                    invoiceamount = BigDecimalUtil.setScale((Object)row.getString("invoiceamount"));
                    taxamount = BigDecimalUtil.setScale((Object)row.getString("taxamount"));
                    totalamount = BigDecimalUtil.setScale((Object)row.getString("totalamount"));
                    effectivetaxamount = BigDecimalUtil.setScale((Object)row.getString(EFFECTIVE_AMOUNT));
                    avaliabletaxamount = BigDecimalUtil.setScale((Object)row.getString(AVALIABLE_AMOUNT));
                    signedtaxamount = BigDecimalUtil.setScale((Object)row.getString("signedtaxamount"));
                    coll.add(new Object[]{primaryId, "", "count", "", "", "", "", "", "", totalamount, invoiceamount, taxamount, effectivetaxamount, avaliabletaxamount, signedtaxamount});
                }
                RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])FIELDS, (DataType[])DATATYPES);
                CollectionInput inputs = new CollectionInput(rowMeta, coll);
                DataSet dataSetCount = Algo.create((String)this.getClass().getName()).createDataSet(new Input[]{inputs});
                dataSet = dataSet.union(dataSetCount);
            }
        }
        return dataSet;
    }

    static {
        INVOICE_TYPE_MAP.put("4", "tdm_invoice_input");
        INVOICE_TYPE_MAP.put("15", "tdm_input_transit_inv");
        FILTER_MAP.put("tdm_invoice_input", "id, org,baseinvoicetype,invoicecode,invoiceno,authenticateflag,taxperiod,salername,totalamount,invoiceamount, taxamount, effectivetaxamount");
        FILTER_MAP.put("tdm_input_transit_inv", "id, org,baseinvoicetype,invoicecode,invoiceno,authenticateflag,taxperiod,salername,totalamount,invoiceamount, taxamount, effectivetaxamount");
    }
}

