/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.identification;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.tctb.helper.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class InvoiceSignRptService {
    public static final String ID = "id";
    public static final String TYPE = "type";
    public static final String ENTITY_INVOICE_PROJECT = "tcvat_in_invoice_project";
    public static final String PROJECT = "project";
    public static final String INVOICEID = "invoiceid";
    public static final String NEW_INVOICE_TYPE_ENTITY = "baseinvoicetype";
    public static final String NEW_INVOICE_TYPE = "baseinvoicetype.number";
    public static final String DEVIDEID = "devideid";
    public static final String TCVAT_DEVIDE_DETAIL = "tcvat_devide_detail";
    private static final String TYPEARRAY = "4,15,1,3";
    public static final String COMMA = ",";
    public static final String INVOICE_TYPE = "invoicetype.id";
    private static String[] DYNAMIC_FILTER_FIELDS = new String[]{"devidestate"};
    public static final String DEVIDESTATE_UNDEVIDE = "0";
    public static final String DEVIDESTATE_DEVIDED = "1";
    public static final String SPLIT_DO = "true";
    public static final String SPLIT_UNDO = "false";
    public static final String ENTITY_DEVIDE_DETAIL = "tcvat_devide_detail";
    public static final String COMPATIBLE_FIELDS = "Cast(id as String) id,org,baseinvoicetype,invoicecode,invoiceno,authenticateflag,taxperiod,salername,salertaxno,invoiceamount,totalamount,taxamount, selectstatus,selectresult, certstatus,remark,invoicedate";
    private static DataType[] DATATYPES = new DataType[]{DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.LongType, DataType.StringType};
    private static String[] FIELDS = new String[]{"id", "org", "type", "projectname", "splitsign", "invoicecode", "invoiceno", "authenticateflag", "taxperiod", "salername", "salertaxno", "totalamount", "invoiceamount", "taxamount", "selectstatus", "selectresult", "certstatus", "remark", "devidestate", "projectid", "fids", "devideid", "invoicedate"};
    private static final Map<String, String> INVOICE_TYPE_MAP = new LinkedHashMap<String, String>();
    private static final Map<String, String> FILTER_MAP = new HashMap<String, String>();

    public static List<DynamicObject> getSelectRowDatas(ReportList reportlist) {
        int[] rows = reportlist.getEntryState().getSelectedRows();
        if (rows.length > 0) {
            IReportListModel reportModel = reportlist.getReportModel();
            return Arrays.stream(rows).mapToObj(obj -> reportModel.getRowData(obj)).collect(Collectors.toList());
        }
        return new ArrayList<DynamicObject>(0);
    }

    public static BigDecimal getSelectSumTax(List<DynamicObject> selectRowDatas) {
        BigDecimal decimal = null;
        for (DynamicObject rowData : selectRowDatas) {
            BigDecimal taxamount = rowData.getBigDecimal("taxamount");
            if (decimal == null) {
                decimal = taxamount;
                continue;
            }
            decimal = decimal.add(taxamount);
        }
        return decimal;
    }

    public static void buildInvoiceProjectRelate(List<Long> primaryKeyValues, List<DynamicObject> selectRowDatas) {
        DynamicObject[] invoicetypes = BusinessDataServiceHelper.load((String)"bd_invoicetype", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("issystem", "=", (Object)DEVIDESTATE_DEVIDED)});
        Map<String, DynamicObject> invoiceTypeMap = Arrays.stream(invoicetypes).collect(Collectors.toMap(o -> o.getString("number"), o -> o));
        ArrayList<DynamicObject> projectInvoiceList = new ArrayList<DynamicObject>(primaryKeyValues.size() * selectRowDatas.size());
        try (TXHandle h = TX.required();){
            try {
                for (DynamicObject invoice : selectRowDatas) {
                    String id = String.valueOf(invoice.get(ID));
                    DynamicObject type = invoiceTypeMap.get(invoice.getString(TYPE));
                    for (Long primaryKeyValue : primaryKeyValues) {
                        DynamicObject projectDynamic = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_INVOICE_PROJECT);
                        projectDynamic.set(PROJECT, (Object)primaryKeyValue);
                        projectDynamic.set(INVOICEID, (Object)id);
                        projectDynamic.set(NEW_INVOICE_TYPE_ENTITY, (Object)type);
                        projectInvoiceList.add(projectDynamic);
                    }
                    DeleteServiceHelper.delete((String)ENTITY_INVOICE_PROJECT, (QFilter[])new QFilter[]{new QFilter(INVOICEID, "=", (Object)id), new QFilter(NEW_INVOICE_TYPE, "=", type.get("number"))});
                }
                DynamicObject[] dynamicObjects = projectInvoiceList.toArray(new DynamicObject[projectInvoiceList.size()]);
                SaveServiceHelper.save((DynamicObject[])dynamicObjects);
            }
            catch (Throwable t) {
                h.markRollback();
                throw t;
            }
        }
    }

    public static void deleteDivideDetails(List<DynamicObject> selectRowDatas) {
        List devidIds = selectRowDatas.stream().map(a -> a.getLong(DEVIDEID)).collect(Collectors.toList());
        DeleteServiceHelper.delete((String)"tcvat_devide_detail", (QFilter[])new QFilter[]{new QFilter(ID, "in", devidIds)});
    }

    public static List<QFilter> getFilterListByField(ReportQueryParam reportQueryParam) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        List list = filterInfo.getFilterItems();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        if (null != list && list.size() > 0) {
            ArrayList<Date> periods = new ArrayList<Date>();
            HashSet<String> typeSet = new HashSet<String>(4);
            for (int i = 0; i < list.size(); ++i) {
                FilterItemInfo item = (FilterItemInfo)list.get(i);
                String name = item.getPropName();
                Object value = item.getValue();
                String compareType = item.getCompareType();
                if (StringUtils.equals((CharSequence)INVOICE_TYPE, (CharSequence)name)) {
                    typeSet.add(String.valueOf(value));
                    continue;
                }
                if (StringUtils.equals((CharSequence)"period", (CharSequence)name)) {
                    if (!(value instanceof Date)) continue;
                    periods.add((Date)value);
                    continue;
                }
                if (StringUtils.equals((CharSequence)"orgs.id", (CharSequence)name) || StringUtils.equals((CharSequence)"orgs.name", (CharSequence)name)) {
                    DynamicObjectCollection dynamicObject;
                    if (StringUtils.equals((CharSequence)"orgs.name", (CharSequence)name) && null != (dynamicObject = TreeUtils.queryOrgListByCondition((Map)TreeUtils.convertParam((String)"name", (Object)value))) && dynamicObject.size() > 0) {
                        value = ((DynamicObject)dynamicObject.get(0)).getString(ID);
                    }
                    name = "org";
                    List orgList = null;
                    if (value instanceof List) {
                        orgList = (List)value;
                    } else if (value.getClass().isArray()) {
                        orgList = Lists.newArrayList((Object[])((Long[])value));
                    } else if (value instanceof Long) {
                        orgList = Lists.newArrayList((Object[])new Long[]{(Long)value});
                    } else if (value instanceof String) {
                        orgList = Lists.newArrayList((Object[])new Long[]{Long.valueOf(String.valueOf(value))});
                    }
                    if (orgList == null) continue;
                    List taxOrgByAccountingOrgs = TaxOrgTakeRelationServiceHelper.getTaxOrgByAccountingOrgs((List)orgList, (Date)new Date());
                    if (taxOrgByAccountingOrgs.size() == 0) {
                        return null;
                    }
                    qFilterList.add(new QFilter(name, "in", (Object)taxOrgByAccountingOrgs));
                    continue;
                }
                if (StringUtils.equals((CharSequence)"select", (CharSequence)name)) {
                    name = "selectstatus";
                    qFilterList.add(new QFilter(name, compareType, value));
                    continue;
                }
                if (StringUtils.equals((CharSequence)"result", (CharSequence)name)) {
                    name = "selectresult";
                    qFilterList.add(new QFilter(name, compareType, value));
                    continue;
                }
                if (StringUtils.equals((CharSequence)"status", (CharSequence)name)) {
                    name = "certstatus";
                    qFilterList.add(new QFilter(name, compareType, value));
                    continue;
                }
                if (StringUtils.equals((CharSequence)"devidestatus", (CharSequence)name)) {
                    name = "devidestate";
                    qFilterList.add(new QFilter(name, compareType, value));
                    continue;
                }
                qFilterList.add(new QFilter(name, compareType, value));
            }
            if (periods.size() > 0) {
                qFilterList.add(InvoiceSignRptService.getPeriodQFilter(periods));
            }
            QFilter qFilterType = new QFilter("number", "in", (Object)TYPEARRAY.split(COMMA));
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bd_invoicetype", (String)"name,number", (QFilter[])new QFilter[]{qFilterType});
            String[] ids = Arrays.stream(dynamicObjects).map(o -> o.getString(ID)).collect(Collectors.toList());
            qFilterList.add(new QFilter(NEW_INVOICE_TYPE_ENTITY, "in", typeSet.size() > 0 ? typeSet.toArray(new String[0]) : ids));
        }
        return qFilterList;
    }

    private static QFilter getPeriodQFilter(List<Date> periods) {
        int monthDiff;
        Date date2;
        Date date1 = periods.get(0);
        if (date1.after(date2 = periods.get(1))) {
            Date date3 = date1;
            date1 = date2;
            date2 = date3;
        }
        if ((monthDiff = DateUtils.getMonthDiff((Date)date1, (Date)date2)) == 1) {
            String value = DateUtils.format((Date)date1, (String)"yyyy-MM");
            return new QFilter("taxperiod", "=", (Object)value);
        }
        List monthBetween = DateUtils.getMonthBetween((Date)date1, (Date)date2);
        return new QFilter("taxperiod", "in", (Object)monthBetween.toArray());
    }

    public static DataSet getSumDataSet(DataSet dataSet, String algoKey) {
        ArrayList<Object[]> coll = new ArrayList<Object[]>();
        long primaryId = 0L;
        BigDecimal totalamount = BigDecimalUtil.setScale((Object)BigDecimal.ZERO);
        BigDecimal taxamount = BigDecimalUtil.setScale((Object)BigDecimal.ZERO);
        BigDecimal invoiceamount = BigDecimalUtil.setScale((Object)BigDecimal.ZERO);
        if (dataSet.copy().count(ID, true) > 0) {
            for (Row row : dataSet.copy()) {
                String invoicePrimaryId = row.getString(ID);
                if (StringUtils.isBlank((CharSequence)invoicePrimaryId)) continue;
                totalamount = totalamount.add(BigDecimalUtil.setScale((Object)row.getString("totalamount")));
                invoiceamount = invoiceamount.add(BigDecimalUtil.setScale((Object)row.getString("invoiceamount")));
                taxamount = taxamount.add(BigDecimalUtil.setScale((Object)row.getString("taxamount")));
            }
            coll.add(new Object[]{primaryId, "", "count", "", "", "", "", "", "", "", "", totalamount, invoiceamount, taxamount, "", "", "", "", "", "", "", 0L, ""});
        }
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])FIELDS, (DataType[])DATATYPES);
        CollectionInput inputs = new CollectionInput(rowMeta, coll);
        DataSet dataSetCount = Algo.create((String)algoKey).createDataSet(new Input[]{inputs});
        dataSet = dataSet.union(dataSetCount);
        return dataSet;
    }

    public static DataSet collectDateSet(List<QFilter> qFilterList, String algoKey) {
        DataSet dataSet = null;
        Map<String, String> collect = Arrays.stream(DYNAMIC_FILTER_FIELDS).collect(Collectors.toMap(String::toString, a -> a, (k1, k2) -> k1));
        ArrayList<QFilter> dynamicQFilter = new ArrayList<QFilter>(16);
        ArrayList<QFilter> fieldQFilter = new ArrayList<QFilter>(16);
        QFilter typeQfilter = null;
        for (QFilter qFilter : qFilterList) {
            if (StringUtil.equals((CharSequence)qFilter.getProperty(), (CharSequence)NEW_INVOICE_TYPE_ENTITY)) {
                typeQfilter = qFilter;
                continue;
            }
            if (collect.get(qFilter.getProperty()) != null) {
                dynamicQFilter.add(qFilter);
                continue;
            }
            fieldQFilter.add(qFilter);
        }
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bd_invoicetype", (String)"id,name,number", null);
        Map<String, String> invoiceTypeMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(o -> o.getString(ID), o -> o.getString("number")));
        if (typeQfilter != null) {
            if (typeQfilter.getCP().equals("in")) {
                Object qfilterValue = typeQfilter.getValue();
                String[] types = qfilterValue instanceof List ? ((List)typeQfilter.getValue()).toArray(new String[0]) : (String[])typeQfilter.getValue();
                for (int i = 0; i < types.length; ++i) {
                    String value = INVOICE_TYPE_MAP.get(invoiceTypeMap.get(types[i]));
                    DataSet newDateSet = InvoiceSignRptService.queryDataSet(fieldQFilter, value, types[i], FILTER_MAP.get(value), algoKey);
                    newDateSet = newDateSet.select(COMPATIBLE_FIELDS);
                    dataSet = null == dataSet ? newDateSet : dataSet.union(newDateSet);
                }
            } else if (typeQfilter.getCP().equals("=")) {
                String value = INVOICE_TYPE_MAP.get(invoiceTypeMap.get(typeQfilter.getValue()));
                DataSet newDateSet = InvoiceSignRptService.queryDataSet(fieldQFilter, value, String.valueOf(typeQfilter.getValue()), FILTER_MAP.get(value), algoKey);
                dataSet = newDateSet.select(COMPATIBLE_FIELDS);
            }
        }
        if (dataSet != null) {
            DataSet wholeDataSet = InvoiceSignRptService.dealOtherColumn(dataSet, algoKey);
            dataSet = InvoiceSignRptService.dealDynamicColumnFilter(wholeDataSet, dynamicQFilter, DYNAMIC_FILTER_FIELDS);
        }
        return null == dataSet ? null : InvoiceSignRptService.getSumDataSet(dataSet, algoKey);
    }

    private static DataSet queryDataSet(List<QFilter> qFilterList, String entity, String type, String selectFields, String algoKey) {
        ArrayList<QFilter> newlist = new ArrayList<QFilter>();
        if ("961634333825754112".equals(type) || "961639799666521088".equals(type)) {
            for (QFilter filter : qFilterList) {
                if ("selectstatus".equals(filter.getProperty()) || "selectresult".equals(filter.getProperty()) || "certstatus".equals(filter.getProperty())) continue;
                newlist.add(filter);
            }
        } else {
            newlist.addAll(qFilterList);
        }
        newlist.add(new QFilter(NEW_INVOICE_TYPE_ENTITY, "=", (Object)Long.parseLong(type)));
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)entity, (String)selectFields, (QFilter[])newlist.toArray(new QFilter[newlist.size()]), null);
    }

    private static DataSet dealOtherColumn(DataSet dataSet, String algoKey) {
        DataSet copy = dataSet.copy();
        ArrayList<String> idsList = new ArrayList<String>(16);
        while (copy.hasNext()) {
            idsList.add(copy.next().get(ID).toString());
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)ENTITY_INVOICE_PROJECT, (String)"id,project.id,project.name,split,invoiceid,baseinvoicetype", (QFilter[])new QFilter[]{new QFilter(INVOICEID, "in", idsList), QFilter.isNotNull((String)"project.name")});
        Map<String, List<DynamicObject>> invoiceProjectMap = query.stream().collect(Collectors.groupingBy(v -> v.getString(INVOICEID) + v.getString(NEW_INVOICE_TYPE_ENTITY)));
        DynamicObjectCollection devideQuery = QueryServiceHelper.query((String)"tcvat_devide_detail", (String)"id,baseinvoicetype,devidetype,sumtaxamount,invoiceid", (QFilter[])new QFilter[]{new QFilter(INVOICEID, "in", idsList)});
        Map<String, DynamicObject> devideDetailMap = devideQuery.stream().collect(Collectors.toMap(v -> v.getString(INVOICEID) + v.getString(NEW_INVOICE_TYPE_ENTITY), a -> a, (k1, k2) -> k1));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bd_invoicetype", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("issystem", "=", (Object)DEVIDESTATE_DEVIDED)});
        Map<String, String> invoiceTypeMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(o -> o.getString(ID), o -> o.getString("number")));
        ArrayList<Object[]> coll = new ArrayList<Object[]>(16);
        copy = dataSet.copy();
        while (copy.hasNext()) {
            DynamicObject devideDetail;
            Row row = copy.next();
            String id = String.valueOf(row.get(ID));
            String idtype = id + row.getString(NEW_INVOICE_TYPE_ENTITY);
            String orgName = row.getString("org");
            String invoiceType = invoiceTypeMap.get(row.getString(NEW_INVOICE_TYPE_ENTITY));
            String invoiceCode = row.getString("invoicecode");
            String invoicedate = DateUtils.format((Date)row.getDate("invoicedate"));
            String invoiceNo = row.getString("invoiceno");
            String authenticateflag = row.getString("authenticateflag");
            String selectstatus = row.getString("selectstatus");
            String selectresult = row.getString("selectresult");
            String certstatus = row.getString("certstatus");
            String taxPeriod = row.getString("taxperiod");
            String salerName = row.getString("salername");
            String salertaxno = row.getString("salertaxno");
            String remark = row.getString("remark");
            BigDecimal invoiceamount = BigDecimalUtil.setScale((Object)row.getString("invoiceamount"));
            BigDecimal taxamount = BigDecimalUtil.setScale((Object)row.getString("taxamount"));
            BigDecimal totalamount = BigDecimalUtil.setScale((Object)row.getString("totalamount"));
            String projectName = "";
            List<DynamicObject> projects = invoiceProjectMap.get(idtype);
            String splitsign = SPLIT_UNDO;
            String projectids = "";
            String fids = "";
            if (projects != null && projects.size() > 0) {
                DynamicObject project;
                String split;
                projectName = projects.stream().map(a -> a.getString("project.name")).reduce((acc, item) -> acc + COMMA + item).get();
                projectids = projects.stream().map(a -> a.getString("project.id")).reduce((acc, item) -> acc + COMMA + item).get();
                fids = projects.stream().map(a -> a.getString(ID)).reduce((acc, item) -> acc + COMMA + item).get();
                if (projects.size() == 1 && SPLIT_DO.equals(split = (project = projects.get(0)).getString("split"))) {
                    splitsign = split;
                }
            }
            String devidestate = (devideDetail = devideDetailMap.get(idtype)) != null ? DEVIDESTATE_DEVIDED : (projects != null && projects.size() > 1 ? DEVIDESTATE_UNDEVIDE : "");
            Long devideid = devideDetail != null ? devideDetail.getLong(ID) : 0L;
            coll.add(new Object[]{id, orgName, invoiceType, projectName, splitsign, invoiceCode, invoiceNo, authenticateflag, taxPeriod, salerName, salertaxno, totalamount, invoiceamount, taxamount, selectstatus, selectresult, certstatus, remark, devidestate, projectids, fids, devideid, invoicedate});
        }
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])FIELDS, (DataType[])DATATYPES);
        CollectionInput inputs = new CollectionInput(rowMeta, coll);
        return Algo.create((String)algoKey).createDataSet(new Input[]{inputs});
    }

    private static DataSet dealDynamicColumnFilter(DataSet dataSet, List<QFilter> qFilterList, String[] columnNames) {
        if (qFilterList.size() == 0) {
            return dataSet;
        }
        Map<String, QFilter> filterMap = qFilterList.stream().collect(Collectors.toMap(QFilter::getProperty, a -> a, (k1, k2) -> k1));
        ArrayList<String> whereList = new ArrayList<String>(columnNames.length);
        for (int i = 0; i < columnNames.length; ++i) {
            String columnName = columnNames[i];
            QFilter qFilter = filterMap.get(columnName);
            String where = qFilter.toString();
            whereList.add(where);
        }
        for (String where : whereList) {
            dataSet = dataSet.where(where);
        }
        return dataSet;
    }

    static {
        INVOICE_TYPE_MAP.put("4", "tdm_invoice_input");
        INVOICE_TYPE_MAP.put("15", "tdm_input_transit_inv");
        INVOICE_TYPE_MAP.put(DEVIDESTATE_DEVIDED, "tdm_input_plain_invoice");
        INVOICE_TYPE_MAP.put("3", "tdm_input_plain_invoice");
        FILTER_MAP.put("tdm_invoice_input", "id,org,baseinvoicetype,invoicecode,invoiceno,authenticateflag,taxperiod,salername,salertaxno,totalamount,invoiceamount,taxamount, selectstatus,selectresult, certstatus,remark,invoicedate");
        FILTER_MAP.put("tdm_input_plain_invoice", "id,org,baseinvoicetype,invoicecode,invoiceno,authenticateflag,taxperiod,salername,salertaxno,totalamount,invoiceamount,taxamount, '0' as selectstatus, '0' as selectresult, '0' as certstatus,remark,invoicedate");
        FILTER_MAP.put("tdm_input_transit_inv", "id,org,baseinvoicetype,invoicecode,invoiceno,authenticateflag,taxperiod,salername,salertaxno,totalamount,invoiceamount,taxamount, selectstatus,selectresult, certstatus,remark,invoicedate");
    }
}

