/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.identification;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;

public class InvoiceSignService {
    private static final String SIGN_RATE_KEY = "signrate";
    private static final String TAXPERIOD = "taxperiod";
    private static final String DEDUCTPERIOD = "deductperiod";
    private static final String CURRENT_AMOUNT = "currentsigntaxamount";
    private static final String EFFECTIVE_AMOUNT = "effectivetaxamount";
    private static final String SIGN_RULE_RADIO_GROUP_KEY = "ruleradio";
    private static final String CONSUMER_RADIO_GROUP_KEY = "radiogroupfield";
    private static final String RULE_1 = "1";
    private static final String RULE_2 = "2";
    private static final String AVALIABLE_AMOUNT = "avaliabletaxamount";
    private static final String SIGNED_AMOUNT = "signedtaxamount";
    private static final String ENTITY_NAME = "tcvat_input_invoice_sign";
    private static final String CACHE_KEY = "input_sign";
    private static final String TAX_AMOUNT = "taxamount";
    private static final String INVOICE_NO = "invoiceno";
    private static final String INVOICE_ID = "invoicepkid";
    private static final String INVOICE_CODE = "invoicecode";
    private static final String ORG_ID = "org";
    private static final String INVOICE_TYPE = "invoicetype";
    private static final String BASEINVOICETYPE = "baseinvoicetype";
    private static final String ROLLOUT_AMOUNT = "rollouttaxamount";

    public static void submitClick(IPageCache pageCache, IDataModel model, IFormView getView, String type) {
        String radiogroupfield = (String)model.getValue(SIGN_RULE_RADIO_GROUP_KEY);
        BigDecimal percent = (BigDecimal)model.getValue(SIGN_RATE_KEY);
        if (RULE_2.equals(radiogroupfield) && (percent == null || BigDecimal.ZERO.compareTo(percent) == 0)) {
            getView.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6807\u8bc6\u6bd4\u4f8b", (String)"InvoiceSignService_0", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        BigDecimal avaliabletaxamount = (BigDecimal)model.getValue(AVALIABLE_AMOUNT);
        if (avaliabletaxamount.compareTo(BigDecimal.ZERO) == 0) {
            getView.showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5df2\u9009\u6570\u636e\u53ef\u6807\u8bc6\u91d1\u989d\u4e3a0\uff0c\u4e0d\u80fd\u6807\u8bc6", (String)"InvoiceSignService_1", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        BigDecimal currentsigntaxamount = (BigDecimal)model.getValue(CURRENT_AMOUNT);
        if (currentsigntaxamount.compareTo(BigDecimal.ZERO) <= 0 || currentsigntaxamount.compareTo(avaliabletaxamount) > 0) {
            getView.showErrorNotification(ResManager.loadKDString((String)"\u672c\u6b21\u6807\u8bc6\u7a0e\u989d\u5e94\u5927\u4e8e0\u5e76\u4e14\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u53ef\u6807\u8bc6\u7a0e\u989d", (String)"InvoiceSignService_2", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        if (InvoiceSignService.save(pageCache, model, type)) {
            getView.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean save(IPageCache pageCache, IDataModel model, String type) {
        String valueString = pageCache.get("input_signvalueMap");
        if (StringUtils.isNotBlank((CharSequence)valueString)) {
            JSONArray jsonArray = JSON.parseArray((String)valueString);
            MainEntityType detailEntityType = EntityMetadataCache.getDataEntityType((String)ENTITY_NAME);
            ArrayList<DynamicObject> detailList = new ArrayList<DynamicObject>();
            String radiogroupfield = (String)model.getValue(SIGN_RULE_RADIO_GROUP_KEY);
            BigDecimal percent = (BigDecimal)model.getValue(SIGN_RATE_KEY);
            String consumerTypeField = (String)model.getValue(CONSUMER_RADIO_GROUP_KEY);
            RequestContext context = RequestContext.get();
            String taxperiod = TAXPERIOD;
            if ("query".equals(type)) {
                taxperiod = "rollouttaxperiod";
            }
            try {
                DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bd_invoicetype", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("issystem", "=", (Object)RULE_1)});
                Map<String, String> invoiceTypeMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(o -> o.getString("number"), o -> o.getString("id")));
                for (int i = 0; i < jsonArray.size(); ++i) {
                    BigDecimal currentSignTaxamount;
                    JSONObject invoice = jsonArray.getJSONObject(i);
                    DynamicObject detail = new DynamicObject((DynamicObjectType)detailEntityType);
                    detail.set(ORG_ID, (Object)invoice.getString(ORG_ID));
                    detail.set(TAXPERIOD, (Object)invoice.getString(taxperiod));
                    detail.set(DEDUCTPERIOD, (Object)DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)(invoice.getString(taxperiod) + "-01"))));
                    detail.set(INVOICE_TYPE, (Object)invoice.getString(INVOICE_TYPE));
                    detail.set(BASEINVOICETYPE, (Object)invoiceTypeMap.get(invoice.getString(INVOICE_TYPE)));
                    detail.set(INVOICE_CODE, (Object)invoice.getString(INVOICE_CODE));
                    detail.set(INVOICE_NO, (Object)invoice.getString(INVOICE_NO));
                    detail.set(TAX_AMOUNT, (Object)BigDecimalUtil.setScale((Object)invoice.getString(TAX_AMOUNT)));
                    detail.set(INVOICE_ID, (Object)invoice.getString(INVOICE_ID));
                    BigDecimal effectiveTaxAmount = BigDecimalUtil.setScale((Object)invoice.getString(EFFECTIVE_AMOUNT));
                    BigDecimal signedTaxAmount = BigDecimalUtil.setScale((Object)invoice.getString(SIGNED_AMOUNT));
                    BigDecimal avaliableTaxAmount = BigDecimalUtil.setScale((Object)invoice.getString(AVALIABLE_AMOUNT));
                    detail.set(EFFECTIVE_AMOUNT, (Object)effectiveTaxAmount);
                    if ("query".equals(type)) {
                        BigDecimal rolloutTaxAmount = BigDecimalUtil.setScale((Object)invoice.getString(ROLLOUT_AMOUNT));
                        detail.set(ROLLOUT_AMOUNT, (Object)rolloutTaxAmount);
                        effectiveTaxAmount = rolloutTaxAmount;
                    }
                    if (BigDecimal.ZERO.compareTo(avaliableTaxAmount) >= 0) continue;
                    if (RULE_1.equals(radiogroupfield)) {
                        currentSignTaxamount = avaliableTaxAmount;
                        signedTaxAmount = avaliableTaxAmount;
                        avaliableTaxAmount = BigDecimal.ZERO;
                    } else if (RULE_2.equals(radiogroupfield)) {
                        currentSignTaxamount = avaliableTaxAmount.multiply(percent).divide(new BigDecimal(100)).setScale(2, 4);
                        avaliableTaxAmount = avaliableTaxAmount.subtract(currentSignTaxamount).setScale(2, 4);
                        signedTaxAmount = signedTaxAmount.add(currentSignTaxamount).setScale(2, 4);
                    } else {
                        currentSignTaxamount = BigDecimalUtil.setScale((Object)model.getValue(CURRENT_AMOUNT));
                        signedTaxAmount = signedTaxAmount.add(currentSignTaxamount).setScale(2, 4);
                        avaliableTaxAmount = effectiveTaxAmount.subtract(signedTaxAmount).setScale(2, 4);
                    }
                    detail.set(AVALIABLE_AMOUNT, (Object)avaliableTaxAmount);
                    detail.set(CURRENT_AMOUNT, (Object)currentSignTaxamount);
                    detail.set(SIGNED_AMOUNT, (Object)signedTaxAmount);
                    detail.set("signtype", (Object)RULE_1);
                    if ("query".equals(type)) {
                        if ("4".equals(consumerTypeField)) {
                            detail.set("refundabletaxamount", (Object)currentSignTaxamount);
                        } else if ("5".equals(consumerTypeField)) {
                            detail.set("undistinguishtaxamount", (Object)currentSignTaxamount);
                        }
                        detail.set("signtype", (Object)"3");
                        detail.set("type", (Object)RULE_1);
                        detail.set("rolloutid", (Object)invoice.getLong("primaryid"));
                        detail.set("rollouttype", (Object)invoice.getString("rollouttype"));
                    }
                    detail.set("consumertype", (Object)consumerTypeField);
                    detail.set("remark", model.getValue("remark"));
                    detail.set("signrule", (Object)radiogroupfield);
                    detail.set(SIGN_RATE_KEY, (Object)percent);
                    detail.set("signstatus", (Object)RULE_1);
                    detail.set("createtime", (Object)new Date());
                    detail.set("creator", (Object)context.getUserId());
                    detail.set("modifier", (Object)context.getUserId());
                    detail.set("modifytime", (Object)new Date());
                    detailList.add(detail);
                }
                if (!detailList.isEmpty()) {
                    DynamicObject[] arrInsertDobj = new DynamicObject[detailList.size()];
                    arrInsertDobj = detailList.toArray(arrInsertDobj);
                    SaveServiceHelper.save((DynamicObject[])arrInsertDobj);
                }
            }
            finally {
                pageCache.remove("input_signvalueMap");
            }
            return true;
        }
        return false;
    }
}

