/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.identification.output;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.tcvat.business.service.engine.task.PartitionSaveTask;
import kd.taxc.tcvat.business.service.engine.task.RuleTask;
import org.apache.commons.lang3.ObjectUtils;

public class OuputInvoiceJzjtSignListService {
    private static Log logger = LogFactory.getLog(OuputInvoiceJzjtSignListService.class);
    private static final String SIM_VATINVOICE = "sim_vatinvoice";
    private static final String TCVAT_OUTPUT_INVOICE_SIGN = "tcvat_output_invoice_sign";
    private static final String TCVAT_OUTPUT_JZJT_SIGN = "tcvat_output_jzjt_sign";
    private static final String SIGN = "sign";
    private static final String UNDOSIGN = "undosign";
    private static final String SEPARATOR = System.getProperty("line.separator");

    public List<Long> getAllPermOrgs() {
        TaxResult result = TaxcCombineDataServiceHelper.queryTaxcMainOrgIdByIsTaxpayerWithPerm((Long)RequestContext.get().getCurrUserId(), (String)"tcvat", (String)TCVAT_OUTPUT_JZJT_SIGN, (String)"47150e89000000ac");
        if (result.isSuccess() && !ObjectUtils.isEmpty((Object)result.getData())) {
            return (List)result.getData();
        }
        return Collections.EMPTY_LIST;
    }

    public List<DynamicObject> getYbnsrOrgs(List<Long> permOrgs) {
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainZzsByOrgId(permOrgs);
        if (result.isSuccess() && !ObjectUtils.isEmpty((Object)result.getData())) {
            return ((List)result.getData()).stream().filter(e -> CollectionUtils.isNotEmpty((Collection)e.getDynamicObjectCollection("categoryentryentity")) ? "ybnsr".equals(((DynamicObject)e.getDynamicObjectCollection("categoryentryentity").get(0)).getString("taxpayertype")) : false).map(e -> e.getDynamicObject("orgid")).collect(Collectors.toList());
        }
        return Collections.EMPTY_LIST;
    }

    public static List<ComboItem> getComboItems(List<Map<String, String>> orgList) {
        String orgID = String.valueOf(RequestContext.get().getOrgId());
        int index = -1;
        int orgIndex = -1;
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(orgList.size());
        for (Map<String, String> map : orgList) {
            ++index;
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(map.get("name")));
            item.setValue(map.get("id"));
            combos.add(item);
            if (!orgID.equals(item.getValue())) continue;
            orgIndex = index;
        }
        if (orgIndex > 0) {
            Collections.swap(combos, 0, orgIndex);
        }
        return combos;
    }

    public Map<Long, String> getSignedMap(List<Long> subInvoiceList) {
        QFilter qFilter = new QFilter("subinvoiceid", "in", subInvoiceList).and("jzjtsign", "=", (Object)"1");
        DynamicObjectCollection signedCollection = QueryServiceHelper.query((String)TCVAT_OUTPUT_INVOICE_SIGN, (String)"subinvoiceid, invoiceno", (QFilter[])new QFilter[]{qFilter});
        return signedCollection.stream().collect(Collectors.toMap(e -> e.getLong("subinvoiceid"), e -> e.getString("invoiceno"), (m, n) -> m));
    }

    public FormShowParameter getSignFormShowParameter(Map<Long, Long> invoiceidMap, DynamicObject jzjtproduct) {
        logger.info("===OuputInvoiceJzjtSignListService:getSignFormShowParameter===starttime:" + System.currentTimeMillis());
        if (ObjectUtils.isEmpty(invoiceidMap)) {
            return null;
        }
        Map<Long, String> signedMap = this.getSignedMap(new ArrayList<Long>(invoiceidMap.keySet()));
        int allCount = (int)invoiceidMap.values().stream().distinct().count();
        invoiceidMap.keySet().removeIf(e -> signedMap.containsKey(e));
        Long jzjtProductId = ObjectUtils.isEmpty((Object)jzjtproduct) ? 0L : jzjtproduct.getLong("id");
        this.saveSign(this.getInvoiceAllItemMap(new ArrayList<Long>(invoiceidMap.values())), jzjtProductId);
        FormShowParameter formShowParameter = null;
        if (signedMap.size() > 0) {
            List<String> invoicenoList = signedMap.values().stream().distinct().collect(Collectors.toList());
            int failCount = invoicenoList.size();
            formShowParameter = this.generateMessage(SIGN, allCount - failCount, failCount, invoicenoList);
        }
        logger.info("===OuputInvoiceJzjtSignListService:getSignFormShowParameter===endtime:" + System.currentTimeMillis());
        return formShowParameter;
    }

    public void saveSign(Map<Long, Long> signMap, Long jzjtproduct) {
        QFilter qFilter = new QFilter("subinvoiceid", "in", signMap.keySet());
        DynamicObject[] existsSigned = BusinessDataServiceHelper.load((String)TCVAT_OUTPUT_INVOICE_SIGN, (String)"subinvoiceid,maininvoiceid,invoiceno,jzjtsign,signedtax,signtime,jzjtproduct,operator", (QFilter[])new QFilter[]{qFilter});
        Map<Long, DynamicObject> existsSignedMap = Arrays.stream(existsSigned).collect(Collectors.toMap(k -> k.getLong("subinvoiceid"), v -> v, (m, n) -> m));
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>();
        DynamicObjectCollection collection = QueryServiceHelper.query((String)SIM_VATINVOICE, (String)"id, invoiceno, items, items.id, items.tax", (QFilter[])new QFilter[]{new QFilter("items.id", "in", signMap.keySet())});
        for (DynamicObject dynamicObject : collection) {
            DynamicObject result = null;
            result = existsSignedMap.containsKey(dynamicObject.getLong("items.id")) ? existsSignedMap.get(dynamicObject.getLong("items.id")) : BusinessDataServiceHelper.newDynamicObject((String)TCVAT_OUTPUT_INVOICE_SIGN);
            result.set("subinvoiceid", dynamicObject.get("items.id"));
            result.set("maininvoiceid", dynamicObject.get("id"));
            result.set("invoiceno", dynamicObject.get("invoiceno"));
            result.set("jzjtsign", (Object)"1");
            result.set("signedtax", dynamicObject.get("items.tax"));
            result.set("signtime", (Object)new Date());
            result.set("jzjtproduct", (Object)jzjtproduct);
            result.set("operator", (Object)RequestContext.get().getCurrUserId());
            resultList.add(result);
        }
        ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(resultList));
    }

    public FormShowParameter getUndosignFormShowParameter(Map<Long, Long> invoiceidMap) {
        logger.info("===OuputInvoiceJzjtSignListService:getUndosignFormShowParameter===starttime:" + System.currentTimeMillis());
        if (ObjectUtils.isEmpty(invoiceidMap)) {
            return null;
        }
        Map<Long, String> signedMap = this.getSignedMap(new ArrayList<Long>(invoiceidMap.keySet()));
        List<Long> maininvoiceidList = invoiceidMap.values().stream().distinct().collect(Collectors.toList());
        int allCount = maininvoiceidList.size();
        invoiceidMap.keySet().removeIf(e -> signedMap.containsKey(e));
        this.saveUndo(maininvoiceidList);
        FormShowParameter formShowParameter = null;
        if (invoiceidMap.size() > 0) {
            int failCount = (int)invoiceidMap.values().stream().distinct().count();
            DynamicObjectCollection unsignedCollection = QueryServiceHelper.query((String)SIM_VATINVOICE, (String)"invoiceno", (QFilter[])new QFilter[]{new QFilter("items.id", "in", invoiceidMap.keySet())});
            List<String> unsignednoList = unsignedCollection.stream().map(e -> e.getString("invoiceno")).distinct().collect(Collectors.toList());
            formShowParameter = this.generateMessage(UNDOSIGN, allCount - failCount, failCount, unsignednoList);
        }
        logger.info("===OuputInvoiceJzjtSignListService:getUndosignFormShowParameter===endtime:" + System.currentTimeMillis());
        return formShowParameter;
    }

    private void saveUndo(List<Long> undoList) {
        DynamicObject[] existsSigned = BusinessDataServiceHelper.load((String)TCVAT_OUTPUT_INVOICE_SIGN, (String)"jzjtsign", (QFilter[])new QFilter[]{new QFilter("maininvoiceid", "in", undoList)});
        Arrays.stream(existsSigned).forEach(e -> e.set("jzjtsign", (Object)" "));
        ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(Arrays.asList(existsSigned)));
    }

    public FormShowParameter getAutosignFormShowParameter(Long org, Date startdate, Date enddate) {
        logger.info("===OuputInvoiceJzjtSignListService:getAutosignFormShowParameter===starttime:" + System.currentTimeMillis());
        if (ObjectUtils.anyNull((Object[])new Object[]{org, startdate, enddate})) {
            return null;
        }
        HashSet<Long> allMainInvoiceIdSet = new HashSet<Long>();
        HashSet<String> failInvoicenoSet = new HashSet<String>();
        Map<Long, List<DynamicObject>> resultMap = this.getAutoSignMap(org, startdate, enddate);
        HashMap<Long, Long> doneMap = new HashMap<Long, Long>();
        for (Map.Entry<Long, List<DynamicObject>> entry : resultMap.entrySet()) {
            Map<Long, Long> invoiceidMap = entry.getValue().stream().collect(Collectors.toMap(k -> k.getLong("items.id"), v -> v.getLong("id"), (m, n) -> m));
            invoiceidMap.keySet().removeIf(e -> doneMap.containsKey(e));
            Map<Long, String> signedMap = this.getSignedMap(new ArrayList<Long>(invoiceidMap.keySet()));
            allMainInvoiceIdSet.addAll(invoiceidMap.values());
            failInvoicenoSet.addAll(signedMap.values());
            invoiceidMap.keySet().removeIf(e -> signedMap.containsKey(e));
            this.saveSign(invoiceidMap, entry.getKey());
            doneMap.putAll(invoiceidMap);
        }
        FormShowParameter formShowParameter = null;
        if (!failInvoicenoSet.isEmpty()) {
            int allCount = allMainInvoiceIdSet.size();
            int failCount = failInvoicenoSet.size();
            formShowParameter = this.generateMessage(SIGN, allCount - failCount, failCount, new ArrayList<String>(failInvoicenoSet));
        }
        logger.info("===OuputInvoiceJzjtSignListService:getAutosignFormShowParameter===endtime:" + System.currentTimeMillis());
        return formShowParameter;
    }

    public Map<Long, List<DynamicObject>> getAutoSignMap(Long org, Date startdate, Date enddate) {
        Map orgRules = RuleUtils.getJxdkOrgRules((RuleTypeEnum)RuleTypeEnum.XXXM, (Long)org, (Boolean)Boolean.FALSE);
        List rules = (List)orgRules.get(RuleTypeEnum.XXXM);
        HashMap<Long, List<DynamicObject>> ruleJzjtProductAndInvoiceMap = new HashMap<Long, List<DynamicObject>>();
        for (DynamicObject rule : rules) {
            DynamicObjectCollection settings = rule.getDynamicObjectCollection("entryentity");
            QFilter orgFilter = new QFilter("taxorg", "=", (Object)org);
            QFilter statusFilter = new QFilter("invoicestatus", "in", Arrays.asList("0", "3"));
            QFilter dateFilter = new QFilter("issuetime", ">=", (Object)startdate).and("issuetime", "<=", (Object)enddate);
            QFilter[] defaultFilter = new QFilter[]{orgFilter, statusFilter, dateFilter};
            RuleTask ruleTask = new RuleTask(org, startdate, enddate, rule, settings, "", defaultFilter);
            List Futures = ThreadPoolsService.getInstance().submitReturnFuture((Task)ruleTask);
            List<DynamicObject> futureList = this.getFutureList(Futures);
            Long jzjtproduct = ObjectUtils.isEmpty((Object)rule.getDynamicObject("jzjtcp")) ? 0L : rule.getDynamicObject("jzjtcp").getLong("id");
            if (!ruleJzjtProductAndInvoiceMap.containsKey(jzjtproduct)) {
                ruleJzjtProductAndInvoiceMap.put(jzjtproduct, new ArrayList());
            }
            List list = (List)ruleJzjtProductAndInvoiceMap.get(jzjtproduct);
            list.addAll(futureList);
        }
        Map<Long, Long> ruleInvoiceidMap = ruleJzjtProductAndInvoiceMap.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream()).collect(Collectors.toMap(k -> k.getLong("items.id"), v -> v.getLong("id"), (m, n) -> n));
        DynamicObjectCollection invoiceCollection = QueryServiceHelper.query((String)SIM_VATINVOICE, (String)"id, items.id", (QFilter[])new QFilter[]{new QFilter("id", "in", ruleInvoiceidMap.values())});
        Map<Long, Long> allInvoiceidMap = invoiceCollection.stream().collect(Collectors.toMap(k -> k.getLong("items.id"), v -> v.getLong("id"), (m, n) -> m));
        List remainInvoiceMainidList = allInvoiceidMap.entrySet().stream().filter(e -> !ruleInvoiceidMap.containsKey(e.getKey())).map(e -> (Long)e.getValue()).collect(Collectors.toList());
        ruleJzjtProductAndInvoiceMap.entrySet().stream().forEach(e -> {
            List value = (List)e.getValue();
            List collect = value.stream().filter(o -> remainInvoiceMainidList.contains(o.getLong("id"))).collect(Collectors.toList());
            value.removeAll(collect);
        });
        return ruleJzjtProductAndInvoiceMap;
    }

    private List<DynamicObject> getFutureList(List<Future<Object>> futures) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        try {
            for (Future<Object> future : futures) {
                list.addAll((Collection)future.get());
            }
        }
        catch (Exception e) {
            logger.error("RuleTask getFutureList error " + e);
        }
        return list;
    }

    public FormShowParameter generateMessage(String operation, int sucessCount, int failCount, List<String> signedInvoicenos) {
        StringBuilder title = new StringBuilder();
        title.append(ResManager.loadKDString((String)"\u6210\u529f", (String)"OuputInvoiceJzjtSignListService_0", (String)"taxc-tcvat", (Object[])new Object[0])).append(sucessCount).append(ResManager.loadKDString((String)"\u6761\uff0c\u5931\u8d25", (String)"OuputInvoiceJzjtSignListService_1", (String)"taxc-tcvat", (Object[])new Object[0])).append(failCount).append(ResManager.loadKDString((String)"\u6761", (String)"OuputInvoiceJzjtSignListService_2", (String)"taxc-tcvat", (Object[])new Object[0]));
        StringBuilder errorMsg = new StringBuilder();
        if (SIGN.equals(operation)) {
            errorMsg.append(ResManager.loadKDString((String)"\u53ea\u6709\u672a\u6807\u8bc6\u7684\u6570\u636e\u624d\u80fd\u6807\u8bc6\uff0c\u53d1\u7968\u53f7\u7801", (String)"OuputInvoiceJzjtSignListService_3", (String)"taxc-tcvat", (Object[])new Object[0])).append(SEPARATOR);
            signedInvoicenos.stream().forEach(e -> errorMsg.append((String)e).append(SEPARATOR));
            errorMsg.append(ResManager.loadKDString((String)"\u5df2\u6807\u8bc6\uff0c\u64cd\u4f5c\u5931\u8d25", (String)"OuputInvoiceJzjtSignListService_4", (String)"taxc-tcvat", (Object[])new Object[0]));
        } else {
            errorMsg.append(ResManager.loadKDString((String)"\u53ea\u6709\u4e3a\u5df2\u6807\u8bc6\u7684\u6570\u636e\u624d\u80fd\u53d6\u6d88\u6807\u8bc6\uff0c\u53d1\u7968\u53f7\u7801", (String)"OuputInvoiceJzjtSignListService_5", (String)"taxc-tcvat", (Object[])new Object[0])).append(SEPARATOR);
            signedInvoicenos.stream().forEach(e -> errorMsg.append((String)e).append(SEPARATOR));
            errorMsg.append(ResManager.loadKDString((String)"\u672a\u6807\u8bc6\uff0c\u64cd\u4f5c\u5931\u8d25", (String)"OuputInvoiceJzjtSignListService_6", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("bos_operationresult");
        parameters.setShowTitle(true);
        parameters.setCaption(ResManager.loadKDString((String)"\u63d0\u793a\u4fe1\u606f", (String)"OuputInvoiceJzjtSignListService_7", (String)"taxc-tcvat", (Object[])new Object[0]));
        parameters.setCustomParam("operateName", (Object)"");
        parameters.setCustomParam("title", (Object)title.toString());
        parameters.setCustomParam("errorMsg", (Object)errorMsg.toString());
        return parameters;
    }

    public Map<Long, Long> getInvoiceAllItemMap(List maininvoiceidList) {
        DynamicObjectCollection result = QueryServiceHelper.query((String)SIM_VATINVOICE, (String)"id,items.id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)maininvoiceidList)});
        return result.stream().collect(Collectors.toMap(k -> k.getLong("items.id"), v -> v.getLong("id")));
    }
}

