/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.jzjt;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.collections4.CollectionUtils;

public class JzjtService {
    private static final String JZJT_FILING_ENTITY = "tcvat_jzjt_filing";
    public static final String TSJS_DRAFT_ENTITY = "tcvat_tsjs_draft_query";
    public static final String TSJS_TSSQB_ENTITY = "tcvat_tssqb_query";
    private static final String SEPARATOR = System.getProperty("line.separator");

    public DynamicObject loadSingleTsjsDraft(Object pkid) {
        return BusinessDataServiceHelper.loadSingle((Object)pkid, (String)TSJS_DRAFT_ENTITY);
    }

    public DynamicObject[] loadTsjsDraft(Object[] pkid) {
        return BusinessDataServiceHelper.load((Object[])pkid, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TSJS_DRAFT_ENTITY));
    }

    public DynamicObject[] loadTsjsDraftByTssqbIds(List<Object> tssqbIds) {
        DynamicObjectCollection ids = QueryServiceHelper.query((String)TSJS_DRAFT_ENTITY, (String)"id", (QFilter[])new QFilter[]{new QFilter("entryentity.tssqb", "in", tssqbIds)});
        return BusinessDataServiceHelper.load((Object[])ids.stream().map(o -> o.get("id")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TSJS_DRAFT_ENTITY));
    }

    public DynamicObject loadSingleTssqb(Object pkid) {
        return BusinessDataServiceHelper.loadSingle((Object)pkid, (String)TSJS_TSSQB_ENTITY);
    }

    public DynamicObject loadSingleTssqbByTsjsDraftId(Object pkid) {
        Long sqbId = this.queryTssqbIdByTsjsDraftId(pkid);
        if (sqbId != null && QueryServiceHelper.exists((String)TSJS_TSSQB_ENTITY, (Object)pkid)) {
            return BusinessDataServiceHelper.loadSingle((Object)sqbId, (String)TSJS_TSSQB_ENTITY);
        }
        return null;
    }

    public Long queryTssqbIdByTsjsDraftId(Object draftId) {
        DynamicObject object = QueryServiceHelper.queryOne((String)TSJS_DRAFT_ENTITY, (String)"entryentity.tssqb", (QFilter[])new QFilter[]{new QFilter("id", "=", draftId)});
        if (object != null) {
            return object.getLong("entryentity.tssqb");
        }
        return 0L;
    }

    public List<ComboItem> buildOrgComboItems(List<ComboItem> comboItems, List<DynamicObject> taxpayers, Set<Long> orgIdSet) {
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(comboItems.size());
        int j = 0;
        HashSet<String> containsOrgIds = new HashSet<String>();
        block0: for (ComboItem comboItem : comboItems) {
            String containsOrg = comboItem.getValue();
            if (orgIdSet.contains(Long.valueOf(containsOrg)) && containsOrgIds.add(containsOrg)) {
                comboItemList.add(comboItem);
                continue;
            }
            while (j < taxpayers.size()) {
                DynamicObject taxpayer = taxpayers.get(j);
                String orgid = taxpayer.getString("orgid.id");
                if (containsOrgIds.add(orgid)) {
                    comboItem = new ComboItem(new LocaleString(taxpayer.getString("orgid.name")), orgid);
                    comboItemList.add(comboItem);
                    continue block0;
                }
                ++j;
            }
        }
        return comboItemList;
    }

    public DynamicObject[] loadTssqb(Object[] pkid) {
        return BusinessDataServiceHelper.load((Object[])pkid, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TSJS_TSSQB_ENTITY));
    }

    public List<Long> queryTssqbIdsByDraftIds(List<Long> draftIds) {
        return QueryServiceHelper.query((String)TSJS_TSSQB_ENTITY, (String)"id", (QFilter[])new QFilter[]{new QFilter("jzjtdraft.fbasedataid.id", "in", draftIds)}).stream().map(o -> o.getLong("id")).collect(Collectors.toList());
    }

    public List<Long> queryYbnsrJzjtFilingTaxMainOrgIdsWithPerm(long userId, String appid, String entityid) {
        List<Long> orgList = this.queryYbnsrOrgIdsWithPerm(userId, appid, entityid).stream().map(o -> o.getLong("orgid.id")).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(orgList)) {
            return this.queryJzjtFilingOrgId(orgList);
        }
        return Collections.emptyList();
    }

    public List<Long> queryDraftIdSqbShow(Long orgId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        qFilters.add(new QFilter("org", "=", (Object)orgId));
        qFilters.add(new QFilter("billstatus", "=", (Object)"C"));
        qFilters.add(new QFilter("entryentity.jzjtytsje", ">", (Object)BigDecimal.ZERO));
        qFilters.add(QFilter.isNull((String)"entryentity.tssqb").or(new QFilter("entryentity.tssqb", "=", (Object)0)));
        qFilters.add(QFilter.isNotNull((String)"jzjttype.id"));
        DynamicObjectCollection drafts = QueryServiceHelper.query((String)TSJS_DRAFT_ENTITY, (String)"id,entryentity.sbbid as sbbid", (QFilter[])qFilters.toArray(new QFilter[0]));
        HashMap<Long, Long> draftIdMap = new HashMap<Long, Long>(drafts.size());
        ArrayList<Long> draftIds = new ArrayList<Long>(drafts.size());
        if (CollectionUtils.isNotEmpty((Collection)drafts)) {
            List<Long> sbbids = drafts.stream().peek(o -> draftIdMap.put(o.getLong("sbbid"), o.getLong("id"))).map(o -> o.getLong("sbbid")).collect(Collectors.toList());
            Set<Long> idSet = this.queryPaidSbbIdsBySbbIds(sbbids);
            draftIdMap.forEach((k, v) -> {
                if (idSet.contains(k)) {
                    draftIds.add((Long)v);
                }
            });
        }
        return draftIds;
    }

    public Set<Long> queryPaidSbbIdsBySbbIds(List<Long> sbbids) {
        DynamicObjectCollection sbbs = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", sbbids), new QFilter("paystatus", "=", (Object)"paid")});
        return sbbs.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
    }

    public DynamicObject queryOneTsjsDraftBySbbId(Long sbbId) {
        return QueryServiceHelper.queryOne((String)TSJS_DRAFT_ENTITY, (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("entryentity.sbbid", "=", (Object)sbbId)});
    }

    public List<Long> queryJzjtFilingOrgId(List<Long> orgIds) {
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"C");
        DynamicObjectCollection object = QueryServiceHelper.query((String)JZJT_FILING_ENTITY, (String)"org.id as orgId", (QFilter[])new QFilter[]{orgFilter, billStatusFilter});
        return object.stream().map(o -> o.getLong("orgId")).distinct().collect(Collectors.toList());
    }

    public List<DynamicObject> queryYbnsrOrgIdsWithPerm(long userId, String appid, String entityid) {
        TaxResult result;
        List data;
        TaxResult taxResult = TaxcCombineDataServiceHelper.queryTaxcMainOrgIdByIsTaxpayerWithPerm((Long)userId, (String)appid, (String)entityid, (String)"47150e89000000ac");
        if (taxResult.isSuccess() && CollectionUtils.isNotEmpty((Collection)(data = (List)taxResult.getData())) && (result = TaxcMainDataServiceHelper.queryTaxcMainZzsByOrgId((List)data)).isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)result.getData()))) {
            return ((List)result.getData()).stream().filter(taxMain -> {
                DynamicObjectCollection categoryentryentity = taxMain.getDynamicObjectCollection("categoryentryentity");
                return CollectionUtils.isNotEmpty((Collection)categoryentryentity) && "ybnsr".equals(((DynamicObject)categoryentryentity.get(0)).getString("taxpayertype")) && "1".equals(((DynamicObject)categoryentryentity.get(0)).getString("enable"));
            }).distinct().collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public DynamicObjectCollection queryJzjtType() {
        QFilter bizQfilter = new QFilter("bizdef.number", "=", (Object)"jmxmmc_jzjt");
        QFilter statsFilter = new QFilter("status", "=", (Object)Boolean.TRUE);
        return QueryServiceHelper.query((String)"tpo_tcvat_bizdef_entity", (String)"id,value", (QFilter[])new QFilter[]{bizQfilter, statsFilter});
    }

    public void updateTssqbBljdbs(Long id, String bljdbs) {
        DynamicObject object;
        DynamicObjectCollection entryentity;
        boolean exists = QueryServiceHelper.exists((String)TSJS_TSSQB_ENTITY, (Object)id);
        if (exists && CollectionUtils.isNotEmpty((Collection)(entryentity = (object = BusinessDataServiceHelper.loadSingle((Object)id, (String)TSJS_TSSQB_ENTITY)).getDynamicObjectCollection("entryentity")))) {
            ((DynamicObject)entryentity.get(0)).set("bljd", (Object)bljdbs);
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{object});
        }
    }

    public Map<String, Object> buildMultiSbbCustomParams(DynamicObject object, BiConsumer<DynamicObject, Map<String, Object>> consumer) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(4);
        if (object != null) {
            customParams.put("entryid", object.getString("id"));
            customParams.put("billno", object.getString("billno"));
            customParams.put("orgid", object.getDynamicObject("org").getString("id"));
            Date skssqq = object.getDate("skssqq");
            Date skssqz = object.getDate("skssqz");
            String startDate = DateUtils.format((Date)skssqq, (String)"yyyy-MM-dd");
            customParams.put("skssqq", startDate);
            customParams.put("skssqz", DateUtils.format((Date)skssqz, (String)"yyyy-MM-dd"));
            customParams.put("readonly", Boolean.TRUE);
            customParams.put("from", "history");
            customParams.put("modifytime", object.getDate("modifytime"));
            consumer.accept(object, customParams);
        }
        return customParams;
    }

    public StringBuilder checkBeforeCreateSqb(DynamicObject[] drafts, ListSelectedRowCollection selectedRows) {
        ArrayList<Long> sbbIds = new ArrayList<Long>(drafts.length);
        Map<Object, DynamicObject> draftmap = Stream.of(drafts).peek(o -> {
            DynamicObjectCollection entryentity = o.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isNotEmpty((Collection)entryentity)) {
                sbbIds.add(((DynamicObject)entryentity.get(0)).getLong("sbbid"));
            }
        }).collect(Collectors.toMap(o -> o.get("id"), o -> o));
        Set<Long> paidSbbIds = this.queryPaidSbbIdsBySbbIds(sbbIds);
        Long orgId = null;
        StringBuilder message = new StringBuilder();
        for (ListSelectedRow selectedRow : selectedRows) {
            DynamicObject draft = draftmap.get(selectedRow.getPrimaryKeyValue());
            if (draft == null) continue;
            if (orgId == null) {
                orgId = draft.getLong("org.id");
            } else if (orgId.longValue() != draft.getLong("org.id")) {
                message.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u540c\u4e00\u7a0e\u52a1\u7ec4\u7ec7\u7684\u9000\u7a0e\u8ba1\u7b97\u5e95\u7a3f", (String)"JzjtService_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                return message;
            }
            if (!"C".equals(draft.getString("billstatus"))) {
                message.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u53ea\u6709\u5df2\u5ba1\u6838\u7684\u5355\u636e\u624d\u80fd\u751f\u6210\u9000\u7a0e\u7533\u8bf7\u8868\u3002", (String)"JzjtService_1", (String)"taxc-tcvat", (Object[])new Object[0]), selectedRow.getRowKey() + 1)).append(SEPARATOR);
                continue;
            }
            if (CollectionUtils.isEmpty((Collection)draft.getDynamicObjectCollection("jzjttype"))) {
                message.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u751f\u6210\u5931\u8d25\u3002\u9009\u4e2d\u884c\u7684\u5373\u5f81\u5373\u9000\u7c7b\u578b\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u751f\u6210\u5373\u5f81\u5373\u9000\u9000\u7a0e\u7533\u8bf7\u8868", (String)"JzjtService_7", (String)"taxc-tcvat", (Object[])new Object[0]), selectedRow.getRowKey() + 1)).append(SEPARATOR);
                continue;
            }
            DynamicObjectCollection entryentity = draft.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)entryentity) || BigDecimal.ZERO.compareTo(((DynamicObject)entryentity.get(0)).getBigDecimal("jzjtytsje")) >= 0) {
                message.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5373\u5f81\u5373\u9000\u5e94\u9000\u7a0e\u91d1\u989d\u5c0f\u4e8e\u7b49\u4e8e0\uff0c\u65e0\u9700\u751f\u6210\u9000\u7a0e\u7533\u8bf7\u3002", (String)"JzjtService_2", (String)"taxc-tcvat", (Object[])new Object[0]), selectedRow.getRowKey() + 1)).append(SEPARATOR);
                continue;
            }
            if (((DynamicObject)entryentity.get(0)).getLong("tssqb.id") > 0L) {
                message.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5e95\u7a3f\u5df2\u751f\u6210\u9000\u7a0e\u7533\u8bf7\u8868\uff0c\u65e0\u9700\u518d\u6b21\u751f\u6210\u3002", (String)"JzjtService_3", (String)"taxc-tcvat", (Object[])new Object[0]), selectedRow.getRowKey() + 1)).append(SEPARATOR);
                continue;
            }
            if (paidSbbIds.contains(((DynamicObject)entryentity.get(0)).getLong("sbbid"))) continue;
            message.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5e95\u7a3f\u5bf9\u5e94\u7684\u589e\u503c\u7a0e\u7533\u62a5\u8868\u672a\u5168\u90e8\u7f34\u6b3e\uff0c\u8bf7\u5148\u7f34\u6b3e\u540e\u518d\u751f\u6210\u9000\u7a0e\u7533\u8bf7\u8868\u3002", (String)"JzjtService_4", (String)"taxc-tcvat", (Object[])new Object[0]), selectedRow.getRowKey() + 1)).append(SEPARATOR);
        }
        return message;
    }

    public Long getTaxoffice(long orgid) {
        TaxResult listTaxResult = TaxcMainDataServiceHelper.queryTaxOfficeIdByOrgId(Collections.singletonList(orgid));
        if (listTaxResult.isSuccess() && ((List)listTaxResult.getData()).size() > 0) {
            return (Long)((List)listTaxResult.getData()).get(0);
        }
        return 0L;
    }

    public Map<String, BigDecimal> getTsjsDraftOrgSkssqqSkssqzMap(ExtendedDataEntity[] dataEntities) {
        List billno = Arrays.stream(dataEntities).filter(d -> !"ybj".equals(((DynamicObject)d.getDataEntity().getDynamicObjectCollection("entryentity").get(0)).getString("bljd"))).map(d -> d.getDataEntity().getString("billno")).collect(Collectors.toList());
        DynamicObjectCollection tsjsDraftCollection = QueryServiceHelper.query((String)TSJS_DRAFT_ENTITY, (String)"org,skssqq,skssqz,entryentity.jzjtytsje", (QFilter[])new QFilter[]{new QFilter("entryentity.tssqb.billno", "in", billno)});
        return tsjsDraftCollection.stream().collect(Collectors.toMap(k -> k.getString("org") + k.getString("skssqq").substring(0, 10) + k.getString("skssqz").substring(0, 10), v -> v.getBigDecimal("entryentity.jzjtytsje"), (k1, k2) -> k2));
    }

    public Map<String, List<DynamicObject>> getOriginalTaxStatusMap(ExtendedDataEntity[] dataEntities) {
        Object[] ids = Stream.of(dataEntities).filter(d -> !"ybj".equals(((DynamicObject)d.getDataEntity().getDynamicObjectCollection("entryentity").get(0)).getString("bljd"))).map(o -> o.getDataEntity().getLong("id")).toArray();
        DynamicObjectCollection tssqbDetailCollection = QueryServiceHelper.query((String)"tpo_declare_detail_tsd", (String)"entryid,value", (QFilter[])new QFilter[]{new QFilter("entryid", "in", (Object)ids), new QFilter("cellnumber", "in", Arrays.asList("tssqb_ywsqk1#tssqb_sksssq", "tssqb_ywsqk2#tssqb_sksssq", "tssqb_ywsqk3#tssqb_sksssq", "tssqb_ywsqk4#tssqb_sksssq", "tssqb_ywsqk5#tssqb_sksssq"))});
        return tssqbDetailCollection.stream().collect(Collectors.groupingBy(t -> t.getString("entryid")));
    }

    public Map<String, Object> buildTaxRefundInfo(Map<String, BigDecimal> orgSkssqqSkssqzMap, DynamicObject dataEntity, String startDate, String endDate) {
        HashMap<String, Object> taxRefundInfoMap = new HashMap<String, Object>();
        taxRefundInfoMap.put("org", dataEntity.getDynamicObject("org").getLong("id"));
        taxRefundInfoMap.put("startdate", DateUtils.stringToDate((String)startDate));
        taxRefundInfoMap.put("enddate", DateUtils.stringToDate((String)endDate));
        taxRefundInfoMap.put("applicationdate", new Date());
        taxRefundInfoMap.put("taxoffice", this.getTaxoffice(dataEntity.getDynamicObject("org").getLong("id")));
        taxRefundInfoMap.put("declaretype", dataEntity.getDynamicObject("templatetype").getString("number"));
        taxRefundInfoMap.put("declarenum", dataEntity.getString("billno"));
        taxRefundInfoMap.put("creator", RequestContext.get().getCurrUserId());
        taxRefundInfoMap.put("refundableamount", orgSkssqqSkssqzMap.get(dataEntity.getDynamicObject("org").getString("id") + startDate + endDate));
        taxRefundInfoMap.put("taxcategory", 1L);
        taxRefundInfoMap.put("currency", 1L);
        return taxRefundInfoMap;
    }

    public Map<Object, Object> getResultMessage(Map<String, Object> result, String operateKey) {
        HashMap<Object, Object> resultMap = new HashMap<Object, Object>();
        if (result.size() == 0) {
            return resultMap;
        }
        boolean success = (Boolean)result.get("success");
        if (!success) {
            List data = (List)result.get("data");
            for (Map datum : data) {
                if ("unapply".equals(operateKey) || "apply".equals(operateKey) || "unaudit".equals(operateKey)) {
                    resultMap.put(datum.get("failnum"), String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u7533\u8bf7\u8868\u7f16\u53f7\uff1a%s \u7684\u4e0b\u6e38\u9000\u7a0e\u4fe1\u606f\u4e3a\u672a\u9000\u7a0e\u6216\u672a\u751f\u6210\u51ed\u8bc1\u65f6\u624d\u80fd\u64cd\u4f5c", (String)"JzjtService_5", (String)"taxc-tcvat", (Object[])new Object[0]), datum.get("failnum")));
                    continue;
                }
                resultMap.put(datum.get("failnum"), datum.get("errormsg"));
            }
        }
        return resultMap;
    }

    public boolean checkData(DynamicObject taxStautsObj) {
        return StringUtil.isBlank((CharSequence)taxStautsObj.getString("value")) || !Pattern.compile(ResManager.loadKDString((String)"\\d{4}[\u5e74]\\d{1,2}[\u6708]\\d{1,2}[\u65e5][-]\\d{4}[\u5e74]\\d{1,2}[\u6708]\\d{1,2}[\u65e5]", (String)"JzjtService_8", (String)"taxc-tcvat", (Object[])new Object[0])).matcher(taxStautsObj.getString("value")).matches();
    }

    public List<Long> getTssqbId(DynamicObjectCollection jzjtdraft) {
        if (CollectionUtils.isNotEmpty((Collection)jzjtdraft)) {
            List<Long> draftIds = jzjtdraft.stream().map(o -> o.getLong("fbasedataid.id")).collect(Collectors.toList());
            List<Long> tssqbIds = this.queryTssqbIdsByDraftIds(draftIds);
            return tssqbIds;
        }
        return new ArrayList<Long>();
    }
}

