/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.ncp;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorgan.TaxcOrganDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.dao.ncp.NcpkcStandardDao;
import kd.taxc.tcvat.common.dto.ncp.NcpkcStandardDto;
import org.apache.commons.lang3.ObjectUtils;

public class NcpkcStandardService {
    private NcpkcStandardDao ncpkcStandardDao = new NcpkcStandardDao();

    public String checkSave(NcpkcStandardDto dto) {
        Long orgId = (Long)dto.getOrgId();
        Long taxofficeId = dto.getTaxoffice();
        String ncphdkcff = dto.getNcphdkcff();
        Long cpmcId = dto.getCpmc();
        Long hyncpmcId = dto.getHyncpmc();
        Long unitId = dto.getUnit();
        Date startDate = (Date)dto.getStartDate();
        Date endDate = (Date)dto.getEndDate();
        Long pkValue = dto.getPkValue();
        if (ObjectUtils.anyNull((Object[])new Object[]{orgId, taxofficeId, ncphdkcff, cpmcId, hyncpmcId, unitId, startDate})) {
            return null;
        }
        String errMsg = this.checkDate(startDate, endDate);
        if (StringUtils.isNotBlank((CharSequence)errMsg)) {
            return errMsg;
        }
        errMsg = this.checkTaxOfficeIsLevelOne(taxofficeId);
        if (StringUtils.isNotBlank((CharSequence)errMsg)) {
            return errMsg;
        }
        QFilter orgFilter = new QFilter("useorg", "=", (Object)orgId);
        QFilter taxofficeFilter = new QFilter("taxoffice", "=", (Object)taxofficeId);
        QFilter ncphdkcffFilter = new QFilter("ncphdkcff", "=", (Object)ncphdkcff);
        QFilter cpmcFilter = new QFilter("cpmc", "=", (Object)cpmcId);
        QFilter hyncpmcFilter = new QFilter("hyncpmc", "=", (Object)hyncpmcId);
        QFilter idFilter = new QFilter("id", "!=", (Object)pkValue);
        DynamicObject object = this.ncpkcStandardDao.queryOneNcpkcStandardData(new QFilter[]{orgFilter, taxofficeFilter, ncphdkcffFilter, cpmcFilter, hyncpmcFilter, idFilter});
        if (object != null) {
            Date enddate = object.getDate("enddate");
            Date startdate = object.getDate("startdate");
            if (!DateUtils.checkTimeRepeat((Date)startdate, (Date)enddate, (Date)startDate, (Date)endDate)) {
                return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6263\u9664\u6807\u51c6\u4e0e\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u6263\u9664\u6807\u51c6\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"NcpkcStandardService_0", (String)"taxc-tcvat", (Object[])new Object[0]), object.getString("number"));
            }
            long unitid = object.getLong("unitId");
            if (unitid != unitId) {
                return String.format(ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d\u4e0e \u201c%s\u201d\u6263\u9664\u6807\u51c6\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"NcpkcStandardService_1", (String)"taxc-tcvat", (Object[])new Object[0]), object.getString("number"));
            }
        } else {
            object = this.ncpkcStandardDao.queryOneNcpkcStandardData(new QFilter[]{hyncpmcFilter, new QFilter("unit", "!=", (Object)unitId), idFilter});
            if (object != null) {
                return String.format(ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d\u4e0e \u201c%s\u201d\u6263\u9664\u6807\u51c6\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"NcpkcStandardService_1", (String)"taxc-tcvat", (Object[])new Object[0]), object.getString("number"));
            }
        }
        return null;
    }

    public String checkDate(Date startDate, Date endDate) {
        if (endDate != null && startDate != null && endDate.before(startDate)) {
            return ResManager.loadKDString((String)"\u6709\u6548\u671f\u6b62\u65e5\u671f\u5c0f\u4e8e\u6709\u6548\u671f\u8d77\u65e5\u671f\uff0c\u8bf7\u4fee\u6539", (String)"NcpkcStandardService_2", (String)"taxc-tcvat", (Object[])new Object[0]);
        }
        return null;
    }

    public String checkTaxOfficeIsLevelOne(Long taxOfficeId) {
        TaxResult listTaxResult = TaxcOrganDataServiceHelper.queryFirstLevelTaxcOrganIds();
        List data = (List)listTaxResult.getData();
        if (data != null && !data.contains(taxOfficeId)) {
            return ResManager.loadKDString((String)"\u7a0e\u52a1\u673a\u5173\u7ef4\u62a4\u9519\u8bef\uff0c\u8bf7\u7ef4\u62a4\u4e00\u7ea7\u7a0e\u52a1\u673a\u5173\u3002", (String)"NcpkcStandardService_3", (String)"taxc-tcvat", (Object[])new Object[0]);
        }
        return null;
    }

    public boolean existsProductName(List<QFilter> qFilterList) {
        return this.ncpkcStandardDao.existsProductName(qFilterList.toArray(new QFilter[0]));
    }

    public boolean existsHyncpName(List<QFilter> qFilterList) {
        return this.ncpkcStandardDao.existsHyncpName(qFilterList.toArray(new QFilter[0]));
    }

    public DynamicObject queryNcpkcStandardDataByCpmcIdAndDate(Long orgId, Long cpmcId, Date now) {
        if (cpmcId == null) {
            return null;
        }
        QFilter orgFilter = new QFilter("useorg", "=", (Object)orgId);
        QFilter dateFilter = new QFilter("startdate", "<=", (Object)now).and(new QFilter("enddate", "is null", null).or("enddate", ">=", (Object)now));
        QFilter cpmcFilter = new QFilter("cpmc", "=", (Object)cpmcId);
        return this.ncpkcStandardDao.queryOneNcpkcStandardData(new QFilter[]{orgFilter, cpmcFilter, dateFilter});
    }

    public DynamicObject queryNcpkcStandardDataByNyncpIdAndDate(Long orgId, Long hyncpId, Date now) {
        if (hyncpId == null) {
            return null;
        }
        QFilter orgFilter = new QFilter("useorg", "=", (Object)orgId);
        QFilter dateFilter = new QFilter("startdate", "<=", (Object)now).and(new QFilter("enddate", "is null", null).or("enddate", ">=", (Object)now));
        QFilter cpmcFilter = new QFilter("hyncpmc", "=", (Object)hyncpId);
        return this.ncpkcStandardDao.queryOneNcpkcStandardData(new QFilter[]{orgFilter, cpmcFilter, dateFilter});
    }
}

