/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.onekeygenerate.engine.ybhz;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.onekeygenerate.IEngine;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineTask;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.engine.impl.hzsb.ybhz.YbhzAddDeductionEngine;
import kd.taxc.tcvat.common.enums.DraftEngineEnum;

public class YbhzAccountingEngine
implements IEngine<TcvatEngineModel> {
    private static Log logger = LogFactory.getLog(YbhzAccountingEngine.class);

    public void deleteData(TcvatEngineModel model) {
        DraftEngineEnum.YBHZ.deleteIncome(model);
        DraftEngineEnum.YBHZ.deleteDiff(model);
        DraftEngineEnum.YBHZ.deleteRollOut(model);
        DraftEngineEnum.YBHZ.deleteDeduction(model);
        DraftEngineEnum.YBHZ.deleteJzjtJxse(model);
        DraftEngineEnum.YBHZ.deleteTaxReduce(model);
        DraftEngineEnum.YBHZ.deleteAddDeduction(model);
        DraftEngineEnum.YBHZ.deleteDraftCellEditRecord(model);
        DraftEngineEnum.YBHZ.deleteWait(model);
    }

    public void runEngine(TcvatEngineModel model) {
        RequestContext context = RequestContext.getOrCreate();
        try {
            List<EngineTask<TcvatEngineModel, DynamicObject>[]> engineTaskList = TcvatEngineModel.getEngineList("zzsybnsr_ybhz");
            for (EngineTask<TcvatEngineModel, DynamicObject>[] tasks : engineTaskList) {
                for (EngineTask<TcvatEngineModel, DynamicObject> task : tasks) {
                    task.setCtx(context);
                    task.setEngineModel((EngineModel)model);
                    task.call();
                }
            }
        }
        catch (Exception e) {
            logger.error("VAT ybnsr accounting engine error!", (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("AccountingEngineError", "VAT ybnsr accounting engine error!"), new Object[0]);
        }
        YbhzAddDeductionEngine engine = new YbhzAddDeductionEngine();
        engine.execute(model);
    }
}

