/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.onekeygenerate.engine.ybhz;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.draft.DraftService;
import kd.taxc.bdtaxr.common.onekeygenerate.IEngine;
import kd.taxc.bdtaxr.common.taxdeclare.draft.org.OrgChangeRecordUtil;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.bdtaxr.common.util.TaxBaseDataUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.account.PolicyConfirmService;
import kd.taxc.tcvat.business.service.draft.PeriodService;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;

public class YbhzPolicyEngine
implements IEngine<TcvatEngineModel> {
    public void deleteData(TcvatEngineModel model) {
        QFilter q1 = new QFilter("orgid", "=", (Object)Long.parseLong(model.getOrgId()));
        QFilter q3 = new QFilter("taxplayeraptitude", "=", (Object)"zzsybnsr");
        QFilter qFilter1 = new QFilter("startdate", ">=", (Object)DateUtils.stringToDate((String)model.getStartDate()));
        QFilter qFilter2 = new QFilter("enddate", "<=", (Object)DateUtils.stringToDate((String)model.getEndDate()));
        QFilter qFilter3 = new QFilter("draftpurpose", "=", (Object)model.getDraftMetaDataDTO().getDraftPurpose());
        DeleteServiceHelper.delete((String)"tcvat_ybhz_policy_confirm", (QFilter[])new QFilter[]{q1, qFilter1, qFilter2, q3, qFilter3});
    }

    public void runEngine(TcvatEngineModel model) {
        DynamicObject declareTypeAndWay = QueryServiceHelper.queryOne((String)"tctb_org_group_latest", (String)"id, summaryorgtype, summaryway,prelevyrate,fixedratio, zfjgsefpfs, zjggdbl ", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(model.getCustom().get("planid").toString()))});
        this.initPolicyConfirm(model, DateUtils.stringToDate((String)model.getStartDate()), DateUtils.stringToDate((String)model.getEndDate()), model.getOrgId(), declareTypeAndWay);
    }

    public void initPolicyConfirm(TcvatEngineModel model, Date startDate, Date endDate, String orgid, DynamicObject declareTypeAndWay) {
        String draftPurpose = model.getDraftMetaDataDTO().getDraftPurpose();
        DynamicObject dynamicObject = OrgChangeRecordUtil.loadChangeRecord((String)orgid, (Date)startDate, (Date)endDate);
        if (null == dynamicObject) {
            return;
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctb_org_group_latest", (String)"orgrow.orgid as orgid,orgrow.levelname as levelname,orgrow.declaration as declaration,orgrow.issuesbb as issuesbb", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)declareTypeAndWay.getLong("id"))});
        Map<String, DynamicObject> orgDyoMap = collection.stream().collect(Collectors.toMap(k -> k.getString("orgid"), v -> v, (k1, k2) -> k1));
        List orgidList = collection.stream().map(c -> c.getLong("orgid")).distinct().collect(Collectors.toList());
        model.addCustom("orglist", orgidList);
        Map<String, String> declareMap = collection.stream().collect(Collectors.toMap(o -> o.getString("orgid"), o -> o.getString("levelname"), (k1, k2) -> k1));
        model.addCustom("declaremap", declareMap);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)Long.valueOf(orgid));
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"tcvat_ybhz_policy_confirm");
        DynamicObject policy = new DynamicObject((DynamicObjectType)entityType);
        int rowNo = 0;
        policy.set("startdate", (Object)startDate);
        policy.set("enddate", (Object)endDate);
        policy.set("orgid", (Object)orgid);
        policy.set("status", (Object)"1");
        policy.set("billstatus", (Object)"A");
        policy.set("declaretype", (Object)"2");
        policy.set("creator", (Object)RequestContext.get().getOrgId());
        policy.set("createtime", (Object)new Date());
        policy.set("hzqylx", (Object)declareTypeAndWay.getString("summaryorgtype"));
        policy.set("hzfs", (Object)declareTypeAndWay.getString("summaryway"));
        policy.set("prelevyrate", (Object)declareTypeAndWay.getString("prelevyrate"));
        policy.set("fixedratio", (Object)declareTypeAndWay.getString("fixedratio"));
        policy.set("assignplan", (Object)declareTypeAndWay.getString("zfjgsefpfs"));
        BigDecimal zjggdbl = declareTypeAndWay.getBigDecimal("zjggdbl");
        policy.set("zjggdbl", (Object)(zjggdbl == null ? new BigDecimal("0.2") : zjggdbl.divide(new BigDecimal("100"), 4, RoundingMode.HALF_UP)));
        DynamicObject category = TaxBaseDataUtils.queryCategoryByTaxtype((Long)Long.parseLong(orgid), (String)"zzs");
        if (category != null) {
            DynamicObject taxMain = (DynamicObject)category.getParent();
            policy.set("registertype", taxMain.get("registertype"));
            policy.set("codeandname", taxMain.get("codeandname"));
            policy.set("taxplayeraptitude", (Object)("zzs" + category.getString("taxpayertype")));
            policy.set("levytype", (Object)category.getString("levytype"));
            policy.set("deadline", (Object)TaxDeclareHelper.getDeadLine(draftPurpose, orgid, startDate, endDate));
        }
        policy.set("draftpurpose", (Object)draftPurpose);
        QFilter startFilter = new QFilter("startdate", "<", (Object)startDate);
        QFilter q3 = new QFilter("taxplayeraptitude", "=", (Object)"zzsybnsr");
        QFilter q5 = new QFilter("draftpurpose", "=", (Object)draftPurpose);
        DynamicObject[] prePolicyObjects = BusinessDataServiceHelper.load((String)"tcvat_ybhz_policy_confirm", (String)"deductionrate, entryentity.suborg, entryentity.ruleid, entryentity.belongsorg, hzentryentity.assignorg, hzentryentity.normalgoods, hzentryentity.jzjtgoods, hzentryentity.normaltax, hzentryentity.jzjttax", (QFilter[])new QFilter[]{orgFilter, startFilter, q3, q5}, (String)"startdate desc");
        DynamicObject prePolicyObject = null != prePolicyObjects && prePolicyObjects.length > 0 ? prePolicyObjects[0] : BusinessDataServiceHelper.newDynamicObject((String)"tcvat_ybhz_policy_confirm");
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Map<String, Date> map = PeriodService.preTaxPeriod(model.getOrgId(), skssqq);
        Date preStart = map.get("startDate");
        Date preEnd = map.get("endDate");
        QFilter preDateFilter = new QFilter("startdate", ">=", (Object)preStart).and(new QFilter("enddate", "<=", (Object)preEnd));
        String bqsfsyjzzc = PolicyConfirmService.queryBqsfsyjzzcDefaultValue(draftPurpose, "tcvat_ybhz_policy_confirm", Long.parseLong(model.getOrgId()), model.getStartDate(), model.getEndDate(), preDateFilter);
        policy.set("bqsfsyjzzc", (Object)bqsfsyjzzc);
        policy.set("deductionrate", (Object)(null != prePolicyObject.getString("deductionrate") ? prePolicyObject.getString("deductionrate") : ""));
        DynamicObjectCollection entryentity = policy.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection entryCollection = new DynamicObjectCollection();
        DynamicObjectCollection hzentryentity = policy.getDynamicObjectCollection("hzentryentity");
        DynamicObjectCollection hzentryCollection = new DynamicObjectCollection();
        QFilter qFilter = new QFilter("orgid", "in", orgidList);
        QFilter qFilter1 = new QFilter("startdate", ">=", (Object)startDate);
        QFilter qFilter2 = new QFilter("enddate", "<=", (Object)endDate);
        QFilter qFilter3 = new QFilter("draftpurpose", "=", (Object)draftPurpose);
        DeleteServiceHelper.delete((String)"tcvat_ybhz_policy_confirm", (QFilter[])new QFilter[]{qFilter, qFilter1, qFilter2, qFilter3});
        String rulePurpose = (String)model.getCustom().get("rulePurpose");
        int i = 0;
        for (Long suborgid : orgidList) {
            Map sharingAndOrgRules = RuleUtils.getSharingAndOrgRules((Long)suborgid, (RuleTypeEnum)RuleTypeEnum.INCOME, (String)"ybnsr", (String)rulePurpose);
            List incomeRuleList = RuleUtils.sortIncomeRules((List)((List)sharingAndOrgRules.get(RuleTypeEnum.INCOME)));
            String declaretype = "1";
            if (suborgid.compareTo(Long.valueOf(orgid)) == 0) {
                declaretype = "2";
            }
            if (incomeRuleList != null && incomeRuleList.size() != 0) {
                for (DynamicObject incomeRule : incomeRuleList) {
                    DynamicObject entryObject = entryentity.addNew();
                    Optional<DynamicObject> preBelongs = prePolicyObject.getDynamicObjectCollection("entryentity").parallelStream().filter(e -> e.getDynamicObject("suborg").getString("id").equals(String.valueOf(suborgid)) && e.getString("ruleid").equals(incomeRule.getString("id"))).findFirst();
                    String name = incomeRule.getString("name");
                    Long ruleId = incomeRule.getLong("id");
                    entryObject.set("org", (Object)orgid);
                    entryObject.set("suborg", (Object)suborgid);
                    entryObject.set("jzjt", incomeRule.get("jzjt"));
                    entryObject.set("taxation", incomeRule.get("taxation"));
                    entryObject.set("rate", incomeRule.get("taxrate"));
                    entryObject.set("ruledeclaretype", (Object)declaretype);
                    entryObject.set("servicedesc", (Object)name);
                    entryObject.set("ruleid", (Object)ruleId);
                    DynamicObject suborgObject = BusinessDataServiceHelper.loadSingleFromCache((Object)suborgid, (String)"bos_org");
                    entryObject.set("belongsorg", (Object)(preBelongs.isPresent() ? preBelongs.get().getDynamicObject("belongsorg") : suborgObject));
                    entryObject.set("rowno", (Object)rowNo);
                    entryCollection.add(rowNo, entryObject);
                    ++rowNo;
                }
            }
            Optional<DynamicObject> preHzentry = prePolicyObject.getDynamicObjectCollection("hzentryentity").parallelStream().filter(e -> e.getDynamicObject("assignorg").getString("id").equals(String.valueOf(suborgid))).findFirst();
            DynamicObject hzentryObject = hzentryentity.addNew();
            hzentryObject.set("seq", (Object)(i + 1));
            hzentryObject.set("assignorg", (Object)suborgid);
            DynamicObject dyo = orgDyoMap.get(suborgid.toString());
            hzentryObject.set("levelname", (Object)dyo.getString("levelname"));
            hzentryObject.set("hzdeclaretype", (Object)declaretype);
            hzentryObject.set("hzorg", (Object)orgid);
            hzentryObject.set("assignrowno", (Object)orgid);
            hzentryObject.set("issuesbb", dyo.get("issuesbb"));
            hzentryObject.set("normalgoods", (Object)(preHzentry.isPresent() ? preHzentry.get().getString("normalgoods") : "0"));
            hzentryObject.set("jzjtgoods", (Object)(preHzentry.isPresent() ? preHzentry.get().getString("jzjtgoods") : "0"));
            hzentryObject.set("normaltax", (Object)(preHzentry.isPresent() ? preHzentry.get().getString("normaltax") : "0"));
            hzentryObject.set("jzjttax", (Object)(preHzentry.isPresent() ? preHzentry.get().getString("jzjttax") : "0"));
            hzentryCollection.add(i, hzentryObject);
            ++i;
        }
        OperationServiceHelper.executeOperate((String)"save", (String)"tcvat_ybhz_policy_confirm", (DynamicObject[])new DynamicObject[]{policy}, (OperateOption)OperateOption.create());
        String orgId = model.getOrgId();
        String startD = model.getStartDate();
        String endD = model.getEndDate();
        String templatetype = (String)model.getCustom().get("templatetype");
        new DraftService().setDefaultRiskInfoNoZlb(draftPurpose, orgId, startD, endD, templatetype);
    }
}

