/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.onekeygenerate.engine.ybnsr;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.onekeygenerate.IEngine;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineTask;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.engine.impl.AddDeductionEngine;
import kd.taxc.tcvat.common.enums.DraftEngineEnum;

public class AccountingEngine
implements IEngine<TcvatEngineModel> {
    private static Log logger = LogFactory.getLog(AccountingEngine.class);

    public void deleteData(TcvatEngineModel model) {
        DraftEngineEnum.YBNSR.deleteIncome(model);
        DraftEngineEnum.YBNSR.deleteDiff(model);
        DraftEngineEnum.YBNSR.deleteDeduction(model);
        DraftEngineEnum.YBNSR.deleteJzjtJxse(model);
        DraftEngineEnum.YBNSR.deleteRollOut(model);
        DraftEngineEnum.YBNSR.deleteTaxReduce(model);
        DraftEngineEnum.YBNSR.deleteAddDeduction(model);
        DraftEngineEnum.YBNSR.deleteDraftCellEditRecord(model);
        DraftEngineEnum.YBNSR.deleteWait(model);
        DraftEngineEnum.YBNSR.deletePerpre(model);
    }

    public void runEngine(TcvatEngineModel model) {
        RequestContext context = RequestContext.getOrCreate();
        try {
            List<EngineTask<TcvatEngineModel, DynamicObject>[]> engineTaskList = TcvatEngineModel.getEngineList("zzsybnsr");
            for (EngineTask<TcvatEngineModel, DynamicObject>[] tasks : engineTaskList) {
                for (EngineTask<TcvatEngineModel, DynamicObject> task : tasks) {
                    task.setCtx(context);
                    task.setEngineModel((EngineModel)model);
                    task.call();
                }
            }
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("AccountingEngineError", "VAT ybnsr accounting engine error!"), new Object[0]);
        }
        long start = System.currentTimeMillis();
        AddDeductionEngine engine = new AddDeductionEngine();
        engine.execute(model);
        logger.info("exec AddDeductionEngine \uff0c\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
    }
}

