/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.onekeygenerate.engine.ybnsr;

import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.draft.DraftService;
import kd.taxc.bdtaxr.common.onekeygenerate.IEngine;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.bdtaxr.common.util.TaxBaseDataUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.account.PolicyConfirmService;
import kd.taxc.tcvat.business.service.draft.PeriodService;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import org.apache.commons.collections.CollectionUtils;

public class PolicyEngine
implements IEngine<TcvatEngineModel> {
    public void deleteData(TcvatEngineModel model) {
        QFilter q1 = new QFilter("orgid", "=", (Object)Long.parseLong(model.getOrgId()));
        QFilter q2 = new QFilter("reportperiod", "=", (Object)DateUtils.stringToDate((String)model.getStartDate()));
        QFilter q3 = new QFilter("taxplayeraptitude", "=", (Object)"zzsybnsr");
        QFilter q4 = new QFilter("draftpurpose", "=", (Object)model.getDraftMetaDataDTO().getDraftPurpose());
        DeleteServiceHelper.delete((String)model.getDraftMetaDataDTO().getPolicyConfirm().getAccountMetaDataName(), (QFilter[])new QFilter[]{q1, q2, q3, q4});
    }

    public void runEngine(TcvatEngineModel model) {
        QFilter q1 = new QFilter("orgid", "=", (Object)Long.parseLong(model.getOrgId()));
        DynamicObject category = TaxBaseDataUtils.queryCategoryByTaxtype((Long)Long.parseLong(model.getOrgId()), (String)"zzs");
        if (category != null) {
            Date startDate = DateUtils.stringToDate((String)model.getStartDate());
            Date endDate = DateUtils.stringToDate((String)model.getEndDate());
            DynamicObject taxMain = (DynamicObject)category.getParent();
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"tcvat_policy_confirm");
            DynamicObject policy = new DynamicObject((DynamicObjectType)entityType);
            policy.set("orgid", (Object)Long.parseLong(model.getOrgId()));
            policy.set("billstatus", (Object)"A");
            policy.set("reportperiod", (Object)startDate);
            policy.set("taxplayeraptitude", (Object)"zzsybnsr");
            policy.set("declaretype", (Object)"1");
            String draftpurpose = model.getDraftMetaDataDTO().getDraftPurpose();
            policy.set("draftpurpose", (Object)draftpurpose);
            policy.set("registertype", taxMain.get("registertype"));
            policy.set("codeandname", taxMain.get("codeandname"));
            policy.set("levytype", (Object)category.getString("levytype"));
            policy.set("deadline", (Object)TaxDeclareHelper.getDeadLine(draftpurpose, model.getOrgId(), startDate, endDate));
            QFilter q3 = new QFilter("taxplayeraptitude", "=", (Object)"zzsybnsr");
            QFilter q4 = new QFilter("reportperiod", "<", (Object)startDate);
            QFilter q5 = new QFilter("draftpurpose", "=", (Object)draftpurpose);
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tcvat_policy_confirm", (String)"id,deductionrate", (QFilter[])new QFilter[]{q1, q3, q4, q5}, (String)"reportperiod desc");
            if (CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
                policy.set("deductionrate", (Object)((DynamicObject)dynamicObjects.get(0)).getString("deductionrate"));
            }
            Date skssqq = startDate;
            Map<String, Date> map = PeriodService.getPreTaxPeriod(draftpurpose, model.getOrgId(), skssqq);
            Date preStart = map.get("startDate");
            Date preEnd = map.get("endDate");
            if (preStart == null || preEnd == null) {
                return;
            }
            QFilter preDateFilter = new QFilter("reportperiod", ">=", (Object)preStart).and(new QFilter("reportperiod", "<=", (Object)preEnd)).and(new QFilter("draftpurpose", "=", (Object)draftpurpose));
            String bqsfsyjzzc = PolicyConfirmService.queryBqsfsyjzzcDefaultValue(draftpurpose, "tcvat_policy_confirm", Long.parseLong(model.getOrgId()), model.getStartDate(), model.getEndDate(), preDateFilter);
            policy.set("bqsfsyjzzc", (Object)bqsfsyjzzc);
            String rulePurpose = (String)model.getCustom().get("rulePurpose");
            Map rules = RuleUtils.getSharingAndOrgRules((Long)Long.parseLong(model.getOrgId()), (RuleTypeEnum)RuleTypeEnum.ALL, (String)"ybnsr", (String)rulePurpose);
            String ruledata = SerializationUtils.toJsonString((Object)rules);
            policy.set("ruledata_tag", (Object)ruledata);
            OperationResult save = OperationServiceHelper.executeOperate((String)"save", (String)model.getDraftMetaDataDTO().getPolicyConfirm().getAccountMetaDataName(), (DynamicObject[])new DynamicObject[]{policy}, (OperateOption)OperateOption.create());
            if (!save.isSuccess() && save.getAllErrorOrValidateInfo() != null) {
                throw new KDBizException(save.getAllErrorOrValidateInfo().stream().filter(a -> a != null).map(a -> a.getMessage()).collect(Collectors.joining()));
            }
            String orgId = model.getOrgId();
            String startD = model.getStartDate();
            String endD = model.getEndDate();
            String templatetype = (String)model.getCustom().get("templatetype");
            new DraftService().setDefaultRiskInfoNoZlb(draftpurpose, orgId, startD, endD, templatetype);
        }
    }
}

