/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.onekeygenerate.handler;

import java.util.ArrayList;
import java.util.List;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.plugin.IFormPlugin;
import kd.taxc.bdtaxr.common.onekeygenerate.IEngine;
import kd.taxc.bdtaxr.common.taxdeclare.TaxStepsConstant;
import kd.taxc.tcvat.business.service.onekeygenerate.engine.xgmnsr.XgmAccountingEngine;
import kd.taxc.tcvat.business.service.onekeygenerate.engine.xgmnsr.XgmPolicyEngine;
import kd.taxc.tcvat.business.service.onekeygenerate.engine.xgmnsr.XgmZlbEngine;
import kd.taxc.tcvat.business.service.onekeygenerate.handler.AbstractEngineHandlerAdapter;

public class XgmnsrHandler
extends AbstractEngineHandlerAdapter {
    private static final List<IEngine> engineList = new ArrayList<IEngine>(){
        {
            this.add(new XgmPolicyEngine());
            this.add(new XgmAccountingEngine());
            this.add(new XgmZlbEngine());
        }
    };

    @Override
    public List<IEngine> getEngineList() {
        return engineList;
    }

    public void handleException(KDBizException exception, IFormView view, IFormPlugin plugin) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("handle_onekey_generate_exception", plugin);
        view.showConfirm(exception.getMessage(), "", MessageBoxOptions.OKCancel, ConfirmTypes.Wait, confirmCallBacks);
    }

    @Override
    protected String getStatus() {
        int size = TaxStepsConstant.getTcvatXgmnsr().size();
        return String.valueOf(size);
    }
}

