/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.onekeygenerate.handler;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.onekeygenerate.IEngine;
import kd.taxc.bdtaxr.common.taxdeclare.TaxStepsConstant;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;
import kd.taxc.tcvat.business.service.account.PolicyConfirmService;
import kd.taxc.tcvat.business.service.draft.PeriodService;
import kd.taxc.tcvat.business.service.onekeygenerate.engine.ybnsr.AccountingEngine;
import kd.taxc.tcvat.business.service.onekeygenerate.engine.ybnsr.PolicyEngine;
import kd.taxc.tcvat.business.service.onekeygenerate.engine.ybnsr.ZlbEngine;
import kd.taxc.tcvat.business.service.onekeygenerate.handler.AbstractEngineHandlerAdapter;

public class YbnsrHandler
extends AbstractEngineHandlerAdapter {
    private static final List<IEngine> engineList = new ArrayList<IEngine>(){
        {
            this.add(new PolicyEngine());
            this.add(new AccountingEngine());
            this.add(new ZlbEngine());
        }
    };

    @Override
    public List<IEngine> getEngineList() {
        return engineList;
    }

    public void validate(EngineModel engineModel) throws KDBizException {
        String orgId = engineModel.getOrgId();
        String startDate = engineModel.getStartDate();
        String declareType = engineModel.getDeclareType();
        String draftpurpose = engineModel.getCustom().getOrDefault("draftpurpose", "nssb");
        QFilter q1 = new QFilter("orgid", "=", (Object)Long.parseLong(orgId));
        QFilter q2 = new QFilter("reportperiod", "<", (Object)DateUtils.stringToDate((String)startDate));
        QFilter q3 = new QFilter("taxplayeraptitude", "=", (Object)"zzsybnsr");
        QFilter q4 = new QFilter("deductionrate", "!=", (Object)"").and("deductionrate", "!=", (Object)" ").and(QFilter.isNotNull((String)"deductionrate"));
        QFilter q5 = new QFilter("draftpurpose", "=", (Object)draftpurpose);
        boolean exists = QueryServiceHelper.exists((String)"tcvat_policy_confirm", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5});
        Map<String, Date> map = PeriodService.preTaxPeriod(orgId, DateUtils.stringToDate((String)startDate));
        Date preStart = map.get("startDate");
        Date preEnd = map.get("endDate");
        QFilter preDateFilter = new QFilter("reportperiod", ">=", (Object)preStart).and(new QFilter("reportperiod", "<=", (Object)preEnd)).and(new QFilter("draftpurpose", "=", (Object)draftpurpose));
        String bqsfsyjzzc = PolicyConfirmService.queryBqsfsyjzzcDefaultValue(draftpurpose, "tcvat_policy_confirm", Long.parseLong(orgId), startDate, engineModel.getEndDate(), preDateFilter);
        StringBuilder tips = new StringBuilder();
        if (!exists) {
            tips.append(ResManager.loadKDString((String)"\u52a0\u8ba1\u62b5\u51cf\u6bd4\u4f8b\u3001", (String)"YbnsrHandler_3", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
        if (StringUtil.isBlank((CharSequence)bqsfsyjzzc)) {
            tips.append(ResManager.loadKDString((String)"\u9002\u7528\u5c0f\u5fae\u4f01\u4e1a\u201c\u516d\u7a0e\u4e24\u8d39\u201d\u51cf\u514d\u653f\u7b56\u3001", (String)"YbnsrHandler_4", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
        if (StringUtil.isNotBlank((CharSequence)tips)) {
            String result = tips.substring(0, tips.length() - 1);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u3010%s\u3011\uff0c\u8bf7\u524d\u5f80\u5e95\u7a3f\u7f16\u5236\u9875\u9762\u65b0\u589e\u3002", (String)"YbnsrHandler_5", (String)"taxc-tcvat", (Object[])new Object[0]), result));
        }
        this.validateDeductionRate(engineModel);
    }

    public void validateDeductionRate(EngineModel engineModel) {
        QFilter q4;
        QFilter q3;
        QFilter q2;
        String orgId = engineModel.getOrgId();
        Date startDate = DateUtils.stringToDate((String)engineModel.getStartDate());
        Date endDate = DateUtils.stringToDate((String)engineModel.getEndDate());
        String draftpurpose = engineModel.getCustom().getOrDefault("draftpurpose", "nssb");
        QFilter q1 = new QFilter("orgid", "=", (Object)Long.parseLong(orgId));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tcvat_policy_confirm", (String)"id,deductionrate", (QFilter[])new QFilter[]{q1, q2 = new QFilter("reportperiod", "<", (Object)startDate), q3 = new QFilter("taxplayeraptitude", "=", (Object)"zzsybnsr"), q4 = new QFilter("draftpurpose", "=", (Object)draftpurpose)}, (String)"reportperiod desc");
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            String deductionrate = ((DynamicObject)dynamicObjects.get(0)).getString("deductionrate");
            if (deductionrate.contains("%")) {
                if ((deductionrate = BigDecimalUtil.toBigDecimal((Object)deductionrate.replace("%", "")).divide(new BigDecimal(100)).setScale(2).toString()).endsWith("0")) {
                    deductionrate = deductionrate.substring(0, deductionrate.length() - 1);
                }
            } else {
                return;
            }
            if (!this.validateRateDate(startDate, endDate, deductionrate)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u3010\u52a0\u8ba1\u62b5\u51cf\u6bd4\u4f8b\u3011\uff0c\u8bf7\u524d\u5f80\u5e95\u7a3f\u7f16\u5236\u9875\u9762\u65b0\u589e\u3002", (String)"YbnsrHandler_0", (String)"taxc-tcvat", (Object[])new Object[0]));
            }
        }
    }

    public boolean validateRateDate(Date startDate, Date endDate, String deductionrate) {
        QFilter numberFilter = new QFilter("number", "=", (Object)"0001_01");
        QFilter deductionrateFilter = new QFilter("entryentity.fvalue1", "=", (Object)deductionrate);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tpo_tcvat_assist", (String)"entryentity.startdate,entryentity.enddate", (QFilter[])new QFilter[]{numberFilter, deductionrateFilter});
        if (dynamicObject != null) {
            boolean isValidEndDate;
            boolean isValidStartDate;
            Date validStartdate = dynamicObject.getDate("entryentity.startdate");
            Date validEnddate = dynamicObject.getDate("entryentity.enddate");
            boolean bl = isValidStartDate = startDate.equals(validStartdate) ? true : DateUtils.isEffectiveDate((Date)startDate, (Date)validStartdate, (Date)validEnddate);
            boolean bl2 = validEnddate == null ? true : (isValidEndDate = endDate.equals(validStartdate) ? true : DateUtils.isEffectiveDate((Date)endDate, (Date)validStartdate, (Date)validEnddate));
            return isValidStartDate && isValidEndDate;
        }
        return false;
    }

    public void handleException(KDBizException exception, IFormView view, IFormPlugin plugin) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("handle_onekey_generate_exception", plugin);
        view.showConfirm(exception.getMessage(), "", MessageBoxOptions.OKCancel, ConfirmTypes.Wait, confirmCallBacks);
    }

    @Override
    protected String getStatus() {
        int size = TaxStepsConstant.getTcvatDraftYbnsr().size();
        return String.valueOf(size);
    }
}

