/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.outputtax.fdckf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcvat.business.service.outputtax.fdckf.EstateSalesConfirmLedgerService;
import kd.taxc.tcvat.business.service.outputtax.fdckf.LandPriceDeductOutputService;

public class LandPriceDeductBatchCalcTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(LandPriceDeductBatchCalcTask.class);

    public void execute(RequestContext rc, Map<String, Object> params) throws KDException {
        String desc = ResManager.loadKDString((String)"\u6279\u91cf\u751f\u6210\u4efb\u52a1\u8fd0\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u3002", (String)"LandPriceDeductBatchCalcTask_0", (String)"taxc-tcvat", (Object[])new Object[0]);
        this.feedbackProgress(1, desc, null);
        String msg = ResManager.loadKDString((String)"\u6279\u91cf\u751f\u6210\u4efb\u52a1\u8fd0\u884c\u7ed3\u675f\u3002", (String)"LandPriceDeductBatchCalcTask_1", (String)"taxc-tcvat", (Object[])new Object[0]);
        try {
            OperationResult save;
            String orgids = (String)params.getOrDefault("orgids", "");
            String projectids = (String)params.getOrDefault("projectids", "");
            String skssqq = (String)params.get("skssqq");
            String skssqz = (String)params.get("skssqz");
            Date qq = DateUtils.stringToDate2((String)skssqq);
            Date qz = DateUtils.stringToDate2((String)skssqz);
            List orgs = Arrays.stream(orgids.split(",")).filter(a -> a != null && a.length() > 0).map(a -> Long.parseLong(a)).collect(Collectors.toList());
            List<Long> projects = Arrays.stream(projectids.split(",")).filter(a -> a != null && a.length() > 0).map(a -> Long.parseLong(a)).collect(Collectors.toList());
            DynamicObjectCollection stageCollection = EstateSalesConfirmLedgerService.queryStageByProjectIds(projects);
            Map<Long, List<DynamicObject>> projectToStage = stageCollection.stream().collect(Collectors.groupingBy(a -> a.getLong("taxproject")));
            List<Long> stages = stageCollection.stream().map(a -> a.getLong("id")).collect(Collectors.toList());
            DynamicObjectCollection extisData = LandPriceDeductOutputService.queryAllStage(stages, qq, qz);
            Set existStage = extisData.stream().map(a -> a.getLong("stage")).collect(Collectors.toSet());
            Map orgObjMap = BusinessDataServiceHelper.loadFromCache((Object[])orgs.toArray(), (String)"bos_org");
            Map projectObjMap = BusinessDataServiceHelper.loadFromCache((Object[])projects.toArray(), (String)"bastax_taxproject");
            Map stagesObjMap = BusinessDataServiceHelper.loadFromCache((Object[])stages.toArray(), (String)"bastax_stage");
            int i = 0;
            int total = stageCollection.size() + 1;
            ArrayList<DynamicObject> arrayList = new ArrayList<DynamicObject>();
            for (Long project : projects) {
                if (!projectToStage.containsKey(project)) continue;
                List<DynamicObject> stageObjList = projectToStage.get(project);
                for (DynamicObject stageObj : stageObjList) {
                    long taxorg;
                    DynamicObject one;
                    long id = stageObj.getLong("id");
                    if (!existStage.contains(id) && (one = LandPriceDeductOutputService.createOne((DynamicObject)orgObjMap.get(taxorg = stageObj.getLong("taxorg")), (DynamicObject)projectObjMap.get(project), (DynamicObject)stagesObjMap.get(id), qq, qz)) != null) {
                        arrayList.add(one);
                    }
                    this.feedbackProgress(++i / total, desc, null);
                }
            }
            if (arrayList.size() == 0) {
                save = new OperationResult();
                save.setMessage(msg);
                save.setSuccess(true);
            } else {
                save = OperationServiceHelper.executeOperate((String)"save", (String)"tcvat_fdc_djdjxx_tz", (DynamicObject[])arrayList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                if (StringUtil.isEmpty((CharSequence)save.getMessage())) {
                    save.setMessage(msg);
                }
            }
            params.put("success", "true");
            params.put("message", msg);
            Map<String, Object> buildResultMessage = this.buildResultMessage(save, arrayList);
            params.putAll(buildResultMessage);
        }
        catch (Exception t) {
            params.put("success", "false");
            params.put("message", ResManager.loadKDString((String)"\u6279\u91cf\u751f\u6210\u4efb\u52a1\u8fd0\u884c\u5931\u8d25\u3002", (String)"LandPriceDeductBatchCalcTask_2", (String)"taxc-tcvat", (Object[])new Object[0]));
            logger.error((Throwable)t);
        }
        this.feedbackProgress(100, msg, null);
        this.feedbackCustomdata(params);
    }

    private Map<String, Object> buildResultMessage(OperationResult opresult, ArrayList<DynamicObject> saveObjs) {
        HashMap<String, Object> msgMap = new HashMap<String, Object>(4);
        int billCount = opresult.getBillCount();
        List successPkIds = opresult.getSuccessPkIds();
        int failcount = billCount - successPkIds.size();
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> billnosb = new ArrayList<String>();
        for (DynamicObject saveObj : saveObjs) {
            long id = saveObj.getLong("id");
            String projectname = saveObj.getString("project.name");
            String stagename = saveObj.getString("stage.name");
            stringBuilder.append(ResManager.loadKDString((String)"\u7a0e\u52a1\u9879\u76ee", (String)"LandPriceDeductBatchCalcTask_3", (String)"taxc-tcvat", (Object[])new Object[0])).append(projectname).append(ResManager.loadKDString((String)"\u5de5\u7a0b\u9879\u76ee\u5206\u671f", (String)"LandPriceDeductBatchCalcTask_4", (String)"taxc-tcvat", (Object[])new Object[0])).append(stagename).append(ResManager.loadKDString((String)"\u6570\u636e\u751f\u6210", (String)"LandPriceDeductBatchCalcTask_5", (String)"taxc-tcvat", (Object[])new Object[0]));
            if (id > 0L && successPkIds.contains(id)) {
                String billno = saveObj.getString("billno");
                billnosb.add(billno == null ? "" : billno);
                stringBuilder.append(ResManager.loadKDString((String)"\u6210\u529f\uff1b", (String)"LandPriceDeductBatchCalcTask_6", (String)"taxc-tcvat", (Object[])new Object[0]));
            } else {
                stringBuilder.append(ResManager.loadKDString((String)"\u5931\u8d25\uff1b", (String)"LandPriceDeductBatchCalcTask_7", (String)"taxc-tcvat", (Object[])new Object[0]));
            }
            stringBuilder.append("\n");
        }
        msgMap.put("totalmsg", String.format(ResManager.loadKDString((String)"\u6210\u529f%1$d\u6761\uff0c\u5931\u8d25%2$d\u6761", (String)"LandPriceDeductBatchCalcTask_8", (String)"taxc-tcvat", (Object[])new Object[0]), successPkIds.size(), failcount));
        msgMap.put("detailmsg", stringBuilder.toString());
        String successNOs = billnosb.stream().collect(Collectors.joining(","));
        msgMap.put("successNOs", successNOs);
        return msgMap;
    }
}

