/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.outputtax.fdckf;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.draft.PeriodService;
import kd.taxc.tcvat.business.service.outputtax.fdckf.EstateSalesConfirmLedgerService;

public class LandPriceDeductOutputService {
    private static final String DEVELOP_LAND_INFO = "tdm_develop_land_info";
    public static final String FDC_DJDJXX_TZ = "tcvat_fdc_djdjxx_tz";

    public static DynamicObject createOne(DynamicObject org, DynamicObject project, DynamicObject stage, Date skssqq, Date skssqz) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)FDC_DJDJXX_TZ);
        dynamicObject.set("org", (Object)org);
        dynamicObject.set("project", (Object)project);
        dynamicObject.set("stage", (Object)stage);
        DynamicObject landInfo = LandPriceDeductOutputService.queryDevelopLandInfo(stage.getLong("id"));
        if (landInfo != null) {
            dynamicObject.set("devlandinfo", (Object)landInfo);
            dynamicObject.set("skssqq", (Object)skssqq);
            dynamicObject.set("skssqz", (Object)skssqz);
            dynamicObject.set("createtime", (Object)new Date());
            long currUserId = RequestContext.get() != null ? RequestContext.get().getCurrUserId() : 0L;
            dynamicObject.set("creator", (Object)currUserId);
            dynamicObject.set("billstatus", (Object)"A");
            List<Map<String, Object>> result = LandPriceDeductOutputService.calcEntryDefaultData(org.getLong("id"), project.getLong("id"), stage.getLong("id"), skssqq, skssqz);
            if (result.size() > 0) {
                DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
                for (int i = 0; i < 1; ++i) {
                    Map<String, Object> objectMap = result.get(i);
                    DynamicObject entryitem = entryentity.addNew();
                    for (Map.Entry<String, Object> objectEntry : objectMap.entrySet()) {
                        entryitem.set(objectEntry.getKey(), objectEntry.getValue());
                    }
                }
            }
            return dynamicObject;
        }
        return null;
    }

    public static List<Map<String, Object>> calcEntryDefaultData(Long orgid, Long projectId, Long stage, Date skssqq, Date skssqz) {
        BigDecimal dqydjtdjk;
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        DynamicObjectCollection landInfoMj = LandPriceDeductOutputService.queryDevelopLandInfoMj(stage, skssqq, skssqz);
        BigDecimal dsjrzksmj = landInfoMj.size() > 0 ? ((DynamicObject)landInfoMj.get(0)).getBigDecimal("dsjrzksmj1") : BigDecimal.ZERO;
        BigDecimal yxdjtdjkhj = landInfoMj.size() > 0 ? ((DynamicObject)landInfoMj.get(0)).getBigDecimal("yxdjtdjkhj1") : BigDecimal.ZERO;
        DynamicObject lastOne = LandPriceDeductOutputService.queryLastPeriod(orgid, projectId, stage, skssqq, skssqz);
        BigDecimal yqqjydjjrksmj = lastOne == null ? BigDecimal.ZERO : lastOne.getBigDecimal("entryentity.yqqjydjjrksmj").add(lastOne.getBigDecimal("entryentity.dqdjjrksmj"));
        BigDecimal yqqjydjdjjk = lastOne == null ? BigDecimal.ZERO : lastOne.getBigDecimal("entryentity.yqqjydjdjjk").add(lastOne.getBigDecimal("entryentity.dqsjdjtdjk"));
        DynamicObjectCollection saleBook = EstateSalesConfirmLedgerService.queryPeriodData(orgid, projectId, stage, skssqq, skssqz);
        BigDecimal dqdjjrksmj = saleBook.stream().map(a -> a.getBigDecimal("roomarea").multiply(a.getBigDecimal("dqqrxsebl"))).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        BigDecimal dqsjdjtdjk = dqydjtdjk = BigDecimal.ZERO.compareTo(dsjrzksmj) == 0 ? BigDecimal.ZERO : yqqjydjjrksmj.add(dqdjjrksmj).multiply(yxdjtdjkhj).divide(dsjrzksmj, 2, RoundingMode.HALF_UP).subtract(yqqjydjdjjk);
        BigDecimal sykdjjrksmj = dsjrzksmj.subtract(yqqjydjjrksmj).subtract(dqdjjrksmj);
        BigDecimal sykdjtdjk = yxdjtdjkhj.subtract(yqqjydjdjjk).subtract(dqsjdjtdjk);
        HashMap<String, BigDecimal> hashMap = new HashMap<String, BigDecimal>();
        hashMap.put("dsjrzksmj", dsjrzksmj);
        hashMap.put("yxdjtdjkhj", yxdjtdjkhj);
        hashMap.put("yqqjydjjrksmj", yqqjydjjrksmj);
        hashMap.put("yqqjydjdjjk", yqqjydjdjjk);
        hashMap.put("dqdjjrksmj", dqdjjrksmj);
        hashMap.put("dqydjtdjk", dqydjtdjk);
        hashMap.put("dqsjdjtdjk", dqsjdjtdjk);
        hashMap.put("sykdjjrksmj", sykdjjrksmj);
        hashMap.put("sykdjtdjk", sykdjtdjk);
        result.add(hashMap);
        return result;
    }

    public static DynamicObjectCollection queryAllStage(List<Long> stages, Date skssqq, Date skssqz) {
        QFilter status = new QFilter("stage", "in", stages);
        QFilter qFilter = new QFilter("skssqq", "=", (Object)skssqq);
        QFilter qFilter1 = new QFilter("skssqz", "=", (Object)skssqz);
        DynamicObjectCollection query = QueryServiceHelper.query((String)FDC_DJDJXX_TZ, (String)"id,stage", (QFilter[])new QFilter[]{status, qFilter, qFilter1});
        return query;
    }

    private static DynamicObject queryLastPeriod(Long orgid, Long projectId, Long stage, Date skssqq, Date skssqz) {
        QFilter taxorg = new QFilter("org", "=", (Object)orgid);
        QFilter enable = new QFilter("project", "=", (Object)projectId);
        QFilter status = new QFilter("stage", "=", (Object)stage);
        Map<String, Date> map = PeriodService.preTaxPeriod(orgid.toString(), skssqq);
        Date startDate = map.get("startDate");
        Date endDate = DateUtils.trunc((Date)map.get("endDate"));
        QFilter qFilter = new QFilter("skssqq", "=", (Object)startDate);
        QFilter qFilter1 = new QFilter("skssqz", "=", (Object)endDate);
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)FDC_DJDJXX_TZ, (String)"id,entryentity.id entryid ,entryentity.dsjrzksmj ,entryentity.yxdjtdjkhj ,entryentity.yqqjydjjrksmj ,entryentity.yqqjydjdjjk ,entryentity.dqdjjrksmj ,entryentity.dqydjtdjk ,entryentity.dqsjdjtdjk ,entryentity.sykdjjrksmj, entryentity.sykdjtdjk", (QFilter[])new QFilter[]{taxorg, enable, status, qFilter, qFilter1});
        return queryOne;
    }

    private static DynamicObjectCollection queryDevelopLandInfoMj(Long stage, Date skssqq, Date skssqz) {
        QFilter stageQf = new QFilter("stage", "=", (Object)stage);
        QFilter bgdjsq = new QFilter("entryentity.bgdjsq", "<=", (Object)skssqq);
        DynamicObjectCollection query = QueryServiceHelper.query((String)DEVELOP_LAND_INFO, (String)"id,entryentity.bgdjsq bgdjsq,entryentity.dsjrzksmj1 dsjrzksmj1,entryentity.yxdjtdjkhj1 yxdjtdjkhj1", (QFilter[])new QFilter[]{stageQf, bgdjsq}, (String)"entryentity.bgdjsq desc");
        return query;
    }

    public static DynamicObject queryDevelopLandInfo(Long stage) {
        QFilter stageQf = new QFilter("stage", "=", (Object)stage);
        DynamicObject queryOne = BusinessDataServiceHelper.loadSingleFromCache((String)DEVELOP_LAND_INFO, (QFilter[])new QFilter[]{stageQf});
        return queryOne;
    }
}

