/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.prepay.declare;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.tcvat.business.service.dispatchservice.dto.PrepayDeclareDTO;

public class CheckParemsService {
    public static ApiResult checkOrg(PrepayDeclareDTO prepayDeclareDTO, IFormView getView) {
        DynamicObject taxOrgObject = OrgCheckUtil.getTaxOrgInfo((Long)prepayDeclareDTO.getOrgId(), (Date)prepayDeclareDTO.getStartDate(), (Date)prepayDeclareDTO.getEndDate());
        if (Objects.isNull(taxOrgObject)) {
            QFilter orgIdFilter = new QFilter("id", "in", (Object)prepayDeclareDTO.getOrgId());
            DynamicObject[] ordDynamicObjects = BusinessDataServiceHelper.load((String)"bos_org", (String)"name", (QFilter[])new QFilter[]{orgIdFilter});
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"%s\u5f53\u524d\u7533\u62a5\u5c5e\u671f\u5185\u4e0d\u5b58\u5728\u6709\u6548\u7684\u53d6\u6570\u5173\u7cfb\uff0c\u5982\u9700\u7533\u62a5\uff0c\u8bf7\u524d\u5f80\u7a0e\u52a1\u4e91\u57fa\u7840\u8d44\u6599\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406\u8fdb\u884c\u7ef4\u62a4", (String)"CheckParemsService_0", (String)"taxc-tcvat", (Object[])new Object[0]), ordDynamicObjects.length > 0 ? ordDynamicObjects[0].getString("name") : ""));
        }
        prepayDeclareDTO.setTaxorg(taxOrgObject.getLong("taxorg"));
        if (LicenseCheckServiceHelper.check((Object)prepayDeclareDTO.getTaxorg(), (IFormView)getView, (String)"tcvat")) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u8bf7\u786e\u4fdd\u7ec4\u7ec7\u8bb8\u53ef\u72b6\u6001\u6b63\u786e\u4e14\u7ec4\u7ec7\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0e\u6388\u6743\u7684\u4e00\u81f4", (String)"CheckParemsService_9", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
        if (prepayDeclareDTO.getOrgId().compareTo(taxOrgObject.getLong("taxorg")) == 0) {
            DynamicObjectCollection orgCollection;
            if (null != getView) {
                DynamicObjectCollection org = TreeUtils.queryOrgListByCondition((Map)TreeUtils.convertParam((String)"id", (Object)prepayDeclareDTO.getOrgId()));
                OrgCheckUtil.orgAuth((String)prepayDeclareDTO.getOrgId().toString(), (IFormView)getView, (DynamicObjectCollection)org);
            }
            if (null != (orgCollection = TreeUtils.queryOrgListByCondition((Map)TreeUtils.convertParam((String)"id", (Object)prepayDeclareDTO.getOrgId()))) && !orgCollection.isEmpty()) {
                if (!"1".equals(OrgUtils.getOrgStatusById((String)((DynamicObject)orgCollection.get(0)).getString("id")))) {
                    return ApiResult.fail((String)ResManager.loadKDString((String)"\u7ec4\u7ec7\u5c1a\u672a\u542f\u7528", (String)"CheckParemsService_2", (String)"taxc-tcvat", (Object[])new Object[0]));
                }
            } else {
                return ApiResult.fail((String)ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u6570\u636e\u4e0d\u5b58\u5728", (String)"CheckParemsService_3", (String)"taxc-tcvat", (Object[])new Object[0]));
            }
        }
        if (!CheckParemsService.checkCard(prepayDeclareDTO).booleanValue()) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u7a0e\u79cd\u5c1a\u672a\u542f\u7528\uff0c\u5982\u9700\u64cd\u4f5c,\u8bf7\u524d\u5f80\u7a0e\u52a1\u4e91-\u57fa\u7840\u8d44\u6599-\u7a0e\u52a1\u4fe1\u606f\u8fdb\u884c\u542f\u7528", (String)"CheckParemsService_4", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
        return ApiResult.success((Object)prepayDeclareDTO);
    }

    private static Boolean checkCard(PrepayDeclareDTO prepayDeclareDTO) {
        DynamicObjectCollection categoryentryentity;
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainZzsByOrgId(Collections.singletonList(prepayDeclareDTO.getOrgId()));
        if (EmptyCheckUtils.isNotEmpty((Object)result.getData()) && EmptyCheckUtils.isNotEmpty((Object)(categoryentryentity = ((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("categoryentryentity")))) {
            if (Objects.equals("0", ((DynamicObject)categoryentryentity.get(0)).getString("enable"))) {
                return Boolean.FALSE;
            }
            prepayDeclareDTO.setTaxPayerType(((DynamicObject)categoryentryentity.get(0)).getString("taxpayertype"));
        }
        return Boolean.TRUE;
    }

    public static ApiResult checkProject(PrepayDeclareDTO prepayDeclareDTO) {
        DynamicObject projectInfo = QueryServiceHelper.queryOne((String)"tcvat_prepay_project_info", (String)"id,org,projectstatus,status", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)prepayDeclareDTO.getProjectId())});
        if (null == projectInfo) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u9879\u76ee\u4e0d\u5b58\u5728, \u8bf7\u524d\u5f80\u9884\u7f34\u9879\u76ee\u8fdb\u884c\u7ef4\u62a4", (String)"CheckParemsService_5", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
        if (!prepayDeclareDTO.getOrgId().toString().equals(projectInfo.getString("org"))) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u9879\u76ee\u4e0e\u7533\u62a5\u7ec4\u7ec7\u4e0d\u5339\u914d", (String)"CheckParemsService_6", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
        if ("close".equals(projectInfo.getString("projectstatus"))) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u4e0d\u662f\u8fdb\u884c\u4e2d\u7684\u9879\u76ee, \u8bf7\u524d\u5f80\u9884\u7f34\u9879\u76ee\u8fdb\u884c\u7ef4\u62a4", (String)"CheckParemsService_7", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
        if (!"C".equals(projectInfo.getString("status"))) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u9879\u76ee\u672a\u5ba1\u6838, \u8bf7\u524d\u5f80\u9884\u7f34\u9879\u76ee\u8fdb\u884c\u7ef4\u62a4", (String)"CheckParemsService_8", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
        prepayDeclareDTO.setProjectId(projectInfo.getLong("id"));
        return ApiResult.success((Object)prepayDeclareDTO);
    }
}

