/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.prepay.engine.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.ComboProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.history.BaseDataHistoryService;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineTask;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.engine.task.PartitionSaveTask;
import kd.taxc.tcvat.business.service.engine.task.RuleSettingTask;
import kd.taxc.tcvat.business.service.prepay.engine.impl.AccountEngineService;
import kd.taxc.tcvat.common.util.PrepayRuleUtils;
import kd.taxc.tcvat.common.util.UUID;
import org.apache.commons.lang.StringUtils;

public class AccountEngine
extends EngineTask<TcvatEngineModel, DynamicObject> {
    private static final String HISTORY_ENTRY = "tctb_history_record";
    private static final String ORGID_KEY = "orgid";
    private static final String TCVAT_PROJECT_ACCOUNT = "tcvat_project_account";
    private static final String PAGE_SALES_DETAIL = "tcvat_prepay_account_deta";

    protected DynamicObject execute() throws Exception {
        TcvatEngineModel model = (TcvatEngineModel)this.getEngineModel();
        DynamicObject project = BusinessDataServiceHelper.loadSingle(model.getCustom().get("projectid"), (String)"tcvat_prepay_project_info");
        String applyid = (String)model.getCustom().get("applyid");
        DynamicObject application = this.queryPrepayApplication(project.getString("prepaytype"), applyid);
        if (application == null) {
            return this.executeRule(project);
        }
        return this.executeApplication(project, application);
    }

    private DynamicObject executeRule(DynamicObject project) throws Exception {
        TcvatEngineModel model = (TcvatEngineModel)this.getEngineModel();
        Date startDate = DateUtils.stringToDate((String)model.getStartDate());
        Date endDate = DateUtils.stringToDate((String)model.getEndDate());
        String declareSerialno = (String)model.getCustom().get("declareserialno");
        QFilter qFilter = new QFilter(ORGID_KEY, "=", (Object)Long.parseLong(model.getOrgId()));
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(model.getOrgId()));
        QFilter qFilter1 = new QFilter("startdate", "=", (Object)startDate).and(new QFilter("enddate", "=", (Object)endDate));
        QFilter qFilter2 = new QFilter("skssqq", "=", (Object)startDate).and(new QFilter("skssqz", "=", (Object)endDate));
        QFilter declareSerialnoFilter = new QFilter("declareserialno", "=", (Object)declareSerialno);
        DeleteServiceHelper.delete((String)TCVAT_PROJECT_ACCOUNT, (QFilter[])new QFilter[]{qFilter, qFilter1, declareSerialnoFilter});
        DeleteServiceHelper.delete((String)PAGE_SALES_DETAIL, (QFilter[])new QFilter[]{orgFilter, qFilter2, declareSerialnoFilter});
        List<DynamicObject> prepayRuleList = PrepayRuleUtils.getSharingAndProjectRules(Collections.singletonList(project.getLong("id")), null, false);
        ArrayList<DynamicObject> salesAmountDetailResult = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> deductionAmountDetailResult = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> accountList = new ArrayList<DynamicObject>();
        List rules = prepayRuleList.stream().filter(p -> {
            String prepaytype = p.getString("prepayproject.prepaytype");
            String ruletype = p.getString("ruletype");
            return "private".equals(ruletype) && model.getCustom().get("projectid").equals(p.getDynamicObject("prepayproject").getString("id")) || "public".equals(ruletype) && StringUtils.equals((String)project.getString("prepaytype"), (String)prepaytype);
        }).collect(Collectors.toList());
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)TCVAT_PROJECT_ACCOUNT);
        DynamicObject account = new DynamicObject((DynamicObjectType)entityType);
        String serialno = UUID.randomUUID();
        account.set("declareserialno", (Object)declareSerialno);
        account.set(ORGID_KEY, (Object)Long.valueOf(model.getOrgId()));
        account.set("serialno", (Object)serialno);
        account.set("projectid", (Object)project.getLong("id"));
        account.set("number", (Object)project.getString("number"));
        account.set("name", (Object)project.getString("name"));
        account.set("licensecode", (Object)project.getString("licensecode"));
        account.set("taxoffice", null != project.getDynamicObject("taxoffice") ? Long.valueOf(project.getDynamicObject("taxoffice").getLong("id")) : "0");
        account.set("levytype", (Object)project.getString("levytype"));
        account.set("prepaytype", (Object)project.getString("prepaytype"));
        account.set("startdate", (Object)startDate);
        account.set("enddate", (Object)endDate);
        account.set("projectzone", (Object)project.getString("projectzone"));
        BigDecimal totalSalesAmount = BigDecimal.ZERO;
        BigDecimal totalDeductionAmount = BigDecimal.ZERO;
        for (DynamicObject rule : rules) {
            String taxrate = null == rule.getDynamicObject("taxrate") ? null : rule.getDynamicObject("taxrate").getString("number");
            List<DynamicObject> salesAmountListDetail = this.getAmountDetail(rule, rule.getDynamicObjectCollection("entryentity"), PAGE_SALES_DETAIL, model, serialno, taxrate);
            salesAmountListDetail.stream().forEach(s -> {
                s.set("detailtype", (Object)"sales");
                s.set("declareserialno", (Object)declareSerialno);
            });
            salesAmountDetailResult.addAll(salesAmountListDetail);
            BigDecimal salesAmount = AccountEngineService.getAccountingAmount(salesAmountListDetail);
            totalSalesAmount = totalSalesAmount.add(salesAmount);
            List<DynamicObject> deductionAmountListDetail = this.getAmountDetail(rule, this.transferKey(rule.getDynamicObjectCollection("deductionentry")), PAGE_SALES_DETAIL, model, serialno, taxrate);
            deductionAmountListDetail.stream().forEach(d -> {
                d.set("detailtype", (Object)"deduction");
                d.set("declareserialno", (Object)declareSerialno);
            });
            deductionAmountDetailResult.addAll(deductionAmountListDetail);
            BigDecimal deductionAmount = AccountEngineService.getAccountingAmount(deductionAmountListDetail);
            totalDeductionAmount = totalDeductionAmount.add(deductionAmount);
            this.saveHistory(rule, model);
        }
        account.set("salesamount", (Object)totalSalesAmount.setScale(2, 4));
        account.set("deductionamount", (Object)totalDeductionAmount.setScale(2, 4));
        AccountEngineService.getEntryEntity(entityType, account, project, model);
        accountList.add(account);
        ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(salesAmountDetailResult));
        ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(deductionAmountDetailResult));
        ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(accountList));
        return null;
    }

    private DynamicObject executeApplication(DynamicObject project, DynamicObject application) {
        TcvatEngineModel model = (TcvatEngineModel)this.getEngineModel();
        Date startDate = DateUtils.stringToDate((String)model.getStartDate());
        Date endDate = DateUtils.stringToDate((String)model.getEndDate());
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)TCVAT_PROJECT_ACCOUNT);
        DynamicObject account = new DynamicObject((DynamicObjectType)entityType);
        String serialno = UUID.randomUUID();
        String declareSerialno = (String)model.getCustom().get("declareserialno");
        account.set("declareserialno", (Object)declareSerialno);
        account.set(ORGID_KEY, (Object)Long.valueOf(model.getOrgId()));
        account.set("serialno", (Object)serialno);
        account.set("projectid", (Object)project.getLong("id"));
        account.set("number", (Object)project.getString("number"));
        account.set("name", (Object)project.getString("name"));
        account.set("licensecode", (Object)project.getString("licensecode"));
        account.set("taxoffice", null != project.getDynamicObject("taxoffice") ? Long.valueOf(project.getDynamicObject("taxoffice").getLong("id")) : "0");
        account.set("levytype", (Object)project.getString("levytype"));
        account.set("prepaytype", (Object)project.getString("prepaytype"));
        account.set("startdate", (Object)startDate);
        account.set("enddate", (Object)endDate);
        account.set("projectzone", (Object)project.getString("projectzone"));
        account.set("applicationno", (Object)application.getString("billno"));
        account.set("salesamount", (Object)application.getString("salesamount"));
        BigDecimal predeductamount = application.get("predeductamount") == null ? BigDecimal.ZERO : application.getBigDecimal("predeductamount");
        account.set("deductionamount", (Object)application.getBigDecimal("deductionamount").add(predeductamount));
        EntityType subEntity = (EntityType)entityType.getAllEntities().get("entryentity");
        DynamicObjectCollection entryCollection = new DynamicObjectCollection();
        DynamicObject tcvatObject = new DynamicObject((DynamicObjectType)subEntity);
        tcvatObject.set("seq", (Object)1);
        tcvatObject.set("taxtype", (Object)AccountEngineService.prepayTaxType.get("tcvat"));
        tcvatObject.set("prepaybase", application.get("taxbase"));
        String prepayrate = application.getString("prepayrate");
        IDataEntityProperty prepayrateProp = (IDataEntityProperty)application.getDynamicObjectType().getProperties().get((Object)"prepayrate");
        tcvatObject.set("prepayrate", (Object)((ComboProp)prepayrateProp).getItemByName(prepayrate));
        tcvatObject.set("prepayamount", application.get("zzsprepay"));
        entryCollection.add((Object)tcvatObject);
        DynamicObjectCollection entryentity = application.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < entryentity.size(); ++i) {
            DynamicObject other = (DynamicObject)entryentity.get(i);
            DynamicObject obj = new DynamicObject((DynamicObjectType)subEntity);
            obj.set("seq", (Object)(i + 2));
            obj.set("taxtype", (Object)AccountEngineService.prepayTaxType.get(other.getString("taxtype")));
            obj.set("prepaybase", other.get("basetax"));
            obj.set("prepayrate", other.get("rate"));
            obj.set("prepayamount", other.get("taxamount"));
            entryCollection.add((Object)obj);
        }
        account.set("entryentity", (Object)entryCollection);
        ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(Collections.singletonList(account)));
        return null;
    }

    private List<DynamicObject> getAmountDetail(DynamicObject rule, DynamicObjectCollection subRulecollection, String pageName, EngineModel model, String serialno, String taxrate) throws Exception {
        RuleSettingTask ruleSettingTask = new RuleSettingTask(rule, model, subRulecollection, serialno, pageName, taxrate);
        List futures = ThreadPoolsService.getInstance().submitReturnFuture((Task)ruleSettingTask);
        List accountingList = AccountEngine.getFutureList((List)futures);
        return accountingList;
    }

    private DynamicObjectCollection transferKey(DynamicObjectCollection subRulecollection) {
        DynamicObject standObject = BusinessDataServiceHelper.newDynamicObject((String)"tcvat_rule_prepay");
        DynamicObjectCollection standEntryCollention = standObject.getDynamicObjectCollection("entryentity");
        for (DynamicObject object : subRulecollection) {
            DynamicObject transferResult = standEntryCollention.addNew();
            transferResult.set("bizname", object.get("deductionbizname"));
            transferResult.set("table", object.get("deductiontable"));
            transferResult.set("amountfield", object.get("deductionamountfield"));
            transferResult.set("absolute", object.get("deductionabsolute"));
            transferResult.set("datatype", object.get("deductiondatatype"));
            transferResult.set("datadirection", object.get("deductiondatadirection"));
            transferResult.set("filtercondition", object.get("deductionfiltercondition"));
            transferResult.set("conditionjson", object.get("deductionconditionjson"));
        }
        return standEntryCollention;
    }

    private void saveHistory(DynamicObject rule, TcvatEngineModel model) {
        DynamicObject historyObject = BaseDataHistoryService.createDynamicObject((long)Long.parseLong(model.getOrgId()), (Date)DateUtils.stringToDate((String)model.getStartDate()), (Date)DateUtils.stringToDate((String)model.getEndDate()), (String)"tcvat_prepay", (String)SerializationUtils.toJsonString((Object)rule));
        historyObject.set("serialno", model.getCustom().get("declareserialno"));
        DynamicObject[] dArr = new DynamicObject[]{historyObject};
        DeleteServiceHelper.delete((String)HISTORY_ENTRY, (QFilter[])new QFilter[]{new QFilter(ORGID_KEY, "=", (Object)model.getOrgId()).and("startdate", "=", (Object)DateUtils.stringToDate((String)model.getStartDate())).and("enddate", "=", (Object)DateUtils.stringToDate((String)model.getEndDate())).and("serialno", "=", model.getCustom().get("declareserialno")).and("type", "=", model.getCustom().get("tcvat_prepay"))});
        SaveServiceHelper.save((DynamicObject[])dArr);
    }

    private DynamicObject queryPrepayApplication(String prepaytype, String applicationno) {
        DynamicObject result = null;
        if (("VAT_YJXMLX_001".equals(prepaytype) || "VAT_YJXMLX_002".equals(prepaytype)) && applicationno != null) {
            result = BusinessDataServiceHelper.loadSingle((Object)applicationno, (String)"tcvat_prepay_application");
        }
        return result;
    }
}

