/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.prepay.engine.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.prepay.application.PrepayApplicationService;

public class AccountEngineService {
    public static final Map<String, String> prepayTypeToSubject = new HashMap<String, String>(8);
    public static final Map<String, String> prepayTaxType = new HashMap<String, String>(8);

    public static void calculateEntryAmount(int seq, BigDecimal rate, String prepayProjectType, String taxPayerType, DynamicObject account, DynamicObject entryObject, BigDecimal prepayamount) {
        if (seq == 1) {
            AccountEngineService.tvatEntryAmount(prepayProjectType, taxPayerType, account, entryObject);
            return;
        }
        if (seq == 2 || seq == 3 || seq == 4) {
            AccountEngineService.fjsfEntryAmount(rate, entryObject, prepayamount);
            return;
        }
        if (seq >= 5) {
            AccountEngineService.otherEntryAmount(prepayProjectType, account, entryObject);
            return;
        }
    }

    private static void tvatEntryAmount(String prepayProjectType, String taxPayerType, DynamicObject account, DynamicObject entryObject) {
        String rate = "1";
        BigDecimal prepayBase = BigDecimal.valueOf(0L);
        BigDecimal taxAmount = account.getBigDecimal("salesamount").subtract(account.getBigDecimal("deductionamount"));
        switch (prepayProjectType) {
            case "VAT_YJXMLX_001": 
            case "VAT_YJXMLX_002": {
                if ("normal".equals(account.getString("levytype"))) {
                    rate = "1.09";
                    prepayBase = taxAmount.divide(BigDecimal.valueOf(1.09), 2, 4);
                }
                if ("simple".equals(account.getString("levytype"))) {
                    if ("xgmnsr".equals(taxPayerType)) {
                        rate = "1.01";
                        prepayBase = taxAmount.divide(BigDecimal.valueOf(1.01), 2, 4);
                    } else {
                        rate = "1.03";
                        prepayBase = taxAmount.divide(BigDecimal.valueOf(1.03), 2, 4);
                    }
                }
                entryObject.set("prepaybase", (Object)prepayBase);
                entryObject.set("prepayamount", (Object)taxAmount.multiply(new BigDecimal(entryObject.getString("prepayrate").replace("%", ""))).divide(new BigDecimal(rate), 4, 4).divide(new BigDecimal(100), 2, 4));
                break;
            }
            case "VAT_YJXMLX_003": 
            case "VAT_YJXMLX_005": {
                if ("normal".equals(account.getString("levytype"))) {
                    rate = "1.09";
                    prepayBase = account.getBigDecimal("salesamount").divide(BigDecimal.valueOf(1.09), 2, 4);
                }
                if ("simple".equals(account.getString("levytype"))) {
                    rate = "1.05";
                    prepayBase = account.getBigDecimal("salesamount").divide(BigDecimal.valueOf(1.05), 2, 4);
                }
                entryObject.set("prepaybase", (Object)prepayBase);
                entryObject.set("prepayamount", (Object)account.getBigDecimal("salesamount").multiply(new BigDecimal(entryObject.getString("prepayrate").replace("%", ""))).divide(new BigDecimal(rate), 4, 4).divide(new BigDecimal(100), 2, 4));
                break;
            }
            case "VAT_YJXMLX_004": {
                rate = "1.05";
                prepayBase = taxAmount.divide(BigDecimal.valueOf(1.05), 2, 4);
                entryObject.set("prepaybase", (Object)prepayBase);
                entryObject.set("prepayamount", (Object)taxAmount.multiply(new BigDecimal(entryObject.getString("prepayrate").replace("%", ""))).divide(new BigDecimal(rate), 4, 4).divide(new BigDecimal(100), 2, 4));
                break;
            }
            default: {
                entryObject.set("prepaybase", (Object)prepayBase);
                entryObject.set("prepayamount", (Object)entryObject.getBigDecimal("prepaybase").multiply(new BigDecimal(entryObject.getString("prepayrate").replace("%", ""))).divide(new BigDecimal(rate), 4, 4).divide(new BigDecimal(100), 2, 4));
            }
        }
    }

    private static void fjsfEntryAmount(BigDecimal rate, DynamicObject entryObject, BigDecimal prepayamount) {
        entryObject.set("prepaybase", (Object)prepayamount);
        if (null != rate) {
            entryObject.set("prepayamount", (Object)entryObject.getBigDecimal("prepaybase").multiply(rate).divide(new BigDecimal(100), 2, 4));
        }
    }

    private static void otherEntryAmount(String prepayProjectType, DynamicObject account, DynamicObject entryObject) {
        entryObject.set("prepaybase", (Object)AccountEngineService.getPrepayBase(entryObject, prepayProjectType, account, BigDecimal.valueOf(0L)));
        BigDecimal prepayrate = new BigDecimal(entryObject.getString("prepayrate").replace("%", ""));
        entryObject.set("prepayamount", (Object)entryObject.getBigDecimal("prepaybase").multiply(prepayrate).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP));
    }

    public static void getEntryEntity(MainEntityType entityType, DynamicObject account, DynamicObject project, TcvatEngineModel model) {
        BigDecimal prepayrate;
        DynamicObject taxOrgObject = OrgCheckUtil.getTaxOrgNsrxx((Long)Long.parseLong(model.getOrgId()), (Date)DateUtils.stringToDate((String)model.getStartDate()), (Date)DateUtils.stringToDate((String)model.getEndDate()), (String)"tcvat");
        String taxPayerType = null;
        long taxOrgId = 0L;
        if (taxOrgObject != null) {
            taxPayerType = taxOrgObject.getString("taxpayertype");
            DynamicObject taxMain = (DynamicObject)taxOrgObject.getParent();
            taxOrgId = taxMain.getLong("taxorg.id");
        }
        EntityType subEntity = (EntityType)entityType.getAllEntities().get("entryentity");
        DynamicObjectCollection entryCollection = new DynamicObjectCollection();
        String prepayProjectType = account.getString("prepaytype");
        DynamicObject tcvatObject = new DynamicObject((DynamicObjectType)subEntity);
        tcvatObject.set("seq", (Object)1);
        tcvatObject.set("taxtype", (Object)prepayTaxType.get("tcvat"));
        if ("true".equals(project.getString("tcvat"))) {
            QFilter taxmethod;
            QFilter subname;
            QFilter general;
            QFilter enddate;
            QFilter startdate = new QFilter("startdate", "<=", (Object)DateUtils.stringToDate((String)model.getStartDate()));
            DynamicObject[] preRateObjects = BusinessDataServiceHelper.load((String)"tpo_tcvat_prerate", (String)"conditionjson,entryentity.prerate,entryentity.subname,entryentity.taxmethod", (QFilter[])new QFilter[]{startdate, enddate = new QFilter("enddate", ">=", (Object)DateUtils.stringToDate((String)model.getEndDate())).or(QFilter.isNull((String)"enddate")), general = new QFilter("general", "=", (Object)"0"), subname = new QFilter("entryentity.subname", "=", (Object)prepayTypeToSubject.get(prepayProjectType)), taxmethod = new QFilter("entryentity.taxmethod", "=", (Object)account.getString("levytype"))});
            List<DynamicObject> preRate = AccountEngineService.getPrerate(preRateObjects, String.valueOf(taxOrgId));
            if (preRate.size() == 0 && taxOrgObject != null) {
                general = new QFilter("general", "=", (Object)"1");
                preRateObjects = BusinessDataServiceHelper.load((String)"tpo_tcvat_prerate", (String)"conditionjson,entryentity.prerate,entryentity.subname,entryentity.taxmethod", (QFilter[])new QFilter[]{startdate, enddate, general, subname, taxmethod});
                preRate = AccountEngineService.getPrerate(preRateObjects, String.valueOf(taxOrgId));
            }
            DynamicObjectCollection rateCollection = new DynamicObjectCollection();
            if (preRate.size() > 0) {
                rateCollection = preRate.get(0).getDynamicObjectCollection("entryentity").stream().filter(e -> e.getString("subname").equals(prepayTypeToSubject.get(prepayProjectType)) && e.getString("taxmethod").equals(account.getString("levytype"))).collect(Collectors.toCollection(DynamicObjectCollection::new));
            }
            tcvatObject.set("prepayrate", rateCollection.size() > 0 ? ((DynamicObject)rateCollection.get(0)).get("prerate") : "0");
            AccountEngineService.calculateEntryAmount(1, null, prepayProjectType, taxPayerType, account, tcvatObject, null);
            entryCollection.add((Object)tcvatObject);
        }
        DynamicObject cswhjssObject = new DynamicObject((DynamicObjectType)subEntity);
        cswhjssObject.set("seq", (Object)2);
        cswhjssObject.set("taxtype", (Object)prepayTaxType.get("cswhjss"));
        if ("true".equals(project.getString("cswhjss"))) {
            BigDecimal rate = PrepayApplicationService.getTaxRate("CSWHJSS", project.getString("zone"), new Date(), new Date());
            if (null != rate) {
                cswhjssObject.set("prepayrate", (Object)(rate.toString() + "%"));
            }
            AccountEngineService.calculateEntryAmount(2, rate, prepayProjectType, taxPayerType, account, cswhjssObject, tcvatObject.getBigDecimal("prepayamount"));
            entryCollection.add((Object)cswhjssObject);
        }
        DynamicObject edufjsfObject = new DynamicObject((DynamicObjectType)subEntity);
        edufjsfObject.set("seq", (Object)3);
        edufjsfObject.set("taxtype", (Object)prepayTaxType.get("edufjsf"));
        if ("true".equals(project.getString("edufjsf"))) {
            DynamicObject assist = PrepayApplicationService.queryAssistData("JYFFJ", new Date(), new Date());
            BigDecimal prepayrate2 = null;
            if (null != assist) {
                prepayrate2 = assist.getBigDecimal("entryentity.fvalue1");
                edufjsfObject.set("prepayrate", (Object)(prepayrate2.toString() + "%"));
            }
            AccountEngineService.calculateEntryAmount(3, prepayrate2, prepayProjectType, taxPayerType, account, edufjsfObject, tcvatObject.getBigDecimal("prepayamount"));
            entryCollection.add((Object)edufjsfObject);
        }
        DynamicObject localObject = new DynamicObject((DynamicObjectType)subEntity);
        localObject.set("seq", (Object)4);
        localObject.set("taxtype", (Object)prepayTaxType.get("localedufjsfs"));
        if ("true".equals(project.getString("localedufjsfs"))) {
            DynamicObject assist = PrepayApplicationService.queryAssistData("DFJYFJ", new Date(), new Date());
            BigDecimal prepayrate3 = null;
            if (null != assist) {
                prepayrate3 = assist.getBigDecimal("entryentity.fvalue1");
                localObject.set("prepayrate", (Object)(prepayrate3.toString() + "%"));
            }
            AccountEngineService.calculateEntryAmount(4, prepayrate3, prepayProjectType, taxPayerType, account, localObject, tcvatObject.getBigDecimal("prepayamount"));
            entryCollection.add((Object)localObject);
        }
        DynamicObject tccitObject = new DynamicObject((DynamicObjectType)subEntity);
        tccitObject.set("seq", (Object)5);
        tccitObject.set("taxtype", (Object)prepayTaxType.get("tccit"));
        if ("true".equals(project.getString("tccit"))) {
            tccitObject.set("prepayrate", (Object)"0.2%");
            AccountEngineService.calculateEntryAmount(5, null, prepayProjectType, taxPayerType, account, tccitObject, null);
            entryCollection.add((Object)tccitObject);
        }
        DynamicObject yhsObject = new DynamicObject((DynamicObjectType)subEntity);
        yhsObject.set("seq", (Object)6);
        yhsObject.set("taxtype", (Object)prepayTaxType.get("yhs"));
        if ("true".equals(project.getString("yhs"))) {
            String yhstaxbasis = project.getString("yhstaxbasis");
            prepayrate = project.getBigDecimal("yhsratio").setScale(2, 4);
            yhsObject.set("prepayrate", (Object)(prepayrate.toString() + "%"));
            AccountEngineService.calculateEntryAmount(6, null, prepayProjectType, taxPayerType, account, yhsObject, null);
            if ("1".equals(yhstaxbasis)) {
                yhsObject.set("prepaybase", (Object)account.getBigDecimal("salesamount"));
                yhsObject.set("prepayamount", (Object)yhsObject.getBigDecimal("prepaybase").multiply(prepayrate).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP));
            }
            entryCollection.add((Object)yhsObject);
        }
        DynamicObject personalObject = new DynamicObject((DynamicObjectType)subEntity);
        personalObject.set("seq", (Object)7);
        personalObject.set("taxtype", (Object)prepayTaxType.get("personaltax"));
        if ("true".equals(project.getString("personaltax"))) {
            prepayrate = project.getBigDecimal("personalratio").setScale(2, 4);
            personalObject.set("prepayrate", (Object)(prepayrate.toString() + "%"));
            AccountEngineService.calculateEntryAmount(7, null, prepayProjectType, taxPayerType, account, personalObject, null);
            entryCollection.add((Object)personalObject);
        }
        DynamicObject ghjfObject = new DynamicObject((DynamicObjectType)subEntity);
        ghjfObject.set("seq", (Object)8);
        ghjfObject.set("taxtype", (Object)prepayTaxType.get("ghjf"));
        if ("true".equals(project.getString("ghjf"))) {
            BigDecimal prepayrate4 = project.getBigDecimal("ghjfratio").setScale(2, 4);
            ghjfObject.set("prepayrate", (Object)(prepayrate4.toString() + "%"));
            AccountEngineService.calculateEntryAmount(8, null, prepayProjectType, taxPayerType, account, ghjfObject, null);
            entryCollection.add((Object)ghjfObject);
        }
        DynamicObject hjbhsObject = new DynamicObject((DynamicObjectType)subEntity);
        hjbhsObject.set("seq", (Object)9);
        hjbhsObject.set("taxtype", (Object)prepayTaxType.get("hjbhs"));
        if ("true".equals(project.getString("hjbhs"))) {
            BigDecimal prepayrate5 = project.getBigDecimal("hjbhsratio").setScale(2, 4);
            hjbhsObject.set("prepayrate", (Object)(prepayrate5.toString() + "%"));
            AccountEngineService.calculateEntryAmount(9, null, prepayProjectType, taxPayerType, account, hjbhsObject, null);
            entryCollection.add((Object)hjbhsObject);
        }
        DynamicObject sljsjjObject = new DynamicObject((DynamicObjectType)subEntity);
        sljsjjObject.set("seq", (Object)10);
        sljsjjObject.set("taxtype", (Object)prepayTaxType.get("sljsjj"));
        if ("true".equals(project.getString("sljsjj"))) {
            String sljsjjbillingbasis = project.getString("sljsjjbillingbasis");
            BigDecimal prepayrate6 = project.getBigDecimal("sljsjjratio").setScale(2, 4);
            sljsjjObject.set("prepayrate", (Object)(prepayrate6.toString() + "%"));
            AccountEngineService.calculateEntryAmount(10, null, prepayProjectType, taxPayerType, account, sljsjjObject, null);
            if ("1".equals(sljsjjbillingbasis)) {
                BigDecimal prepayamount = tcvatObject.getBigDecimal("prepayamount");
                sljsjjObject.set("prepaybase", (Object)prepayamount);
                sljsjjObject.set("prepayamount", (Object)sljsjjObject.getBigDecimal("prepaybase").multiply(prepayrate6).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP));
            }
            entryCollection.add((Object)sljsjjObject);
        }
        account.set("entryentity", (Object)entryCollection);
    }

    public static BigDecimal getAccountingAmount(List<DynamicObject> accountingList) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (DynamicObject invoice : accountingList) {
            totalAmount = totalAmount.add(invoice.getBigDecimal("amount"));
        }
        return totalAmount;
    }

    public static List<DynamicObject> getPrerate(DynamicObject[] preRateDynamics, String orgid) {
        ArrayList<DynamicObject> parentTableIdList = new ArrayList<DynamicObject>();
        for (DynamicObject object : preRateDynamics) {
            Boolean exists = (Boolean)TaxcMainDataServiceHelper.queryTaxcMainByOrgIdAndWhereJson((Long)Long.parseLong(orgid), (String)object.getString("conditionjson")).getData();
            if (!exists.booleanValue()) continue;
            parentTableIdList.add(object);
        }
        return parentTableIdList;
    }

    public static BigDecimal getPrepayBase(DynamicObject subObject, String prepayProjectType, DynamicObject account, BigDecimal prepayBase) {
        switch (prepayProjectType) {
            case "VAT_YJXMLX_001": 
            case "VAT_YJXMLX_002": {
                if ("normal".equals(account.getString("levytype"))) {
                    prepayBase = account.getBigDecimal("salesamount").divide(BigDecimal.valueOf(1.09), 2, 4);
                    subObject.set("prepayamount", (Object)new BigDecimal("1.09"));
                }
                if ("simple".equals(account.getString("levytype"))) {
                    prepayBase = account.getBigDecimal("salesamount").divide(BigDecimal.valueOf(1.03), 2, 4);
                    subObject.set("prepayamount", (Object)new BigDecimal("1.03"));
                }
                return prepayBase;
            }
            case "VAT_YJXMLX_003": 
            case "VAT_YJXMLX_005": {
                if ("normal".equals(account.getString("levytype"))) {
                    prepayBase = account.getBigDecimal("salesamount").divide(BigDecimal.valueOf(1.09), 2, 4);
                    subObject.set("prepayamount", (Object)new BigDecimal("1.09"));
                }
                if ("simple".equals(account.getString("levytype"))) {
                    prepayBase = account.getBigDecimal("salesamount").divide(BigDecimal.valueOf(1.05), 2, 4);
                    subObject.set("prepayamount", (Object)new BigDecimal("1.05"));
                }
                return prepayBase;
            }
            case "VAT_YJXMLX_004": {
                prepayBase = account.getBigDecimal("salesamount").divide(BigDecimal.valueOf(1.05), 2, 4);
                subObject.set("prepayamount", (Object)new BigDecimal("1.05"));
                return prepayBase;
            }
        }
        subObject.set("prepayamount", (Object)new BigDecimal("1"));
        return prepayBase;
    }

    static {
        prepayTypeToSubject.put("VAT_YJXMLX_001", ResManager.loadKDString((String)"\u9500\u552e\u5efa\u7b51\u670d\u52a1", (String)"AccountEngineService_0", (String)"taxc-tcvat", (Object[])new Object[0]));
        prepayTypeToSubject.put("VAT_YJXMLX_002", ResManager.loadKDString((String)"\u9500\u552e\u5efa\u7b51\u670d\u52a1", (String)"AccountEngineService_0", (String)"taxc-tcvat", (Object[])new Object[0]));
        prepayTypeToSubject.put("VAT_YJXMLX_003", ResManager.loadKDString((String)"\u9500\u552e\u81ea\u884c\u5f00\u53d1\u623f\u5730\u4ea7", (String)"AccountEngineService_1", (String)"taxc-tcvat", (Object[])new Object[0]));
        prepayTypeToSubject.put("VAT_YJXMLX_004", ResManager.loadKDString((String)"\u9500\u552e\u4e0d\u52a8\u4ea7\uff08\u975e\u623f\u5730\u4ea7\u4f01\u4e1a\uff09", (String)"AccountEngineService_2", (String)"taxc-tcvat", (Object[])new Object[0]));
        prepayTypeToSubject.put("VAT_YJXMLX_005", ResManager.loadKDString((String)"\u4e0d\u52a8\u4ea7\u7ecf\u8425\u79df\u8d41", (String)"AccountEngineService_3", (String)"taxc-tcvat", (Object[])new Object[0]));
        prepayTaxType.put("tcvat", ResManager.loadKDString((String)"\u589e\u503c\u7a0e", (String)"AccountEngineService_4", (String)"taxc-tcvat", (Object[])new Object[0]));
        prepayTaxType.put("tccit", ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e", (String)"AccountEngineService_5", (String)"taxc-tcvat", (Object[])new Object[0]));
        prepayTaxType.put("cswhjss", ResManager.loadKDString((String)"\u57ce\u5e02\u5efa\u8bbe\u7ef4\u62a4\u7a0e", (String)"AccountEngineService_6", (String)"taxc-tcvat", (Object[])new Object[0]));
        prepayTaxType.put("edufjsf", ResManager.loadKDString((String)"\u6559\u80b2\u9644\u52a0\u7a0e", (String)"AccountEngineService_7", (String)"taxc-tcvat", (Object[])new Object[0]));
        prepayTaxType.put("localedufjsfs", ResManager.loadKDString((String)"\u5730\u65b9\u6559\u80b2\u9644\u52a0\u7a0e", (String)"AccountEngineService_8", (String)"taxc-tcvat", (Object[])new Object[0]));
        prepayTaxType.put("personaltax", ResManager.loadKDString((String)"\u4e2a\u4eba\u6240\u5f97\u7a0e", (String)"AccountEngineService_9", (String)"taxc-tcvat", (Object[])new Object[0]));
        prepayTaxType.put("yhs", ResManager.loadKDString((String)"\u5370\u82b1\u7a0e", (String)"AccountEngineService_10", (String)"taxc-tcvat", (Object[])new Object[0]));
        prepayTaxType.put("ghjf", ResManager.loadKDString((String)"\u5de5\u4f1a\u7ecf\u8d39", (String)"AccountEngineService_11", (String)"taxc-tcvat", (Object[])new Object[0]));
        prepayTaxType.put("hjbhs", ResManager.loadKDString((String)"\u73af\u5883\u4fdd\u62a4\u7a0e", (String)"AccountEngineService_12", (String)"taxc-tcvat", (Object[])new Object[0]));
        prepayTaxType.put("sljsjj", ResManager.loadKDString((String)"\u6c34\u5229\u5efa\u8bbe\u57fa\u91d1", (String)"AccountEngineService_13", (String)"taxc-tcvat", (Object[])new Object[0]));
    }
}

