/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.prepay.project;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.tctb.helper.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class ProjectService {
    public static void beforeImportData(BeforeImportDataEventArgs e) {
        DynamicObject accountOrg;
        JSONObject org;
        String orgNumber;
        Date date;
        Map sourceData = e.getSourceData();
        JSONObject taxoffice = (JSONObject)sourceData.get("taxoffice");
        Object number = taxoffice.get((Object)"number");
        QFilter[] qFilters = new QFilter("number", "=", number).and(new QFilter("start", "<", (Object)(date = new Date()))).and(new QFilter("end", ">=", (Object)date).or(QFilter.isNull((String)"end"))).toArray();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"tpo_taxorgan_tree", (String)"id,number,start,end", (QFilter[])qFilters);
        if (dynamicObject != null) {
            taxoffice.put("id", dynamicObject.get("id"));
        }
        if (StringUtil.isNotEmpty((CharSequence)(orgNumber = (org = (JSONObject)sourceData.get("org")).getString("number"))) && (accountOrg = QueryServiceHelper.queryOne((String)"bos_org", (String)"id,number", (QFilter[])new QFilter("number", "=", (Object)orgNumber).toArray())) != null) {
            List taxOrgID = TaxOrgTakeRelationServiceHelper.getTaxOrgByAccountingOrg((Long)accountOrg.getLong("id"), (Date)new Date());
            if (taxOrgID.size() > 0) {
                JSONObject taxOrg = new JSONObject();
                taxOrg.put("importprop", (Object)"id");
                taxOrg.put("id", taxOrgID.get(0));
                sourceData.put("taxorg", taxOrg);
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u7ec4\u7ec7\u53d6\u6570\u5173\u7cfb", (String)"ProjectService_0", (String)"taxc-tcvat", (Object[])new Object[0]));
            }
        }
    }

    public static void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection datas = super.getData(start, limit);
                List idList = datas.stream().map(a -> a.getLong("id")).collect(Collectors.toList());
                DynamicObject[] load = BusinessDataServiceHelper.load((String)"tcvat_prepay_project_info", (String)"id,projectzone", (QFilter[])new QFilter("id", "in", idList).toArray());
                Map<Object, Object> zoneMap = Arrays.asList(load).stream().collect(Collectors.toMap(a -> a.get("id"), a -> a.get("projectzone")));
                for (DynamicObject data : datas) {
                    String address;
                    DynamicObject dynamicObject;
                    data.set("address", (Object)"");
                    Object zoneObj = zoneMap.get(data.get("id"));
                    if (zoneObj == null || (dynamicObject = QueryServiceHelper.queryOne((String)"bd_admindivision", (String)"country,fullname,longnumber,number,name,parent", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf((String)zoneObj))})) == null || dynamicObject.get("fullname") == null || (address = (String)dynamicObject.get("fullname")) == null) continue;
                    data.set("address", (Object)address.replace('_', '/'));
                }
                return datas;
            }
        });
    }
}

