/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.rule;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class IncomeRuleService {
    private static final String EXPORTINGSTATUS = "1";
    public static final ArrayList<String> export_taxation = Lists.newArrayList((Object[])new String[]{"Export_02", "Export_01"});

    public boolean isExporting(Object status) {
        return Objects.equals(EXPORTINGSTATUS, status);
    }

    public Map<String, DynamicObject> megerTaxBusinessType(ListSelectedRowCollection listSelectedRows, String orgid, String taxPayerType) {
        List ids = listSelectedRows.stream().map(lsr -> Long.parseLong(lsr.getPrimaryKeyValue().toString())).collect(Collectors.toList());
        Map<Object, DynamicObject> mergeCodeObject = this.loadTaxrateentryById(ids.toArray());
        ArrayList<String> mergeCode = new ArrayList<String>(mergeCodeObject.size());
        for (DynamicObject object : mergeCodeObject.values()) {
            mergeCode.add(object.getString("mergecode"));
        }
        return this.mergeProperty(mergeCode, orgid, taxPayerType);
    }

    private Map<String, DynamicObject> mergeProperty(List<String> mergeCode, String orgid, Object taxpayertype) {
        Map<Object, DynamicObject> conditionjson = this.queryConditionJson(taxpayertype);
        List<Long> parentTableIdList = this.getParentTableId(orgid, conditionjson);
        DynamicObjectCollection collection = this.queryTaxrateentryByFilter(mergeCode, parentTableIdList);
        return IncomeRuleService.mergeObject(collection);
    }

    private static Map<String, DynamicObject> mergeObject(DynamicObjectCollection collection) {
        HashMap<String, DynamicObject> resultMap = new HashMap<String, DynamicObject>(32);
        for (DynamicObject object : collection) {
            String key = object.get("mergecode").toString();
            if (null == resultMap.get(key)) {
                resultMap.put(key, object);
                continue;
            }
            DynamicObject temDynamicObject = (DynamicObject)resultMap.get(key);
            temDynamicObject.set("taxrate", (Object)IncomeRuleService.mergeAndDistinct(temDynamicObject.get("taxrate").toString(), object.get("taxrate").toString()));
            temDynamicObject.set("taxmethod", (Object)IncomeRuleService.mergeAndDistinct(temDynamicObject.get("taxmethod").toString(), object.get("taxmethod").toString()));
            resultMap.put(key, temDynamicObject);
        }
        return resultMap;
    }

    private static String mergeAndDistinct(String mapProperty, String objectProperty) {
        String mergeProperty = mapProperty.concat("\u3001").concat(objectProperty);
        String propertys = StringUtils.join((Object[])Arrays.stream(mergeProperty.split("\\\u3001")).distinct().collect(Collectors.toList()).toArray(new String[0]), (String)"\u3001");
        return propertys;
    }

    public List<String> getTaxRateList(Map<String, DynamicObject> taxrates, String taxPayerType) {
        List rateList = null;
        for (Map.Entry<String, DynamicObject> entry : taxrates.entrySet()) {
            String taxrate = entry.getValue().getString("taxrate");
            ArrayList list1 = Lists.newArrayList((Object[])taxrate.split("\u3001"));
            if (rateList == null) {
                rateList = list1;
                continue;
            }
            rateList.removeIf(next -> !list1.contains(next));
        }
        if (rateList != null && "xgmnsr".equals(taxPayerType)) {
            rateList.add("1%");
        }
        return rateList;
    }

    public List<String> getTaxActionList(Map<String, DynamicObject> taxrates, String taxPayerType, Object exportingStatus) {
        Iterable zsfsList = null;
        for (Map.Entry<String, DynamicObject> entry : taxrates.entrySet()) {
            String taxmethod = entry.getValue().getString("taxmethod");
            ArrayList list = Lists.newArrayList((Object[])taxmethod.split("\u3001"));
            if (zsfsList == null) {
                zsfsList = list;
                continue;
            }
            zsfsList.removeIf(next -> !list.contains(next));
        }
        ArrayList<String> list = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(zsfsList)) {
            if (null != zsfsList) {
                zsfsList.forEach(zsfs -> {
                    if (zsfs.contains(ResManager.loadKDString((String)"3%\u7b80\u6613\u5f81\u6536", (String)"IncomeRuleService_0", (String)"taxc-tcvat", (Object[])new Object[0]))) {
                        list.add("JYZS_3");
                    } else if (zsfs.contains(ResManager.loadKDString((String)"5%\u7b80\u6613\u5f81\u6536", (String)"IncomeRuleService_1", (String)"taxc-tcvat", (Object[])new Object[0]))) {
                        list.add("JYZS_5");
                    } else if ("ybnsr".equals(taxPayerType) && zsfs.contains(ResManager.loadKDString((String)"\u4e00\u822c\u8ba1\u7a0e", (String)"IncomeRuleService_2", (String)"taxc-tcvat", (Object[])new Object[0]))) {
                        list.add("YBJS");
                    } else if (zsfs.contains(ResManager.loadKDString((String)"\u514d\u7a0e", (String)"IncomeRuleService_3", (String)"taxc-tcvat", (Object[])new Object[0]))) {
                        list.add("MS");
                    }
                });
            }
            if ("xgmnsr".equals(taxPayerType)) {
                list.add("JYZS_1");
            }
            if (this.isExporting(exportingStatus)) {
                list.addAll(export_taxation);
            }
        }
        return list;
    }

    public QFilter getTaxRateNumberFilter(String taxratestr, DynamicObject taxation) {
        if (null == taxation) {
            return new QFilter("number", "in", (Object)taxratestr.split(","));
        }
        if ("JYZS_3".equals(taxation.getString("number"))) {
            return new QFilter("number", "=", (Object)"3%");
        }
        if ("JYZS_5".equals(taxation.getString("number"))) {
            return new QFilter("number", "=", (Object)"5%");
        }
        if ("JYZS_1".equals(taxation.getString("number"))) {
            return new QFilter("number", "=", (Object)"1%");
        }
        return new QFilter("number", "in", (Object)taxratestr.split(","));
    }

    public boolean validateEntityEmpty(DynamicObjectCollection ... collections) {
        IncomeRuleService incomeRuleService = new IncomeRuleService();
        boolean isEmpty = true;
        List<String> originalFields = Arrays.asList("bizname", "table", "amountfield");
        if (collections != null) {
            for (DynamicObjectCollection collection : collections) {
                List<String> fields;
                String entryentity = collection.getDynamicObjectType().getName();
                if (Objects.equals(entryentity, "invoiceentity")) {
                    fields = Collections.singletonList("invoicebizname");
                } else {
                    String suffix = entryentity.replace("entryentity", "");
                    fields = originalFields.stream().map(a -> a + suffix).collect(Collectors.toList());
                }
                if (incomeRuleService.validateEntityEmpty(collection, fields)) continue;
                isEmpty = false;
                break;
            }
        }
        return isEmpty;
    }

    public boolean validateEntityEmpty(DynamicObjectCollection dynamicObjectCollection, List<String> fields) {
        boolean isEmpty = true;
        int validCount = 0;
        for (DynamicObject object : dynamicObjectCollection) {
            boolean valid = true;
            for (String field : fields) {
                if (object.get(field) != null) continue;
                valid = false;
                break;
            }
            if (!valid) continue;
            ++validCount;
        }
        if (validCount > 0) {
            isEmpty = false;
        }
        return isEmpty;
    }

    private List<Long> getParentTableId(String orgid, Map<Object, DynamicObject> conditionjson) {
        ArrayList<Long> parentTableIdList = new ArrayList<Long>();
        for (DynamicObject object : conditionjson.values()) {
            Boolean exists = (Boolean)TaxcMainDataServiceHelper.queryTaxcMainByOrgIdAndWhereJson((Long)Long.parseLong(orgid), (String)object.getString("conditionjson")).getData();
            if (!exists.booleanValue()) continue;
            parentTableIdList.add(object.getLong("id"));
        }
        return parentTableIdList;
    }

    private Map<Object, DynamicObject> queryConditionJson(Object taxpayertype) {
        Date now = new Date();
        QFilter startdate = new QFilter("startdate", "<=", (Object)now);
        QFilter enddate = new QFilter("enddate", ">=", (Object)now).or(QFilter.isNull((String)"enddate"));
        QFilter taxpayertypeFilter = new QFilter("taxpayertype", "=", taxpayertype);
        Map conditionjson = BusinessDataServiceHelper.loadFromCache((String)"tpo_tcvat_taxrate", (String)"id,conditionjson", (QFilter[])new QFilter[]{startdate, enddate, taxpayertypeFilter});
        return conditionjson;
    }

    private Map<Object, DynamicObject> loadTaxrateentryById(Object[] idsArray) {
        return BusinessDataServiceHelper.loadFromCache((Object[])idsArray, (String)"tpo_tcvat_taxrateentry");
    }

    private DynamicObjectCollection queryTaxrateentryByFilter(List<String> mergeCode, List<Long> parentTableIdList) {
        QFilter codeFilter = new QFilter("mergecode", "in", mergeCode);
        QFilter idFilter = new QFilter("taxrange", "in", parentTableIdList);
        return QueryServiceHelper.query((String)"tpo_tcvat_taxrateentry", (String)"id,number,isleaf,mergecode,name,taxmethod,parent,enable,taxrate", (QFilter[])new QFilter[]{codeFilter, idFilter});
    }
}

