/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.rule;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IPageCache;
import kd.taxc.bdtaxr.common.history.BaseDataHistoryService;

public class RuleHistoryService {
    public static void setValue(IDataModel getModel, JSONObject object, String entryName, String prefex, String entryRow) {
        JSONArray entryentity = object.getJSONArray(entryName);
        for (int i = 0; i < entryentity.size(); ++i) {
            int index = getModel.createNewEntryRow(entryRow + "entryentity");
            JSONObject entry = entryentity.getJSONObject(i);
            getModel.setValue(prefex + "bizname", (Object)entry.getString(prefex + "bizname"), index);
            getModel.setValue(prefex + "table", (Object)entry.getJSONObject(prefex + "table").getString("bizname"), index);
            getModel.setValue(prefex + "amountfield", (Object)entry.getJSONObject(prefex + "amountfield").getString("bizsubname"), index);
            getModel.setValue(prefex + "absolute", (Object)entry.getString(prefex + "absolute"), index);
            getModel.setValue(prefex + "datatype", (Object)entry.getString(prefex + "datatype"), index);
            getModel.setValue(prefex + "datadirection", (Object)entry.getString(prefex + "datadirection"), index);
            getModel.setValue(prefex + "filtercondition", (Object)entry.getString(prefex + "filtercondition"), index);
        }
    }

    public static void setTcvatRule(IDataModel getModel, IPageCache getPageCache, JSONObject object, String prefex, Map<String, String> jzjtMap) {
        JSONArray rulesArray = object.getJSONArray(prefex.toUpperCase());
        if (rulesArray != null && rulesArray.size() > 0) {
            for (int i = 0; i < rulesArray.size(); ++i) {
                JSONObject jsonObject = rulesArray.getJSONObject(i);
                getPageCache.put(prefex.toUpperCase() + jsonObject.getString("id"), SerializationUtils.toJsonString((Object)jsonObject));
                String replacePreFex = prefex.replace("_", "");
                int index = getModel.createNewEntryRow(replacePreFex + "entry");
                getModel.setValue(replacePreFex + "entryid", (Object)jsonObject.getLong("id"), index);
                getModel.setValue(replacePreFex + "type", (Object)jsonObject.getJSONObject(replacePreFex + "type").getString("value"), index);
                getModel.setValue(replacePreFex + "rulename", (Object)jsonObject.getJSONObject("name").getString("zh_CN"), index);
                getModel.setValue(replacePreFex + "org", (Object)jsonObject.getJSONObject("org").getString("name"), index);
                getModel.setValue(replacePreFex + "jzjt", (Object)jzjtMap.get(jsonObject.getString("jzjt")), index);
                getModel.setValue(replacePreFex + "ruletype", (Object)jsonObject.getString("ruletype"), index);
                getModel.setValue(replacePreFex + "enable", (Object)jsonObject.getString("enable"), index);
            }
        }
    }

    private static Map<String, String> getTaxerTypeMap() {
        return new HashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("ybnsr", ResManager.loadKDString((String)"\u4e00\u822c\u7eb3\u7a0e\u4eba", (String)"RuleHistoryService_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                this.put("xgmnsr", ResManager.loadKDString((String)"\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba", (String)"RuleHistoryService_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                this.put("zzsybnsr_zjg", ResManager.loadKDString((String)"\u4e00\u822c\u7eb3\u7a0e\u4eba\u603b\u673a\u6784\u6c47\u603b\u7533\u62a5", (String)"RuleHistoryService_2", (String)"taxc-tcvat", (Object[])new Object[0]));
                this.put("zzsybnsr_fzjg", ResManager.loadKDString((String)"\u4e00\u822c\u7eb3\u7a0e\u4eba\u5206\u652f\u673a\u6784\u6c47\u603b\u7533\u62a5", (String)"RuleHistoryService_3", (String)"taxc-tcvat", (Object[])new Object[0]));
                this.put("zzsybnsr_ybhz", ResManager.loadKDString((String)"\u4e00\u822c\u7eb3\u7a0e\u4eba\u603b\u673a\u6784\u4e00\u822c\u4f01\u4e1a\u6c47\u603b\u7533\u62a5", (String)"RuleHistoryService_4", (String)"taxc-tcvat", (Object[])new Object[0]));
            }
        };
    }

    private static Map<String, String> getDeadlineMap() {
        return new HashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("aysb", ResManager.loadKDString((String)"\u6309\u6708\u7533\u62a5", (String)"RuleHistoryService_5", (String)"taxc-tcvat", (Object[])new Object[0]));
                this.put("ajsb", ResManager.loadKDString((String)"\u6309\u5b63\u7533\u62a5", (String)"RuleHistoryService_6", (String)"taxc-tcvat", (Object[])new Object[0]));
                this.put("acsb", ResManager.loadKDString((String)"\u6309\u6b21\u7533\u62a5", (String)"RuleHistoryService_7", (String)"taxc-tcvat", (Object[])new Object[0]));
            }
        };
    }

    private static Map<String, String> getLevyTypeMap() {
        return new HashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("czzs", ResManager.loadKDString((String)"\u67e5\u8d26\u5f81\u6536", (String)"RuleHistoryService_8", (String)"taxc-tcvat", (Object[])new Object[0]));
                this.put("hdzs", ResManager.loadKDString((String)"\u6838\u5b9a\u5f81\u6536", (String)"RuleHistoryService_9", (String)"taxc-tcvat", (Object[])new Object[0]));
                this.put("aqhz", ResManager.loadKDString((String)"\u6309\u671f\u6c47\u603b", (String)"RuleHistoryService_10", (String)"taxc-tcvat", (Object[])new Object[0]));
            }
        };
    }

    public static void initPolicy(String orgId, Date startDate, Date endDate, IDataModel getModel) {
        String json = BaseDataHistoryService.queryBaseDataHistory((long)Long.parseLong(orgId), (String)"tctb_tax_main", (Date)startDate, (Date)endDate);
        if (!json.isEmpty()) {
            String taxpayertype = "";
            String deadline = "";
            String levytype = "";
            String registeraddress = "";
            String codeandname = "";
            Object object = JSONObject.parse((String)json);
            if (object instanceof JSONArray) {
                JSONArray array = (JSONArray)object;
                for (Object obj : array) {
                    JSONObject jsobj = (JSONObject)obj;
                    JSONArray categoryentryentity = jsobj.getJSONArray("categoryentryentity");
                    for (Object cate : categoryentryentity) {
                        JSONObject catev = (JSONObject)cate;
                        if (!"zzs".equals(catev.get((Object)"taxtype"))) continue;
                        taxpayertype = RuleHistoryService.getTaxerTypeMap().get(catev.get((Object)"taxpayertype"));
                        deadline = RuleHistoryService.getDeadlineMap().get(catev.get((Object)"deadline"));
                        levytype = RuleHistoryService.getLevyTypeMap().get(catev.get((Object)"levytype"));
                        break;
                    }
                    registeraddress = (String)jsobj.get((Object)"registeraddress");
                    JSONObject codeObj = jsobj.getJSONObject("codeandname");
                    if (null == codeObj || null == codeObj.getJSONObject("name")) continue;
                    codeandname = codeObj.getJSONObject("name").getString("zh_CN");
                }
            }
            getModel.setValue("taxpayertype", (Object)taxpayertype);
            getModel.setValue("deadline", (Object)deadline);
            getModel.setValue("levytype", (Object)levytype);
            getModel.setValue("registeraddress", (Object)registeraddress);
            getModel.setValue("codeandname", (Object)codeandname);
        }
    }

    public static void initPolicyHz(String orgId, Date startDate, Date endDate, IDataModel getModel) {
        Object object;
        String json = BaseDataHistoryService.queryBaseDataHistory((long)Long.parseLong(orgId), (String)"tctb_org_group_latest", (Date)startDate, (Date)endDate);
        if (!json.isEmpty() && (object = JSONObject.parse((String)json)) instanceof JSONArray) {
            JSONArray array = (JSONArray)object;
            for (Object obj : array) {
                JSONObject jsobj = (JSONObject)obj;
                Date effectdate = jsobj.getDate("effectdate");
                Date invaliddate = jsobj.getDate("invaliddate");
                if (effectdate == null || startDate == null || endDate == null || startDate.compareTo(effectdate) < 0 || invaliddate != null && invaliddate.compareTo(endDate) < 0) continue;
                JSONArray orgrow = jsobj.getJSONArray("orgrow");
                for (Object org : orgrow) {
                    JSONObject orgidJson;
                    JSONObject orgJson = (JSONObject)org;
                    if (orgJson == null || (orgidJson = orgJson.getJSONObject("orgid")) == null) continue;
                    Long orgidLong = orgidJson.getLong("id");
                    if (Long.parseLong(orgId) != orgidLong) continue;
                    getModel.setValue("hzqylx", (Object)jsobj.getString("summaryorgtype"));
                    getModel.setValue("hzfs", (Object)jsobj.getString("summaryway"));
                    return;
                }
            }
        }
    }
}

