/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.rule;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.MulComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.draft.fi.GetGLBalanceCommonUtil;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.FilterBuilderUtils;
import kd.taxc.bdtaxr.common.util.bean.BeanCopyUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcvat.business.service.draft.PeriodService;
import kd.taxc.tcvat.business.service.draft.metadata.handler.hz.nssb.NssbHzDraftMetaDataEnum;
import kd.taxc.tcvat.business.service.draft.metadata.handler.hz.sjjt.SjjtHzDraftMetaDataEnum;
import kd.taxc.tcvat.business.service.draft.metadata.handler.xgmnsr.nssb.NssbXgmnsrDraftMetaDataEnum;
import kd.taxc.tcvat.business.service.draft.metadata.handler.xgmnsr.sjjt.SjjtXgmnsrDraftMetaDataEnum;
import kd.taxc.tcvat.business.service.draft.metadata.handler.ybnsr.nssb.NssbYbnsrDraftMetaDataEnum;
import kd.taxc.tcvat.business.service.draft.metadata.handler.ybnsr.sjjt.SjjtYbnsrDraftMetaDataEnum;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.engine.task.NewRuleSettingTask;
import kd.taxc.tcvat.business.service.engine.task.util.InvoiceTaskUtils;
import kd.taxc.tcvat.business.service.engine.task.util.NewRuleSettingUtils;
import kd.taxc.tcvat.business.service.engine.task.util.RuleSettingUtils;
import kd.taxc.tcvat.common.enums.RuleTypeStrategyEnum;

public class RuleService {
    private static final Log logger = LogFactory.getLog(RuleService.class);
    private static final BigDecimal ONE_HUNDRED = new BigDecimal("100");
    public static List<Long> VAT_RULE_ROOT_ID = new ArrayList<Long>(){
        {
            this.add(1870275165167180800L);
            this.add(1874049518841207808L);
            this.add(1890542731327992832L);
            this.add(1891259292422731776L);
            this.add(1891379628287987712L);
            this.add(1891408247651556352L);
        }
    };

    public void addRuleFilter(String entityType, String entryName, Boolean differenceInvoice, String taxRate, boolean isQtfpqsAndXxsr, boolean isQtfpseAndXxse, boolean isWkpseAndXxse, List<QFilter> filterList) {
        if (entryName.equals("sim_vatinvoice")) {
            filterList.add(QFilter.isNotNull((String)"items.goodscode").and("items.goodscode", "!=", (Object)" ").and("items.goodscode", "!=", (Object)""));
        }
        if (entryName.equals("tdm_invoice_output")) {
            filterList.add(new QFilter("invoicestatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"0", "3"})));
        }
        BigDecimal rate = BigDecimal.ZERO;
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)taxRate)) {
            taxRate = NewRuleSettingUtils.trimTaxRate(taxRate);
            rate = new BigDecimal(taxRate.replaceAll("%", "")).divide(ONE_HUNDRED).setScale(2);
        }
        if (isQtfpqsAndXxsr || isQtfpseAndXxse) {
            InvoiceTaskUtils.setRateFilter(filterList, "items.taxrate", rate, differenceInvoice, entryName);
            logger.info("1 \u7a0e\u7387\u914d\u7f6e\u6761\u4ef6" + JsonUtil.toJson((Object)filterList.toString()));
        }
        if (isWkpseAndXxse) {
            InvoiceTaskUtils.setRateFilter(filterList, "taxrate", rate, differenceInvoice, entryName);
            logger.info("2 \u7a0e\u7387\u914d\u7f6e\u6761\u4ef6" + JsonUtil.toJson((Object)filterList.toString()));
        }
        if (Arrays.asList("tcvat_accdetail_rollout", "tcvat_hz_accdetail_rout").contains(entityType) && org.apache.commons.lang.StringUtils.equals((String)"tcvat_input_invoice_sign", (String)entryName)) {
            QFilter signStatusFilter = new QFilter("signstatus", "=", (Object)"1");
            filterList.add(signStatusFilter);
        }
    }

    public QFilter specialInvoiceInitQFilter() {
        return new QFilter("baseinvoicetype.number", "in", Arrays.asList("2", "4", "27"));
    }

    public String getRulePurposeName(String ruleEntity, String rulePurpose) {
        if (org.apache.commons.lang.StringUtils.isBlank((String)ruleEntity) || org.apache.commons.lang.StringUtils.isBlank((String)rulePurpose)) {
            return "";
        }
        MulComboProp rulepurposeProp = (MulComboProp)MetadataServiceHelper.getDataEntityType((String)ruleEntity).getProperty("rulepurpose");
        return Arrays.stream(rulePurpose.split(",")).filter(StringUtils::isNotBlank).map(arg_0 -> ((MulComboProp)rulepurposeProp).getItemByName(arg_0)).collect(Collectors.joining("\u3001"));
    }

    public boolean isIncomeRuleSumEntry(String entity) {
        return SjjtYbnsrDraftMetaDataEnum.INCOME.getAccountMetaDataName().equals(entity) || NssbYbnsrDraftMetaDataEnum.INCOME.getAccountMetaDataName().equals(entity) || NssbHzDraftMetaDataEnum.INCOME.getAccountMetaDataName().equals(entity) || SjjtHzDraftMetaDataEnum.INCOME.getAccountMetaDataName().equals(entity) || NssbXgmnsrDraftMetaDataEnum.INCOME.getAccountMetaDataName().equals(entity) || SjjtXgmnsrDraftMetaDataEnum.INCOME.getAccountMetaDataName().equals(entity);
    }

    public boolean isPatialPerpayRuleSumEntry(String entity) {
        return SjjtYbnsrDraftMetaDataEnum.PERPRE.getAccountMetaDataName().equals(entity) || NssbYbnsrDraftMetaDataEnum.PERPRE.getAccountMetaDataName().equals(entity) || NssbHzDraftMetaDataEnum.PERPRE.getAccountMetaDataName().equals(entity) || SjjtHzDraftMetaDataEnum.PERPRE.getAccountMetaDataName().equals(entity);
    }

    public void setGlFilter(String entryName, String amountName, Date start, Date end, List<QFilter> filterList) {
        boolean isBeginOrEnd = GetGLBalanceCommonUtil.conditionCheck((String)entryName, (String)amountName);
        if (isBeginOrEnd) {
            if (StringUtil.startsWith((CharSequence)amountName, (CharSequence)"begin")) {
                for (QFilter filter : filterList) {
                    if ("period.begindate".equals(filter.getProperty()) && "<=".equals(filter.getCP())) {
                        filter.__setProperty("endperiod.begindate");
                        filter.__setCP(">");
                        filter.__setValue((Object)DateUtils.getLastDateOfMonth((Date)start));
                        filter.or("endperiod.begindate", "is null", null);
                    }
                    if (!"period.begindate".equals(filter.getProperty()) || !">=".equals(filter.getCP())) continue;
                    filter.__setProperty("period.enddate");
                    filter.__setCP("=");
                    filter.__setValue((Object)DateUtils.getLastDateOfMonth((Date)start));
                    filter.or(new QFilter("period.enddate", "<", (Object)DateUtils.getLastDateOfMonth((Date)start)));
                }
            }
            if (StringUtil.startsWith((CharSequence)amountName, (CharSequence)"end")) {
                for (QFilter filter : filterList) {
                    if ("period.begindate".equals(filter.getProperty()) && ">=".equals(filter.getCP())) {
                        filter.__setProperty("endperiod.begindate");
                        filter.__setCP(">");
                        filter.__setValue((Object)DateUtils.getLastDateOfMonth((Date)end));
                        filter.or("endperiod.begindate", "is null", null);
                    }
                    if (!"period.begindate".equals(filter.getProperty()) || !"<=".equals(filter.getCP())) continue;
                    filter.__setProperty("period.enddate");
                    filter.__setValue((Object)DateUtils.getLastDateOfMonth((Date)end));
                }
            }
        }
    }

    public void setDateFilter(String dataField, String entityType, String entryName, String taxperiod, Date firstDayOfMonth, Date lastDayOfMonth, List<QFilter> filterList) {
        if (null != dataField) {
            if (org.apache.commons.lang.StringUtils.equals((String)"til_in_transfer_out_bill", (String)entryName)) {
                QFilter periodFilter = new QFilter(dataField, "=", (Object)DateUtils.stringToDate((String)DateUtils.format((Date)firstDayOfMonth, (String)"yyyy-MM-dd HH:mm:ss")));
                filterList.add(periodFilter);
            } else {
                QFilter startFilter = new QFilter(dataField, ">=", (Object)firstDayOfMonth);
                QFilter endFilter = new QFilter(dataField, "<=", (Object)lastDayOfMonth);
                filterList.add(startFilter);
                filterList.add(endFilter);
            }
        }
    }

    public QFilter parseCondition(String conditionjson, String entryName) {
        QFilter conditionFilters = null;
        if (StringUtils.isNotBlank((CharSequence)conditionjson)) {
            if ((entryName.equals("gl_voucher") || entryName.equals("gl_balance")) && conditionjson.contains("assgrp")) {
                conditionjson = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"RuleFilterService", (String)"setAssgrpConditionJson", (Object[])new Object[]{conditionjson});
            }
            if ((conditionFilters = FilterBuilderUtils.buildFilter((String)conditionjson, (String)entryName)) != null) {
                if (entryName.equals("sim_vatinvoice") && conditionjson.contains("taxrate")) {
                    conditionFilters = RuleSettingUtils.dealRate(conditionFilters);
                }
                logger.info("0 \u89c4\u5219\u914d\u7f6e\u6761\u4ef6" + JsonUtil.toJson((Object)conditionFilters.toString()));
            }
        }
        return conditionFilters;
    }

    public DynamicObject queryRuleBySerialNo(String ruleEntry, String draftEntry, String serialno) {
        DynamicObject ruleId;
        DynamicObject rule = null;
        if (ruleEntry != null && (ruleId = QueryServiceHelper.queryOne((String)draftEntry, (String)"ruleid", (QFilter[])new QFilter[]{new QFilter("serialno", "=", (Object)serialno)})) != null && (rule = QueryServiceHelper.queryOne((String)ruleEntry, (String)this.getSelectFields(ruleEntry), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)ruleId.getLong("ruleid"))})) != null) {
            return rule;
        }
        return rule;
    }

    public String getSelectFields(String ruleEntry) {
        if ("tcvat_rule_income".equals(ruleEntry)) {
            return "taxrate.name as taxrate, jzjt";
        }
        if ("tcvat_rule_perpre".equals(ruleEntry)) {
            return "perpreproduct.number as prepaytype";
        }
        return "taxrate.name as taxrate";
    }

    public DynamicObjectCollection queryNoDetailIds(String entryName, boolean differenceInvoice, boolean isQtfpqsAndXxsr, boolean isQtfpseAndXxse, String taxRate, List<Long> detailIds, List<QFilter> filterList, String filterIdName) {
        DynamicObjectCollection noDetails = new DynamicObjectCollection();
        if (entryName.equals("sim_vatinvoice")) {
            ArrayList<QFilter> noDetailFilters = new ArrayList<QFilter>(filterList);
            noDetailFilters.add(new QFilter("issuetype", "=", (Object)"1"));
            noDetailFilters.add(QFilter.isNull((String)"items.goodscode").or("items.goodscode", "=", (Object)" ").or("items.goodscode", "=", (Object)""));
            noDetailFilters.add(new QFilter(filterIdName, "not in", detailIds));
            if (org.apache.commons.lang.StringUtils.isNotBlank((String)taxRate) && (isQtfpqsAndXxsr || isQtfpseAndXxse)) {
                taxRate = NewRuleSettingUtils.trimTaxRate(taxRate);
                BigDecimal rate = new BigDecimal(taxRate.replaceAll("%", "")).divide(ONE_HUNDRED).setScale(2);
                InvoiceTaskUtils.setRateFilter(noDetailFilters, "items.taxrate", rate, differenceInvoice, entryName);
            }
            noDetails = QueryServiceHelper.query((String)entryName, (String)filterIdName, (QFilter[])noDetailFilters.toArray(new QFilter[0]));
        }
        return noDetails;
    }

    public DynamicObjectCollection queryCustomSourceById(Long id) {
        DynamicObjectCollection dataSource = QueryServiceHelper.query((String)"tctb_custom_datasource", (String)"name,entityname,subname,ischild,entryentity.fieldsubname as fieldsubname,entryentity.id as entryid,entryentity.fieldname as fieldname,entryentity.bizsubname as bizsubname,entryentity.drilldown as drilldown", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id), new QFilter("entryentity.drilldown", "=", (Object)Boolean.TRUE)}, (String)"entryentity.seq");
        return dataSource;
    }

    public static boolean loadTaxPayerTypeChangeRecord(String orgId, String ruleType) {
        if ("public".equals(ruleType)) {
            return true;
        }
        DynamicObject taxMain = PeriodService.loadTaxMain(orgId);
        if (null == taxMain) {
            return false;
        }
        String selectFields = "taxpayertype";
        QFilter taxTypeFilter = new QFilter("taxtype", "=", (Object)"zzs");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter mainIdFilter = new QFilter("maintableid", "in", (Object)taxMain.getString("id"));
        QFilter[] qFilters = new QFilter[]{mainIdFilter, taxTypeFilter, enableFilter};
        DynamicObjectCollection list = QueryServiceHelper.query((String)"tctb_tax_change_record", (String)selectFields, (QFilter[])qFilters);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return false;
        }
        List taxPayerType = list.stream().map(obj -> obj.getString("taxpayertype")).collect(Collectors.toList()).stream().distinct().collect(Collectors.toList());
        return taxPayerType.size() > 1;
    }

    public boolean isybnsr(DynamicObjectCollection list, String ruletype, boolean existTypeChange) {
        if ("public".equals(ruletype) || existTypeChange) {
            return true;
        }
        if (EmptyCheckUtils.isNotEmpty((Object)list)) {
            DynamicObject dy = (DynamicObject)list.get(0);
            if ("ybnsr".equals(dy.getString("taxpayertype"))) {
                return true;
            }
            if ("xgmnsr".equals(dy.getString("taxpayertype"))) {
                return false;
            }
        }
        return false;
    }

    public List<DynamicObject> calRuleEntryentityEntity(TcvatEngineModel model, String detailEntity, DynamicObject rule, DynamicObjectCollection entryentity, String suffix) throws Exception {
        NewRuleSettingTask ruleSettingTask = new NewRuleSettingTask(new HashMap<String, String>(), new HashMap<String, Map<String, Object>>(), rule, model, entryentity, "", detailEntity, "", suffix, "", model.getStartDate().substring(0, 7));
        List futures = ThreadPoolsService.getInstance().submitReturnFuture((Task)ruleSettingTask);
        return this.getFutureList(futures);
    }

    public List<DynamicObject> getFutureList(List<Future<Object>> futures) throws Exception {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        for (Future<Object> future : futures) {
            list.addAll((Collection)future.get());
        }
        return list;
    }

    public String getTaxPayerTypeBYOrgId(Long orgId) {
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainZzsByOrgId(Collections.singletonList(orgId));
        if (EmptyCheckUtils.isNotEmpty((Object)result.getData()) && EmptyCheckUtils.isNotEmpty((Object)((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("categoryentryentity"))) {
            DynamicObjectCollection list = ((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("categoryentryentity");
            return ((DynamicObject)list.get(0)).getString("taxpayertype");
        }
        return null;
    }

    public String getBillListIdName(String amountName, String entryName) {
        MainEntityType dataEntityType;
        IDataEntityProperty amountProp;
        IDataEntityType parent;
        String filterIdName = "id";
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)amountName) && (parent = (amountProp = (dataEntityType = MetadataServiceHelper.getDataEntityType((String)entryName)).findProperty(amountName)).getParent()) instanceof EntryType) {
            filterIdName = parent.getName() + ".id";
        }
        if ("er_tripreimbursebill".equals(entryName) && filterIdName.startsWith("entryentity.")) {
            filterIdName = "tripentry." + filterIdName;
        }
        return filterIdName;
    }

    public static DynamicObject saveRule(DynamicObject ruleObject, String issystem) {
        block18: {
            String formId = ruleObject.getDataEntityType().getName();
            Long groupId = RuleTypeStrategyEnum.getGroupIdByFormId(formId);
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tcvat_all_rule_config");
            String number = CodeRuleServiceHelper.getNumber((String)formId, (DynamicObject)ruleObject, (String)ruleObject.getString("org.id"));
            ruleObject.set("number", (Object)number);
            Throwable throwable = null;
            try (TXHandle h = TX.requiresNew();){
                DynamicObject[] objs = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{ruleObject});
                if (objs == null || objs.length <= 0) break block18;
                DynamicObject obj = objs[0];
                BeanCopyUtils.copyDynamicObjectWithoutEntity((DynamicObject)obj, (DynamicObject)dynamicObject);
                dynamicObject.set("issystem", (Object)issystem);
                dynamicObject.set("group", (Object)groupId);
                Long id = obj.getLong("id");
                if (QueryServiceHelper.exists((String)"tcvat_all_rule_config", (Object)id)) {
                    SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
                    DynamicObject dynamicObject2 = ruleObject;
                    return dynamicObject2;
                }
                try {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                }
                catch (Throwable t) {
                    h.markRollback();
                    throw new KDBizException(t.getMessage());
                }
            }
        }
        return ruleObject;
    }
}

