/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.rule.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.EntryProp;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.declare.model.result.BaseResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.impt.TcvatRuleEntryEntityEnum;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.tcvat.common.util.ValidateUtils;
import org.apache.commons.collections.CollectionUtils;

public class RuleSaveValidator {
    private DynamicObject rule;
    private BaseResult<List<String>> result;

    public RuleSaveValidator() {
        this.result = new BaseResult();
        this.result.setCode(BaseResult.OK);
        this.result.setData(new ArrayList());
    }

    public RuleSaveValidator(DynamicObject rule) {
        this.rule = rule;
        this.setNewResult();
    }

    public DynamicObject getRule() {
        return this.rule;
    }

    public void setRule(DynamicObject rule) {
        this.rule = rule;
        this.result.setMessage(rule.getString("id"));
    }

    public BaseResult<List<String>> getResult() {
        return this.result;
    }

    public final void setNewResult() {
        this.result = new BaseResult();
        this.result.setCode(BaseResult.OK);
        this.result.setData(new ArrayList());
    }

    public void checkOrg() {
        Long orgId = this.rule.getDynamicObject("org").getLong("id");
        if (!((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)orgId).getData()).booleanValue()) {
            this.result.setCode(BaseResult.FAIL);
            ((List)this.result.getData()).add(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002 ", (String)"RuleSaveValidator_0", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
    }

    public void checkVatrate() {
        String ruleType = this.rule.getDataEntityType().getName();
        TcvatRuleEntryEntityEnum entryEnum = TcvatRuleEntryEntityEnum.match((String)ruleType);
        List vatRateEnumList = entryEnum.getEntryList();
        if (!TcvatRuleEntryEntityEnum.isNeedCheckVatRateNot0((String)ruleType) || CollectionUtils.isEmpty((Collection)vatRateEnumList)) {
            return;
        }
        vatRateEnumList.forEach(t -> {
            DynamicObjectCollection entryentity = this.rule.getDynamicObjectCollection(t.getEntryEntity());
            for (int i = 0; i < entryentity.size(); ++i) {
                DynamicObject e = (DynamicObject)entryentity.get(i);
                String dataType = e.getString(t.getDataTypeField());
                if (dataType.equals("zjqs") || BigDecimal.ZERO.compareTo(e.getBigDecimal(t.getVatRateField())) != 0) continue;
                this.result.setCode(BaseResult.FAIL);
                ((List)this.result.getData()).add(t.getEntryEntityName().getDescription() + String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u589e\u503c\u7a0e\u7a0e\u7387\u9700\u5927\u4e8e0\u3002 ", (String)"RuleSaveValidator_1", (String)"taxc-tcvat", (Object[])new Object[0]), i + 1));
            }
        });
    }

    public List<String> getSettingFields(String entityName) {
        String suffix = entityName.replace("entryentity", "");
        return Arrays.asList("bizname" + suffix, "table" + suffix, "amountfield" + suffix, "datatype" + suffix, "absolute" + suffix, "datadirection" + suffix, "filtercondition" + suffix);
    }

    public void checkInOneRule() {
        DataEntityPropertyCollection properties = this.rule.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : properties) {
            if (!(property instanceof EntryProp)) continue;
            String entityName = property.getName();
            DynamicObjectCollection entityCollection = this.rule.getDynamicObjectCollection(entityName);
            for (int i = 0; i < entityCollection.size(); ++i) {
                for (int j = i + 1; j < entityCollection.size(); ++j) {
                    DynamicObject entity1 = (DynamicObject)entityCollection.get(i);
                    DynamicObject entity2 = (DynamicObject)entityCollection.get(j);
                    List<String> settingFields = this.getSettingFields(entityName);
                    this.compareAccounting(entity1, entity2, settingFields, property.getDisplayName().getLocaleValue());
                }
            }
        }
    }

    private void compareAccounting(DynamicObject entity1, DynamicObject entity2, List<String> settingFields, String entryName) {
        if (settingFields.stream().noneMatch(field -> null != entity1.get(field) && !entity1.get(field).equals(entity2.get(field)))) {
            String msg = String.format(ValidateUtils.getErrorFormatAccounting(), entity1.get("seq"), entity2.get("seq"));
            this.result.setCode(BaseResult.FAIL);
            ((List)this.result.getData()).add(entryName + msg);
        }
    }

    public void checkInOneOrg() {
        String name = this.rule.getDataEntityType().getName();
        DataEntityPropertyCollection properties = this.rule.getDataEntityType().getProperties();
        Map sharingAndOrgRules = RuleUtils.getSharingAndOrgRules((Long)this.rule.getDynamicObject("org").getLong("id"), Collections.singletonList(this.rule.getLong("id")), (RuleTypeEnum)RuleTypeEnum.valueOfEntry((String)name), properties.containsKey((Object)"taxpayertype") ? this.rule.getString("taxpayertype") : null, null);
        List list = (List)sharingAndOrgRules.get(RuleTypeEnum.valueOfEntry((String)name));
        for (IDataEntityProperty property : properties) {
            if (!(property instanceof EntryProp)) continue;
            String entityName = property.getName();
            DynamicObjectCollection entityCollection = this.rule.getDynamicObjectCollection(entityName);
            List<String> settingFields = this.getSettingFields(entityName);
            HashMap map = new HashMap();
            if (list != null) {
                for (DynamicObject dynamicObject : list) {
                    if (!dynamicObject.containsProperty(entityName)) continue;
                    DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(entityName);
                    dynamicObjectCollection.stream().forEach(e -> map.put(settingFields.stream().map(arg_0 -> ((DynamicObject)e).getString(arg_0)).collect(Collectors.joining("-")), dynamicObject));
                }
            }
            for (int i = 0; i < entityCollection.size(); ++i) {
                DynamicObject dynamicObject;
                dynamicObject = (DynamicObject)entityCollection.get(i);
                String resultStr = settingFields.stream().map(arg_0 -> ((DynamicObject)dynamicObject).getString(arg_0)).collect(Collectors.joining("-"));
                DynamicObject repeatRule = (DynamicObject)map.get(resultStr);
                if (null == repeatRule) continue;
                this.result.setCode(BaseResult.FAIL);
                ((List)this.result.getData()).add(String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c\u5df2\u5728\u7ec4\u7ec7\uff1a%3$s \u7f16\u7801\uff1a%4$s \u7684\u89c4\u5219\u4e2d\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u914d\u7f6e ", (String)"RuleSaveValidator_2", (String)"taxc-tcvat", (Object[])new Object[0]), property.getDisplayName().getLocaleValue(), i + 1, repeatRule.getDynamicObject("org").getString("name"), repeatRule.getString("number")));
            }
        }
    }

    public void checkCustom() {
    }
}

